/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;

public class ExecutionConfig {
    private final Locale locale;
    private final boolean annotationCollectionEnabled;
    private final Predicate<String> annotationCollectionFilter;
    private final Boolean formatAssertionsEnabled;
    private final boolean failFast;
    private final Boolean readOnly;
    private final Boolean writeOnly;

    public static ExecutionConfig getInstance() {
        return Holder.INSTANCE;
    }

    protected ExecutionConfig(Locale locale, boolean annotationCollectionEnabled, Predicate<String> annotationCollectionFilter, Boolean formatAssertionsEnabled, boolean failFast, Boolean readOnly, Boolean writeOnly) {
        this.locale = locale;
        this.annotationCollectionEnabled = annotationCollectionEnabled;
        this.annotationCollectionFilter = annotationCollectionFilter;
        this.formatAssertionsEnabled = formatAssertionsEnabled;
        this.failFast = failFast;
        this.readOnly = readOnly;
        this.writeOnly = writeOnly;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Boolean getFormatAssertionsEnabled() {
        return this.formatAssertionsEnabled;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public boolean isAnnotationCollectionEnabled() {
        return this.annotationCollectionEnabled;
    }

    public Predicate<String> getAnnotationCollectionFilter() {
        return this.annotationCollectionFilter;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ExecutionConfig config) {
        Builder copy = new Builder();
        copy.locale = config.locale;
        copy.annotationCollectionEnabled = config.annotationCollectionEnabled;
        copy.annotationCollectionFilter = config.annotationCollectionFilter;
        copy.formatAssertionsEnabled = config.formatAssertionsEnabled;
        copy.failFast = config.failFast;
        copy.readOnly = config.readOnly;
        copy.writeOnly = config.writeOnly;
        return copy;
    }

    private static class Holder {
        private static final ExecutionConfig INSTANCE = ExecutionConfig.builder().build();

        private Holder() {
        }
    }

    public static class Builder
    extends BuilderSupport<Builder> {
        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class BuilderSupport<T> {
        protected Locale locale = Locale.ROOT;
        protected boolean annotationCollectionEnabled = false;
        protected Predicate<String> annotationCollectionFilter = keyword -> false;
        protected Boolean formatAssertionsEnabled = null;
        protected boolean failFast = false;
        protected Boolean readOnly = null;
        protected Boolean writeOnly = null;

        protected abstract T self();

        public T locale(Locale locale) {
            this.locale = locale;
            return this.self();
        }

        public T annotationCollectionEnabled(boolean annotationCollectionEnabled) {
            this.annotationCollectionEnabled = annotationCollectionEnabled;
            return this.self();
        }

        public T annotationCollectionFilter(Predicate<String> annotationCollectionFilter) {
            this.annotationCollectionFilter = annotationCollectionFilter;
            return this.self();
        }

        public T formatAssertionsEnabled(Boolean formatAssertionsEnabled) {
            this.formatAssertionsEnabled = formatAssertionsEnabled;
            return this.self();
        }

        public T failFast(boolean failFast) {
            this.failFast = failFast;
            return this.self();
        }

        public T readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this.self();
        }

        public T writeOnly(Boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this.self();
        }

        public ExecutionConfig build() {
            Locale locale = this.locale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            Objects.requireNonNull(this.annotationCollectionFilter, "annotationCollectionFilter must not be null");
            return new ExecutionConfig(locale, this.annotationCollectionEnabled, this.annotationCollectionFilter, this.formatAssertionsEnabled, this.failFast, this.readOnly, this.writeOnly);
        }
    }
}

