/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Int$;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;

public class RangeIterator
extends AbstractIterator<Object>
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final int step;
    private final int lastElement;
    private boolean _hasNext;
    private int _next;

    public RangeIterator(int start, int step, int lastElement, boolean initiallyEmpty) {
        this.step = step;
        this.lastElement = lastElement;
        this._hasNext = !initiallyEmpty;
        this._next = start;
    }

    @Override
    public int knownSize() {
        if (this._hasNext) {
            return (this.lastElement - this._next) / this.step + 1;
        }
        return 0;
    }

    @Override
    public boolean hasNext() {
        return this._hasNext;
    }

    @Override
    public int next() throws NoSuchElementException {
        int value;
        if (!this._hasNext) {
            Iterator$.MODULE$.empty().next();
        }
        this._hasNext = (value = this._next) != this.lastElement;
        this._next = value + this.step;
        return value;
    }

    @Override
    public Iterator<Object> drop(int n) {
        if (n > 0) {
            long longPos = (long)this._next + (long)(this.step * n);
            if (this.step > 0) {
                this._next = (int)Math.min(Int$.MODULE$.int2long(this.lastElement), longPos);
                this._hasNext = longPos <= (long)this.lastElement;
            } else if (this.step < 0) {
                this._next = (int)Math.max(Int$.MODULE$.int2long(this.lastElement), longPos);
                this._hasNext = longPos >= (long)this.lastElement;
            }
        }
        return this;
    }
}

