/* automatically generated by rust-bindgen 0.72.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0 OR ISC


#![allow(
    clippy::cast_lossless,
    clippy::cast_possible_truncation,
    clippy::cast_possible_wrap,
    clippy::default_trait_access,
    clippy::missing_safety_doc,
    clippy::must_use_candidate,
    clippy::not_unsafe_ptr_arg_deref,
    clippy::ptr_as_ptr,
    clippy::ptr_offset_with_cast,
    clippy::pub_underscore_fields,
    clippy::semicolon_if_nothing_returned,
    clippy::too_many_lines,
    clippy::unreadable_literal,
    clippy::used_underscore_binding,
    clippy::useless_transmute,
    dead_code,
    improper_ctypes,
    non_camel_case_types,
    non_snake_case,
    non_upper_case_globals,
    unpredictable_function_pointer_comparisons,
    unused_imports
)]


#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
        };
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = unsafe {
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
        };
        unsafe { *byte = Self::change_bit(*byte, index, val) };
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
        }
    }
}
pub const AWSLC_VERSION_NAME: &[u8; 7] = b"AWS-LC\0";
pub const OPENSSL_VERSION_NUMBER: i32 = 269488255;
pub const SSLEAY_VERSION_NUMBER: i32 = 269488255;
pub const AWSLC_API_VERSION: i32 = 35;
pub const AWSLC_VERSION_NUMBER_STRING: &[u8; 7] = b"1.65.0\0";
pub const AES_ENCRYPT: i32 = 1;
pub const AES_DECRYPT: i32 = 0;
pub const AES_MAXNR: i32 = 14;
pub const AES_BLOCK_SIZE: i32 = 16;
pub const SHA_CBLOCK: i32 = 64;
pub const SHA_DIGEST_LENGTH: i32 = 20;
pub const SHA224_CBLOCK: i32 = 64;
pub const SHA224_DIGEST_LENGTH: i32 = 28;
pub const SHA256_CBLOCK: i32 = 64;
pub const SHA256_DIGEST_LENGTH: i32 = 32;
pub const SHA384_CBLOCK: i32 = 128;
pub const SHA384_DIGEST_LENGTH: i32 = 48;
pub const SHA512_CBLOCK: i32 = 128;
pub const SHA512_DIGEST_LENGTH: i32 = 64;
pub const SHA512_224_DIGEST_LENGTH: i32 = 28;
pub const SHA512_256_DIGEST_LENGTH: i32 = 32;
pub const OPENSSL_VERSION_TEXT: &[u8; 42] = b"OpenSSL 1.1.1 (compatible; AWS-LC 1.65.0)\0";
pub const OPENSSL_VERSION: i32 = 0;
pub const OPENSSL_CFLAGS: i32 = 1;
pub const OPENSSL_BUILT_ON: i32 = 2;
pub const OPENSSL_PLATFORM: i32 = 3;
pub const OPENSSL_DIR: i32 = 4;
pub const SSLEAY_VERSION: i32 = 0;
pub const SSLEAY_CFLAGS: i32 = 1;
pub const SSLEAY_BUILT_ON: i32 = 2;
pub const SSLEAY_PLATFORM: i32 = 3;
pub const SSLEAY_DIR: i32 = 4;
pub const OPENSSL_INIT_NO_LOAD_CRYPTO_STRINGS: i32 = 0;
pub const OPENSSL_INIT_LOAD_CRYPTO_STRINGS: i32 = 0;
pub const OPENSSL_INIT_ADD_ALL_CIPHERS: i32 = 0;
pub const OPENSSL_INIT_ADD_ALL_DIGESTS: i32 = 0;
pub const OPENSSL_INIT_NO_ADD_ALL_CIPHERS: i32 = 0;
pub const OPENSSL_INIT_NO_ADD_ALL_DIGESTS: i32 = 0;
pub const OPENSSL_INIT_LOAD_CONFIG: i32 = 0;
pub const OPENSSL_INIT_NO_LOAD_CONFIG: i32 = 0;
pub const OPENSSL_INIT_ENGINE_ALL_BUILTIN: i32 = 0;
pub const CRYPTO_MEM_CHECK_ON: i32 = 0;
pub const ERR_FLAG_STRING: i32 = 1;
pub const ERR_FLAG_MALLOCED: i32 = 2;
pub const ERR_LIB_NONE: i32 = 1;
pub const ERR_LIB_SYS: i32 = 2;
pub const ERR_LIB_BN: i32 = 3;
pub const ERR_LIB_RSA: i32 = 4;
pub const ERR_LIB_DH: i32 = 5;
pub const ERR_LIB_EVP: i32 = 6;
pub const ERR_LIB_BUF: i32 = 7;
pub const ERR_LIB_OBJ: i32 = 8;
pub const ERR_LIB_PEM: i32 = 9;
pub const ERR_LIB_DSA: i32 = 10;
pub const ERR_LIB_X509: i32 = 11;
pub const ERR_LIB_ASN1: i32 = 12;
pub const ERR_LIB_CONF: i32 = 13;
pub const ERR_LIB_CRYPTO: i32 = 14;
pub const ERR_LIB_EC: i32 = 15;
pub const ERR_LIB_SSL: i32 = 16;
pub const ERR_LIB_BIO: i32 = 17;
pub const ERR_LIB_PKCS7: i32 = 18;
pub const ERR_LIB_PKCS8: i32 = 19;
pub const ERR_LIB_X509V3: i32 = 20;
pub const ERR_LIB_RAND: i32 = 21;
pub const ERR_LIB_ENGINE: i32 = 22;
pub const ERR_LIB_OCSP: i32 = 23;
pub const ERR_LIB_UI: i32 = 24;
pub const ERR_LIB_COMP: i32 = 25;
pub const ERR_LIB_ECDSA: i32 = 26;
pub const ERR_LIB_ECDH: i32 = 27;
pub const ERR_LIB_HMAC: i32 = 28;
pub const ERR_LIB_DIGEST: i32 = 29;
pub const ERR_LIB_CIPHER: i32 = 30;
pub const ERR_LIB_HKDF: i32 = 31;
pub const ERR_LIB_TRUST_TOKEN: i32 = 32;
pub const ERR_LIB_USER: i32 = 33;
pub const ERR_NUM_LIBS: i32 = 34;
pub const ERR_LIB_PKCS12: i32 = 35;
pub const ERR_LIB_DSO: i32 = 36;
pub const ERR_LIB_OSSL_STORE: i32 = 37;
pub const ERR_LIB_FIPS: i32 = 38;
pub const ERR_LIB_CMS: i32 = 39;
pub const ERR_LIB_TS: i32 = 40;
pub const ERR_LIB_CT: i32 = 41;
pub const ERR_LIB_ASYNC: i32 = 42;
pub const ERR_LIB_KDF: i32 = 43;
pub const ERR_LIB_SM2: i32 = 44;
pub const ERR_R_SYS_LIB: i32 = 2;
pub const ERR_R_BN_LIB: i32 = 3;
pub const ERR_R_RSA_LIB: i32 = 4;
pub const ERR_R_DH_LIB: i32 = 5;
pub const ERR_R_EVP_LIB: i32 = 6;
pub const ERR_R_BUF_LIB: i32 = 7;
pub const ERR_R_OBJ_LIB: i32 = 8;
pub const ERR_R_PEM_LIB: i32 = 9;
pub const ERR_R_DSA_LIB: i32 = 10;
pub const ERR_R_X509_LIB: i32 = 11;
pub const ERR_R_ASN1_LIB: i32 = 12;
pub const ERR_R_CONF_LIB: i32 = 13;
pub const ERR_R_CRYPTO_LIB: i32 = 14;
pub const ERR_R_EC_LIB: i32 = 15;
pub const ERR_R_SSL_LIB: i32 = 16;
pub const ERR_R_BIO_LIB: i32 = 17;
pub const ERR_R_PKCS7_LIB: i32 = 18;
pub const ERR_R_PKCS8_LIB: i32 = 19;
pub const ERR_R_X509V3_LIB: i32 = 20;
pub const ERR_R_RAND_LIB: i32 = 21;
pub const ERR_R_DSO_LIB: i32 = 36;
pub const ERR_R_ENGINE_LIB: i32 = 22;
pub const ERR_R_OCSP_LIB: i32 = 23;
pub const ERR_R_UI_LIB: i32 = 24;
pub const ERR_R_COMP_LIB: i32 = 25;
pub const ERR_R_ECDSA_LIB: i32 = 26;
pub const ERR_R_ECDH_LIB: i32 = 27;
pub const ERR_R_FIPS_LIB: i32 = 38;
pub const ERR_R_CMS_LIB: i32 = 39;
pub const ERR_R_TS_LIB: i32 = 40;
pub const ERR_R_HMAC_LIB: i32 = 28;
pub const ERR_R_USER_LIB: i32 = 33;
pub const ERR_R_DIGEST_LIB: i32 = 29;
pub const ERR_R_CIPHER_LIB: i32 = 30;
pub const ERR_R_HKDF_LIB: i32 = 31;
pub const ERR_R_TRUST_TOKEN_LIB: i32 = 32;
pub const ERR_R_FATAL: i32 = 64;
pub const ERR_R_MALLOC_FAILURE: i32 = 65;
pub const ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED: i32 = 66;
pub const ERR_R_PASSED_NULL_PARAMETER: i32 = 67;
pub const ERR_R_INTERNAL_ERROR: i32 = 68;
pub const ERR_R_OVERFLOW: i32 = 69;
pub const ERR_ERROR_STRING_BUF_LEN: i32 = 120;
pub const ERR_TXT_STRING: i32 = 1;
pub const ERR_TXT_MALLOCED: i32 = 2;
pub const ERR_NUM_ERRORS: i32 = 16;
pub const BN_BITS2: i32 = 64;
pub const BN_DEC_FMT1: &[u8; 4] = b"%lu\0";
pub const BN_HEX_FMT1: &[u8; 4] = b"%lx\0";
pub const BN_HEX_FMT2: &[u8; 7] = b"%016lx\0";
pub const BN_RAND_TOP_ANY: i32 = -1;
pub const BN_RAND_TOP_ONE: i32 = 0;
pub const BN_RAND_TOP_TWO: i32 = 1;
pub const BN_RAND_BOTTOM_ANY: i32 = 0;
pub const BN_RAND_BOTTOM_ODD: i32 = 1;
pub const BN_GENCB_GENERATED: i32 = 0;
pub const BN_GENCB_PRIME_TEST: i32 = 1;
pub const BN_prime_checks_for_validation: i32 = 64;
pub const BN_prime_checks_for_generation: i32 = 0;
pub const BN_prime_checks: i32 = 64;
pub const BN_FLG_MALLOCED: i32 = 1;
pub const BN_FLG_STATIC_DATA: i32 = 2;
pub const BN_R_ARG2_LT_ARG3: i32 = 100;
pub const BN_R_BAD_RECIPROCAL: i32 = 101;
pub const BN_R_BIGNUM_TOO_LONG: i32 = 102;
pub const BN_R_BITS_TOO_SMALL: i32 = 103;
pub const BN_R_CALLED_WITH_EVEN_MODULUS: i32 = 104;
pub const BN_R_DIV_BY_ZERO: i32 = 105;
pub const BN_R_EXPAND_ON_STATIC_BIGNUM_DATA: i32 = 106;
pub const BN_R_INPUT_NOT_REDUCED: i32 = 107;
pub const BN_R_INVALID_RANGE: i32 = 108;
pub const BN_R_NEGATIVE_NUMBER: i32 = 109;
pub const BN_R_NOT_A_SQUARE: i32 = 110;
pub const BN_R_NOT_INITIALIZED: i32 = 111;
pub const BN_R_NO_INVERSE: i32 = 112;
pub const BN_R_PRIVATE_KEY_TOO_LARGE: i32 = 113;
pub const BN_R_P_IS_NOT_PRIME: i32 = 114;
pub const BN_R_TOO_MANY_ITERATIONS: i32 = 115;
pub const BN_R_TOO_MANY_TEMPORARY_VARIABLES: i32 = 116;
pub const BN_R_BAD_ENCODING: i32 = 117;
pub const BN_R_ENCODE_ERROR: i32 = 118;
pub const BN_R_INVALID_INPUT: i32 = 119;
pub const BN_F_BN_GENERATE_PRIME_EX: i32 = 0;
pub const CBS_ASN1_TAG_SHIFT: i32 = 24;
pub const CBS_ASN1_CONSTRUCTED: i32 = 536870912;
pub const CBS_ASN1_UNIVERSAL: i32 = 0;
pub const CBS_ASN1_APPLICATION: i32 = 1073741824;
pub const CBS_ASN1_CONTEXT_SPECIFIC: i64 = 2147483648;
pub const CBS_ASN1_PRIVATE: i64 = 3221225472;
pub const CBS_ASN1_CLASS_MASK: i64 = 3221225472;
pub const CBS_ASN1_TAG_NUMBER_MASK: i32 = 536870911;
pub const CBS_ASN1_BOOLEAN: i32 = 1;
pub const CBS_ASN1_INTEGER: i32 = 2;
pub const CBS_ASN1_BITSTRING: i32 = 3;
pub const CBS_ASN1_OCTETSTRING: i32 = 4;
pub const CBS_ASN1_NULL: i32 = 5;
pub const CBS_ASN1_OBJECT: i32 = 6;
pub const CBS_ASN1_ENUMERATED: i32 = 10;
pub const CBS_ASN1_UTF8STRING: i32 = 12;
pub const CBS_ASN1_SEQUENCE: i32 = 536870928;
pub const CBS_ASN1_SET: i32 = 536870929;
pub const CBS_ASN1_NUMERICSTRING: i32 = 18;
pub const CBS_ASN1_PRINTABLESTRING: i32 = 19;
pub const CBS_ASN1_T61STRING: i32 = 20;
pub const CBS_ASN1_VIDEOTEXSTRING: i32 = 21;
pub const CBS_ASN1_IA5STRING: i32 = 22;
pub const CBS_ASN1_UTCTIME: i32 = 23;
pub const CBS_ASN1_GENERALIZEDTIME: i32 = 24;
pub const CBS_ASN1_GRAPHICSTRING: i32 = 25;
pub const CBS_ASN1_VISIBLESTRING: i32 = 26;
pub const CBS_ASN1_GENERALSTRING: i32 = 27;
pub const CBS_ASN1_UNIVERSALSTRING: i32 = 28;
pub const CBS_ASN1_BMPSTRING: i32 = 30;
pub const EVP_CIPH_STREAM_CIPHER: i32 = 0;
pub const EVP_CIPH_ECB_MODE: i32 = 1;
pub const EVP_CIPH_CBC_MODE: i32 = 2;
pub const EVP_CIPH_CFB_MODE: i32 = 3;
pub const EVP_CIPH_OFB_MODE: i32 = 4;
pub const EVP_CIPH_CTR_MODE: i32 = 5;
pub const EVP_CIPH_GCM_MODE: i32 = 6;
pub const EVP_CIPH_XTS_MODE: i32 = 7;
pub const EVP_CIPH_CCM_MODE: i32 = 8;
pub const EVP_CIPH_FLAG_LENGTH_BITS: i32 = 8192;
pub const EVP_CIPH_OCB_MODE: i32 = 9;
pub const EVP_CIPH_WRAP_MODE: i32 = 10;
pub const EVP_CIPH_VARIABLE_LENGTH: i32 = 64;
pub const EVP_CIPH_ALWAYS_CALL_INIT: i32 = 128;
pub const EVP_CIPH_CUSTOM_IV: i32 = 256;
pub const EVP_CIPH_CTRL_INIT: i32 = 512;
pub const EVP_CIPH_FLAG_CUSTOM_CIPHER: i32 = 1024;
pub const EVP_CIPH_FLAG_AEAD_CIPHER: i32 = 2048;
pub const EVP_CIPH_CUSTOM_COPY: i32 = 4096;
pub const EVP_CIPH_FLAG_NON_FIPS_ALLOW: i32 = 0;
pub const EVP_CIPHER_CTX_FLAG_WRAP_ALLOW: i32 = 0;
pub const EVP_CIPH_NO_PADDING: i32 = 2048;
pub const EVP_CTRL_INIT: i32 = 0;
pub const EVP_CTRL_SET_KEY_LENGTH: i32 = 1;
pub const EVP_CTRL_GET_RC2_KEY_BITS: i32 = 2;
pub const EVP_CTRL_SET_RC2_KEY_BITS: i32 = 3;
pub const EVP_CTRL_GET_RC5_ROUNDS: i32 = 4;
pub const EVP_CTRL_SET_RC5_ROUNDS: i32 = 5;
pub const EVP_CTRL_RAND_KEY: i32 = 6;
pub const EVP_CTRL_PBE_PRF_NID: i32 = 7;
pub const EVP_CTRL_COPY: i32 = 8;
pub const EVP_CTRL_AEAD_SET_IVLEN: i32 = 9;
pub const EVP_CTRL_AEAD_GET_TAG: i32 = 16;
pub const EVP_CTRL_AEAD_SET_TAG: i32 = 17;
pub const EVP_CTRL_AEAD_SET_IV_FIXED: i32 = 18;
pub const EVP_CTRL_GCM_IV_GEN: i32 = 19;
pub const EVP_CTRL_CCM_SET_L: i32 = 20;
pub const EVP_CTRL_AEAD_SET_MAC_KEY: i32 = 23;
pub const EVP_CTRL_GCM_SET_IV_INV: i32 = 24;
pub const EVP_CTRL_GET_IVLEN: i32 = 25;
pub const EVP_GCM_TLS_FIXED_IV_LEN: i32 = 4;
pub const EVP_GCM_TLS_EXPLICIT_IV_LEN: i32 = 8;
pub const EVP_GCM_TLS_TAG_LEN: i32 = 16;
pub const EVP_CTRL_GCM_SET_IVLEN: i32 = 9;
pub const EVP_CTRL_GCM_GET_TAG: i32 = 16;
pub const EVP_CTRL_GCM_SET_TAG: i32 = 17;
pub const EVP_CTRL_GCM_SET_IV_FIXED: i32 = 18;
pub const EVP_MAX_KEY_LENGTH: i32 = 64;
pub const EVP_MAX_IV_LENGTH: i32 = 16;
pub const EVP_MAX_BLOCK_LENGTH: i32 = 32;
pub const EVP_CTRL_AEAD_TLS1_AAD: i32 = 22;
pub const EVP_AEAD_TLS1_AAD_LEN: i32 = 13;
pub const CIPHER_R_AES_KEY_SETUP_FAILED: i32 = 100;
pub const CIPHER_R_BAD_DECRYPT: i32 = 101;
pub const CIPHER_R_BAD_KEY_LENGTH: i32 = 102;
pub const CIPHER_R_BUFFER_TOO_SMALL: i32 = 103;
pub const CIPHER_R_CTRL_NOT_IMPLEMENTED: i32 = 104;
pub const CIPHER_R_CTRL_OPERATION_NOT_IMPLEMENTED: i32 = 105;
pub const CIPHER_R_DATA_NOT_MULTIPLE_OF_BLOCK_LENGTH: i32 = 106;
pub const CIPHER_R_INITIALIZATION_ERROR: i32 = 107;
pub const CIPHER_R_INPUT_NOT_INITIALIZED: i32 = 108;
pub const CIPHER_R_INVALID_AD_SIZE: i32 = 109;
pub const CIPHER_R_INVALID_KEY_LENGTH: i32 = 110;
pub const CIPHER_R_INVALID_NONCE_SIZE: i32 = 111;
pub const CIPHER_R_INVALID_OPERATION: i32 = 112;
pub const CIPHER_R_IV_TOO_LARGE: i32 = 113;
pub const CIPHER_R_NO_CIPHER_SET: i32 = 114;
pub const CIPHER_R_OUTPUT_ALIASES_INPUT: i32 = 115;
pub const CIPHER_R_TAG_TOO_LARGE: i32 = 116;
pub const CIPHER_R_TOO_LARGE: i32 = 117;
pub const CIPHER_R_UNSUPPORTED_AD_SIZE: i32 = 118;
pub const CIPHER_R_UNSUPPORTED_INPUT_SIZE: i32 = 119;
pub const CIPHER_R_UNSUPPORTED_KEY_SIZE: i32 = 120;
pub const CIPHER_R_UNSUPPORTED_NONCE_SIZE: i32 = 121;
pub const CIPHER_R_UNSUPPORTED_TAG_SIZE: i32 = 122;
pub const CIPHER_R_WRONG_FINAL_BLOCK_LENGTH: i32 = 123;
pub const CIPHER_R_NO_DIRECTION_SET: i32 = 124;
pub const CIPHER_R_INVALID_NONCE: i32 = 125;
pub const CIPHER_R_XTS_DUPLICATED_KEYS: i32 = 138;
pub const CIPHER_R_XTS_DATA_UNIT_IS_TOO_LARGE: i32 = 139;
pub const CIPHER_R_CTRL_OPERATION_NOT_PERFORMED: i32 = 140;
pub const CIPHER_R_SERIALIZATION_INVALID_EVP_AEAD_CTX: i32 = 141;
pub const CIPHER_R_ALIGNMENT_CHANGED: i32 = 142;
pub const CIPHER_R_SERIALIZATION_INVALID_SERDE_VERSION: i32 = 143;
pub const CIPHER_R_SERIALIZATION_INVALID_CIPHER_ID: i32 = 144;
pub const X25519_PRIVATE_KEY_LEN: i32 = 32;
pub const X25519_PUBLIC_VALUE_LEN: i32 = 32;
pub const X25519_SHARED_KEY_LEN: i32 = 32;
pub const ED25519_PRIVATE_KEY_LEN: i32 = 64;
pub const ED25519_PRIVATE_KEY_SEED_LEN: i32 = 32;
pub const ED25519_PUBLIC_KEY_LEN: i32 = 32;
pub const ED25519_SIGNATURE_LEN: i32 = 64;
pub const ED25519_SEED_LEN: i32 = 32;
pub const SPAKE2_MAX_MSG_SIZE: i32 = 32;
pub const SPAKE2_MAX_KEY_SIZE: i32 = 64;
pub const EVP_MAX_MD_SIZE: i32 = 64;
pub const EVP_MAX_MD_CHAINING_LENGTH: i32 = 64;
pub const EVP_MAX_MD_BLOCK_SIZE: i32 = 144;
pub const EVP_MD_FLAG_DIGALGID_ABSENT: i32 = 2;
pub const EVP_MD_FLAG_XOF: i32 = 4;
pub const EVP_MD_CTX_FLAG_NON_FIPS_ALLOW: i32 = 0;
pub const DIGEST_R_INPUT_NOT_INITIALIZED: i32 = 100;
pub const DIGEST_R_DECODE_ERROR: i32 = 101;
pub const DIGEST_R_UNKNOWN_HASH: i32 = 102;
pub const OPENSSL_EC_EXPLICIT_CURVE: i32 = 0;
pub const OPENSSL_EC_NAMED_CURVE: i32 = 1;
pub const EC_PKEY_NO_PARAMETERS: i32 = 1;
pub const EC_PKEY_NO_PUBKEY: i32 = 2;
pub const ECDSA_FLAG_OPAQUE: i32 = 1;
pub const EC_R_BUFFER_TOO_SMALL: i32 = 100;
pub const EC_R_COORDINATES_OUT_OF_RANGE: i32 = 101;
pub const EC_R_D2I_ECPKPARAMETERS_FAILURE: i32 = 102;
pub const EC_R_EC_GROUP_NEW_BY_NAME_FAILURE: i32 = 103;
pub const EC_R_GROUP2PKPARAMETERS_FAILURE: i32 = 104;
pub const EC_R_I2D_ECPKPARAMETERS_FAILURE: i32 = 105;
pub const EC_R_INCOMPATIBLE_OBJECTS: i32 = 106;
pub const EC_R_INVALID_COMPRESSED_POINT: i32 = 107;
pub const EC_R_INVALID_COMPRESSION_BIT: i32 = 108;
pub const EC_R_INVALID_ENCODING: i32 = 109;
pub const EC_R_INVALID_FIELD: i32 = 110;
pub const EC_R_INVALID_FORM: i32 = 111;
pub const EC_R_INVALID_GROUP_ORDER: i32 = 112;
pub const EC_R_INVALID_PRIVATE_KEY: i32 = 113;
pub const EC_R_MISSING_PARAMETERS: i32 = 114;
pub const EC_R_MISSING_PRIVATE_KEY: i32 = 115;
pub const EC_R_NON_NAMED_CURVE: i32 = 116;
pub const EC_R_NOT_INITIALIZED: i32 = 117;
pub const EC_R_PKPARAMETERS2GROUP_FAILURE: i32 = 118;
pub const EC_R_POINT_AT_INFINITY: i32 = 119;
pub const EC_R_POINT_IS_NOT_ON_CURVE: i32 = 120;
pub const EC_R_SLOT_FULL: i32 = 121;
pub const EC_R_UNDEFINED_GENERATOR: i32 = 122;
pub const EC_R_UNKNOWN_GROUP: i32 = 123;
pub const EC_R_UNKNOWN_ORDER: i32 = 124;
pub const EC_R_WRONG_ORDER: i32 = 125;
pub const EC_R_BIGNUM_OUT_OF_RANGE: i32 = 126;
pub const EC_R_WRONG_CURVE_PARAMETERS: i32 = 127;
pub const EC_R_DECODE_ERROR: i32 = 128;
pub const EC_R_ENCODE_ERROR: i32 = 129;
pub const EC_R_GROUP_MISMATCH: i32 = 130;
pub const EC_R_INVALID_COFACTOR: i32 = 131;
pub const EC_R_PUBLIC_KEY_VALIDATION_FAILED: i32 = 132;
pub const EC_R_INVALID_SCALAR: i32 = 133;
pub const ECDH_R_KDF_FAILED: i32 = 100;
pub const ECDH_R_NO_PRIVATE_VALUE: i32 = 101;
pub const ECDH_R_POINT_ARITHMETIC_FAILURE: i32 = 102;
pub const ECDH_R_UNKNOWN_DIGEST_LENGTH: i32 = 103;
pub const ECDSA_R_BAD_SIGNATURE: i32 = 100;
pub const ECDSA_R_MISSING_PARAMETERS: i32 = 101;
pub const ECDSA_R_NEED_NEW_SETUP_VALUES: i32 = 102;
pub const ECDSA_R_NOT_IMPLEMENTED: i32 = 103;
pub const ECDSA_R_RANDOM_NUMBER_GENERATION_FAILED: i32 = 104;
pub const ECDSA_R_ENCODE_ERROR: i32 = 105;
pub const ECDSA_R_MISMATCHED_SIGNATURE: i32 = 205;
pub const ECDSA_R_TOO_MANY_ITERATIONS: i32 = 106;
pub const EVP_AEAD_MAX_KEY_LENGTH: i32 = 80;
pub const EVP_AEAD_MAX_NONCE_LENGTH: i32 = 24;
pub const EVP_AEAD_MAX_OVERHEAD: i32 = 64;
pub const EVP_AEAD_DEFAULT_TAG_LENGTH: i32 = 0;
pub const FIPS_AES_GCM_NONCE_LENGTH: i32 = 12;
pub const SN_undef: &[u8; 6] = b"UNDEF\0";
pub const LN_undef: &[u8; 10] = b"undefined\0";
pub const NID_undef: i32 = 0;
pub const OBJ_undef: i32 = 0;
pub const SN_rsadsi: &[u8; 7] = b"rsadsi\0";
pub const LN_rsadsi: &[u8; 24] = b"RSA Data Security, Inc.\0";
pub const NID_rsadsi: i32 = 1;
pub const SN_pkcs: &[u8; 5] = b"pkcs\0";
pub const LN_pkcs: &[u8; 29] = b"RSA Data Security, Inc. PKCS\0";
pub const NID_pkcs: i32 = 2;
pub const SN_md2: &[u8; 4] = b"MD2\0";
pub const LN_md2: &[u8; 4] = b"md2\0";
pub const NID_md2: i32 = 3;
pub const SN_md5: &[u8; 4] = b"MD5\0";
pub const LN_md5: &[u8; 4] = b"md5\0";
pub const NID_md5: i32 = 4;
pub const SN_rc4: &[u8; 4] = b"RC4\0";
pub const LN_rc4: &[u8; 4] = b"rc4\0";
pub const NID_rc4: i32 = 5;
pub const LN_rsaEncryption: &[u8; 14] = b"rsaEncryption\0";
pub const NID_rsaEncryption: i32 = 6;
pub const SN_md2WithRSAEncryption: &[u8; 8] = b"RSA-MD2\0";
pub const LN_md2WithRSAEncryption: &[u8; 21] = b"md2WithRSAEncryption\0";
pub const NID_md2WithRSAEncryption: i32 = 7;
pub const SN_md5WithRSAEncryption: &[u8; 8] = b"RSA-MD5\0";
pub const LN_md5WithRSAEncryption: &[u8; 21] = b"md5WithRSAEncryption\0";
pub const NID_md5WithRSAEncryption: i32 = 8;
pub const SN_pbeWithMD2AndDES_CBC: &[u8; 12] = b"PBE-MD2-DES\0";
pub const LN_pbeWithMD2AndDES_CBC: &[u8; 21] = b"pbeWithMD2AndDES-CBC\0";
pub const NID_pbeWithMD2AndDES_CBC: i32 = 9;
pub const SN_pbeWithMD5AndDES_CBC: &[u8; 12] = b"PBE-MD5-DES\0";
pub const LN_pbeWithMD5AndDES_CBC: &[u8; 21] = b"pbeWithMD5AndDES-CBC\0";
pub const NID_pbeWithMD5AndDES_CBC: i32 = 10;
pub const SN_X500: &[u8; 5] = b"X500\0";
pub const LN_X500: &[u8; 27] = b"directory services (X.500)\0";
pub const NID_X500: i32 = 11;
pub const SN_X509: &[u8; 5] = b"X509\0";
pub const NID_X509: i32 = 12;
pub const SN_commonName: &[u8; 3] = b"CN\0";
pub const LN_commonName: &[u8; 11] = b"commonName\0";
pub const NID_commonName: i32 = 13;
pub const SN_countryName: &[u8; 2] = b"C\0";
pub const LN_countryName: &[u8; 12] = b"countryName\0";
pub const NID_countryName: i32 = 14;
pub const SN_localityName: &[u8; 2] = b"L\0";
pub const LN_localityName: &[u8; 13] = b"localityName\0";
pub const NID_localityName: i32 = 15;
pub const SN_stateOrProvinceName: &[u8; 3] = b"ST\0";
pub const LN_stateOrProvinceName: &[u8; 20] = b"stateOrProvinceName\0";
pub const NID_stateOrProvinceName: i32 = 16;
pub const SN_organizationName: &[u8; 2] = b"O\0";
pub const LN_organizationName: &[u8; 17] = b"organizationName\0";
pub const NID_organizationName: i32 = 17;
pub const SN_organizationalUnitName: &[u8; 3] = b"OU\0";
pub const LN_organizationalUnitName: &[u8; 23] = b"organizationalUnitName\0";
pub const NID_organizationalUnitName: i32 = 18;
pub const SN_rsa: &[u8; 4] = b"RSA\0";
pub const LN_rsa: &[u8; 4] = b"rsa\0";
pub const NID_rsa: i32 = 19;
pub const SN_pkcs7: &[u8; 6] = b"pkcs7\0";
pub const NID_pkcs7: i32 = 20;
pub const LN_pkcs7_data: &[u8; 11] = b"pkcs7-data\0";
pub const NID_pkcs7_data: i32 = 21;
pub const LN_pkcs7_signed: &[u8; 17] = b"pkcs7-signedData\0";
pub const NID_pkcs7_signed: i32 = 22;
pub const LN_pkcs7_enveloped: &[u8; 20] = b"pkcs7-envelopedData\0";
pub const NID_pkcs7_enveloped: i32 = 23;
pub const LN_pkcs7_signedAndEnveloped: &[u8; 29] = b"pkcs7-signedAndEnvelopedData\0";
pub const NID_pkcs7_signedAndEnveloped: i32 = 24;
pub const LN_pkcs7_digest: &[u8; 17] = b"pkcs7-digestData\0";
pub const NID_pkcs7_digest: i32 = 25;
pub const LN_pkcs7_encrypted: &[u8; 20] = b"pkcs7-encryptedData\0";
pub const NID_pkcs7_encrypted: i32 = 26;
pub const SN_pkcs3: &[u8; 6] = b"pkcs3\0";
pub const NID_pkcs3: i32 = 27;
pub const LN_dhKeyAgreement: &[u8; 15] = b"dhKeyAgreement\0";
pub const NID_dhKeyAgreement: i32 = 28;
pub const SN_des_ecb: &[u8; 8] = b"DES-ECB\0";
pub const LN_des_ecb: &[u8; 8] = b"des-ecb\0";
pub const NID_des_ecb: i32 = 29;
pub const SN_des_cfb64: &[u8; 8] = b"DES-CFB\0";
pub const LN_des_cfb64: &[u8; 8] = b"des-cfb\0";
pub const NID_des_cfb64: i32 = 30;
pub const SN_des_cbc: &[u8; 8] = b"DES-CBC\0";
pub const LN_des_cbc: &[u8; 8] = b"des-cbc\0";
pub const NID_des_cbc: i32 = 31;
pub const SN_des_ede_ecb: &[u8; 8] = b"DES-EDE\0";
pub const LN_des_ede_ecb: &[u8; 8] = b"des-ede\0";
pub const NID_des_ede_ecb: i32 = 32;
pub const SN_des_ede3_ecb: &[u8; 9] = b"DES-EDE3\0";
pub const LN_des_ede3_ecb: &[u8; 9] = b"des-ede3\0";
pub const NID_des_ede3_ecb: i32 = 33;
pub const SN_idea_cbc: &[u8; 9] = b"IDEA-CBC\0";
pub const LN_idea_cbc: &[u8; 9] = b"idea-cbc\0";
pub const NID_idea_cbc: i32 = 34;
pub const SN_idea_cfb64: &[u8; 9] = b"IDEA-CFB\0";
pub const LN_idea_cfb64: &[u8; 9] = b"idea-cfb\0";
pub const NID_idea_cfb64: i32 = 35;
pub const SN_idea_ecb: &[u8; 9] = b"IDEA-ECB\0";
pub const LN_idea_ecb: &[u8; 9] = b"idea-ecb\0";
pub const NID_idea_ecb: i32 = 36;
pub const SN_rc2_cbc: &[u8; 8] = b"RC2-CBC\0";
pub const LN_rc2_cbc: &[u8; 8] = b"rc2-cbc\0";
pub const NID_rc2_cbc: i32 = 37;
pub const SN_rc2_ecb: &[u8; 8] = b"RC2-ECB\0";
pub const LN_rc2_ecb: &[u8; 8] = b"rc2-ecb\0";
pub const NID_rc2_ecb: i32 = 38;
pub const SN_rc2_cfb64: &[u8; 8] = b"RC2-CFB\0";
pub const LN_rc2_cfb64: &[u8; 8] = b"rc2-cfb\0";
pub const NID_rc2_cfb64: i32 = 39;
pub const SN_rc2_ofb64: &[u8; 8] = b"RC2-OFB\0";
pub const LN_rc2_ofb64: &[u8; 8] = b"rc2-ofb\0";
pub const NID_rc2_ofb64: i32 = 40;
pub const SN_sha: &[u8; 4] = b"SHA\0";
pub const LN_sha: &[u8; 4] = b"sha\0";
pub const NID_sha: i32 = 41;
pub const SN_shaWithRSAEncryption: &[u8; 8] = b"RSA-SHA\0";
pub const LN_shaWithRSAEncryption: &[u8; 21] = b"shaWithRSAEncryption\0";
pub const NID_shaWithRSAEncryption: i32 = 42;
pub const SN_des_ede_cbc: &[u8; 12] = b"DES-EDE-CBC\0";
pub const LN_des_ede_cbc: &[u8; 12] = b"des-ede-cbc\0";
pub const NID_des_ede_cbc: i32 = 43;
pub const SN_des_ede3_cbc: &[u8; 13] = b"DES-EDE3-CBC\0";
pub const LN_des_ede3_cbc: &[u8; 13] = b"des-ede3-cbc\0";
pub const NID_des_ede3_cbc: i32 = 44;
pub const SN_des_ofb64: &[u8; 8] = b"DES-OFB\0";
pub const LN_des_ofb64: &[u8; 8] = b"des-ofb\0";
pub const NID_des_ofb64: i32 = 45;
pub const SN_idea_ofb64: &[u8; 9] = b"IDEA-OFB\0";
pub const LN_idea_ofb64: &[u8; 9] = b"idea-ofb\0";
pub const NID_idea_ofb64: i32 = 46;
pub const SN_pkcs9: &[u8; 6] = b"pkcs9\0";
pub const NID_pkcs9: i32 = 47;
pub const LN_pkcs9_emailAddress: &[u8; 13] = b"emailAddress\0";
pub const NID_pkcs9_emailAddress: i32 = 48;
pub const LN_pkcs9_unstructuredName: &[u8; 17] = b"unstructuredName\0";
pub const NID_pkcs9_unstructuredName: i32 = 49;
pub const LN_pkcs9_contentType: &[u8; 12] = b"contentType\0";
pub const NID_pkcs9_contentType: i32 = 50;
pub const LN_pkcs9_messageDigest: &[u8; 14] = b"messageDigest\0";
pub const NID_pkcs9_messageDigest: i32 = 51;
pub const LN_pkcs9_signingTime: &[u8; 12] = b"signingTime\0";
pub const NID_pkcs9_signingTime: i32 = 52;
pub const LN_pkcs9_countersignature: &[u8; 17] = b"countersignature\0";
pub const NID_pkcs9_countersignature: i32 = 53;
pub const LN_pkcs9_challengePassword: &[u8; 18] = b"challengePassword\0";
pub const NID_pkcs9_challengePassword: i32 = 54;
pub const LN_pkcs9_unstructuredAddress: &[u8; 20] = b"unstructuredAddress\0";
pub const NID_pkcs9_unstructuredAddress: i32 = 55;
pub const LN_pkcs9_extCertAttributes: &[u8; 30] = b"extendedCertificateAttributes\0";
pub const NID_pkcs9_extCertAttributes: i32 = 56;
pub const SN_netscape: &[u8; 9] = b"Netscape\0";
pub const LN_netscape: &[u8; 30] = b"Netscape Communications Corp.\0";
pub const NID_netscape: i32 = 57;
pub const SN_netscape_cert_extension: &[u8; 10] = b"nsCertExt\0";
pub const LN_netscape_cert_extension: &[u8; 31] = b"Netscape Certificate Extension\0";
pub const NID_netscape_cert_extension: i32 = 58;
pub const SN_netscape_data_type: &[u8; 11] = b"nsDataType\0";
pub const LN_netscape_data_type: &[u8; 19] = b"Netscape Data Type\0";
pub const NID_netscape_data_type: i32 = 59;
pub const SN_des_ede_cfb64: &[u8; 12] = b"DES-EDE-CFB\0";
pub const LN_des_ede_cfb64: &[u8; 12] = b"des-ede-cfb\0";
pub const NID_des_ede_cfb64: i32 = 60;
pub const SN_des_ede3_cfb64: &[u8; 13] = b"DES-EDE3-CFB\0";
pub const LN_des_ede3_cfb64: &[u8; 13] = b"des-ede3-cfb\0";
pub const NID_des_ede3_cfb64: i32 = 61;
pub const SN_des_ede_ofb64: &[u8; 12] = b"DES-EDE-OFB\0";
pub const LN_des_ede_ofb64: &[u8; 12] = b"des-ede-ofb\0";
pub const NID_des_ede_ofb64: i32 = 62;
pub const SN_des_ede3_ofb64: &[u8; 13] = b"DES-EDE3-OFB\0";
pub const LN_des_ede3_ofb64: &[u8; 13] = b"des-ede3-ofb\0";
pub const NID_des_ede3_ofb64: i32 = 63;
pub const SN_sha1: &[u8; 5] = b"SHA1\0";
pub const LN_sha1: &[u8; 5] = b"sha1\0";
pub const NID_sha1: i32 = 64;
pub const SN_sha1WithRSAEncryption: &[u8; 9] = b"RSA-SHA1\0";
pub const LN_sha1WithRSAEncryption: &[u8; 22] = b"sha1WithRSAEncryption\0";
pub const NID_sha1WithRSAEncryption: i32 = 65;
pub const SN_dsaWithSHA: &[u8; 8] = b"DSA-SHA\0";
pub const LN_dsaWithSHA: &[u8; 11] = b"dsaWithSHA\0";
pub const NID_dsaWithSHA: i32 = 66;
pub const SN_dsa_2: &[u8; 8] = b"DSA-old\0";
pub const LN_dsa_2: &[u8; 18] = b"dsaEncryption-old\0";
pub const NID_dsa_2: i32 = 67;
pub const SN_pbeWithSHA1AndRC2_CBC: &[u8; 16] = b"PBE-SHA1-RC2-64\0";
pub const LN_pbeWithSHA1AndRC2_CBC: &[u8; 22] = b"pbeWithSHA1AndRC2-CBC\0";
pub const NID_pbeWithSHA1AndRC2_CBC: i32 = 68;
pub const LN_id_pbkdf2: &[u8; 7] = b"PBKDF2\0";
pub const NID_id_pbkdf2: i32 = 69;
pub const SN_dsaWithSHA1_2: &[u8; 13] = b"DSA-SHA1-old\0";
pub const LN_dsaWithSHA1_2: &[u8; 16] = b"dsaWithSHA1-old\0";
pub const NID_dsaWithSHA1_2: i32 = 70;
pub const SN_netscape_cert_type: &[u8; 11] = b"nsCertType\0";
pub const LN_netscape_cert_type: &[u8; 19] = b"Netscape Cert Type\0";
pub const NID_netscape_cert_type: i32 = 71;
pub const SN_netscape_base_url: &[u8; 10] = b"nsBaseUrl\0";
pub const LN_netscape_base_url: &[u8; 18] = b"Netscape Base Url\0";
pub const NID_netscape_base_url: i32 = 72;
pub const SN_netscape_revocation_url: &[u8; 16] = b"nsRevocationUrl\0";
pub const LN_netscape_revocation_url: &[u8; 24] = b"Netscape Revocation Url\0";
pub const NID_netscape_revocation_url: i32 = 73;
pub const SN_netscape_ca_revocation_url: &[u8; 18] = b"nsCaRevocationUrl\0";
pub const LN_netscape_ca_revocation_url: &[u8; 27] = b"Netscape CA Revocation Url\0";
pub const NID_netscape_ca_revocation_url: i32 = 74;
pub const SN_netscape_renewal_url: &[u8; 13] = b"nsRenewalUrl\0";
pub const LN_netscape_renewal_url: &[u8; 21] = b"Netscape Renewal Url\0";
pub const NID_netscape_renewal_url: i32 = 75;
pub const SN_netscape_ca_policy_url: &[u8; 14] = b"nsCaPolicyUrl\0";
pub const LN_netscape_ca_policy_url: &[u8; 23] = b"Netscape CA Policy Url\0";
pub const NID_netscape_ca_policy_url: i32 = 76;
pub const SN_netscape_ssl_server_name: &[u8; 16] = b"nsSslServerName\0";
pub const LN_netscape_ssl_server_name: &[u8; 25] = b"Netscape SSL Server Name\0";
pub const NID_netscape_ssl_server_name: i32 = 77;
pub const SN_netscape_comment: &[u8; 10] = b"nsComment\0";
pub const LN_netscape_comment: &[u8; 17] = b"Netscape Comment\0";
pub const NID_netscape_comment: i32 = 78;
pub const SN_netscape_cert_sequence: &[u8; 15] = b"nsCertSequence\0";
pub const LN_netscape_cert_sequence: &[u8; 30] = b"Netscape Certificate Sequence\0";
pub const NID_netscape_cert_sequence: i32 = 79;
pub const SN_desx_cbc: &[u8; 9] = b"DESX-CBC\0";
pub const LN_desx_cbc: &[u8; 9] = b"desx-cbc\0";
pub const NID_desx_cbc: i32 = 80;
pub const SN_id_ce: &[u8; 6] = b"id-ce\0";
pub const NID_id_ce: i32 = 81;
pub const SN_subject_key_identifier: &[u8; 21] = b"subjectKeyIdentifier\0";
pub const LN_subject_key_identifier: &[u8; 30] = b"X509v3 Subject Key Identifier\0";
pub const NID_subject_key_identifier: i32 = 82;
pub const SN_key_usage: &[u8; 9] = b"keyUsage\0";
pub const LN_key_usage: &[u8; 17] = b"X509v3 Key Usage\0";
pub const NID_key_usage: i32 = 83;
pub const SN_private_key_usage_period: &[u8; 22] = b"privateKeyUsagePeriod\0";
pub const LN_private_key_usage_period: &[u8; 32] = b"X509v3 Private Key Usage Period\0";
pub const NID_private_key_usage_period: i32 = 84;
pub const SN_subject_alt_name: &[u8; 15] = b"subjectAltName\0";
pub const LN_subject_alt_name: &[u8; 32] = b"X509v3 Subject Alternative Name\0";
pub const NID_subject_alt_name: i32 = 85;
pub const SN_issuer_alt_name: &[u8; 14] = b"issuerAltName\0";
pub const LN_issuer_alt_name: &[u8; 31] = b"X509v3 Issuer Alternative Name\0";
pub const NID_issuer_alt_name: i32 = 86;
pub const SN_basic_constraints: &[u8; 17] = b"basicConstraints\0";
pub const LN_basic_constraints: &[u8; 25] = b"X509v3 Basic Constraints\0";
pub const NID_basic_constraints: i32 = 87;
pub const SN_crl_number: &[u8; 10] = b"crlNumber\0";
pub const LN_crl_number: &[u8; 18] = b"X509v3 CRL Number\0";
pub const NID_crl_number: i32 = 88;
pub const SN_certificate_policies: &[u8; 20] = b"certificatePolicies\0";
pub const LN_certificate_policies: &[u8; 28] = b"X509v3 Certificate Policies\0";
pub const NID_certificate_policies: i32 = 89;
pub const SN_authority_key_identifier: &[u8; 23] = b"authorityKeyIdentifier\0";
pub const LN_authority_key_identifier: &[u8; 32] = b"X509v3 Authority Key Identifier\0";
pub const NID_authority_key_identifier: i32 = 90;
pub const SN_bf_cbc: &[u8; 7] = b"BF-CBC\0";
pub const LN_bf_cbc: &[u8; 7] = b"bf-cbc\0";
pub const NID_bf_cbc: i32 = 91;
pub const SN_bf_ecb: &[u8; 7] = b"BF-ECB\0";
pub const LN_bf_ecb: &[u8; 7] = b"bf-ecb\0";
pub const NID_bf_ecb: i32 = 92;
pub const SN_bf_cfb64: &[u8; 7] = b"BF-CFB\0";
pub const LN_bf_cfb64: &[u8; 7] = b"bf-cfb\0";
pub const NID_bf_cfb64: i32 = 93;
pub const SN_bf_ofb64: &[u8; 7] = b"BF-OFB\0";
pub const LN_bf_ofb64: &[u8; 7] = b"bf-ofb\0";
pub const NID_bf_ofb64: i32 = 94;
pub const SN_mdc2: &[u8; 5] = b"MDC2\0";
pub const LN_mdc2: &[u8; 5] = b"mdc2\0";
pub const NID_mdc2: i32 = 95;
pub const SN_mdc2WithRSA: &[u8; 9] = b"RSA-MDC2\0";
pub const LN_mdc2WithRSA: &[u8; 12] = b"mdc2WithRSA\0";
pub const NID_mdc2WithRSA: i32 = 96;
pub const SN_rc4_40: &[u8; 7] = b"RC4-40\0";
pub const LN_rc4_40: &[u8; 7] = b"rc4-40\0";
pub const NID_rc4_40: i32 = 97;
pub const SN_rc2_40_cbc: &[u8; 11] = b"RC2-40-CBC\0";
pub const LN_rc2_40_cbc: &[u8; 11] = b"rc2-40-cbc\0";
pub const NID_rc2_40_cbc: i32 = 98;
pub const SN_givenName: &[u8; 3] = b"GN\0";
pub const LN_givenName: &[u8; 10] = b"givenName\0";
pub const NID_givenName: i32 = 99;
pub const SN_surname: &[u8; 3] = b"SN\0";
pub const LN_surname: &[u8; 8] = b"surname\0";
pub const NID_surname: i32 = 100;
pub const SN_initials: &[u8; 9] = b"initials\0";
pub const LN_initials: &[u8; 9] = b"initials\0";
pub const NID_initials: i32 = 101;
pub const SN_crl_distribution_points: &[u8; 22] = b"crlDistributionPoints\0";
pub const LN_crl_distribution_points: &[u8; 31] = b"X509v3 CRL Distribution Points\0";
pub const NID_crl_distribution_points: i32 = 103;
pub const SN_md5WithRSA: &[u8; 11] = b"RSA-NP-MD5\0";
pub const LN_md5WithRSA: &[u8; 11] = b"md5WithRSA\0";
pub const NID_md5WithRSA: i32 = 104;
pub const LN_serialNumber: &[u8; 13] = b"serialNumber\0";
pub const NID_serialNumber: i32 = 105;
pub const SN_title: &[u8; 6] = b"title\0";
pub const LN_title: &[u8; 6] = b"title\0";
pub const NID_title: i32 = 106;
pub const LN_description: &[u8; 12] = b"description\0";
pub const NID_description: i32 = 107;
pub const SN_cast5_cbc: &[u8; 10] = b"CAST5-CBC\0";
pub const LN_cast5_cbc: &[u8; 10] = b"cast5-cbc\0";
pub const NID_cast5_cbc: i32 = 108;
pub const SN_cast5_ecb: &[u8; 10] = b"CAST5-ECB\0";
pub const LN_cast5_ecb: &[u8; 10] = b"cast5-ecb\0";
pub const NID_cast5_ecb: i32 = 109;
pub const SN_cast5_cfb64: &[u8; 10] = b"CAST5-CFB\0";
pub const LN_cast5_cfb64: &[u8; 10] = b"cast5-cfb\0";
pub const NID_cast5_cfb64: i32 = 110;
pub const SN_cast5_ofb64: &[u8; 10] = b"CAST5-OFB\0";
pub const LN_cast5_ofb64: &[u8; 10] = b"cast5-ofb\0";
pub const NID_cast5_ofb64: i32 = 111;
pub const LN_pbeWithMD5AndCast5_CBC: &[u8; 22] = b"pbeWithMD5AndCast5CBC\0";
pub const NID_pbeWithMD5AndCast5_CBC: i32 = 112;
pub const SN_dsaWithSHA1: &[u8; 9] = b"DSA-SHA1\0";
pub const LN_dsaWithSHA1: &[u8; 12] = b"dsaWithSHA1\0";
pub const NID_dsaWithSHA1: i32 = 113;
pub const SN_md5_sha1: &[u8; 9] = b"MD5-SHA1\0";
pub const LN_md5_sha1: &[u8; 9] = b"md5-sha1\0";
pub const NID_md5_sha1: i32 = 114;
pub const SN_sha1WithRSA: &[u8; 11] = b"RSA-SHA1-2\0";
pub const LN_sha1WithRSA: &[u8; 12] = b"sha1WithRSA\0";
pub const NID_sha1WithRSA: i32 = 115;
pub const SN_dsa: &[u8; 4] = b"DSA\0";
pub const LN_dsa: &[u8; 14] = b"dsaEncryption\0";
pub const NID_dsa: i32 = 116;
pub const SN_ripemd160: &[u8; 10] = b"RIPEMD160\0";
pub const LN_ripemd160: &[u8; 10] = b"ripemd160\0";
pub const NID_ripemd160: i32 = 117;
pub const SN_ripemd160WithRSA: &[u8; 14] = b"RSA-RIPEMD160\0";
pub const LN_ripemd160WithRSA: &[u8; 17] = b"ripemd160WithRSA\0";
pub const NID_ripemd160WithRSA: i32 = 119;
pub const SN_rc5_cbc: &[u8; 8] = b"RC5-CBC\0";
pub const LN_rc5_cbc: &[u8; 8] = b"rc5-cbc\0";
pub const NID_rc5_cbc: i32 = 120;
pub const SN_rc5_ecb: &[u8; 8] = b"RC5-ECB\0";
pub const LN_rc5_ecb: &[u8; 8] = b"rc5-ecb\0";
pub const NID_rc5_ecb: i32 = 121;
pub const SN_rc5_cfb64: &[u8; 8] = b"RC5-CFB\0";
pub const LN_rc5_cfb64: &[u8; 8] = b"rc5-cfb\0";
pub const NID_rc5_cfb64: i32 = 122;
pub const SN_rc5_ofb64: &[u8; 8] = b"RC5-OFB\0";
pub const LN_rc5_ofb64: &[u8; 8] = b"rc5-ofb\0";
pub const NID_rc5_ofb64: i32 = 123;
pub const SN_zlib_compression: &[u8; 5] = b"ZLIB\0";
pub const LN_zlib_compression: &[u8; 17] = b"zlib compression\0";
pub const NID_zlib_compression: i32 = 125;
pub const SN_ext_key_usage: &[u8; 17] = b"extendedKeyUsage\0";
pub const LN_ext_key_usage: &[u8; 26] = b"X509v3 Extended Key Usage\0";
pub const NID_ext_key_usage: i32 = 126;
pub const SN_id_pkix: &[u8; 5] = b"PKIX\0";
pub const NID_id_pkix: i32 = 127;
pub const SN_id_kp: &[u8; 6] = b"id-kp\0";
pub const NID_id_kp: i32 = 128;
pub const SN_server_auth: &[u8; 11] = b"serverAuth\0";
pub const LN_server_auth: &[u8; 30] = b"TLS Web Server Authentication\0";
pub const NID_server_auth: i32 = 129;
pub const SN_client_auth: &[u8; 11] = b"clientAuth\0";
pub const LN_client_auth: &[u8; 30] = b"TLS Web Client Authentication\0";
pub const NID_client_auth: i32 = 130;
pub const SN_code_sign: &[u8; 12] = b"codeSigning\0";
pub const LN_code_sign: &[u8; 13] = b"Code Signing\0";
pub const NID_code_sign: i32 = 131;
pub const SN_email_protect: &[u8; 16] = b"emailProtection\0";
pub const LN_email_protect: &[u8; 18] = b"E-mail Protection\0";
pub const NID_email_protect: i32 = 132;
pub const SN_time_stamp: &[u8; 13] = b"timeStamping\0";
pub const LN_time_stamp: &[u8; 14] = b"Time Stamping\0";
pub const NID_time_stamp: i32 = 133;
pub const SN_ms_code_ind: &[u8; 10] = b"msCodeInd\0";
pub const LN_ms_code_ind: &[u8; 34] = b"Microsoft Individual Code Signing\0";
pub const NID_ms_code_ind: i32 = 134;
pub const SN_ms_code_com: &[u8; 10] = b"msCodeCom\0";
pub const LN_ms_code_com: &[u8; 34] = b"Microsoft Commercial Code Signing\0";
pub const NID_ms_code_com: i32 = 135;
pub const SN_ms_ctl_sign: &[u8; 10] = b"msCTLSign\0";
pub const LN_ms_ctl_sign: &[u8; 29] = b"Microsoft Trust List Signing\0";
pub const NID_ms_ctl_sign: i32 = 136;
pub const SN_ms_sgc: &[u8; 6] = b"msSGC\0";
pub const LN_ms_sgc: &[u8; 30] = b"Microsoft Server Gated Crypto\0";
pub const NID_ms_sgc: i32 = 137;
pub const SN_ms_efs: &[u8; 6] = b"msEFS\0";
pub const LN_ms_efs: &[u8; 32] = b"Microsoft Encrypted File System\0";
pub const NID_ms_efs: i32 = 138;
pub const SN_ns_sgc: &[u8; 6] = b"nsSGC\0";
pub const LN_ns_sgc: &[u8; 29] = b"Netscape Server Gated Crypto\0";
pub const NID_ns_sgc: i32 = 139;
pub const SN_delta_crl: &[u8; 9] = b"deltaCRL\0";
pub const LN_delta_crl: &[u8; 27] = b"X509v3 Delta CRL Indicator\0";
pub const NID_delta_crl: i32 = 140;
pub const SN_crl_reason: &[u8; 10] = b"CRLReason\0";
pub const LN_crl_reason: &[u8; 23] = b"X509v3 CRL Reason Code\0";
pub const NID_crl_reason: i32 = 141;
pub const SN_invalidity_date: &[u8; 15] = b"invalidityDate\0";
pub const LN_invalidity_date: &[u8; 16] = b"Invalidity Date\0";
pub const NID_invalidity_date: i32 = 142;
pub const SN_sxnet: &[u8; 8] = b"SXNetID\0";
pub const LN_sxnet: &[u8; 19] = b"Strong Extranet ID\0";
pub const NID_sxnet: i32 = 143;
pub const SN_pbe_WithSHA1And128BitRC4: &[u8; 17] = b"PBE-SHA1-RC4-128\0";
pub const LN_pbe_WithSHA1And128BitRC4: &[u8; 24] = b"pbeWithSHA1And128BitRC4\0";
pub const NID_pbe_WithSHA1And128BitRC4: i32 = 144;
pub const SN_pbe_WithSHA1And40BitRC4: &[u8; 16] = b"PBE-SHA1-RC4-40\0";
pub const LN_pbe_WithSHA1And40BitRC4: &[u8; 23] = b"pbeWithSHA1And40BitRC4\0";
pub const NID_pbe_WithSHA1And40BitRC4: i32 = 145;
pub const SN_pbe_WithSHA1And3_Key_TripleDES_CBC: &[u8; 14] = b"PBE-SHA1-3DES\0";
pub const LN_pbe_WithSHA1And3_Key_TripleDES_CBC: &[u8; 33] = b"pbeWithSHA1And3-KeyTripleDES-CBC\0";
pub const NID_pbe_WithSHA1And3_Key_TripleDES_CBC: i32 = 146;
pub const SN_pbe_WithSHA1And2_Key_TripleDES_CBC: &[u8; 14] = b"PBE-SHA1-2DES\0";
pub const LN_pbe_WithSHA1And2_Key_TripleDES_CBC: &[u8; 33] = b"pbeWithSHA1And2-KeyTripleDES-CBC\0";
pub const NID_pbe_WithSHA1And2_Key_TripleDES_CBC: i32 = 147;
pub const SN_pbe_WithSHA1And128BitRC2_CBC: &[u8; 17] = b"PBE-SHA1-RC2-128\0";
pub const LN_pbe_WithSHA1And128BitRC2_CBC: &[u8; 28] = b"pbeWithSHA1And128BitRC2-CBC\0";
pub const NID_pbe_WithSHA1And128BitRC2_CBC: i32 = 148;
pub const SN_pbe_WithSHA1And40BitRC2_CBC: &[u8; 16] = b"PBE-SHA1-RC2-40\0";
pub const LN_pbe_WithSHA1And40BitRC2_CBC: &[u8; 27] = b"pbeWithSHA1And40BitRC2-CBC\0";
pub const NID_pbe_WithSHA1And40BitRC2_CBC: i32 = 149;
pub const LN_keyBag: &[u8; 7] = b"keyBag\0";
pub const NID_keyBag: i32 = 150;
pub const LN_pkcs8ShroudedKeyBag: &[u8; 20] = b"pkcs8ShroudedKeyBag\0";
pub const NID_pkcs8ShroudedKeyBag: i32 = 151;
pub const LN_certBag: &[u8; 8] = b"certBag\0";
pub const NID_certBag: i32 = 152;
pub const LN_crlBag: &[u8; 7] = b"crlBag\0";
pub const NID_crlBag: i32 = 153;
pub const LN_secretBag: &[u8; 10] = b"secretBag\0";
pub const NID_secretBag: i32 = 154;
pub const LN_safeContentsBag: &[u8; 16] = b"safeContentsBag\0";
pub const NID_safeContentsBag: i32 = 155;
pub const LN_friendlyName: &[u8; 13] = b"friendlyName\0";
pub const NID_friendlyName: i32 = 156;
pub const LN_localKeyID: &[u8; 11] = b"localKeyID\0";
pub const NID_localKeyID: i32 = 157;
pub const LN_x509Certificate: &[u8; 16] = b"x509Certificate\0";
pub const NID_x509Certificate: i32 = 158;
pub const LN_sdsiCertificate: &[u8; 16] = b"sdsiCertificate\0";
pub const NID_sdsiCertificate: i32 = 159;
pub const LN_x509Crl: &[u8; 8] = b"x509Crl\0";
pub const NID_x509Crl: i32 = 160;
pub const LN_pbes2: &[u8; 6] = b"PBES2\0";
pub const NID_pbes2: i32 = 161;
pub const LN_pbmac1: &[u8; 7] = b"PBMAC1\0";
pub const NID_pbmac1: i32 = 162;
pub const LN_hmacWithSHA1: &[u8; 13] = b"hmacWithSHA1\0";
pub const NID_hmacWithSHA1: i32 = 163;
pub const SN_id_qt_cps: &[u8; 10] = b"id-qt-cps\0";
pub const LN_id_qt_cps: &[u8; 21] = b"Policy Qualifier CPS\0";
pub const NID_id_qt_cps: i32 = 164;
pub const SN_id_qt_unotice: &[u8; 14] = b"id-qt-unotice\0";
pub const LN_id_qt_unotice: &[u8; 29] = b"Policy Qualifier User Notice\0";
pub const NID_id_qt_unotice: i32 = 165;
pub const SN_rc2_64_cbc: &[u8; 11] = b"RC2-64-CBC\0";
pub const LN_rc2_64_cbc: &[u8; 11] = b"rc2-64-cbc\0";
pub const NID_rc2_64_cbc: i32 = 166;
pub const SN_SMIMECapabilities: &[u8; 11] = b"SMIME-CAPS\0";
pub const LN_SMIMECapabilities: &[u8; 20] = b"S/MIME Capabilities\0";
pub const NID_SMIMECapabilities: i32 = 167;
pub const SN_pbeWithMD2AndRC2_CBC: &[u8; 15] = b"PBE-MD2-RC2-64\0";
pub const LN_pbeWithMD2AndRC2_CBC: &[u8; 21] = b"pbeWithMD2AndRC2-CBC\0";
pub const NID_pbeWithMD2AndRC2_CBC: i32 = 168;
pub const SN_pbeWithMD5AndRC2_CBC: &[u8; 15] = b"PBE-MD5-RC2-64\0";
pub const LN_pbeWithMD5AndRC2_CBC: &[u8; 21] = b"pbeWithMD5AndRC2-CBC\0";
pub const NID_pbeWithMD5AndRC2_CBC: i32 = 169;
pub const SN_pbeWithSHA1AndDES_CBC: &[u8; 13] = b"PBE-SHA1-DES\0";
pub const LN_pbeWithSHA1AndDES_CBC: &[u8; 22] = b"pbeWithSHA1AndDES-CBC\0";
pub const NID_pbeWithSHA1AndDES_CBC: i32 = 170;
pub const SN_ms_ext_req: &[u8; 9] = b"msExtReq\0";
pub const LN_ms_ext_req: &[u8; 28] = b"Microsoft Extension Request\0";
pub const NID_ms_ext_req: i32 = 171;
pub const SN_ext_req: &[u8; 7] = b"extReq\0";
pub const LN_ext_req: &[u8; 18] = b"Extension Request\0";
pub const NID_ext_req: i32 = 172;
pub const SN_name: &[u8; 5] = b"name\0";
pub const LN_name: &[u8; 5] = b"name\0";
pub const NID_name: i32 = 173;
pub const SN_dnQualifier: &[u8; 12] = b"dnQualifier\0";
pub const LN_dnQualifier: &[u8; 12] = b"dnQualifier\0";
pub const NID_dnQualifier: i32 = 174;
pub const SN_id_pe: &[u8; 6] = b"id-pe\0";
pub const NID_id_pe: i32 = 175;
pub const SN_id_ad: &[u8; 6] = b"id-ad\0";
pub const NID_id_ad: i32 = 176;
pub const SN_info_access: &[u8; 20] = b"authorityInfoAccess\0";
pub const LN_info_access: &[u8; 29] = b"Authority Information Access\0";
pub const NID_info_access: i32 = 177;
pub const SN_ad_OCSP: &[u8; 5] = b"OCSP\0";
pub const LN_ad_OCSP: &[u8; 5] = b"OCSP\0";
pub const NID_ad_OCSP: i32 = 178;
pub const SN_ad_ca_issuers: &[u8; 10] = b"caIssuers\0";
pub const LN_ad_ca_issuers: &[u8; 11] = b"CA Issuers\0";
pub const NID_ad_ca_issuers: i32 = 179;
pub const SN_OCSP_sign: &[u8; 12] = b"OCSPSigning\0";
pub const LN_OCSP_sign: &[u8; 13] = b"OCSP Signing\0";
pub const NID_OCSP_sign: i32 = 180;
pub const SN_iso: &[u8; 4] = b"ISO\0";
pub const LN_iso: &[u8; 4] = b"iso\0";
pub const NID_iso: i32 = 181;
pub const OBJ_iso: i32 = 1;
pub const SN_member_body: &[u8; 12] = b"member-body\0";
pub const LN_member_body: &[u8; 16] = b"ISO Member Body\0";
pub const NID_member_body: i32 = 182;
pub const SN_ISO_US: &[u8; 7] = b"ISO-US\0";
pub const LN_ISO_US: &[u8; 19] = b"ISO US Member Body\0";
pub const NID_ISO_US: i32 = 183;
pub const SN_X9_57: &[u8; 6] = b"X9-57\0";
pub const LN_X9_57: &[u8; 6] = b"X9.57\0";
pub const NID_X9_57: i32 = 184;
pub const SN_X9cm: &[u8; 5] = b"X9cm\0";
pub const LN_X9cm: &[u8; 11] = b"X9.57 CM ?\0";
pub const NID_X9cm: i32 = 185;
pub const SN_pkcs1: &[u8; 6] = b"pkcs1\0";
pub const NID_pkcs1: i32 = 186;
pub const SN_pkcs5: &[u8; 6] = b"pkcs5\0";
pub const NID_pkcs5: i32 = 187;
pub const SN_SMIME: &[u8; 6] = b"SMIME\0";
pub const LN_SMIME: &[u8; 7] = b"S/MIME\0";
pub const NID_SMIME: i32 = 188;
pub const SN_id_smime_mod: &[u8; 13] = b"id-smime-mod\0";
pub const NID_id_smime_mod: i32 = 189;
pub const SN_id_smime_ct: &[u8; 12] = b"id-smime-ct\0";
pub const NID_id_smime_ct: i32 = 190;
pub const SN_id_smime_aa: &[u8; 12] = b"id-smime-aa\0";
pub const NID_id_smime_aa: i32 = 191;
pub const SN_id_smime_alg: &[u8; 13] = b"id-smime-alg\0";
pub const NID_id_smime_alg: i32 = 192;
pub const SN_id_smime_cd: &[u8; 12] = b"id-smime-cd\0";
pub const NID_id_smime_cd: i32 = 193;
pub const SN_id_smime_spq: &[u8; 13] = b"id-smime-spq\0";
pub const NID_id_smime_spq: i32 = 194;
pub const SN_id_smime_cti: &[u8; 13] = b"id-smime-cti\0";
pub const NID_id_smime_cti: i32 = 195;
pub const SN_id_smime_mod_cms: &[u8; 17] = b"id-smime-mod-cms\0";
pub const NID_id_smime_mod_cms: i32 = 196;
pub const SN_id_smime_mod_ess: &[u8; 17] = b"id-smime-mod-ess\0";
pub const NID_id_smime_mod_ess: i32 = 197;
pub const SN_id_smime_mod_oid: &[u8; 17] = b"id-smime-mod-oid\0";
pub const NID_id_smime_mod_oid: i32 = 198;
pub const SN_id_smime_mod_msg_v3: &[u8; 20] = b"id-smime-mod-msg-v3\0";
pub const NID_id_smime_mod_msg_v3: i32 = 199;
pub const SN_id_smime_mod_ets_eSignature_88: &[u8; 31] = b"id-smime-mod-ets-eSignature-88\0";
pub const NID_id_smime_mod_ets_eSignature_88: i32 = 200;
pub const SN_id_smime_mod_ets_eSignature_97: &[u8; 31] = b"id-smime-mod-ets-eSignature-97\0";
pub const NID_id_smime_mod_ets_eSignature_97: i32 = 201;
pub const SN_id_smime_mod_ets_eSigPolicy_88: &[u8; 31] = b"id-smime-mod-ets-eSigPolicy-88\0";
pub const NID_id_smime_mod_ets_eSigPolicy_88: i32 = 202;
pub const SN_id_smime_mod_ets_eSigPolicy_97: &[u8; 31] = b"id-smime-mod-ets-eSigPolicy-97\0";
pub const NID_id_smime_mod_ets_eSigPolicy_97: i32 = 203;
pub const SN_id_smime_ct_receipt: &[u8; 20] = b"id-smime-ct-receipt\0";
pub const NID_id_smime_ct_receipt: i32 = 204;
pub const SN_id_smime_ct_authData: &[u8; 21] = b"id-smime-ct-authData\0";
pub const NID_id_smime_ct_authData: i32 = 205;
pub const SN_id_smime_ct_publishCert: &[u8; 24] = b"id-smime-ct-publishCert\0";
pub const NID_id_smime_ct_publishCert: i32 = 206;
pub const SN_id_smime_ct_TSTInfo: &[u8; 20] = b"id-smime-ct-TSTInfo\0";
pub const NID_id_smime_ct_TSTInfo: i32 = 207;
pub const SN_id_smime_ct_TDTInfo: &[u8; 20] = b"id-smime-ct-TDTInfo\0";
pub const NID_id_smime_ct_TDTInfo: i32 = 208;
pub const SN_id_smime_ct_contentInfo: &[u8; 24] = b"id-smime-ct-contentInfo\0";
pub const NID_id_smime_ct_contentInfo: i32 = 209;
pub const SN_id_smime_ct_DVCSRequestData: &[u8; 28] = b"id-smime-ct-DVCSRequestData\0";
pub const NID_id_smime_ct_DVCSRequestData: i32 = 210;
pub const SN_id_smime_ct_DVCSResponseData: &[u8; 29] = b"id-smime-ct-DVCSResponseData\0";
pub const NID_id_smime_ct_DVCSResponseData: i32 = 211;
pub const SN_id_smime_aa_receiptRequest: &[u8; 27] = b"id-smime-aa-receiptRequest\0";
pub const NID_id_smime_aa_receiptRequest: i32 = 212;
pub const SN_id_smime_aa_securityLabel: &[u8; 26] = b"id-smime-aa-securityLabel\0";
pub const NID_id_smime_aa_securityLabel: i32 = 213;
pub const SN_id_smime_aa_mlExpandHistory: &[u8; 28] = b"id-smime-aa-mlExpandHistory\0";
pub const NID_id_smime_aa_mlExpandHistory: i32 = 214;
pub const SN_id_smime_aa_contentHint: &[u8; 24] = b"id-smime-aa-contentHint\0";
pub const NID_id_smime_aa_contentHint: i32 = 215;
pub const SN_id_smime_aa_msgSigDigest: &[u8; 25] = b"id-smime-aa-msgSigDigest\0";
pub const NID_id_smime_aa_msgSigDigest: i32 = 216;
pub const SN_id_smime_aa_encapContentType: &[u8; 29] = b"id-smime-aa-encapContentType\0";
pub const NID_id_smime_aa_encapContentType: i32 = 217;
pub const SN_id_smime_aa_contentIdentifier: &[u8; 30] = b"id-smime-aa-contentIdentifier\0";
pub const NID_id_smime_aa_contentIdentifier: i32 = 218;
pub const SN_id_smime_aa_macValue: &[u8; 21] = b"id-smime-aa-macValue\0";
pub const NID_id_smime_aa_macValue: i32 = 219;
pub const SN_id_smime_aa_equivalentLabels: &[u8; 29] = b"id-smime-aa-equivalentLabels\0";
pub const NID_id_smime_aa_equivalentLabels: i32 = 220;
pub const SN_id_smime_aa_contentReference: &[u8; 29] = b"id-smime-aa-contentReference\0";
pub const NID_id_smime_aa_contentReference: i32 = 221;
pub const SN_id_smime_aa_encrypKeyPref: &[u8; 26] = b"id-smime-aa-encrypKeyPref\0";
pub const NID_id_smime_aa_encrypKeyPref: i32 = 222;
pub const SN_id_smime_aa_signingCertificate: &[u8; 31] = b"id-smime-aa-signingCertificate\0";
pub const NID_id_smime_aa_signingCertificate: i32 = 223;
pub const SN_id_smime_aa_smimeEncryptCerts: &[u8; 30] = b"id-smime-aa-smimeEncryptCerts\0";
pub const NID_id_smime_aa_smimeEncryptCerts: i32 = 224;
pub const SN_id_smime_aa_timeStampToken: &[u8; 27] = b"id-smime-aa-timeStampToken\0";
pub const NID_id_smime_aa_timeStampToken: i32 = 225;
pub const SN_id_smime_aa_ets_sigPolicyId: &[u8; 28] = b"id-smime-aa-ets-sigPolicyId\0";
pub const NID_id_smime_aa_ets_sigPolicyId: i32 = 226;
pub const SN_id_smime_aa_ets_commitmentType: &[u8; 31] = b"id-smime-aa-ets-commitmentType\0";
pub const NID_id_smime_aa_ets_commitmentType: i32 = 227;
pub const SN_id_smime_aa_ets_signerLocation: &[u8; 31] = b"id-smime-aa-ets-signerLocation\0";
pub const NID_id_smime_aa_ets_signerLocation: i32 = 228;
pub const SN_id_smime_aa_ets_signerAttr: &[u8; 27] = b"id-smime-aa-ets-signerAttr\0";
pub const NID_id_smime_aa_ets_signerAttr: i32 = 229;
pub const SN_id_smime_aa_ets_otherSigCert: &[u8; 29] = b"id-smime-aa-ets-otherSigCert\0";
pub const NID_id_smime_aa_ets_otherSigCert: i32 = 230;
pub const SN_id_smime_aa_ets_contentTimestamp: &[u8; 33] = b"id-smime-aa-ets-contentTimestamp\0";
pub const NID_id_smime_aa_ets_contentTimestamp: i32 = 231;
pub const SN_id_smime_aa_ets_CertificateRefs: &[u8; 32] = b"id-smime-aa-ets-CertificateRefs\0";
pub const NID_id_smime_aa_ets_CertificateRefs: i32 = 232;
pub const SN_id_smime_aa_ets_RevocationRefs: &[u8; 31] = b"id-smime-aa-ets-RevocationRefs\0";
pub const NID_id_smime_aa_ets_RevocationRefs: i32 = 233;
pub const SN_id_smime_aa_ets_certValues: &[u8; 27] = b"id-smime-aa-ets-certValues\0";
pub const NID_id_smime_aa_ets_certValues: i32 = 234;
pub const SN_id_smime_aa_ets_revocationValues: &[u8; 33] = b"id-smime-aa-ets-revocationValues\0";
pub const NID_id_smime_aa_ets_revocationValues: i32 = 235;
pub const SN_id_smime_aa_ets_escTimeStamp: &[u8; 29] = b"id-smime-aa-ets-escTimeStamp\0";
pub const NID_id_smime_aa_ets_escTimeStamp: i32 = 236;
pub const SN_id_smime_aa_ets_certCRLTimestamp: &[u8; 33] = b"id-smime-aa-ets-certCRLTimestamp\0";
pub const NID_id_smime_aa_ets_certCRLTimestamp: i32 = 237;
pub const SN_id_smime_aa_ets_archiveTimeStamp: &[u8; 33] = b"id-smime-aa-ets-archiveTimeStamp\0";
pub const NID_id_smime_aa_ets_archiveTimeStamp: i32 = 238;
pub const SN_id_smime_aa_signatureType: &[u8; 26] = b"id-smime-aa-signatureType\0";
pub const NID_id_smime_aa_signatureType: i32 = 239;
pub const SN_id_smime_aa_dvcs_dvc: &[u8; 21] = b"id-smime-aa-dvcs-dvc\0";
pub const NID_id_smime_aa_dvcs_dvc: i32 = 240;
pub const SN_id_smime_alg_ESDHwith3DES: &[u8; 26] = b"id-smime-alg-ESDHwith3DES\0";
pub const NID_id_smime_alg_ESDHwith3DES: i32 = 241;
pub const SN_id_smime_alg_ESDHwithRC2: &[u8; 25] = b"id-smime-alg-ESDHwithRC2\0";
pub const NID_id_smime_alg_ESDHwithRC2: i32 = 242;
pub const SN_id_smime_alg_3DESwrap: &[u8; 22] = b"id-smime-alg-3DESwrap\0";
pub const NID_id_smime_alg_3DESwrap: i32 = 243;
pub const SN_id_smime_alg_RC2wrap: &[u8; 21] = b"id-smime-alg-RC2wrap\0";
pub const NID_id_smime_alg_RC2wrap: i32 = 244;
pub const SN_id_smime_alg_ESDH: &[u8; 18] = b"id-smime-alg-ESDH\0";
pub const NID_id_smime_alg_ESDH: i32 = 245;
pub const SN_id_smime_alg_CMS3DESwrap: &[u8; 25] = b"id-smime-alg-CMS3DESwrap\0";
pub const NID_id_smime_alg_CMS3DESwrap: i32 = 246;
pub const SN_id_smime_alg_CMSRC2wrap: &[u8; 24] = b"id-smime-alg-CMSRC2wrap\0";
pub const NID_id_smime_alg_CMSRC2wrap: i32 = 247;
pub const SN_id_smime_cd_ldap: &[u8; 17] = b"id-smime-cd-ldap\0";
pub const NID_id_smime_cd_ldap: i32 = 248;
pub const SN_id_smime_spq_ets_sqt_uri: &[u8; 25] = b"id-smime-spq-ets-sqt-uri\0";
pub const NID_id_smime_spq_ets_sqt_uri: i32 = 249;
pub const SN_id_smime_spq_ets_sqt_unotice: &[u8; 29] = b"id-smime-spq-ets-sqt-unotice\0";
pub const NID_id_smime_spq_ets_sqt_unotice: i32 = 250;
pub const SN_id_smime_cti_ets_proofOfOrigin: &[u8; 31] = b"id-smime-cti-ets-proofOfOrigin\0";
pub const NID_id_smime_cti_ets_proofOfOrigin: i32 = 251;
pub const SN_id_smime_cti_ets_proofOfReceipt: &[u8; 32] = b"id-smime-cti-ets-proofOfReceipt\0";
pub const NID_id_smime_cti_ets_proofOfReceipt: i32 = 252;
pub const SN_id_smime_cti_ets_proofOfDelivery: &[u8; 33] = b"id-smime-cti-ets-proofOfDelivery\0";
pub const NID_id_smime_cti_ets_proofOfDelivery: i32 = 253;
pub const SN_id_smime_cti_ets_proofOfSender: &[u8; 31] = b"id-smime-cti-ets-proofOfSender\0";
pub const NID_id_smime_cti_ets_proofOfSender: i32 = 254;
pub const SN_id_smime_cti_ets_proofOfApproval: &[u8; 33] = b"id-smime-cti-ets-proofOfApproval\0";
pub const NID_id_smime_cti_ets_proofOfApproval: i32 = 255;
pub const SN_id_smime_cti_ets_proofOfCreation: &[u8; 33] = b"id-smime-cti-ets-proofOfCreation\0";
pub const NID_id_smime_cti_ets_proofOfCreation: i32 = 256;
pub const SN_md4: &[u8; 4] = b"MD4\0";
pub const LN_md4: &[u8; 4] = b"md4\0";
pub const NID_md4: i32 = 257;
pub const SN_id_pkix_mod: &[u8; 12] = b"id-pkix-mod\0";
pub const NID_id_pkix_mod: i32 = 258;
pub const SN_id_qt: &[u8; 6] = b"id-qt\0";
pub const NID_id_qt: i32 = 259;
pub const SN_id_it: &[u8; 6] = b"id-it\0";
pub const NID_id_it: i32 = 260;
pub const SN_id_pkip: &[u8; 8] = b"id-pkip\0";
pub const NID_id_pkip: i32 = 261;
pub const SN_id_alg: &[u8; 7] = b"id-alg\0";
pub const NID_id_alg: i32 = 262;
pub const SN_id_cmc: &[u8; 7] = b"id-cmc\0";
pub const NID_id_cmc: i32 = 263;
pub const SN_id_on: &[u8; 6] = b"id-on\0";
pub const NID_id_on: i32 = 264;
pub const SN_id_pda: &[u8; 7] = b"id-pda\0";
pub const NID_id_pda: i32 = 265;
pub const SN_id_aca: &[u8; 7] = b"id-aca\0";
pub const NID_id_aca: i32 = 266;
pub const SN_id_qcs: &[u8; 7] = b"id-qcs\0";
pub const NID_id_qcs: i32 = 267;
pub const SN_id_cct: &[u8; 7] = b"id-cct\0";
pub const NID_id_cct: i32 = 268;
pub const SN_id_pkix1_explicit_88: &[u8; 21] = b"id-pkix1-explicit-88\0";
pub const NID_id_pkix1_explicit_88: i32 = 269;
pub const SN_id_pkix1_implicit_88: &[u8; 21] = b"id-pkix1-implicit-88\0";
pub const NID_id_pkix1_implicit_88: i32 = 270;
pub const SN_id_pkix1_explicit_93: &[u8; 21] = b"id-pkix1-explicit-93\0";
pub const NID_id_pkix1_explicit_93: i32 = 271;
pub const SN_id_pkix1_implicit_93: &[u8; 21] = b"id-pkix1-implicit-93\0";
pub const NID_id_pkix1_implicit_93: i32 = 272;
pub const SN_id_mod_crmf: &[u8; 12] = b"id-mod-crmf\0";
pub const NID_id_mod_crmf: i32 = 273;
pub const SN_id_mod_cmc: &[u8; 11] = b"id-mod-cmc\0";
pub const NID_id_mod_cmc: i32 = 274;
pub const SN_id_mod_kea_profile_88: &[u8; 22] = b"id-mod-kea-profile-88\0";
pub const NID_id_mod_kea_profile_88: i32 = 275;
pub const SN_id_mod_kea_profile_93: &[u8; 22] = b"id-mod-kea-profile-93\0";
pub const NID_id_mod_kea_profile_93: i32 = 276;
pub const SN_id_mod_cmp: &[u8; 11] = b"id-mod-cmp\0";
pub const NID_id_mod_cmp: i32 = 277;
pub const SN_id_mod_qualified_cert_88: &[u8; 25] = b"id-mod-qualified-cert-88\0";
pub const NID_id_mod_qualified_cert_88: i32 = 278;
pub const SN_id_mod_qualified_cert_93: &[u8; 25] = b"id-mod-qualified-cert-93\0";
pub const NID_id_mod_qualified_cert_93: i32 = 279;
pub const SN_id_mod_attribute_cert: &[u8; 22] = b"id-mod-attribute-cert\0";
pub const NID_id_mod_attribute_cert: i32 = 280;
pub const SN_id_mod_timestamp_protocol: &[u8; 26] = b"id-mod-timestamp-protocol\0";
pub const NID_id_mod_timestamp_protocol: i32 = 281;
pub const SN_id_mod_ocsp: &[u8; 12] = b"id-mod-ocsp\0";
pub const NID_id_mod_ocsp: i32 = 282;
pub const SN_id_mod_dvcs: &[u8; 12] = b"id-mod-dvcs\0";
pub const NID_id_mod_dvcs: i32 = 283;
pub const SN_id_mod_cmp2000: &[u8; 15] = b"id-mod-cmp2000\0";
pub const NID_id_mod_cmp2000: i32 = 284;
pub const SN_biometricInfo: &[u8; 14] = b"biometricInfo\0";
pub const LN_biometricInfo: &[u8; 15] = b"Biometric Info\0";
pub const NID_biometricInfo: i32 = 285;
pub const SN_qcStatements: &[u8; 13] = b"qcStatements\0";
pub const NID_qcStatements: i32 = 286;
pub const SN_ac_auditEntity: &[u8; 15] = b"ac-auditEntity\0";
pub const NID_ac_auditEntity: i32 = 287;
pub const SN_ac_targeting: &[u8; 13] = b"ac-targeting\0";
pub const NID_ac_targeting: i32 = 288;
pub const SN_aaControls: &[u8; 11] = b"aaControls\0";
pub const NID_aaControls: i32 = 289;
pub const SN_sbgp_ipAddrBlock: &[u8; 17] = b"sbgp-ipAddrBlock\0";
pub const NID_sbgp_ipAddrBlock: i32 = 290;
pub const SN_sbgp_autonomousSysNum: &[u8; 22] = b"sbgp-autonomousSysNum\0";
pub const NID_sbgp_autonomousSysNum: i32 = 291;
pub const SN_sbgp_routerIdentifier: &[u8; 22] = b"sbgp-routerIdentifier\0";
pub const NID_sbgp_routerIdentifier: i32 = 292;
pub const SN_textNotice: &[u8; 11] = b"textNotice\0";
pub const NID_textNotice: i32 = 293;
pub const SN_ipsecEndSystem: &[u8; 15] = b"ipsecEndSystem\0";
pub const LN_ipsecEndSystem: &[u8; 17] = b"IPSec End System\0";
pub const NID_ipsecEndSystem: i32 = 294;
pub const SN_ipsecTunnel: &[u8; 12] = b"ipsecTunnel\0";
pub const LN_ipsecTunnel: &[u8; 13] = b"IPSec Tunnel\0";
pub const NID_ipsecTunnel: i32 = 295;
pub const SN_ipsecUser: &[u8; 10] = b"ipsecUser\0";
pub const LN_ipsecUser: &[u8; 11] = b"IPSec User\0";
pub const NID_ipsecUser: i32 = 296;
pub const SN_dvcs: &[u8; 5] = b"DVCS\0";
pub const LN_dvcs: &[u8; 5] = b"dvcs\0";
pub const NID_dvcs: i32 = 297;
pub const SN_id_it_caProtEncCert: &[u8; 20] = b"id-it-caProtEncCert\0";
pub const NID_id_it_caProtEncCert: i32 = 298;
pub const SN_id_it_signKeyPairTypes: &[u8; 23] = b"id-it-signKeyPairTypes\0";
pub const NID_id_it_signKeyPairTypes: i32 = 299;
pub const SN_id_it_encKeyPairTypes: &[u8; 22] = b"id-it-encKeyPairTypes\0";
pub const NID_id_it_encKeyPairTypes: i32 = 300;
pub const SN_id_it_preferredSymmAlg: &[u8; 23] = b"id-it-preferredSymmAlg\0";
pub const NID_id_it_preferredSymmAlg: i32 = 301;
pub const SN_id_it_caKeyUpdateInfo: &[u8; 22] = b"id-it-caKeyUpdateInfo\0";
pub const NID_id_it_caKeyUpdateInfo: i32 = 302;
pub const SN_id_it_currentCRL: &[u8; 17] = b"id-it-currentCRL\0";
pub const NID_id_it_currentCRL: i32 = 303;
pub const SN_id_it_unsupportedOIDs: &[u8; 22] = b"id-it-unsupportedOIDs\0";
pub const NID_id_it_unsupportedOIDs: i32 = 304;
pub const SN_id_it_subscriptionRequest: &[u8; 26] = b"id-it-subscriptionRequest\0";
pub const NID_id_it_subscriptionRequest: i32 = 305;
pub const SN_id_it_subscriptionResponse: &[u8; 27] = b"id-it-subscriptionResponse\0";
pub const NID_id_it_subscriptionResponse: i32 = 306;
pub const SN_id_it_keyPairParamReq: &[u8; 22] = b"id-it-keyPairParamReq\0";
pub const NID_id_it_keyPairParamReq: i32 = 307;
pub const SN_id_it_keyPairParamRep: &[u8; 22] = b"id-it-keyPairParamRep\0";
pub const NID_id_it_keyPairParamRep: i32 = 308;
pub const SN_id_it_revPassphrase: &[u8; 20] = b"id-it-revPassphrase\0";
pub const NID_id_it_revPassphrase: i32 = 309;
pub const SN_id_it_implicitConfirm: &[u8; 22] = b"id-it-implicitConfirm\0";
pub const NID_id_it_implicitConfirm: i32 = 310;
pub const SN_id_it_confirmWaitTime: &[u8; 22] = b"id-it-confirmWaitTime\0";
pub const NID_id_it_confirmWaitTime: i32 = 311;
pub const SN_id_it_origPKIMessage: &[u8; 21] = b"id-it-origPKIMessage\0";
pub const NID_id_it_origPKIMessage: i32 = 312;
pub const SN_id_regCtrl: &[u8; 11] = b"id-regCtrl\0";
pub const NID_id_regCtrl: i32 = 313;
pub const SN_id_regInfo: &[u8; 11] = b"id-regInfo\0";
pub const NID_id_regInfo: i32 = 314;
pub const SN_id_regCtrl_regToken: &[u8; 20] = b"id-regCtrl-regToken\0";
pub const NID_id_regCtrl_regToken: i32 = 315;
pub const SN_id_regCtrl_authenticator: &[u8; 25] = b"id-regCtrl-authenticator\0";
pub const NID_id_regCtrl_authenticator: i32 = 316;
pub const SN_id_regCtrl_pkiPublicationInfo: &[u8; 30] = b"id-regCtrl-pkiPublicationInfo\0";
pub const NID_id_regCtrl_pkiPublicationInfo: i32 = 317;
pub const SN_id_regCtrl_pkiArchiveOptions: &[u8; 29] = b"id-regCtrl-pkiArchiveOptions\0";
pub const NID_id_regCtrl_pkiArchiveOptions: i32 = 318;
pub const SN_id_regCtrl_oldCertID: &[u8; 21] = b"id-regCtrl-oldCertID\0";
pub const NID_id_regCtrl_oldCertID: i32 = 319;
pub const SN_id_regCtrl_protocolEncrKey: &[u8; 27] = b"id-regCtrl-protocolEncrKey\0";
pub const NID_id_regCtrl_protocolEncrKey: i32 = 320;
pub const SN_id_regInfo_utf8Pairs: &[u8; 21] = b"id-regInfo-utf8Pairs\0";
pub const NID_id_regInfo_utf8Pairs: i32 = 321;
pub const SN_id_regInfo_certReq: &[u8; 19] = b"id-regInfo-certReq\0";
pub const NID_id_regInfo_certReq: i32 = 322;
pub const SN_id_alg_des40: &[u8; 13] = b"id-alg-des40\0";
pub const NID_id_alg_des40: i32 = 323;
pub const SN_id_alg_noSignature: &[u8; 19] = b"id-alg-noSignature\0";
pub const NID_id_alg_noSignature: i32 = 324;
pub const SN_id_alg_dh_sig_hmac_sha1: &[u8; 24] = b"id-alg-dh-sig-hmac-sha1\0";
pub const NID_id_alg_dh_sig_hmac_sha1: i32 = 325;
pub const SN_id_alg_dh_pop: &[u8; 14] = b"id-alg-dh-pop\0";
pub const NID_id_alg_dh_pop: i32 = 326;
pub const SN_id_cmc_statusInfo: &[u8; 18] = b"id-cmc-statusInfo\0";
pub const NID_id_cmc_statusInfo: i32 = 327;
pub const SN_id_cmc_identification: &[u8; 22] = b"id-cmc-identification\0";
pub const NID_id_cmc_identification: i32 = 328;
pub const SN_id_cmc_identityProof: &[u8; 21] = b"id-cmc-identityProof\0";
pub const NID_id_cmc_identityProof: i32 = 329;
pub const SN_id_cmc_dataReturn: &[u8; 18] = b"id-cmc-dataReturn\0";
pub const NID_id_cmc_dataReturn: i32 = 330;
pub const SN_id_cmc_transactionId: &[u8; 21] = b"id-cmc-transactionId\0";
pub const NID_id_cmc_transactionId: i32 = 331;
pub const SN_id_cmc_senderNonce: &[u8; 19] = b"id-cmc-senderNonce\0";
pub const NID_id_cmc_senderNonce: i32 = 332;
pub const SN_id_cmc_recipientNonce: &[u8; 22] = b"id-cmc-recipientNonce\0";
pub const NID_id_cmc_recipientNonce: i32 = 333;
pub const SN_id_cmc_addExtensions: &[u8; 21] = b"id-cmc-addExtensions\0";
pub const NID_id_cmc_addExtensions: i32 = 334;
pub const SN_id_cmc_encryptedPOP: &[u8; 20] = b"id-cmc-encryptedPOP\0";
pub const NID_id_cmc_encryptedPOP: i32 = 335;
pub const SN_id_cmc_decryptedPOP: &[u8; 20] = b"id-cmc-decryptedPOP\0";
pub const NID_id_cmc_decryptedPOP: i32 = 336;
pub const SN_id_cmc_lraPOPWitness: &[u8; 21] = b"id-cmc-lraPOPWitness\0";
pub const NID_id_cmc_lraPOPWitness: i32 = 337;
pub const SN_id_cmc_getCert: &[u8; 15] = b"id-cmc-getCert\0";
pub const NID_id_cmc_getCert: i32 = 338;
pub const SN_id_cmc_getCRL: &[u8; 14] = b"id-cmc-getCRL\0";
pub const NID_id_cmc_getCRL: i32 = 339;
pub const SN_id_cmc_revokeRequest: &[u8; 21] = b"id-cmc-revokeRequest\0";
pub const NID_id_cmc_revokeRequest: i32 = 340;
pub const SN_id_cmc_regInfo: &[u8; 15] = b"id-cmc-regInfo\0";
pub const NID_id_cmc_regInfo: i32 = 341;
pub const SN_id_cmc_responseInfo: &[u8; 20] = b"id-cmc-responseInfo\0";
pub const NID_id_cmc_responseInfo: i32 = 342;
pub const SN_id_cmc_queryPending: &[u8; 20] = b"id-cmc-queryPending\0";
pub const NID_id_cmc_queryPending: i32 = 343;
pub const SN_id_cmc_popLinkRandom: &[u8; 21] = b"id-cmc-popLinkRandom\0";
pub const NID_id_cmc_popLinkRandom: i32 = 344;
pub const SN_id_cmc_popLinkWitness: &[u8; 22] = b"id-cmc-popLinkWitness\0";
pub const NID_id_cmc_popLinkWitness: i32 = 345;
pub const SN_id_cmc_confirmCertAcceptance: &[u8; 29] = b"id-cmc-confirmCertAcceptance\0";
pub const NID_id_cmc_confirmCertAcceptance: i32 = 346;
pub const SN_id_on_personalData: &[u8; 19] = b"id-on-personalData\0";
pub const NID_id_on_personalData: i32 = 347;
pub const SN_id_pda_dateOfBirth: &[u8; 19] = b"id-pda-dateOfBirth\0";
pub const NID_id_pda_dateOfBirth: i32 = 348;
pub const SN_id_pda_placeOfBirth: &[u8; 20] = b"id-pda-placeOfBirth\0";
pub const NID_id_pda_placeOfBirth: i32 = 349;
pub const SN_id_pda_gender: &[u8; 14] = b"id-pda-gender\0";
pub const NID_id_pda_gender: i32 = 351;
pub const SN_id_pda_countryOfCitizenship: &[u8; 28] = b"id-pda-countryOfCitizenship\0";
pub const NID_id_pda_countryOfCitizenship: i32 = 352;
pub const SN_id_pda_countryOfResidence: &[u8; 26] = b"id-pda-countryOfResidence\0";
pub const NID_id_pda_countryOfResidence: i32 = 353;
pub const SN_id_aca_authenticationInfo: &[u8; 26] = b"id-aca-authenticationInfo\0";
pub const NID_id_aca_authenticationInfo: i32 = 354;
pub const SN_id_aca_accessIdentity: &[u8; 22] = b"id-aca-accessIdentity\0";
pub const NID_id_aca_accessIdentity: i32 = 355;
pub const SN_id_aca_chargingIdentity: &[u8; 24] = b"id-aca-chargingIdentity\0";
pub const NID_id_aca_chargingIdentity: i32 = 356;
pub const SN_id_aca_group: &[u8; 13] = b"id-aca-group\0";
pub const NID_id_aca_group: i32 = 357;
pub const SN_id_aca_role: &[u8; 12] = b"id-aca-role\0";
pub const NID_id_aca_role: i32 = 358;
pub const SN_id_qcs_pkixQCSyntax_v1: &[u8; 23] = b"id-qcs-pkixQCSyntax-v1\0";
pub const NID_id_qcs_pkixQCSyntax_v1: i32 = 359;
pub const SN_id_cct_crs: &[u8; 11] = b"id-cct-crs\0";
pub const NID_id_cct_crs: i32 = 360;
pub const SN_id_cct_PKIData: &[u8; 15] = b"id-cct-PKIData\0";
pub const NID_id_cct_PKIData: i32 = 361;
pub const SN_id_cct_PKIResponse: &[u8; 19] = b"id-cct-PKIResponse\0";
pub const NID_id_cct_PKIResponse: i32 = 362;
pub const SN_ad_timeStamping: &[u8; 16] = b"ad_timestamping\0";
pub const LN_ad_timeStamping: &[u8; 17] = b"AD Time Stamping\0";
pub const NID_ad_timeStamping: i32 = 363;
pub const SN_ad_dvcs: &[u8; 8] = b"AD_DVCS\0";
pub const LN_ad_dvcs: &[u8; 8] = b"ad dvcs\0";
pub const NID_ad_dvcs: i32 = 364;
pub const SN_id_pkix_OCSP_basic: &[u8; 18] = b"basicOCSPResponse\0";
pub const LN_id_pkix_OCSP_basic: &[u8; 20] = b"Basic OCSP Response\0";
pub const NID_id_pkix_OCSP_basic: i32 = 365;
pub const SN_id_pkix_OCSP_Nonce: &[u8; 6] = b"Nonce\0";
pub const LN_id_pkix_OCSP_Nonce: &[u8; 11] = b"OCSP Nonce\0";
pub const NID_id_pkix_OCSP_Nonce: i32 = 366;
pub const SN_id_pkix_OCSP_CrlID: &[u8; 6] = b"CrlID\0";
pub const LN_id_pkix_OCSP_CrlID: &[u8; 12] = b"OCSP CRL ID\0";
pub const NID_id_pkix_OCSP_CrlID: i32 = 367;
pub const SN_id_pkix_OCSP_acceptableResponses: &[u8; 20] = b"acceptableResponses\0";
pub const LN_id_pkix_OCSP_acceptableResponses: &[u8; 26] = b"Acceptable OCSP Responses\0";
pub const NID_id_pkix_OCSP_acceptableResponses: i32 = 368;
pub const SN_id_pkix_OCSP_noCheck: &[u8; 8] = b"noCheck\0";
pub const LN_id_pkix_OCSP_noCheck: &[u8; 14] = b"OCSP No Check\0";
pub const NID_id_pkix_OCSP_noCheck: i32 = 369;
pub const SN_id_pkix_OCSP_archiveCutoff: &[u8; 14] = b"archiveCutoff\0";
pub const LN_id_pkix_OCSP_archiveCutoff: &[u8; 20] = b"OCSP Archive Cutoff\0";
pub const NID_id_pkix_OCSP_archiveCutoff: i32 = 370;
pub const SN_id_pkix_OCSP_serviceLocator: &[u8; 15] = b"serviceLocator\0";
pub const LN_id_pkix_OCSP_serviceLocator: &[u8; 21] = b"OCSP Service Locator\0";
pub const NID_id_pkix_OCSP_serviceLocator: i32 = 371;
pub const SN_id_pkix_OCSP_extendedStatus: &[u8; 15] = b"extendedStatus\0";
pub const LN_id_pkix_OCSP_extendedStatus: &[u8; 21] = b"Extended OCSP Status\0";
pub const NID_id_pkix_OCSP_extendedStatus: i32 = 372;
pub const SN_id_pkix_OCSP_valid: &[u8; 6] = b"valid\0";
pub const NID_id_pkix_OCSP_valid: i32 = 373;
pub const SN_id_pkix_OCSP_path: &[u8; 5] = b"path\0";
pub const NID_id_pkix_OCSP_path: i32 = 374;
pub const SN_id_pkix_OCSP_trustRoot: &[u8; 10] = b"trustRoot\0";
pub const LN_id_pkix_OCSP_trustRoot: &[u8; 11] = b"Trust Root\0";
pub const NID_id_pkix_OCSP_trustRoot: i32 = 375;
pub const SN_algorithm: &[u8; 10] = b"algorithm\0";
pub const LN_algorithm: &[u8; 10] = b"algorithm\0";
pub const NID_algorithm: i32 = 376;
pub const SN_rsaSignature: &[u8; 13] = b"rsaSignature\0";
pub const NID_rsaSignature: i32 = 377;
pub const SN_X500algorithms: &[u8; 15] = b"X500algorithms\0";
pub const LN_X500algorithms: &[u8; 32] = b"directory services - algorithms\0";
pub const NID_X500algorithms: i32 = 378;
pub const SN_org: &[u8; 4] = b"ORG\0";
pub const LN_org: &[u8; 4] = b"org\0";
pub const NID_org: i32 = 379;
pub const SN_dod: &[u8; 4] = b"DOD\0";
pub const LN_dod: &[u8; 4] = b"dod\0";
pub const NID_dod: i32 = 380;
pub const SN_iana: &[u8; 5] = b"IANA\0";
pub const LN_iana: &[u8; 5] = b"iana\0";
pub const NID_iana: i32 = 381;
pub const SN_Directory: &[u8; 10] = b"directory\0";
pub const LN_Directory: &[u8; 10] = b"Directory\0";
pub const NID_Directory: i32 = 382;
pub const SN_Management: &[u8; 5] = b"mgmt\0";
pub const LN_Management: &[u8; 11] = b"Management\0";
pub const NID_Management: i32 = 383;
pub const SN_Experimental: &[u8; 13] = b"experimental\0";
pub const LN_Experimental: &[u8; 13] = b"Experimental\0";
pub const NID_Experimental: i32 = 384;
pub const SN_Private: &[u8; 8] = b"private\0";
pub const LN_Private: &[u8; 8] = b"Private\0";
pub const NID_Private: i32 = 385;
pub const SN_Security: &[u8; 9] = b"security\0";
pub const LN_Security: &[u8; 9] = b"Security\0";
pub const NID_Security: i32 = 386;
pub const SN_SNMPv2: &[u8; 7] = b"snmpv2\0";
pub const LN_SNMPv2: &[u8; 7] = b"SNMPv2\0";
pub const NID_SNMPv2: i32 = 387;
pub const LN_Mail: &[u8; 5] = b"Mail\0";
pub const NID_Mail: i32 = 388;
pub const SN_Enterprises: &[u8; 12] = b"enterprises\0";
pub const LN_Enterprises: &[u8; 12] = b"Enterprises\0";
pub const NID_Enterprises: i32 = 389;
pub const SN_dcObject: &[u8; 9] = b"dcobject\0";
pub const LN_dcObject: &[u8; 9] = b"dcObject\0";
pub const NID_dcObject: i32 = 390;
pub const SN_domainComponent: &[u8; 3] = b"DC\0";
pub const LN_domainComponent: &[u8; 16] = b"domainComponent\0";
pub const NID_domainComponent: i32 = 391;
pub const SN_Domain: &[u8; 7] = b"domain\0";
pub const LN_Domain: &[u8; 7] = b"Domain\0";
pub const NID_Domain: i32 = 392;
pub const SN_selected_attribute_types: &[u8; 25] = b"selected-attribute-types\0";
pub const LN_selected_attribute_types: &[u8; 25] = b"Selected Attribute Types\0";
pub const NID_selected_attribute_types: i32 = 394;
pub const SN_clearance: &[u8; 10] = b"clearance\0";
pub const NID_clearance: i32 = 395;
pub const SN_md4WithRSAEncryption: &[u8; 8] = b"RSA-MD4\0";
pub const LN_md4WithRSAEncryption: &[u8; 21] = b"md4WithRSAEncryption\0";
pub const NID_md4WithRSAEncryption: i32 = 396;
pub const SN_ac_proxying: &[u8; 12] = b"ac-proxying\0";
pub const NID_ac_proxying: i32 = 397;
pub const SN_sinfo_access: &[u8; 18] = b"subjectInfoAccess\0";
pub const LN_sinfo_access: &[u8; 27] = b"Subject Information Access\0";
pub const NID_sinfo_access: i32 = 398;
pub const SN_id_aca_encAttrs: &[u8; 16] = b"id-aca-encAttrs\0";
pub const NID_id_aca_encAttrs: i32 = 399;
pub const SN_role: &[u8; 5] = b"role\0";
pub const LN_role: &[u8; 5] = b"role\0";
pub const NID_role: i32 = 400;
pub const SN_policy_constraints: &[u8; 18] = b"policyConstraints\0";
pub const LN_policy_constraints: &[u8; 26] = b"X509v3 Policy Constraints\0";
pub const NID_policy_constraints: i32 = 401;
pub const SN_target_information: &[u8; 18] = b"targetInformation\0";
pub const LN_target_information: &[u8; 20] = b"X509v3 AC Targeting\0";
pub const NID_target_information: i32 = 402;
pub const SN_no_rev_avail: &[u8; 11] = b"noRevAvail\0";
pub const LN_no_rev_avail: &[u8; 31] = b"X509v3 No Revocation Available\0";
pub const NID_no_rev_avail: i32 = 403;
pub const SN_ansi_X9_62: &[u8; 11] = b"ansi-X9-62\0";
pub const LN_ansi_X9_62: &[u8; 11] = b"ANSI X9.62\0";
pub const NID_ansi_X9_62: i32 = 405;
pub const SN_X9_62_prime_field: &[u8; 12] = b"prime-field\0";
pub const NID_X9_62_prime_field: i32 = 406;
pub const SN_X9_62_characteristic_two_field: &[u8; 25] = b"characteristic-two-field\0";
pub const NID_X9_62_characteristic_two_field: i32 = 407;
pub const SN_X9_62_id_ecPublicKey: &[u8; 15] = b"id-ecPublicKey\0";
pub const NID_X9_62_id_ecPublicKey: i32 = 408;
pub const SN_X9_62_prime192v1: &[u8; 11] = b"prime192v1\0";
pub const NID_X9_62_prime192v1: i32 = 409;
pub const SN_X9_62_prime192v2: &[u8; 11] = b"prime192v2\0";
pub const NID_X9_62_prime192v2: i32 = 410;
pub const SN_X9_62_prime192v3: &[u8; 11] = b"prime192v3\0";
pub const NID_X9_62_prime192v3: i32 = 411;
pub const SN_X9_62_prime239v1: &[u8; 11] = b"prime239v1\0";
pub const NID_X9_62_prime239v1: i32 = 412;
pub const SN_X9_62_prime239v2: &[u8; 11] = b"prime239v2\0";
pub const NID_X9_62_prime239v2: i32 = 413;
pub const SN_X9_62_prime239v3: &[u8; 11] = b"prime239v3\0";
pub const NID_X9_62_prime239v3: i32 = 414;
pub const SN_X9_62_prime256v1: &[u8; 11] = b"prime256v1\0";
pub const NID_X9_62_prime256v1: i32 = 415;
pub const SN_ecdsa_with_SHA1: &[u8; 16] = b"ecdsa-with-SHA1\0";
pub const NID_ecdsa_with_SHA1: i32 = 416;
pub const SN_ms_csp_name: &[u8; 8] = b"CSPName\0";
pub const LN_ms_csp_name: &[u8; 19] = b"Microsoft CSP Name\0";
pub const NID_ms_csp_name: i32 = 417;
pub const SN_aes_128_ecb: &[u8; 12] = b"AES-128-ECB\0";
pub const LN_aes_128_ecb: &[u8; 12] = b"aes-128-ecb\0";
pub const NID_aes_128_ecb: i32 = 418;
pub const SN_aes_128_cbc: &[u8; 12] = b"AES-128-CBC\0";
pub const LN_aes_128_cbc: &[u8; 12] = b"aes-128-cbc\0";
pub const NID_aes_128_cbc: i32 = 419;
pub const SN_aes_128_ofb128: &[u8; 12] = b"AES-128-OFB\0";
pub const LN_aes_128_ofb128: &[u8; 12] = b"aes-128-ofb\0";
pub const NID_aes_128_ofb128: i32 = 420;
pub const SN_aes_128_cfb128: &[u8; 12] = b"AES-128-CFB\0";
pub const LN_aes_128_cfb128: &[u8; 12] = b"aes-128-cfb\0";
pub const NID_aes_128_cfb128: i32 = 421;
pub const SN_aes_192_ecb: &[u8; 12] = b"AES-192-ECB\0";
pub const LN_aes_192_ecb: &[u8; 12] = b"aes-192-ecb\0";
pub const NID_aes_192_ecb: i32 = 422;
pub const SN_aes_192_cbc: &[u8; 12] = b"AES-192-CBC\0";
pub const LN_aes_192_cbc: &[u8; 12] = b"aes-192-cbc\0";
pub const NID_aes_192_cbc: i32 = 423;
pub const SN_aes_192_ofb128: &[u8; 12] = b"AES-192-OFB\0";
pub const LN_aes_192_ofb128: &[u8; 12] = b"aes-192-ofb\0";
pub const NID_aes_192_ofb128: i32 = 424;
pub const SN_aes_192_cfb128: &[u8; 12] = b"AES-192-CFB\0";
pub const LN_aes_192_cfb128: &[u8; 12] = b"aes-192-cfb\0";
pub const NID_aes_192_cfb128: i32 = 425;
pub const SN_aes_256_ecb: &[u8; 12] = b"AES-256-ECB\0";
pub const LN_aes_256_ecb: &[u8; 12] = b"aes-256-ecb\0";
pub const NID_aes_256_ecb: i32 = 426;
pub const SN_aes_256_cbc: &[u8; 12] = b"AES-256-CBC\0";
pub const LN_aes_256_cbc: &[u8; 12] = b"aes-256-cbc\0";
pub const NID_aes_256_cbc: i32 = 427;
pub const SN_aes_256_ofb128: &[u8; 12] = b"AES-256-OFB\0";
pub const LN_aes_256_ofb128: &[u8; 12] = b"aes-256-ofb\0";
pub const NID_aes_256_ofb128: i32 = 428;
pub const SN_aes_256_cfb128: &[u8; 12] = b"AES-256-CFB\0";
pub const LN_aes_256_cfb128: &[u8; 12] = b"aes-256-cfb\0";
pub const NID_aes_256_cfb128: i32 = 429;
pub const SN_hold_instruction_code: &[u8; 20] = b"holdInstructionCode\0";
pub const LN_hold_instruction_code: &[u8; 22] = b"Hold Instruction Code\0";
pub const NID_hold_instruction_code: i32 = 430;
pub const SN_hold_instruction_none: &[u8; 20] = b"holdInstructionNone\0";
pub const LN_hold_instruction_none: &[u8; 22] = b"Hold Instruction None\0";
pub const NID_hold_instruction_none: i32 = 431;
pub const SN_hold_instruction_call_issuer: &[u8; 26] = b"holdInstructionCallIssuer\0";
pub const LN_hold_instruction_call_issuer: &[u8; 29] = b"Hold Instruction Call Issuer\0";
pub const NID_hold_instruction_call_issuer: i32 = 432;
pub const SN_hold_instruction_reject: &[u8; 22] = b"holdInstructionReject\0";
pub const LN_hold_instruction_reject: &[u8; 24] = b"Hold Instruction Reject\0";
pub const NID_hold_instruction_reject: i32 = 433;
pub const SN_data: &[u8; 5] = b"data\0";
pub const NID_data: i32 = 434;
pub const SN_pss: &[u8; 4] = b"pss\0";
pub const NID_pss: i32 = 435;
pub const SN_ucl: &[u8; 4] = b"ucl\0";
pub const NID_ucl: i32 = 436;
pub const SN_pilot: &[u8; 6] = b"pilot\0";
pub const NID_pilot: i32 = 437;
pub const LN_pilotAttributeType: &[u8; 19] = b"pilotAttributeType\0";
pub const NID_pilotAttributeType: i32 = 438;
pub const LN_pilotAttributeSyntax: &[u8; 21] = b"pilotAttributeSyntax\0";
pub const NID_pilotAttributeSyntax: i32 = 439;
pub const LN_pilotObjectClass: &[u8; 17] = b"pilotObjectClass\0";
pub const NID_pilotObjectClass: i32 = 440;
pub const LN_pilotGroups: &[u8; 12] = b"pilotGroups\0";
pub const NID_pilotGroups: i32 = 441;
pub const LN_iA5StringSyntax: &[u8; 16] = b"iA5StringSyntax\0";
pub const NID_iA5StringSyntax: i32 = 442;
pub const LN_caseIgnoreIA5StringSyntax: &[u8; 26] = b"caseIgnoreIA5StringSyntax\0";
pub const NID_caseIgnoreIA5StringSyntax: i32 = 443;
pub const LN_pilotObject: &[u8; 12] = b"pilotObject\0";
pub const NID_pilotObject: i32 = 444;
pub const LN_pilotPerson: &[u8; 12] = b"pilotPerson\0";
pub const NID_pilotPerson: i32 = 445;
pub const SN_account: &[u8; 8] = b"account\0";
pub const NID_account: i32 = 446;
pub const SN_document: &[u8; 9] = b"document\0";
pub const NID_document: i32 = 447;
pub const SN_room: &[u8; 5] = b"room\0";
pub const NID_room: i32 = 448;
pub const LN_documentSeries: &[u8; 15] = b"documentSeries\0";
pub const NID_documentSeries: i32 = 449;
pub const LN_rFC822localPart: &[u8; 16] = b"rFC822localPart\0";
pub const NID_rFC822localPart: i32 = 450;
pub const LN_dNSDomain: &[u8; 10] = b"dNSDomain\0";
pub const NID_dNSDomain: i32 = 451;
pub const LN_domainRelatedObject: &[u8; 20] = b"domainRelatedObject\0";
pub const NID_domainRelatedObject: i32 = 452;
pub const LN_friendlyCountry: &[u8; 16] = b"friendlyCountry\0";
pub const NID_friendlyCountry: i32 = 453;
pub const LN_simpleSecurityObject: &[u8; 21] = b"simpleSecurityObject\0";
pub const NID_simpleSecurityObject: i32 = 454;
pub const LN_pilotOrganization: &[u8; 18] = b"pilotOrganization\0";
pub const NID_pilotOrganization: i32 = 455;
pub const LN_pilotDSA: &[u8; 9] = b"pilotDSA\0";
pub const NID_pilotDSA: i32 = 456;
pub const LN_qualityLabelledData: &[u8; 20] = b"qualityLabelledData\0";
pub const NID_qualityLabelledData: i32 = 457;
pub const SN_userId: &[u8; 4] = b"UID\0";
pub const LN_userId: &[u8; 7] = b"userId\0";
pub const NID_userId: i32 = 458;
pub const LN_textEncodedORAddress: &[u8; 21] = b"textEncodedORAddress\0";
pub const NID_textEncodedORAddress: i32 = 459;
pub const SN_rfc822Mailbox: &[u8; 5] = b"mail\0";
pub const LN_rfc822Mailbox: &[u8; 14] = b"rfc822Mailbox\0";
pub const NID_rfc822Mailbox: i32 = 460;
pub const SN_info: &[u8; 5] = b"info\0";
pub const NID_info: i32 = 461;
pub const LN_favouriteDrink: &[u8; 15] = b"favouriteDrink\0";
pub const NID_favouriteDrink: i32 = 462;
pub const LN_roomNumber: &[u8; 11] = b"roomNumber\0";
pub const NID_roomNumber: i32 = 463;
pub const SN_photo: &[u8; 6] = b"photo\0";
pub const NID_photo: i32 = 464;
pub const LN_userClass: &[u8; 10] = b"userClass\0";
pub const NID_userClass: i32 = 465;
pub const SN_host: &[u8; 5] = b"host\0";
pub const NID_host: i32 = 466;
pub const SN_manager: &[u8; 8] = b"manager\0";
pub const NID_manager: i32 = 467;
pub const LN_documentIdentifier: &[u8; 19] = b"documentIdentifier\0";
pub const NID_documentIdentifier: i32 = 468;
pub const LN_documentTitle: &[u8; 14] = b"documentTitle\0";
pub const NID_documentTitle: i32 = 469;
pub const LN_documentVersion: &[u8; 16] = b"documentVersion\0";
pub const NID_documentVersion: i32 = 470;
pub const LN_documentAuthor: &[u8; 15] = b"documentAuthor\0";
pub const NID_documentAuthor: i32 = 471;
pub const LN_documentLocation: &[u8; 17] = b"documentLocation\0";
pub const NID_documentLocation: i32 = 472;
pub const LN_homeTelephoneNumber: &[u8; 20] = b"homeTelephoneNumber\0";
pub const NID_homeTelephoneNumber: i32 = 473;
pub const SN_secretary: &[u8; 10] = b"secretary\0";
pub const NID_secretary: i32 = 474;
pub const LN_otherMailbox: &[u8; 13] = b"otherMailbox\0";
pub const NID_otherMailbox: i32 = 475;
pub const LN_lastModifiedTime: &[u8; 17] = b"lastModifiedTime\0";
pub const NID_lastModifiedTime: i32 = 476;
pub const LN_lastModifiedBy: &[u8; 15] = b"lastModifiedBy\0";
pub const NID_lastModifiedBy: i32 = 477;
pub const LN_aRecord: &[u8; 8] = b"aRecord\0";
pub const NID_aRecord: i32 = 478;
pub const LN_pilotAttributeType27: &[u8; 21] = b"pilotAttributeType27\0";
pub const NID_pilotAttributeType27: i32 = 479;
pub const LN_mXRecord: &[u8; 9] = b"mXRecord\0";
pub const NID_mXRecord: i32 = 480;
pub const LN_nSRecord: &[u8; 9] = b"nSRecord\0";
pub const NID_nSRecord: i32 = 481;
pub const LN_sOARecord: &[u8; 10] = b"sOARecord\0";
pub const NID_sOARecord: i32 = 482;
pub const LN_cNAMERecord: &[u8; 12] = b"cNAMERecord\0";
pub const NID_cNAMERecord: i32 = 483;
pub const LN_associatedDomain: &[u8; 17] = b"associatedDomain\0";
pub const NID_associatedDomain: i32 = 484;
pub const LN_associatedName: &[u8; 15] = b"associatedName\0";
pub const NID_associatedName: i32 = 485;
pub const LN_homePostalAddress: &[u8; 18] = b"homePostalAddress\0";
pub const NID_homePostalAddress: i32 = 486;
pub const LN_personalTitle: &[u8; 14] = b"personalTitle\0";
pub const NID_personalTitle: i32 = 487;
pub const LN_mobileTelephoneNumber: &[u8; 22] = b"mobileTelephoneNumber\0";
pub const NID_mobileTelephoneNumber: i32 = 488;
pub const LN_pagerTelephoneNumber: &[u8; 21] = b"pagerTelephoneNumber\0";
pub const NID_pagerTelephoneNumber: i32 = 489;
pub const LN_friendlyCountryName: &[u8; 20] = b"friendlyCountryName\0";
pub const NID_friendlyCountryName: i32 = 490;
pub const LN_organizationalStatus: &[u8; 21] = b"organizationalStatus\0";
pub const NID_organizationalStatus: i32 = 491;
pub const LN_janetMailbox: &[u8; 13] = b"janetMailbox\0";
pub const NID_janetMailbox: i32 = 492;
pub const LN_mailPreferenceOption: &[u8; 21] = b"mailPreferenceOption\0";
pub const NID_mailPreferenceOption: i32 = 493;
pub const LN_buildingName: &[u8; 13] = b"buildingName\0";
pub const NID_buildingName: i32 = 494;
pub const LN_dSAQuality: &[u8; 11] = b"dSAQuality\0";
pub const NID_dSAQuality: i32 = 495;
pub const LN_singleLevelQuality: &[u8; 19] = b"singleLevelQuality\0";
pub const NID_singleLevelQuality: i32 = 496;
pub const LN_subtreeMinimumQuality: &[u8; 22] = b"subtreeMinimumQuality\0";
pub const NID_subtreeMinimumQuality: i32 = 497;
pub const LN_subtreeMaximumQuality: &[u8; 22] = b"subtreeMaximumQuality\0";
pub const NID_subtreeMaximumQuality: i32 = 498;
pub const LN_personalSignature: &[u8; 18] = b"personalSignature\0";
pub const NID_personalSignature: i32 = 499;
pub const LN_dITRedirect: &[u8; 12] = b"dITRedirect\0";
pub const NID_dITRedirect: i32 = 500;
pub const SN_audio: &[u8; 6] = b"audio\0";
pub const NID_audio: i32 = 501;
pub const LN_documentPublisher: &[u8; 18] = b"documentPublisher\0";
pub const NID_documentPublisher: i32 = 502;
pub const LN_x500UniqueIdentifier: &[u8; 21] = b"x500UniqueIdentifier\0";
pub const NID_x500UniqueIdentifier: i32 = 503;
pub const SN_mime_mhs: &[u8; 9] = b"mime-mhs\0";
pub const LN_mime_mhs: &[u8; 9] = b"MIME MHS\0";
pub const NID_mime_mhs: i32 = 504;
pub const SN_mime_mhs_headings: &[u8; 18] = b"mime-mhs-headings\0";
pub const LN_mime_mhs_headings: &[u8; 18] = b"mime-mhs-headings\0";
pub const NID_mime_mhs_headings: i32 = 505;
pub const SN_mime_mhs_bodies: &[u8; 16] = b"mime-mhs-bodies\0";
pub const LN_mime_mhs_bodies: &[u8; 16] = b"mime-mhs-bodies\0";
pub const NID_mime_mhs_bodies: i32 = 506;
pub const SN_id_hex_partial_message: &[u8; 23] = b"id-hex-partial-message\0";
pub const LN_id_hex_partial_message: &[u8; 23] = b"id-hex-partial-message\0";
pub const NID_id_hex_partial_message: i32 = 507;
pub const SN_id_hex_multipart_message: &[u8; 25] = b"id-hex-multipart-message\0";
pub const LN_id_hex_multipart_message: &[u8; 25] = b"id-hex-multipart-message\0";
pub const NID_id_hex_multipart_message: i32 = 508;
pub const LN_generationQualifier: &[u8; 20] = b"generationQualifier\0";
pub const NID_generationQualifier: i32 = 509;
pub const LN_pseudonym: &[u8; 10] = b"pseudonym\0";
pub const NID_pseudonym: i32 = 510;
pub const SN_id_set: &[u8; 7] = b"id-set\0";
pub const LN_id_set: &[u8; 31] = b"Secure Electronic Transactions\0";
pub const NID_id_set: i32 = 512;
pub const SN_set_ctype: &[u8; 10] = b"set-ctype\0";
pub const LN_set_ctype: &[u8; 14] = b"content types\0";
pub const NID_set_ctype: i32 = 513;
pub const SN_set_msgExt: &[u8; 11] = b"set-msgExt\0";
pub const LN_set_msgExt: &[u8; 19] = b"message extensions\0";
pub const NID_set_msgExt: i32 = 514;
pub const SN_set_attr: &[u8; 9] = b"set-attr\0";
pub const NID_set_attr: i32 = 515;
pub const SN_set_policy: &[u8; 11] = b"set-policy\0";
pub const NID_set_policy: i32 = 516;
pub const SN_set_certExt: &[u8; 12] = b"set-certExt\0";
pub const LN_set_certExt: &[u8; 23] = b"certificate extensions\0";
pub const NID_set_certExt: i32 = 517;
pub const SN_set_brand: &[u8; 10] = b"set-brand\0";
pub const NID_set_brand: i32 = 518;
pub const SN_setct_PANData: &[u8; 14] = b"setct-PANData\0";
pub const NID_setct_PANData: i32 = 519;
pub const SN_setct_PANToken: &[u8; 15] = b"setct-PANToken\0";
pub const NID_setct_PANToken: i32 = 520;
pub const SN_setct_PANOnly: &[u8; 14] = b"setct-PANOnly\0";
pub const NID_setct_PANOnly: i32 = 521;
pub const SN_setct_OIData: &[u8; 13] = b"setct-OIData\0";
pub const NID_setct_OIData: i32 = 522;
pub const SN_setct_PI: &[u8; 9] = b"setct-PI\0";
pub const NID_setct_PI: i32 = 523;
pub const SN_setct_PIData: &[u8; 13] = b"setct-PIData\0";
pub const NID_setct_PIData: i32 = 524;
pub const SN_setct_PIDataUnsigned: &[u8; 21] = b"setct-PIDataUnsigned\0";
pub const NID_setct_PIDataUnsigned: i32 = 525;
pub const SN_setct_HODInput: &[u8; 15] = b"setct-HODInput\0";
pub const NID_setct_HODInput: i32 = 526;
pub const SN_setct_AuthResBaggage: &[u8; 21] = b"setct-AuthResBaggage\0";
pub const NID_setct_AuthResBaggage: i32 = 527;
pub const SN_setct_AuthRevReqBaggage: &[u8; 24] = b"setct-AuthRevReqBaggage\0";
pub const NID_setct_AuthRevReqBaggage: i32 = 528;
pub const SN_setct_AuthRevResBaggage: &[u8; 24] = b"setct-AuthRevResBaggage\0";
pub const NID_setct_AuthRevResBaggage: i32 = 529;
pub const SN_setct_CapTokenSeq: &[u8; 18] = b"setct-CapTokenSeq\0";
pub const NID_setct_CapTokenSeq: i32 = 530;
pub const SN_setct_PInitResData: &[u8; 19] = b"setct-PInitResData\0";
pub const NID_setct_PInitResData: i32 = 531;
pub const SN_setct_PI_TBS: &[u8; 13] = b"setct-PI-TBS\0";
pub const NID_setct_PI_TBS: i32 = 532;
pub const SN_setct_PResData: &[u8; 15] = b"setct-PResData\0";
pub const NID_setct_PResData: i32 = 533;
pub const SN_setct_AuthReqTBS: &[u8; 17] = b"setct-AuthReqTBS\0";
pub const NID_setct_AuthReqTBS: i32 = 534;
pub const SN_setct_AuthResTBS: &[u8; 17] = b"setct-AuthResTBS\0";
pub const NID_setct_AuthResTBS: i32 = 535;
pub const SN_setct_AuthResTBSX: &[u8; 18] = b"setct-AuthResTBSX\0";
pub const NID_setct_AuthResTBSX: i32 = 536;
pub const SN_setct_AuthTokenTBS: &[u8; 19] = b"setct-AuthTokenTBS\0";
pub const NID_setct_AuthTokenTBS: i32 = 537;
pub const SN_setct_CapTokenData: &[u8; 19] = b"setct-CapTokenData\0";
pub const NID_setct_CapTokenData: i32 = 538;
pub const SN_setct_CapTokenTBS: &[u8; 18] = b"setct-CapTokenTBS\0";
pub const NID_setct_CapTokenTBS: i32 = 539;
pub const SN_setct_AcqCardCodeMsg: &[u8; 21] = b"setct-AcqCardCodeMsg\0";
pub const NID_setct_AcqCardCodeMsg: i32 = 540;
pub const SN_setct_AuthRevReqTBS: &[u8; 20] = b"setct-AuthRevReqTBS\0";
pub const NID_setct_AuthRevReqTBS: i32 = 541;
pub const SN_setct_AuthRevResData: &[u8; 21] = b"setct-AuthRevResData\0";
pub const NID_setct_AuthRevResData: i32 = 542;
pub const SN_setct_AuthRevResTBS: &[u8; 20] = b"setct-AuthRevResTBS\0";
pub const NID_setct_AuthRevResTBS: i32 = 543;
pub const SN_setct_CapReqTBS: &[u8; 16] = b"setct-CapReqTBS\0";
pub const NID_setct_CapReqTBS: i32 = 544;
pub const SN_setct_CapReqTBSX: &[u8; 17] = b"setct-CapReqTBSX\0";
pub const NID_setct_CapReqTBSX: i32 = 545;
pub const SN_setct_CapResData: &[u8; 17] = b"setct-CapResData\0";
pub const NID_setct_CapResData: i32 = 546;
pub const SN_setct_CapRevReqTBS: &[u8; 19] = b"setct-CapRevReqTBS\0";
pub const NID_setct_CapRevReqTBS: i32 = 547;
pub const SN_setct_CapRevReqTBSX: &[u8; 20] = b"setct-CapRevReqTBSX\0";
pub const NID_setct_CapRevReqTBSX: i32 = 548;
pub const SN_setct_CapRevResData: &[u8; 20] = b"setct-CapRevResData\0";
pub const NID_setct_CapRevResData: i32 = 549;
pub const SN_setct_CredReqTBS: &[u8; 17] = b"setct-CredReqTBS\0";
pub const NID_setct_CredReqTBS: i32 = 550;
pub const SN_setct_CredReqTBSX: &[u8; 18] = b"setct-CredReqTBSX\0";
pub const NID_setct_CredReqTBSX: i32 = 551;
pub const SN_setct_CredResData: &[u8; 18] = b"setct-CredResData\0";
pub const NID_setct_CredResData: i32 = 552;
pub const SN_setct_CredRevReqTBS: &[u8; 20] = b"setct-CredRevReqTBS\0";
pub const NID_setct_CredRevReqTBS: i32 = 553;
pub const SN_setct_CredRevReqTBSX: &[u8; 21] = b"setct-CredRevReqTBSX\0";
pub const NID_setct_CredRevReqTBSX: i32 = 554;
pub const SN_setct_CredRevResData: &[u8; 21] = b"setct-CredRevResData\0";
pub const NID_setct_CredRevResData: i32 = 555;
pub const SN_setct_PCertReqData: &[u8; 19] = b"setct-PCertReqData\0";
pub const NID_setct_PCertReqData: i32 = 556;
pub const SN_setct_PCertResTBS: &[u8; 18] = b"setct-PCertResTBS\0";
pub const NID_setct_PCertResTBS: i32 = 557;
pub const SN_setct_BatchAdminReqData: &[u8; 24] = b"setct-BatchAdminReqData\0";
pub const NID_setct_BatchAdminReqData: i32 = 558;
pub const SN_setct_BatchAdminResData: &[u8; 24] = b"setct-BatchAdminResData\0";
pub const NID_setct_BatchAdminResData: i32 = 559;
pub const SN_setct_CardCInitResTBS: &[u8; 22] = b"setct-CardCInitResTBS\0";
pub const NID_setct_CardCInitResTBS: i32 = 560;
pub const SN_setct_MeAqCInitResTBS: &[u8; 22] = b"setct-MeAqCInitResTBS\0";
pub const NID_setct_MeAqCInitResTBS: i32 = 561;
pub const SN_setct_RegFormResTBS: &[u8; 20] = b"setct-RegFormResTBS\0";
pub const NID_setct_RegFormResTBS: i32 = 562;
pub const SN_setct_CertReqData: &[u8; 18] = b"setct-CertReqData\0";
pub const NID_setct_CertReqData: i32 = 563;
pub const SN_setct_CertReqTBS: &[u8; 17] = b"setct-CertReqTBS\0";
pub const NID_setct_CertReqTBS: i32 = 564;
pub const SN_setct_CertResData: &[u8; 18] = b"setct-CertResData\0";
pub const NID_setct_CertResData: i32 = 565;
pub const SN_setct_CertInqReqTBS: &[u8; 20] = b"setct-CertInqReqTBS\0";
pub const NID_setct_CertInqReqTBS: i32 = 566;
pub const SN_setct_ErrorTBS: &[u8; 15] = b"setct-ErrorTBS\0";
pub const NID_setct_ErrorTBS: i32 = 567;
pub const SN_setct_PIDualSignedTBE: &[u8; 22] = b"setct-PIDualSignedTBE\0";
pub const NID_setct_PIDualSignedTBE: i32 = 568;
pub const SN_setct_PIUnsignedTBE: &[u8; 20] = b"setct-PIUnsignedTBE\0";
pub const NID_setct_PIUnsignedTBE: i32 = 569;
pub const SN_setct_AuthReqTBE: &[u8; 17] = b"setct-AuthReqTBE\0";
pub const NID_setct_AuthReqTBE: i32 = 570;
pub const SN_setct_AuthResTBE: &[u8; 17] = b"setct-AuthResTBE\0";
pub const NID_setct_AuthResTBE: i32 = 571;
pub const SN_setct_AuthResTBEX: &[u8; 18] = b"setct-AuthResTBEX\0";
pub const NID_setct_AuthResTBEX: i32 = 572;
pub const SN_setct_AuthTokenTBE: &[u8; 19] = b"setct-AuthTokenTBE\0";
pub const NID_setct_AuthTokenTBE: i32 = 573;
pub const SN_setct_CapTokenTBE: &[u8; 18] = b"setct-CapTokenTBE\0";
pub const NID_setct_CapTokenTBE: i32 = 574;
pub const SN_setct_CapTokenTBEX: &[u8; 19] = b"setct-CapTokenTBEX\0";
pub const NID_setct_CapTokenTBEX: i32 = 575;
pub const SN_setct_AcqCardCodeMsgTBE: &[u8; 24] = b"setct-AcqCardCodeMsgTBE\0";
pub const NID_setct_AcqCardCodeMsgTBE: i32 = 576;
pub const SN_setct_AuthRevReqTBE: &[u8; 20] = b"setct-AuthRevReqTBE\0";
pub const NID_setct_AuthRevReqTBE: i32 = 577;
pub const SN_setct_AuthRevResTBE: &[u8; 20] = b"setct-AuthRevResTBE\0";
pub const NID_setct_AuthRevResTBE: i32 = 578;
pub const SN_setct_AuthRevResTBEB: &[u8; 21] = b"setct-AuthRevResTBEB\0";
pub const NID_setct_AuthRevResTBEB: i32 = 579;
pub const SN_setct_CapReqTBE: &[u8; 16] = b"setct-CapReqTBE\0";
pub const NID_setct_CapReqTBE: i32 = 580;
pub const SN_setct_CapReqTBEX: &[u8; 17] = b"setct-CapReqTBEX\0";
pub const NID_setct_CapReqTBEX: i32 = 581;
pub const SN_setct_CapResTBE: &[u8; 16] = b"setct-CapResTBE\0";
pub const NID_setct_CapResTBE: i32 = 582;
pub const SN_setct_CapRevReqTBE: &[u8; 19] = b"setct-CapRevReqTBE\0";
pub const NID_setct_CapRevReqTBE: i32 = 583;
pub const SN_setct_CapRevReqTBEX: &[u8; 20] = b"setct-CapRevReqTBEX\0";
pub const NID_setct_CapRevReqTBEX: i32 = 584;
pub const SN_setct_CapRevResTBE: &[u8; 19] = b"setct-CapRevResTBE\0";
pub const NID_setct_CapRevResTBE: i32 = 585;
pub const SN_setct_CredReqTBE: &[u8; 17] = b"setct-CredReqTBE\0";
pub const NID_setct_CredReqTBE: i32 = 586;
pub const SN_setct_CredReqTBEX: &[u8; 18] = b"setct-CredReqTBEX\0";
pub const NID_setct_CredReqTBEX: i32 = 587;
pub const SN_setct_CredResTBE: &[u8; 17] = b"setct-CredResTBE\0";
pub const NID_setct_CredResTBE: i32 = 588;
pub const SN_setct_CredRevReqTBE: &[u8; 20] = b"setct-CredRevReqTBE\0";
pub const NID_setct_CredRevReqTBE: i32 = 589;
pub const SN_setct_CredRevReqTBEX: &[u8; 21] = b"setct-CredRevReqTBEX\0";
pub const NID_setct_CredRevReqTBEX: i32 = 590;
pub const SN_setct_CredRevResTBE: &[u8; 20] = b"setct-CredRevResTBE\0";
pub const NID_setct_CredRevResTBE: i32 = 591;
pub const SN_setct_BatchAdminReqTBE: &[u8; 23] = b"setct-BatchAdminReqTBE\0";
pub const NID_setct_BatchAdminReqTBE: i32 = 592;
pub const SN_setct_BatchAdminResTBE: &[u8; 23] = b"setct-BatchAdminResTBE\0";
pub const NID_setct_BatchAdminResTBE: i32 = 593;
pub const SN_setct_RegFormReqTBE: &[u8; 20] = b"setct-RegFormReqTBE\0";
pub const NID_setct_RegFormReqTBE: i32 = 594;
pub const SN_setct_CertReqTBE: &[u8; 17] = b"setct-CertReqTBE\0";
pub const NID_setct_CertReqTBE: i32 = 595;
pub const SN_setct_CertReqTBEX: &[u8; 18] = b"setct-CertReqTBEX\0";
pub const NID_setct_CertReqTBEX: i32 = 596;
pub const SN_setct_CertResTBE: &[u8; 17] = b"setct-CertResTBE\0";
pub const NID_setct_CertResTBE: i32 = 597;
pub const SN_setct_CRLNotificationTBS: &[u8; 25] = b"setct-CRLNotificationTBS\0";
pub const NID_setct_CRLNotificationTBS: i32 = 598;
pub const SN_setct_CRLNotificationResTBS: &[u8; 28] = b"setct-CRLNotificationResTBS\0";
pub const NID_setct_CRLNotificationResTBS: i32 = 599;
pub const SN_setct_BCIDistributionTBS: &[u8; 25] = b"setct-BCIDistributionTBS\0";
pub const NID_setct_BCIDistributionTBS: i32 = 600;
pub const SN_setext_genCrypt: &[u8; 16] = b"setext-genCrypt\0";
pub const LN_setext_genCrypt: &[u8; 19] = b"generic cryptogram\0";
pub const NID_setext_genCrypt: i32 = 601;
pub const SN_setext_miAuth: &[u8; 14] = b"setext-miAuth\0";
pub const LN_setext_miAuth: &[u8; 24] = b"merchant initiated auth\0";
pub const NID_setext_miAuth: i32 = 602;
pub const SN_setext_pinSecure: &[u8; 17] = b"setext-pinSecure\0";
pub const NID_setext_pinSecure: i32 = 603;
pub const SN_setext_pinAny: &[u8; 14] = b"setext-pinAny\0";
pub const NID_setext_pinAny: i32 = 604;
pub const SN_setext_track2: &[u8; 14] = b"setext-track2\0";
pub const NID_setext_track2: i32 = 605;
pub const SN_setext_cv: &[u8; 10] = b"setext-cv\0";
pub const LN_setext_cv: &[u8; 24] = b"additional verification\0";
pub const NID_setext_cv: i32 = 606;
pub const SN_set_policy_root: &[u8; 16] = b"set-policy-root\0";
pub const NID_set_policy_root: i32 = 607;
pub const SN_setCext_hashedRoot: &[u8; 19] = b"setCext-hashedRoot\0";
pub const NID_setCext_hashedRoot: i32 = 608;
pub const SN_setCext_certType: &[u8; 17] = b"setCext-certType\0";
pub const NID_setCext_certType: i32 = 609;
pub const SN_setCext_merchData: &[u8; 18] = b"setCext-merchData\0";
pub const NID_setCext_merchData: i32 = 610;
pub const SN_setCext_cCertRequired: &[u8; 22] = b"setCext-cCertRequired\0";
pub const NID_setCext_cCertRequired: i32 = 611;
pub const SN_setCext_tunneling: &[u8; 18] = b"setCext-tunneling\0";
pub const NID_setCext_tunneling: i32 = 612;
pub const SN_setCext_setExt: &[u8; 15] = b"setCext-setExt\0";
pub const NID_setCext_setExt: i32 = 613;
pub const SN_setCext_setQualf: &[u8; 17] = b"setCext-setQualf\0";
pub const NID_setCext_setQualf: i32 = 614;
pub const SN_setCext_PGWYcapabilities: &[u8; 25] = b"setCext-PGWYcapabilities\0";
pub const NID_setCext_PGWYcapabilities: i32 = 615;
pub const SN_setCext_TokenIdentifier: &[u8; 24] = b"setCext-TokenIdentifier\0";
pub const NID_setCext_TokenIdentifier: i32 = 616;
pub const SN_setCext_Track2Data: &[u8; 19] = b"setCext-Track2Data\0";
pub const NID_setCext_Track2Data: i32 = 617;
pub const SN_setCext_TokenType: &[u8; 18] = b"setCext-TokenType\0";
pub const NID_setCext_TokenType: i32 = 618;
pub const SN_setCext_IssuerCapabilities: &[u8; 27] = b"setCext-IssuerCapabilities\0";
pub const NID_setCext_IssuerCapabilities: i32 = 619;
pub const SN_setAttr_Cert: &[u8; 13] = b"setAttr-Cert\0";
pub const NID_setAttr_Cert: i32 = 620;
pub const SN_setAttr_PGWYcap: &[u8; 16] = b"setAttr-PGWYcap\0";
pub const LN_setAttr_PGWYcap: &[u8; 29] = b"payment gateway capabilities\0";
pub const NID_setAttr_PGWYcap: i32 = 621;
pub const SN_setAttr_TokenType: &[u8; 18] = b"setAttr-TokenType\0";
pub const NID_setAttr_TokenType: i32 = 622;
pub const SN_setAttr_IssCap: &[u8; 15] = b"setAttr-IssCap\0";
pub const LN_setAttr_IssCap: &[u8; 20] = b"issuer capabilities\0";
pub const NID_setAttr_IssCap: i32 = 623;
pub const SN_set_rootKeyThumb: &[u8; 17] = b"set-rootKeyThumb\0";
pub const NID_set_rootKeyThumb: i32 = 624;
pub const SN_set_addPolicy: &[u8; 14] = b"set-addPolicy\0";
pub const NID_set_addPolicy: i32 = 625;
pub const SN_setAttr_Token_EMV: &[u8; 18] = b"setAttr-Token-EMV\0";
pub const NID_setAttr_Token_EMV: i32 = 626;
pub const SN_setAttr_Token_B0Prime: &[u8; 22] = b"setAttr-Token-B0Prime\0";
pub const NID_setAttr_Token_B0Prime: i32 = 627;
pub const SN_setAttr_IssCap_CVM: &[u8; 19] = b"setAttr-IssCap-CVM\0";
pub const NID_setAttr_IssCap_CVM: i32 = 628;
pub const SN_setAttr_IssCap_T2: &[u8; 18] = b"setAttr-IssCap-T2\0";
pub const NID_setAttr_IssCap_T2: i32 = 629;
pub const SN_setAttr_IssCap_Sig: &[u8; 19] = b"setAttr-IssCap-Sig\0";
pub const NID_setAttr_IssCap_Sig: i32 = 630;
pub const SN_setAttr_GenCryptgrm: &[u8; 20] = b"setAttr-GenCryptgrm\0";
pub const LN_setAttr_GenCryptgrm: &[u8; 20] = b"generate cryptogram\0";
pub const NID_setAttr_GenCryptgrm: i32 = 631;
pub const SN_setAttr_T2Enc: &[u8; 14] = b"setAttr-T2Enc\0";
pub const LN_setAttr_T2Enc: &[u8; 18] = b"encrypted track 2\0";
pub const NID_setAttr_T2Enc: i32 = 632;
pub const SN_setAttr_T2cleartxt: &[u8; 19] = b"setAttr-T2cleartxt\0";
pub const LN_setAttr_T2cleartxt: &[u8; 18] = b"cleartext track 2\0";
pub const NID_setAttr_T2cleartxt: i32 = 633;
pub const SN_setAttr_TokICCsig: &[u8; 18] = b"setAttr-TokICCsig\0";
pub const LN_setAttr_TokICCsig: &[u8; 23] = b"ICC or token signature\0";
pub const NID_setAttr_TokICCsig: i32 = 634;
pub const SN_setAttr_SecDevSig: &[u8; 18] = b"setAttr-SecDevSig\0";
pub const LN_setAttr_SecDevSig: &[u8; 24] = b"secure device signature\0";
pub const NID_setAttr_SecDevSig: i32 = 635;
pub const SN_set_brand_IATA_ATA: &[u8; 19] = b"set-brand-IATA-ATA\0";
pub const NID_set_brand_IATA_ATA: i32 = 636;
pub const SN_set_brand_Diners: &[u8; 17] = b"set-brand-Diners\0";
pub const NID_set_brand_Diners: i32 = 637;
pub const SN_set_brand_AmericanExpress: &[u8; 26] = b"set-brand-AmericanExpress\0";
pub const NID_set_brand_AmericanExpress: i32 = 638;
pub const SN_set_brand_JCB: &[u8; 14] = b"set-brand-JCB\0";
pub const NID_set_brand_JCB: i32 = 639;
pub const SN_set_brand_Visa: &[u8; 15] = b"set-brand-Visa\0";
pub const NID_set_brand_Visa: i32 = 640;
pub const SN_set_brand_MasterCard: &[u8; 21] = b"set-brand-MasterCard\0";
pub const NID_set_brand_MasterCard: i32 = 641;
pub const SN_set_brand_Novus: &[u8; 16] = b"set-brand-Novus\0";
pub const NID_set_brand_Novus: i32 = 642;
pub const SN_des_cdmf: &[u8; 9] = b"DES-CDMF\0";
pub const LN_des_cdmf: &[u8; 9] = b"des-cdmf\0";
pub const NID_des_cdmf: i32 = 643;
pub const SN_rsaOAEPEncryptionSET: &[u8; 21] = b"rsaOAEPEncryptionSET\0";
pub const NID_rsaOAEPEncryptionSET: i32 = 644;
pub const SN_itu_t: &[u8; 6] = b"ITU-T\0";
pub const LN_itu_t: &[u8; 6] = b"itu-t\0";
pub const NID_itu_t: i32 = 645;
pub const OBJ_itu_t: i32 = 0;
pub const SN_joint_iso_itu_t: &[u8; 16] = b"JOINT-ISO-ITU-T\0";
pub const LN_joint_iso_itu_t: &[u8; 16] = b"joint-iso-itu-t\0";
pub const NID_joint_iso_itu_t: i32 = 646;
pub const OBJ_joint_iso_itu_t: i32 = 2;
pub const SN_international_organizations: &[u8; 28] = b"international-organizations\0";
pub const LN_international_organizations: &[u8; 28] = b"International Organizations\0";
pub const NID_international_organizations: i32 = 647;
pub const SN_ms_smartcard_login: &[u8; 17] = b"msSmartcardLogin\0";
pub const LN_ms_smartcard_login: &[u8; 25] = b"Microsoft Smartcardlogin\0";
pub const NID_ms_smartcard_login: i32 = 648;
pub const SN_ms_upn: &[u8; 6] = b"msUPN\0";
pub const LN_ms_upn: &[u8; 35] = b"Microsoft Universal Principal Name\0";
pub const NID_ms_upn: i32 = 649;
pub const SN_aes_128_cfb1: &[u8; 13] = b"AES-128-CFB1\0";
pub const LN_aes_128_cfb1: &[u8; 13] = b"aes-128-cfb1\0";
pub const NID_aes_128_cfb1: i32 = 650;
pub const SN_aes_192_cfb1: &[u8; 13] = b"AES-192-CFB1\0";
pub const LN_aes_192_cfb1: &[u8; 13] = b"aes-192-cfb1\0";
pub const NID_aes_192_cfb1: i32 = 651;
pub const SN_aes_256_cfb1: &[u8; 13] = b"AES-256-CFB1\0";
pub const LN_aes_256_cfb1: &[u8; 13] = b"aes-256-cfb1\0";
pub const NID_aes_256_cfb1: i32 = 652;
pub const SN_aes_128_cfb8: &[u8; 13] = b"AES-128-CFB8\0";
pub const LN_aes_128_cfb8: &[u8; 13] = b"aes-128-cfb8\0";
pub const NID_aes_128_cfb8: i32 = 653;
pub const SN_aes_192_cfb8: &[u8; 13] = b"AES-192-CFB8\0";
pub const LN_aes_192_cfb8: &[u8; 13] = b"aes-192-cfb8\0";
pub const NID_aes_192_cfb8: i32 = 654;
pub const SN_aes_256_cfb8: &[u8; 13] = b"AES-256-CFB8\0";
pub const LN_aes_256_cfb8: &[u8; 13] = b"aes-256-cfb8\0";
pub const NID_aes_256_cfb8: i32 = 655;
pub const SN_des_cfb1: &[u8; 9] = b"DES-CFB1\0";
pub const LN_des_cfb1: &[u8; 9] = b"des-cfb1\0";
pub const NID_des_cfb1: i32 = 656;
pub const SN_des_cfb8: &[u8; 9] = b"DES-CFB8\0";
pub const LN_des_cfb8: &[u8; 9] = b"des-cfb8\0";
pub const NID_des_cfb8: i32 = 657;
pub const SN_des_ede3_cfb1: &[u8; 14] = b"DES-EDE3-CFB1\0";
pub const LN_des_ede3_cfb1: &[u8; 14] = b"des-ede3-cfb1\0";
pub const NID_des_ede3_cfb1: i32 = 658;
pub const SN_des_ede3_cfb8: &[u8; 14] = b"DES-EDE3-CFB8\0";
pub const LN_des_ede3_cfb8: &[u8; 14] = b"des-ede3-cfb8\0";
pub const NID_des_ede3_cfb8: i32 = 659;
pub const SN_streetAddress: &[u8; 7] = b"street\0";
pub const LN_streetAddress: &[u8; 14] = b"streetAddress\0";
pub const NID_streetAddress: i32 = 660;
pub const LN_postalCode: &[u8; 11] = b"postalCode\0";
pub const NID_postalCode: i32 = 661;
pub const SN_id_ppl: &[u8; 7] = b"id-ppl\0";
pub const NID_id_ppl: i32 = 662;
pub const SN_proxyCertInfo: &[u8; 14] = b"proxyCertInfo\0";
pub const LN_proxyCertInfo: &[u8; 30] = b"Proxy Certificate Information\0";
pub const NID_proxyCertInfo: i32 = 663;
pub const SN_id_ppl_anyLanguage: &[u8; 19] = b"id-ppl-anyLanguage\0";
pub const LN_id_ppl_anyLanguage: &[u8; 13] = b"Any language\0";
pub const NID_id_ppl_anyLanguage: i32 = 664;
pub const SN_id_ppl_inheritAll: &[u8; 18] = b"id-ppl-inheritAll\0";
pub const LN_id_ppl_inheritAll: &[u8; 12] = b"Inherit all\0";
pub const NID_id_ppl_inheritAll: i32 = 665;
pub const SN_name_constraints: &[u8; 16] = b"nameConstraints\0";
pub const LN_name_constraints: &[u8; 24] = b"X509v3 Name Constraints\0";
pub const NID_name_constraints: i32 = 666;
pub const SN_Independent: &[u8; 19] = b"id-ppl-independent\0";
pub const LN_Independent: &[u8; 12] = b"Independent\0";
pub const NID_Independent: i32 = 667;
pub const SN_sha256WithRSAEncryption: &[u8; 11] = b"RSA-SHA256\0";
pub const LN_sha256WithRSAEncryption: &[u8; 24] = b"sha256WithRSAEncryption\0";
pub const NID_sha256WithRSAEncryption: i32 = 668;
pub const SN_sha384WithRSAEncryption: &[u8; 11] = b"RSA-SHA384\0";
pub const LN_sha384WithRSAEncryption: &[u8; 24] = b"sha384WithRSAEncryption\0";
pub const NID_sha384WithRSAEncryption: i32 = 669;
pub const SN_sha512WithRSAEncryption: &[u8; 11] = b"RSA-SHA512\0";
pub const LN_sha512WithRSAEncryption: &[u8; 24] = b"sha512WithRSAEncryption\0";
pub const NID_sha512WithRSAEncryption: i32 = 670;
pub const SN_sha224WithRSAEncryption: &[u8; 11] = b"RSA-SHA224\0";
pub const LN_sha224WithRSAEncryption: &[u8; 24] = b"sha224WithRSAEncryption\0";
pub const NID_sha224WithRSAEncryption: i32 = 671;
pub const SN_sha256: &[u8; 7] = b"SHA256\0";
pub const LN_sha256: &[u8; 7] = b"sha256\0";
pub const NID_sha256: i32 = 672;
pub const SN_sha384: &[u8; 7] = b"SHA384\0";
pub const LN_sha384: &[u8; 7] = b"sha384\0";
pub const NID_sha384: i32 = 673;
pub const SN_sha512: &[u8; 7] = b"SHA512\0";
pub const LN_sha512: &[u8; 7] = b"sha512\0";
pub const NID_sha512: i32 = 674;
pub const SN_sha224: &[u8; 7] = b"SHA224\0";
pub const LN_sha224: &[u8; 7] = b"sha224\0";
pub const NID_sha224: i32 = 675;
pub const SN_identified_organization: &[u8; 24] = b"identified-organization\0";
pub const NID_identified_organization: i32 = 676;
pub const SN_certicom_arc: &[u8; 13] = b"certicom-arc\0";
pub const NID_certicom_arc: i32 = 677;
pub const SN_wap: &[u8; 4] = b"wap\0";
pub const NID_wap: i32 = 678;
pub const SN_wap_wsg: &[u8; 8] = b"wap-wsg\0";
pub const NID_wap_wsg: i32 = 679;
pub const SN_X9_62_id_characteristic_two_basis: &[u8; 28] = b"id-characteristic-two-basis\0";
pub const NID_X9_62_id_characteristic_two_basis: i32 = 680;
pub const SN_X9_62_onBasis: &[u8; 8] = b"onBasis\0";
pub const NID_X9_62_onBasis: i32 = 681;
pub const SN_X9_62_tpBasis: &[u8; 8] = b"tpBasis\0";
pub const NID_X9_62_tpBasis: i32 = 682;
pub const SN_X9_62_ppBasis: &[u8; 8] = b"ppBasis\0";
pub const NID_X9_62_ppBasis: i32 = 683;
pub const SN_X9_62_c2pnb163v1: &[u8; 11] = b"c2pnb163v1\0";
pub const NID_X9_62_c2pnb163v1: i32 = 684;
pub const SN_X9_62_c2pnb163v2: &[u8; 11] = b"c2pnb163v2\0";
pub const NID_X9_62_c2pnb163v2: i32 = 685;
pub const SN_X9_62_c2pnb163v3: &[u8; 11] = b"c2pnb163v3\0";
pub const NID_X9_62_c2pnb163v3: i32 = 686;
pub const SN_X9_62_c2pnb176v1: &[u8; 11] = b"c2pnb176v1\0";
pub const NID_X9_62_c2pnb176v1: i32 = 687;
pub const SN_X9_62_c2tnb191v1: &[u8; 11] = b"c2tnb191v1\0";
pub const NID_X9_62_c2tnb191v1: i32 = 688;
pub const SN_X9_62_c2tnb191v2: &[u8; 11] = b"c2tnb191v2\0";
pub const NID_X9_62_c2tnb191v2: i32 = 689;
pub const SN_X9_62_c2tnb191v3: &[u8; 11] = b"c2tnb191v3\0";
pub const NID_X9_62_c2tnb191v3: i32 = 690;
pub const SN_X9_62_c2onb191v4: &[u8; 11] = b"c2onb191v4\0";
pub const NID_X9_62_c2onb191v4: i32 = 691;
pub const SN_X9_62_c2onb191v5: &[u8; 11] = b"c2onb191v5\0";
pub const NID_X9_62_c2onb191v5: i32 = 692;
pub const SN_X9_62_c2pnb208w1: &[u8; 11] = b"c2pnb208w1\0";
pub const NID_X9_62_c2pnb208w1: i32 = 693;
pub const SN_X9_62_c2tnb239v1: &[u8; 11] = b"c2tnb239v1\0";
pub const NID_X9_62_c2tnb239v1: i32 = 694;
pub const SN_X9_62_c2tnb239v2: &[u8; 11] = b"c2tnb239v2\0";
pub const NID_X9_62_c2tnb239v2: i32 = 695;
pub const SN_X9_62_c2tnb239v3: &[u8; 11] = b"c2tnb239v3\0";
pub const NID_X9_62_c2tnb239v3: i32 = 696;
pub const SN_X9_62_c2onb239v4: &[u8; 11] = b"c2onb239v4\0";
pub const NID_X9_62_c2onb239v4: i32 = 697;
pub const SN_X9_62_c2onb239v5: &[u8; 11] = b"c2onb239v5\0";
pub const NID_X9_62_c2onb239v5: i32 = 698;
pub const SN_X9_62_c2pnb272w1: &[u8; 11] = b"c2pnb272w1\0";
pub const NID_X9_62_c2pnb272w1: i32 = 699;
pub const SN_X9_62_c2pnb304w1: &[u8; 11] = b"c2pnb304w1\0";
pub const NID_X9_62_c2pnb304w1: i32 = 700;
pub const SN_X9_62_c2tnb359v1: &[u8; 11] = b"c2tnb359v1\0";
pub const NID_X9_62_c2tnb359v1: i32 = 701;
pub const SN_X9_62_c2pnb368w1: &[u8; 11] = b"c2pnb368w1\0";
pub const NID_X9_62_c2pnb368w1: i32 = 702;
pub const SN_X9_62_c2tnb431r1: &[u8; 11] = b"c2tnb431r1\0";
pub const NID_X9_62_c2tnb431r1: i32 = 703;
pub const SN_secp112r1: &[u8; 10] = b"secp112r1\0";
pub const NID_secp112r1: i32 = 704;
pub const SN_secp112r2: &[u8; 10] = b"secp112r2\0";
pub const NID_secp112r2: i32 = 705;
pub const SN_secp128r1: &[u8; 10] = b"secp128r1\0";
pub const NID_secp128r1: i32 = 706;
pub const SN_secp128r2: &[u8; 10] = b"secp128r2\0";
pub const NID_secp128r2: i32 = 707;
pub const SN_secp160k1: &[u8; 10] = b"secp160k1\0";
pub const NID_secp160k1: i32 = 708;
pub const SN_secp160r1: &[u8; 10] = b"secp160r1\0";
pub const NID_secp160r1: i32 = 709;
pub const SN_secp160r2: &[u8; 10] = b"secp160r2\0";
pub const NID_secp160r2: i32 = 710;
pub const SN_secp192k1: &[u8; 10] = b"secp192k1\0";
pub const NID_secp192k1: i32 = 711;
pub const SN_secp224k1: &[u8; 10] = b"secp224k1\0";
pub const NID_secp224k1: i32 = 712;
pub const SN_secp224r1: &[u8; 10] = b"secp224r1\0";
pub const NID_secp224r1: i32 = 713;
pub const SN_secp256k1: &[u8; 10] = b"secp256k1\0";
pub const NID_secp256k1: i32 = 714;
pub const SN_secp384r1: &[u8; 10] = b"secp384r1\0";
pub const NID_secp384r1: i32 = 715;
pub const SN_secp521r1: &[u8; 10] = b"secp521r1\0";
pub const NID_secp521r1: i32 = 716;
pub const SN_sect113r1: &[u8; 10] = b"sect113r1\0";
pub const NID_sect113r1: i32 = 717;
pub const SN_sect113r2: &[u8; 10] = b"sect113r2\0";
pub const NID_sect113r2: i32 = 718;
pub const SN_sect131r1: &[u8; 10] = b"sect131r1\0";
pub const NID_sect131r1: i32 = 719;
pub const SN_sect131r2: &[u8; 10] = b"sect131r2\0";
pub const NID_sect131r2: i32 = 720;
pub const SN_sect163k1: &[u8; 10] = b"sect163k1\0";
pub const NID_sect163k1: i32 = 721;
pub const SN_sect163r1: &[u8; 10] = b"sect163r1\0";
pub const NID_sect163r1: i32 = 722;
pub const SN_sect163r2: &[u8; 10] = b"sect163r2\0";
pub const NID_sect163r2: i32 = 723;
pub const SN_sect193r1: &[u8; 10] = b"sect193r1\0";
pub const NID_sect193r1: i32 = 724;
pub const SN_sect193r2: &[u8; 10] = b"sect193r2\0";
pub const NID_sect193r2: i32 = 725;
pub const SN_sect233k1: &[u8; 10] = b"sect233k1\0";
pub const NID_sect233k1: i32 = 726;
pub const SN_sect233r1: &[u8; 10] = b"sect233r1\0";
pub const NID_sect233r1: i32 = 727;
pub const SN_sect239k1: &[u8; 10] = b"sect239k1\0";
pub const NID_sect239k1: i32 = 728;
pub const SN_sect283k1: &[u8; 10] = b"sect283k1\0";
pub const NID_sect283k1: i32 = 729;
pub const SN_sect283r1: &[u8; 10] = b"sect283r1\0";
pub const NID_sect283r1: i32 = 730;
pub const SN_sect409k1: &[u8; 10] = b"sect409k1\0";
pub const NID_sect409k1: i32 = 731;
pub const SN_sect409r1: &[u8; 10] = b"sect409r1\0";
pub const NID_sect409r1: i32 = 732;
pub const SN_sect571k1: &[u8; 10] = b"sect571k1\0";
pub const NID_sect571k1: i32 = 733;
pub const SN_sect571r1: &[u8; 10] = b"sect571r1\0";
pub const NID_sect571r1: i32 = 734;
pub const SN_wap_wsg_idm_ecid_wtls1: &[u8; 23] = b"wap-wsg-idm-ecid-wtls1\0";
pub const NID_wap_wsg_idm_ecid_wtls1: i32 = 735;
pub const SN_wap_wsg_idm_ecid_wtls3: &[u8; 23] = b"wap-wsg-idm-ecid-wtls3\0";
pub const NID_wap_wsg_idm_ecid_wtls3: i32 = 736;
pub const SN_wap_wsg_idm_ecid_wtls4: &[u8; 23] = b"wap-wsg-idm-ecid-wtls4\0";
pub const NID_wap_wsg_idm_ecid_wtls4: i32 = 737;
pub const SN_wap_wsg_idm_ecid_wtls5: &[u8; 23] = b"wap-wsg-idm-ecid-wtls5\0";
pub const NID_wap_wsg_idm_ecid_wtls5: i32 = 738;
pub const SN_wap_wsg_idm_ecid_wtls6: &[u8; 23] = b"wap-wsg-idm-ecid-wtls6\0";
pub const NID_wap_wsg_idm_ecid_wtls6: i32 = 739;
pub const SN_wap_wsg_idm_ecid_wtls7: &[u8; 23] = b"wap-wsg-idm-ecid-wtls7\0";
pub const NID_wap_wsg_idm_ecid_wtls7: i32 = 740;
pub const SN_wap_wsg_idm_ecid_wtls8: &[u8; 23] = b"wap-wsg-idm-ecid-wtls8\0";
pub const NID_wap_wsg_idm_ecid_wtls8: i32 = 741;
pub const SN_wap_wsg_idm_ecid_wtls9: &[u8; 23] = b"wap-wsg-idm-ecid-wtls9\0";
pub const NID_wap_wsg_idm_ecid_wtls9: i32 = 742;
pub const SN_wap_wsg_idm_ecid_wtls10: &[u8; 24] = b"wap-wsg-idm-ecid-wtls10\0";
pub const NID_wap_wsg_idm_ecid_wtls10: i32 = 743;
pub const SN_wap_wsg_idm_ecid_wtls11: &[u8; 24] = b"wap-wsg-idm-ecid-wtls11\0";
pub const NID_wap_wsg_idm_ecid_wtls11: i32 = 744;
pub const SN_wap_wsg_idm_ecid_wtls12: &[u8; 24] = b"wap-wsg-idm-ecid-wtls12\0";
pub const NID_wap_wsg_idm_ecid_wtls12: i32 = 745;
pub const SN_any_policy: &[u8; 10] = b"anyPolicy\0";
pub const LN_any_policy: &[u8; 18] = b"X509v3 Any Policy\0";
pub const NID_any_policy: i32 = 746;
pub const SN_policy_mappings: &[u8; 15] = b"policyMappings\0";
pub const LN_policy_mappings: &[u8; 23] = b"X509v3 Policy Mappings\0";
pub const NID_policy_mappings: i32 = 747;
pub const SN_inhibit_any_policy: &[u8; 17] = b"inhibitAnyPolicy\0";
pub const LN_inhibit_any_policy: &[u8; 26] = b"X509v3 Inhibit Any Policy\0";
pub const NID_inhibit_any_policy: i32 = 748;
pub const SN_ipsec3: &[u8; 14] = b"Oakley-EC2N-3\0";
pub const LN_ipsec3: &[u8; 7] = b"ipsec3\0";
pub const NID_ipsec3: i32 = 749;
pub const SN_ipsec4: &[u8; 14] = b"Oakley-EC2N-4\0";
pub const LN_ipsec4: &[u8; 7] = b"ipsec4\0";
pub const NID_ipsec4: i32 = 750;
pub const SN_camellia_128_cbc: &[u8; 17] = b"CAMELLIA-128-CBC\0";
pub const LN_camellia_128_cbc: &[u8; 17] = b"camellia-128-cbc\0";
pub const NID_camellia_128_cbc: i32 = 751;
pub const SN_camellia_192_cbc: &[u8; 17] = b"CAMELLIA-192-CBC\0";
pub const LN_camellia_192_cbc: &[u8; 17] = b"camellia-192-cbc\0";
pub const NID_camellia_192_cbc: i32 = 752;
pub const SN_camellia_256_cbc: &[u8; 17] = b"CAMELLIA-256-CBC\0";
pub const LN_camellia_256_cbc: &[u8; 17] = b"camellia-256-cbc\0";
pub const NID_camellia_256_cbc: i32 = 753;
pub const SN_camellia_128_ecb: &[u8; 17] = b"CAMELLIA-128-ECB\0";
pub const LN_camellia_128_ecb: &[u8; 17] = b"camellia-128-ecb\0";
pub const NID_camellia_128_ecb: i32 = 754;
pub const SN_camellia_192_ecb: &[u8; 17] = b"CAMELLIA-192-ECB\0";
pub const LN_camellia_192_ecb: &[u8; 17] = b"camellia-192-ecb\0";
pub const NID_camellia_192_ecb: i32 = 755;
pub const SN_camellia_256_ecb: &[u8; 17] = b"CAMELLIA-256-ECB\0";
pub const LN_camellia_256_ecb: &[u8; 17] = b"camellia-256-ecb\0";
pub const NID_camellia_256_ecb: i32 = 756;
pub const SN_camellia_128_cfb128: &[u8; 17] = b"CAMELLIA-128-CFB\0";
pub const LN_camellia_128_cfb128: &[u8; 17] = b"camellia-128-cfb\0";
pub const NID_camellia_128_cfb128: i32 = 757;
pub const SN_camellia_192_cfb128: &[u8; 17] = b"CAMELLIA-192-CFB\0";
pub const LN_camellia_192_cfb128: &[u8; 17] = b"camellia-192-cfb\0";
pub const NID_camellia_192_cfb128: i32 = 758;
pub const SN_camellia_256_cfb128: &[u8; 17] = b"CAMELLIA-256-CFB\0";
pub const LN_camellia_256_cfb128: &[u8; 17] = b"camellia-256-cfb\0";
pub const NID_camellia_256_cfb128: i32 = 759;
pub const SN_camellia_128_cfb1: &[u8; 18] = b"CAMELLIA-128-CFB1\0";
pub const LN_camellia_128_cfb1: &[u8; 18] = b"camellia-128-cfb1\0";
pub const NID_camellia_128_cfb1: i32 = 760;
pub const SN_camellia_192_cfb1: &[u8; 18] = b"CAMELLIA-192-CFB1\0";
pub const LN_camellia_192_cfb1: &[u8; 18] = b"camellia-192-cfb1\0";
pub const NID_camellia_192_cfb1: i32 = 761;
pub const SN_camellia_256_cfb1: &[u8; 18] = b"CAMELLIA-256-CFB1\0";
pub const LN_camellia_256_cfb1: &[u8; 18] = b"camellia-256-cfb1\0";
pub const NID_camellia_256_cfb1: i32 = 762;
pub const SN_camellia_128_cfb8: &[u8; 18] = b"CAMELLIA-128-CFB8\0";
pub const LN_camellia_128_cfb8: &[u8; 18] = b"camellia-128-cfb8\0";
pub const NID_camellia_128_cfb8: i32 = 763;
pub const SN_camellia_192_cfb8: &[u8; 18] = b"CAMELLIA-192-CFB8\0";
pub const LN_camellia_192_cfb8: &[u8; 18] = b"camellia-192-cfb8\0";
pub const NID_camellia_192_cfb8: i32 = 764;
pub const SN_camellia_256_cfb8: &[u8; 18] = b"CAMELLIA-256-CFB8\0";
pub const LN_camellia_256_cfb8: &[u8; 18] = b"camellia-256-cfb8\0";
pub const NID_camellia_256_cfb8: i32 = 765;
pub const SN_camellia_128_ofb128: &[u8; 17] = b"CAMELLIA-128-OFB\0";
pub const LN_camellia_128_ofb128: &[u8; 17] = b"camellia-128-ofb\0";
pub const NID_camellia_128_ofb128: i32 = 766;
pub const SN_camellia_192_ofb128: &[u8; 17] = b"CAMELLIA-192-OFB\0";
pub const LN_camellia_192_ofb128: &[u8; 17] = b"camellia-192-ofb\0";
pub const NID_camellia_192_ofb128: i32 = 767;
pub const SN_camellia_256_ofb128: &[u8; 17] = b"CAMELLIA-256-OFB\0";
pub const LN_camellia_256_ofb128: &[u8; 17] = b"camellia-256-ofb\0";
pub const NID_camellia_256_ofb128: i32 = 768;
pub const SN_subject_directory_attributes: &[u8; 27] = b"subjectDirectoryAttributes\0";
pub const LN_subject_directory_attributes: &[u8; 36] = b"X509v3 Subject Directory Attributes\0";
pub const NID_subject_directory_attributes: i32 = 769;
pub const SN_issuing_distribution_point: &[u8; 25] = b"issuingDistributionPoint\0";
pub const LN_issuing_distribution_point: &[u8; 34] = b"X509v3 Issuing Distribution Point\0";
pub const NID_issuing_distribution_point: i32 = 770;
pub const SN_certificate_issuer: &[u8; 18] = b"certificateIssuer\0";
pub const LN_certificate_issuer: &[u8; 26] = b"X509v3 Certificate Issuer\0";
pub const NID_certificate_issuer: i32 = 771;
pub const SN_kisa: &[u8; 5] = b"KISA\0";
pub const LN_kisa: &[u8; 5] = b"kisa\0";
pub const NID_kisa: i32 = 773;
pub const SN_seed_ecb: &[u8; 9] = b"SEED-ECB\0";
pub const LN_seed_ecb: &[u8; 9] = b"seed-ecb\0";
pub const NID_seed_ecb: i32 = 776;
pub const SN_seed_cbc: &[u8; 9] = b"SEED-CBC\0";
pub const LN_seed_cbc: &[u8; 9] = b"seed-cbc\0";
pub const NID_seed_cbc: i32 = 777;
pub const SN_seed_ofb128: &[u8; 9] = b"SEED-OFB\0";
pub const LN_seed_ofb128: &[u8; 9] = b"seed-ofb\0";
pub const NID_seed_ofb128: i32 = 778;
pub const SN_seed_cfb128: &[u8; 9] = b"SEED-CFB\0";
pub const LN_seed_cfb128: &[u8; 9] = b"seed-cfb\0";
pub const NID_seed_cfb128: i32 = 779;
pub const SN_hmac_md5: &[u8; 9] = b"HMAC-MD5\0";
pub const LN_hmac_md5: &[u8; 9] = b"hmac-md5\0";
pub const NID_hmac_md5: i32 = 780;
pub const SN_hmac_sha1: &[u8; 10] = b"HMAC-SHA1\0";
pub const LN_hmac_sha1: &[u8; 10] = b"hmac-sha1\0";
pub const NID_hmac_sha1: i32 = 781;
pub const SN_id_PasswordBasedMAC: &[u8; 20] = b"id-PasswordBasedMAC\0";
pub const LN_id_PasswordBasedMAC: &[u8; 19] = b"password based MAC\0";
pub const NID_id_PasswordBasedMAC: i32 = 782;
pub const SN_id_DHBasedMac: &[u8; 14] = b"id-DHBasedMac\0";
pub const LN_id_DHBasedMac: &[u8; 25] = b"Diffie-Hellman based MAC\0";
pub const NID_id_DHBasedMac: i32 = 783;
pub const SN_id_it_suppLangTags: &[u8; 19] = b"id-it-suppLangTags\0";
pub const NID_id_it_suppLangTags: i32 = 784;
pub const SN_caRepository: &[u8; 13] = b"caRepository\0";
pub const LN_caRepository: &[u8; 14] = b"CA Repository\0";
pub const NID_caRepository: i32 = 785;
pub const SN_id_smime_ct_compressedData: &[u8; 27] = b"id-smime-ct-compressedData\0";
pub const NID_id_smime_ct_compressedData: i32 = 786;
pub const SN_id_ct_asciiTextWithCRLF: &[u8; 24] = b"id-ct-asciiTextWithCRLF\0";
pub const NID_id_ct_asciiTextWithCRLF: i32 = 787;
pub const SN_id_aes128_wrap: &[u8; 15] = b"id-aes128-wrap\0";
pub const NID_id_aes128_wrap: i32 = 788;
pub const SN_id_aes192_wrap: &[u8; 15] = b"id-aes192-wrap\0";
pub const NID_id_aes192_wrap: i32 = 789;
pub const SN_id_aes256_wrap: &[u8; 15] = b"id-aes256-wrap\0";
pub const NID_id_aes256_wrap: i32 = 790;
pub const SN_ecdsa_with_Recommended: &[u8; 23] = b"ecdsa-with-Recommended\0";
pub const NID_ecdsa_with_Recommended: i32 = 791;
pub const SN_ecdsa_with_Specified: &[u8; 21] = b"ecdsa-with-Specified\0";
pub const NID_ecdsa_with_Specified: i32 = 792;
pub const SN_ecdsa_with_SHA224: &[u8; 18] = b"ecdsa-with-SHA224\0";
pub const NID_ecdsa_with_SHA224: i32 = 793;
pub const SN_ecdsa_with_SHA256: &[u8; 18] = b"ecdsa-with-SHA256\0";
pub const NID_ecdsa_with_SHA256: i32 = 794;
pub const SN_ecdsa_with_SHA384: &[u8; 18] = b"ecdsa-with-SHA384\0";
pub const NID_ecdsa_with_SHA384: i32 = 795;
pub const SN_ecdsa_with_SHA512: &[u8; 18] = b"ecdsa-with-SHA512\0";
pub const NID_ecdsa_with_SHA512: i32 = 796;
pub const LN_hmacWithMD5: &[u8; 12] = b"hmacWithMD5\0";
pub const NID_hmacWithMD5: i32 = 797;
pub const LN_hmacWithSHA224: &[u8; 15] = b"hmacWithSHA224\0";
pub const NID_hmacWithSHA224: i32 = 798;
pub const LN_hmacWithSHA256: &[u8; 15] = b"hmacWithSHA256\0";
pub const NID_hmacWithSHA256: i32 = 799;
pub const LN_hmacWithSHA384: &[u8; 15] = b"hmacWithSHA384\0";
pub const NID_hmacWithSHA384: i32 = 800;
pub const LN_hmacWithSHA512: &[u8; 15] = b"hmacWithSHA512\0";
pub const NID_hmacWithSHA512: i32 = 801;
pub const SN_dsa_with_SHA224: &[u8; 16] = b"dsa_with_SHA224\0";
pub const NID_dsa_with_SHA224: i32 = 802;
pub const SN_dsa_with_SHA256: &[u8; 16] = b"dsa_with_SHA256\0";
pub const NID_dsa_with_SHA256: i32 = 803;
pub const SN_whirlpool: &[u8; 10] = b"whirlpool\0";
pub const NID_whirlpool: i32 = 804;
pub const SN_cryptopro: &[u8; 10] = b"cryptopro\0";
pub const NID_cryptopro: i32 = 805;
pub const SN_cryptocom: &[u8; 10] = b"cryptocom\0";
pub const NID_cryptocom: i32 = 806;
pub const SN_id_GostR3411_94_with_GostR3410_2001: &[u8; 36] =
    b"id-GostR3411-94-with-GostR3410-2001\0";
pub const LN_id_GostR3411_94_with_GostR3410_2001: &[u8; 39] =
    b"GOST R 34.11-94 with GOST R 34.10-2001\0";
pub const NID_id_GostR3411_94_with_GostR3410_2001: i32 = 807;
pub const SN_id_GostR3411_94_with_GostR3410_94: &[u8; 34] = b"id-GostR3411-94-with-GostR3410-94\0";
pub const LN_id_GostR3411_94_with_GostR3410_94: &[u8; 37] =
    b"GOST R 34.11-94 with GOST R 34.10-94\0";
pub const NID_id_GostR3411_94_with_GostR3410_94: i32 = 808;
pub const SN_id_GostR3411_94: &[u8; 10] = b"md_gost94\0";
pub const LN_id_GostR3411_94: &[u8; 16] = b"GOST R 34.11-94\0";
pub const NID_id_GostR3411_94: i32 = 809;
pub const SN_id_HMACGostR3411_94: &[u8; 20] = b"id-HMACGostR3411-94\0";
pub const LN_id_HMACGostR3411_94: &[u8; 19] = b"HMAC GOST 34.11-94\0";
pub const NID_id_HMACGostR3411_94: i32 = 810;
pub const SN_id_GostR3410_2001: &[u8; 9] = b"gost2001\0";
pub const LN_id_GostR3410_2001: &[u8; 18] = b"GOST R 34.10-2001\0";
pub const NID_id_GostR3410_2001: i32 = 811;
pub const SN_id_GostR3410_94: &[u8; 7] = b"gost94\0";
pub const LN_id_GostR3410_94: &[u8; 16] = b"GOST R 34.10-94\0";
pub const NID_id_GostR3410_94: i32 = 812;
pub const SN_id_Gost28147_89: &[u8; 7] = b"gost89\0";
pub const LN_id_Gost28147_89: &[u8; 14] = b"GOST 28147-89\0";
pub const NID_id_Gost28147_89: i32 = 813;
pub const SN_gost89_cnt: &[u8; 11] = b"gost89-cnt\0";
pub const NID_gost89_cnt: i32 = 814;
pub const SN_id_Gost28147_89_MAC: &[u8; 9] = b"gost-mac\0";
pub const LN_id_Gost28147_89_MAC: &[u8; 18] = b"GOST 28147-89 MAC\0";
pub const NID_id_Gost28147_89_MAC: i32 = 815;
pub const SN_id_GostR3411_94_prf: &[u8; 17] = b"prf-gostr3411-94\0";
pub const LN_id_GostR3411_94_prf: &[u8; 20] = b"GOST R 34.11-94 PRF\0";
pub const NID_id_GostR3411_94_prf: i32 = 816;
pub const SN_id_GostR3410_2001DH: &[u8; 20] = b"id-GostR3410-2001DH\0";
pub const LN_id_GostR3410_2001DH: &[u8; 21] = b"GOST R 34.10-2001 DH\0";
pub const NID_id_GostR3410_2001DH: i32 = 817;
pub const SN_id_GostR3410_94DH: &[u8; 18] = b"id-GostR3410-94DH\0";
pub const LN_id_GostR3410_94DH: &[u8; 19] = b"GOST R 34.10-94 DH\0";
pub const NID_id_GostR3410_94DH: i32 = 818;
pub const SN_id_Gost28147_89_CryptoPro_KeyMeshing: &[u8; 37] =
    b"id-Gost28147-89-CryptoPro-KeyMeshing\0";
pub const NID_id_Gost28147_89_CryptoPro_KeyMeshing: i32 = 819;
pub const SN_id_Gost28147_89_None_KeyMeshing: &[u8; 32] = b"id-Gost28147-89-None-KeyMeshing\0";
pub const NID_id_Gost28147_89_None_KeyMeshing: i32 = 820;
pub const SN_id_GostR3411_94_TestParamSet: &[u8; 29] = b"id-GostR3411-94-TestParamSet\0";
pub const NID_id_GostR3411_94_TestParamSet: i32 = 821;
pub const SN_id_GostR3411_94_CryptoProParamSet: &[u8; 34] = b"id-GostR3411-94-CryptoProParamSet\0";
pub const NID_id_GostR3411_94_CryptoProParamSet: i32 = 822;
pub const SN_id_Gost28147_89_TestParamSet: &[u8; 29] = b"id-Gost28147-89-TestParamSet\0";
pub const NID_id_Gost28147_89_TestParamSet: i32 = 823;
pub const SN_id_Gost28147_89_CryptoPro_A_ParamSet: &[u8; 37] =
    b"id-Gost28147-89-CryptoPro-A-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_A_ParamSet: i32 = 824;
pub const SN_id_Gost28147_89_CryptoPro_B_ParamSet: &[u8; 37] =
    b"id-Gost28147-89-CryptoPro-B-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_B_ParamSet: i32 = 825;
pub const SN_id_Gost28147_89_CryptoPro_C_ParamSet: &[u8; 37] =
    b"id-Gost28147-89-CryptoPro-C-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_C_ParamSet: i32 = 826;
pub const SN_id_Gost28147_89_CryptoPro_D_ParamSet: &[u8; 37] =
    b"id-Gost28147-89-CryptoPro-D-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_D_ParamSet: i32 = 827;
pub const SN_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet: &[u8; 45] =
    b"id-Gost28147-89-CryptoPro-Oscar-1-1-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_Oscar_1_1_ParamSet: i32 = 828;
pub const SN_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet: &[u8; 45] =
    b"id-Gost28147-89-CryptoPro-Oscar-1-0-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_Oscar_1_0_ParamSet: i32 = 829;
pub const SN_id_Gost28147_89_CryptoPro_RIC_1_ParamSet: &[u8; 41] =
    b"id-Gost28147-89-CryptoPro-RIC-1-ParamSet\0";
pub const NID_id_Gost28147_89_CryptoPro_RIC_1_ParamSet: i32 = 830;
pub const SN_id_GostR3410_94_TestParamSet: &[u8; 29] = b"id-GostR3410-94-TestParamSet\0";
pub const NID_id_GostR3410_94_TestParamSet: i32 = 831;
pub const SN_id_GostR3410_94_CryptoPro_A_ParamSet: &[u8; 37] =
    b"id-GostR3410-94-CryptoPro-A-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_A_ParamSet: i32 = 832;
pub const SN_id_GostR3410_94_CryptoPro_B_ParamSet: &[u8; 37] =
    b"id-GostR3410-94-CryptoPro-B-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_B_ParamSet: i32 = 833;
pub const SN_id_GostR3410_94_CryptoPro_C_ParamSet: &[u8; 37] =
    b"id-GostR3410-94-CryptoPro-C-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_C_ParamSet: i32 = 834;
pub const SN_id_GostR3410_94_CryptoPro_D_ParamSet: &[u8; 37] =
    b"id-GostR3410-94-CryptoPro-D-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_D_ParamSet: i32 = 835;
pub const SN_id_GostR3410_94_CryptoPro_XchA_ParamSet: &[u8; 40] =
    b"id-GostR3410-94-CryptoPro-XchA-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_XchA_ParamSet: i32 = 836;
pub const SN_id_GostR3410_94_CryptoPro_XchB_ParamSet: &[u8; 40] =
    b"id-GostR3410-94-CryptoPro-XchB-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_XchB_ParamSet: i32 = 837;
pub const SN_id_GostR3410_94_CryptoPro_XchC_ParamSet: &[u8; 40] =
    b"id-GostR3410-94-CryptoPro-XchC-ParamSet\0";
pub const NID_id_GostR3410_94_CryptoPro_XchC_ParamSet: i32 = 838;
pub const SN_id_GostR3410_2001_TestParamSet: &[u8; 31] = b"id-GostR3410-2001-TestParamSet\0";
pub const NID_id_GostR3410_2001_TestParamSet: i32 = 839;
pub const SN_id_GostR3410_2001_CryptoPro_A_ParamSet: &[u8; 39] =
    b"id-GostR3410-2001-CryptoPro-A-ParamSet\0";
pub const NID_id_GostR3410_2001_CryptoPro_A_ParamSet: i32 = 840;
pub const SN_id_GostR3410_2001_CryptoPro_B_ParamSet: &[u8; 39] =
    b"id-GostR3410-2001-CryptoPro-B-ParamSet\0";
pub const NID_id_GostR3410_2001_CryptoPro_B_ParamSet: i32 = 841;
pub const SN_id_GostR3410_2001_CryptoPro_C_ParamSet: &[u8; 39] =
    b"id-GostR3410-2001-CryptoPro-C-ParamSet\0";
pub const NID_id_GostR3410_2001_CryptoPro_C_ParamSet: i32 = 842;
pub const SN_id_GostR3410_2001_CryptoPro_XchA_ParamSet: &[u8; 42] =
    b"id-GostR3410-2001-CryptoPro-XchA-ParamSet\0";
pub const NID_id_GostR3410_2001_CryptoPro_XchA_ParamSet: i32 = 843;
pub const SN_id_GostR3410_2001_CryptoPro_XchB_ParamSet: &[u8; 42] =
    b"id-GostR3410-2001-CryptoPro-XchB-ParamSet\0";
pub const NID_id_GostR3410_2001_CryptoPro_XchB_ParamSet: i32 = 844;
pub const SN_id_GostR3410_94_a: &[u8; 18] = b"id-GostR3410-94-a\0";
pub const NID_id_GostR3410_94_a: i32 = 845;
pub const SN_id_GostR3410_94_aBis: &[u8; 21] = b"id-GostR3410-94-aBis\0";
pub const NID_id_GostR3410_94_aBis: i32 = 846;
pub const SN_id_GostR3410_94_b: &[u8; 18] = b"id-GostR3410-94-b\0";
pub const NID_id_GostR3410_94_b: i32 = 847;
pub const SN_id_GostR3410_94_bBis: &[u8; 21] = b"id-GostR3410-94-bBis\0";
pub const NID_id_GostR3410_94_bBis: i32 = 848;
pub const SN_id_Gost28147_89_cc: &[u8; 19] = b"id-Gost28147-89-cc\0";
pub const LN_id_Gost28147_89_cc: &[u8; 33] = b"GOST 28147-89 Cryptocom ParamSet\0";
pub const NID_id_Gost28147_89_cc: i32 = 849;
pub const SN_id_GostR3410_94_cc: &[u8; 9] = b"gost94cc\0";
pub const LN_id_GostR3410_94_cc: &[u8; 24] = b"GOST 34.10-94 Cryptocom\0";
pub const NID_id_GostR3410_94_cc: i32 = 850;
pub const SN_id_GostR3410_2001_cc: &[u8; 11] = b"gost2001cc\0";
pub const LN_id_GostR3410_2001_cc: &[u8; 26] = b"GOST 34.10-2001 Cryptocom\0";
pub const NID_id_GostR3410_2001_cc: i32 = 851;
pub const SN_id_GostR3411_94_with_GostR3410_94_cc: &[u8; 37] =
    b"id-GostR3411-94-with-GostR3410-94-cc\0";
pub const LN_id_GostR3411_94_with_GostR3410_94_cc: &[u8; 47] =
    b"GOST R 34.11-94 with GOST R 34.10-94 Cryptocom\0";
pub const NID_id_GostR3411_94_with_GostR3410_94_cc: i32 = 852;
pub const SN_id_GostR3411_94_with_GostR3410_2001_cc: &[u8; 39] =
    b"id-GostR3411-94-with-GostR3410-2001-cc\0";
pub const LN_id_GostR3411_94_with_GostR3410_2001_cc: &[u8; 49] =
    b"GOST R 34.11-94 with GOST R 34.10-2001 Cryptocom\0";
pub const NID_id_GostR3411_94_with_GostR3410_2001_cc: i32 = 853;
pub const SN_id_GostR3410_2001_ParamSet_cc: &[u8; 30] = b"id-GostR3410-2001-ParamSet-cc\0";
pub const LN_id_GostR3410_2001_ParamSet_cc: &[u8; 41] =
    b"GOST R 3410-2001 Parameter Set Cryptocom\0";
pub const NID_id_GostR3410_2001_ParamSet_cc: i32 = 854;
pub const SN_hmac: &[u8; 5] = b"HMAC\0";
pub const LN_hmac: &[u8; 5] = b"hmac\0";
pub const NID_hmac: i32 = 855;
pub const SN_LocalKeySet: &[u8; 12] = b"LocalKeySet\0";
pub const LN_LocalKeySet: &[u8; 24] = b"Microsoft Local Key set\0";
pub const NID_LocalKeySet: i32 = 856;
pub const SN_freshest_crl: &[u8; 12] = b"freshestCRL\0";
pub const LN_freshest_crl: &[u8; 20] = b"X509v3 Freshest CRL\0";
pub const NID_freshest_crl: i32 = 857;
pub const SN_id_on_permanentIdentifier: &[u8; 26] = b"id-on-permanentIdentifier\0";
pub const LN_id_on_permanentIdentifier: &[u8; 21] = b"Permanent Identifier\0";
pub const NID_id_on_permanentIdentifier: i32 = 858;
pub const LN_searchGuide: &[u8; 12] = b"searchGuide\0";
pub const NID_searchGuide: i32 = 859;
pub const LN_businessCategory: &[u8; 17] = b"businessCategory\0";
pub const NID_businessCategory: i32 = 860;
pub const LN_postalAddress: &[u8; 14] = b"postalAddress\0";
pub const NID_postalAddress: i32 = 861;
pub const LN_postOfficeBox: &[u8; 14] = b"postOfficeBox\0";
pub const NID_postOfficeBox: i32 = 862;
pub const LN_physicalDeliveryOfficeName: &[u8; 27] = b"physicalDeliveryOfficeName\0";
pub const NID_physicalDeliveryOfficeName: i32 = 863;
pub const LN_telephoneNumber: &[u8; 16] = b"telephoneNumber\0";
pub const NID_telephoneNumber: i32 = 864;
pub const LN_telexNumber: &[u8; 12] = b"telexNumber\0";
pub const NID_telexNumber: i32 = 865;
pub const LN_teletexTerminalIdentifier: &[u8; 26] = b"teletexTerminalIdentifier\0";
pub const NID_teletexTerminalIdentifier: i32 = 866;
pub const LN_facsimileTelephoneNumber: &[u8; 25] = b"facsimileTelephoneNumber\0";
pub const NID_facsimileTelephoneNumber: i32 = 867;
pub const LN_x121Address: &[u8; 12] = b"x121Address\0";
pub const NID_x121Address: i32 = 868;
pub const LN_internationaliSDNNumber: &[u8; 24] = b"internationaliSDNNumber\0";
pub const NID_internationaliSDNNumber: i32 = 869;
pub const LN_registeredAddress: &[u8; 18] = b"registeredAddress\0";
pub const NID_registeredAddress: i32 = 870;
pub const LN_destinationIndicator: &[u8; 21] = b"destinationIndicator\0";
pub const NID_destinationIndicator: i32 = 871;
pub const LN_preferredDeliveryMethod: &[u8; 24] = b"preferredDeliveryMethod\0";
pub const NID_preferredDeliveryMethod: i32 = 872;
pub const LN_presentationAddress: &[u8; 20] = b"presentationAddress\0";
pub const NID_presentationAddress: i32 = 873;
pub const LN_supportedApplicationContext: &[u8; 28] = b"supportedApplicationContext\0";
pub const NID_supportedApplicationContext: i32 = 874;
pub const SN_member: &[u8; 7] = b"member\0";
pub const NID_member: i32 = 875;
pub const SN_owner: &[u8; 6] = b"owner\0";
pub const NID_owner: i32 = 876;
pub const LN_roleOccupant: &[u8; 13] = b"roleOccupant\0";
pub const NID_roleOccupant: i32 = 877;
pub const SN_seeAlso: &[u8; 8] = b"seeAlso\0";
pub const NID_seeAlso: i32 = 878;
pub const LN_userPassword: &[u8; 13] = b"userPassword\0";
pub const NID_userPassword: i32 = 879;
pub const LN_userCertificate: &[u8; 16] = b"userCertificate\0";
pub const NID_userCertificate: i32 = 880;
pub const LN_cACertificate: &[u8; 14] = b"cACertificate\0";
pub const NID_cACertificate: i32 = 881;
pub const LN_authorityRevocationList: &[u8; 24] = b"authorityRevocationList\0";
pub const NID_authorityRevocationList: i32 = 882;
pub const LN_certificateRevocationList: &[u8; 26] = b"certificateRevocationList\0";
pub const NID_certificateRevocationList: i32 = 883;
pub const LN_crossCertificatePair: &[u8; 21] = b"crossCertificatePair\0";
pub const NID_crossCertificatePair: i32 = 884;
pub const LN_enhancedSearchGuide: &[u8; 20] = b"enhancedSearchGuide\0";
pub const NID_enhancedSearchGuide: i32 = 885;
pub const LN_protocolInformation: &[u8; 20] = b"protocolInformation\0";
pub const NID_protocolInformation: i32 = 886;
pub const LN_distinguishedName: &[u8; 18] = b"distinguishedName\0";
pub const NID_distinguishedName: i32 = 887;
pub const LN_uniqueMember: &[u8; 13] = b"uniqueMember\0";
pub const NID_uniqueMember: i32 = 888;
pub const LN_houseIdentifier: &[u8; 16] = b"houseIdentifier\0";
pub const NID_houseIdentifier: i32 = 889;
pub const LN_supportedAlgorithms: &[u8; 20] = b"supportedAlgorithms\0";
pub const NID_supportedAlgorithms: i32 = 890;
pub const LN_deltaRevocationList: &[u8; 20] = b"deltaRevocationList\0";
pub const NID_deltaRevocationList: i32 = 891;
pub const SN_dmdName: &[u8; 8] = b"dmdName\0";
pub const NID_dmdName: i32 = 892;
pub const SN_id_alg_PWRI_KEK: &[u8; 16] = b"id-alg-PWRI-KEK\0";
pub const NID_id_alg_PWRI_KEK: i32 = 893;
pub const SN_cmac: &[u8; 5] = b"CMAC\0";
pub const LN_cmac: &[u8; 5] = b"cmac\0";
pub const NID_cmac: i32 = 894;
pub const SN_aes_128_gcm: &[u8; 14] = b"id-aes128-GCM\0";
pub const LN_aes_128_gcm: &[u8; 12] = b"aes-128-gcm\0";
pub const NID_aes_128_gcm: i32 = 895;
pub const SN_aes_128_ccm: &[u8; 14] = b"id-aes128-CCM\0";
pub const LN_aes_128_ccm: &[u8; 12] = b"aes-128-ccm\0";
pub const NID_aes_128_ccm: i32 = 896;
pub const SN_id_aes128_wrap_pad: &[u8; 19] = b"id-aes128-wrap-pad\0";
pub const NID_id_aes128_wrap_pad: i32 = 897;
pub const SN_aes_192_gcm: &[u8; 14] = b"id-aes192-GCM\0";
pub const LN_aes_192_gcm: &[u8; 12] = b"aes-192-gcm\0";
pub const NID_aes_192_gcm: i32 = 898;
pub const SN_aes_192_ccm: &[u8; 14] = b"id-aes192-CCM\0";
pub const LN_aes_192_ccm: &[u8; 12] = b"aes-192-ccm\0";
pub const NID_aes_192_ccm: i32 = 899;
pub const SN_id_aes192_wrap_pad: &[u8; 19] = b"id-aes192-wrap-pad\0";
pub const NID_id_aes192_wrap_pad: i32 = 900;
pub const SN_aes_256_gcm: &[u8; 14] = b"id-aes256-GCM\0";
pub const LN_aes_256_gcm: &[u8; 12] = b"aes-256-gcm\0";
pub const NID_aes_256_gcm: i32 = 901;
pub const SN_aes_256_ccm: &[u8; 14] = b"id-aes256-CCM\0";
pub const LN_aes_256_ccm: &[u8; 12] = b"aes-256-ccm\0";
pub const NID_aes_256_ccm: i32 = 902;
pub const SN_id_aes256_wrap_pad: &[u8; 19] = b"id-aes256-wrap-pad\0";
pub const NID_id_aes256_wrap_pad: i32 = 903;
pub const SN_aes_128_ctr: &[u8; 12] = b"AES-128-CTR\0";
pub const LN_aes_128_ctr: &[u8; 12] = b"aes-128-ctr\0";
pub const NID_aes_128_ctr: i32 = 904;
pub const SN_aes_192_ctr: &[u8; 12] = b"AES-192-CTR\0";
pub const LN_aes_192_ctr: &[u8; 12] = b"aes-192-ctr\0";
pub const NID_aes_192_ctr: i32 = 905;
pub const SN_aes_256_ctr: &[u8; 12] = b"AES-256-CTR\0";
pub const LN_aes_256_ctr: &[u8; 12] = b"aes-256-ctr\0";
pub const NID_aes_256_ctr: i32 = 906;
pub const SN_id_camellia128_wrap: &[u8; 20] = b"id-camellia128-wrap\0";
pub const NID_id_camellia128_wrap: i32 = 907;
pub const SN_id_camellia192_wrap: &[u8; 20] = b"id-camellia192-wrap\0";
pub const NID_id_camellia192_wrap: i32 = 908;
pub const SN_id_camellia256_wrap: &[u8; 20] = b"id-camellia256-wrap\0";
pub const NID_id_camellia256_wrap: i32 = 909;
pub const SN_anyExtendedKeyUsage: &[u8; 20] = b"anyExtendedKeyUsage\0";
pub const LN_anyExtendedKeyUsage: &[u8; 23] = b"Any Extended Key Usage\0";
pub const NID_anyExtendedKeyUsage: i32 = 910;
pub const SN_mgf1: &[u8; 5] = b"MGF1\0";
pub const LN_mgf1: &[u8; 5] = b"mgf1\0";
pub const NID_mgf1: i32 = 911;
pub const SN_rsassaPss: &[u8; 11] = b"RSASSA-PSS\0";
pub const LN_rsassaPss: &[u8; 10] = b"rsassaPss\0";
pub const NID_rsassaPss: i32 = 912;
pub const SN_aes_128_xts: &[u8; 12] = b"AES-128-XTS\0";
pub const LN_aes_128_xts: &[u8; 12] = b"aes-128-xts\0";
pub const NID_aes_128_xts: i32 = 913;
pub const SN_aes_256_xts: &[u8; 12] = b"AES-256-XTS\0";
pub const LN_aes_256_xts: &[u8; 12] = b"aes-256-xts\0";
pub const NID_aes_256_xts: i32 = 914;
pub const SN_rc4_hmac_md5: &[u8; 13] = b"RC4-HMAC-MD5\0";
pub const LN_rc4_hmac_md5: &[u8; 13] = b"rc4-hmac-md5\0";
pub const NID_rc4_hmac_md5: i32 = 915;
pub const SN_aes_128_cbc_hmac_sha1: &[u8; 22] = b"AES-128-CBC-HMAC-SHA1\0";
pub const LN_aes_128_cbc_hmac_sha1: &[u8; 22] = b"aes-128-cbc-hmac-sha1\0";
pub const NID_aes_128_cbc_hmac_sha1: i32 = 916;
pub const SN_aes_192_cbc_hmac_sha1: &[u8; 22] = b"AES-192-CBC-HMAC-SHA1\0";
pub const LN_aes_192_cbc_hmac_sha1: &[u8; 22] = b"aes-192-cbc-hmac-sha1\0";
pub const NID_aes_192_cbc_hmac_sha1: i32 = 917;
pub const SN_aes_256_cbc_hmac_sha1: &[u8; 22] = b"AES-256-CBC-HMAC-SHA1\0";
pub const LN_aes_256_cbc_hmac_sha1: &[u8; 22] = b"aes-256-cbc-hmac-sha1\0";
pub const NID_aes_256_cbc_hmac_sha1: i32 = 918;
pub const SN_rsaesOaep: &[u8; 11] = b"RSAES-OAEP\0";
pub const LN_rsaesOaep: &[u8; 10] = b"rsaesOaep\0";
pub const NID_rsaesOaep: i32 = 919;
pub const SN_dhpublicnumber: &[u8; 15] = b"dhpublicnumber\0";
pub const LN_dhpublicnumber: &[u8; 9] = b"X9.42 DH\0";
pub const NID_dhpublicnumber: i32 = 920;
pub const SN_brainpoolP160r1: &[u8; 16] = b"brainpoolP160r1\0";
pub const NID_brainpoolP160r1: i32 = 921;
pub const SN_brainpoolP160t1: &[u8; 16] = b"brainpoolP160t1\0";
pub const NID_brainpoolP160t1: i32 = 922;
pub const SN_brainpoolP192r1: &[u8; 16] = b"brainpoolP192r1\0";
pub const NID_brainpoolP192r1: i32 = 923;
pub const SN_brainpoolP192t1: &[u8; 16] = b"brainpoolP192t1\0";
pub const NID_brainpoolP192t1: i32 = 924;
pub const SN_brainpoolP224r1: &[u8; 16] = b"brainpoolP224r1\0";
pub const NID_brainpoolP224r1: i32 = 925;
pub const SN_brainpoolP224t1: &[u8; 16] = b"brainpoolP224t1\0";
pub const NID_brainpoolP224t1: i32 = 926;
pub const SN_brainpoolP256r1: &[u8; 16] = b"brainpoolP256r1\0";
pub const NID_brainpoolP256r1: i32 = 927;
pub const SN_brainpoolP256t1: &[u8; 16] = b"brainpoolP256t1\0";
pub const NID_brainpoolP256t1: i32 = 928;
pub const SN_brainpoolP320r1: &[u8; 16] = b"brainpoolP320r1\0";
pub const NID_brainpoolP320r1: i32 = 929;
pub const SN_brainpoolP320t1: &[u8; 16] = b"brainpoolP320t1\0";
pub const NID_brainpoolP320t1: i32 = 930;
pub const SN_brainpoolP384r1: &[u8; 16] = b"brainpoolP384r1\0";
pub const NID_brainpoolP384r1: i32 = 931;
pub const SN_brainpoolP384t1: &[u8; 16] = b"brainpoolP384t1\0";
pub const NID_brainpoolP384t1: i32 = 932;
pub const SN_brainpoolP512r1: &[u8; 16] = b"brainpoolP512r1\0";
pub const NID_brainpoolP512r1: i32 = 933;
pub const SN_brainpoolP512t1: &[u8; 16] = b"brainpoolP512t1\0";
pub const NID_brainpoolP512t1: i32 = 934;
pub const SN_pSpecified: &[u8; 11] = b"PSPECIFIED\0";
pub const LN_pSpecified: &[u8; 11] = b"pSpecified\0";
pub const NID_pSpecified: i32 = 935;
pub const SN_dhSinglePass_stdDH_sha1kdf_scheme: &[u8; 34] = b"dhSinglePass-stdDH-sha1kdf-scheme\0";
pub const NID_dhSinglePass_stdDH_sha1kdf_scheme: i32 = 936;
pub const SN_dhSinglePass_stdDH_sha224kdf_scheme: &[u8; 36] =
    b"dhSinglePass-stdDH-sha224kdf-scheme\0";
pub const NID_dhSinglePass_stdDH_sha224kdf_scheme: i32 = 937;
pub const SN_dhSinglePass_stdDH_sha256kdf_scheme: &[u8; 36] =
    b"dhSinglePass-stdDH-sha256kdf-scheme\0";
pub const NID_dhSinglePass_stdDH_sha256kdf_scheme: i32 = 938;
pub const SN_dhSinglePass_stdDH_sha384kdf_scheme: &[u8; 36] =
    b"dhSinglePass-stdDH-sha384kdf-scheme\0";
pub const NID_dhSinglePass_stdDH_sha384kdf_scheme: i32 = 939;
pub const SN_dhSinglePass_stdDH_sha512kdf_scheme: &[u8; 36] =
    b"dhSinglePass-stdDH-sha512kdf-scheme\0";
pub const NID_dhSinglePass_stdDH_sha512kdf_scheme: i32 = 940;
pub const SN_dhSinglePass_cofactorDH_sha1kdf_scheme: &[u8; 39] =
    b"dhSinglePass-cofactorDH-sha1kdf-scheme\0";
pub const NID_dhSinglePass_cofactorDH_sha1kdf_scheme: i32 = 941;
pub const SN_dhSinglePass_cofactorDH_sha224kdf_scheme: &[u8; 41] =
    b"dhSinglePass-cofactorDH-sha224kdf-scheme\0";
pub const NID_dhSinglePass_cofactorDH_sha224kdf_scheme: i32 = 942;
pub const SN_dhSinglePass_cofactorDH_sha256kdf_scheme: &[u8; 41] =
    b"dhSinglePass-cofactorDH-sha256kdf-scheme\0";
pub const NID_dhSinglePass_cofactorDH_sha256kdf_scheme: i32 = 943;
pub const SN_dhSinglePass_cofactorDH_sha384kdf_scheme: &[u8; 41] =
    b"dhSinglePass-cofactorDH-sha384kdf-scheme\0";
pub const NID_dhSinglePass_cofactorDH_sha384kdf_scheme: i32 = 944;
pub const SN_dhSinglePass_cofactorDH_sha512kdf_scheme: &[u8; 41] =
    b"dhSinglePass-cofactorDH-sha512kdf-scheme\0";
pub const NID_dhSinglePass_cofactorDH_sha512kdf_scheme: i32 = 945;
pub const SN_dh_std_kdf: &[u8; 11] = b"dh-std-kdf\0";
pub const NID_dh_std_kdf: i32 = 946;
pub const SN_dh_cofactor_kdf: &[u8; 16] = b"dh-cofactor-kdf\0";
pub const NID_dh_cofactor_kdf: i32 = 947;
pub const SN_X25519: &[u8; 7] = b"X25519\0";
pub const NID_X25519: i32 = 948;
pub const SN_ED25519: &[u8; 8] = b"ED25519\0";
pub const NID_ED25519: i32 = 949;
pub const SN_chacha20_poly1305: &[u8; 18] = b"ChaCha20-Poly1305\0";
pub const LN_chacha20_poly1305: &[u8; 18] = b"chacha20-poly1305\0";
pub const NID_chacha20_poly1305: i32 = 950;
pub const SN_kx_rsa: &[u8; 6] = b"KxRSA\0";
pub const LN_kx_rsa: &[u8; 7] = b"kx-rsa\0";
pub const NID_kx_rsa: i32 = 951;
pub const SN_kx_ecdhe: &[u8; 8] = b"KxECDHE\0";
pub const LN_kx_ecdhe: &[u8; 9] = b"kx-ecdhe\0";
pub const NID_kx_ecdhe: i32 = 952;
pub const SN_kx_psk: &[u8; 6] = b"KxPSK\0";
pub const LN_kx_psk: &[u8; 7] = b"kx-psk\0";
pub const NID_kx_psk: i32 = 953;
pub const SN_auth_rsa: &[u8; 8] = b"AuthRSA\0";
pub const LN_auth_rsa: &[u8; 9] = b"auth-rsa\0";
pub const NID_auth_rsa: i32 = 954;
pub const SN_auth_ecdsa: &[u8; 10] = b"AuthECDSA\0";
pub const LN_auth_ecdsa: &[u8; 11] = b"auth-ecdsa\0";
pub const NID_auth_ecdsa: i32 = 955;
pub const SN_auth_psk: &[u8; 8] = b"AuthPSK\0";
pub const LN_auth_psk: &[u8; 9] = b"auth-psk\0";
pub const NID_auth_psk: i32 = 956;
pub const SN_kx_any: &[u8; 6] = b"KxANY\0";
pub const LN_kx_any: &[u8; 7] = b"kx-any\0";
pub const NID_kx_any: i32 = 957;
pub const SN_auth_any: &[u8; 8] = b"AuthANY\0";
pub const LN_auth_any: &[u8; 9] = b"auth-any\0";
pub const NID_auth_any: i32 = 958;
pub const SN_ED448: &[u8; 6] = b"ED448\0";
pub const NID_ED448: i32 = 960;
pub const SN_X448: &[u8; 5] = b"X448\0";
pub const NID_X448: i32 = 961;
pub const SN_sha512_256: &[u8; 11] = b"SHA512-256\0";
pub const LN_sha512_256: &[u8; 11] = b"sha512-256\0";
pub const NID_sha512_256: i32 = 962;
pub const SN_aes_128_cbc_hmac_sha256: &[u8; 24] = b"AES-128-CBC-HMAC-SHA256\0";
pub const LN_aes_128_cbc_hmac_sha256: &[u8; 24] = b"aes-128-cbc-hmac-sha256\0";
pub const NID_aes_128_cbc_hmac_sha256: i32 = 963;
pub const SN_aes_256_cbc_hmac_sha256: &[u8; 24] = b"AES-256-CBC-HMAC-SHA256\0";
pub const LN_aes_256_cbc_hmac_sha256: &[u8; 24] = b"aes-256-cbc-hmac-sha256\0";
pub const NID_aes_256_cbc_hmac_sha256: i32 = 964;
pub const SN_sha3_224: &[u8; 9] = b"SHA3-224\0";
pub const LN_sha3_224: &[u8; 9] = b"sha3-224\0";
pub const NID_sha3_224: i32 = 965;
pub const SN_sha3_256: &[u8; 9] = b"SHA3-256\0";
pub const LN_sha3_256: &[u8; 9] = b"sha3-256\0";
pub const NID_sha3_256: i32 = 966;
pub const SN_sha3_384: &[u8; 9] = b"SHA3-384\0";
pub const LN_sha3_384: &[u8; 9] = b"sha3-384\0";
pub const NID_sha3_384: i32 = 967;
pub const SN_sha3_512: &[u8; 9] = b"SHA3-512\0";
pub const LN_sha3_512: &[u8; 9] = b"sha3-512\0";
pub const NID_sha3_512: i32 = 968;
pub const SN_hkdf: &[u8; 5] = b"HKDF\0";
pub const LN_hkdf: &[u8; 5] = b"hkdf\0";
pub const NID_hkdf: i32 = 969;
pub const SN_kem: &[u8; 4] = b"KEM\0";
pub const LN_kem: &[u8; 4] = b"kem\0";
pub const NID_kem: i32 = 970;
pub const SN_KYBER512: &[u8; 9] = b"KYBER512\0";
pub const NID_KYBER512: i32 = 971;
pub const SN_KYBER512_R3: &[u8; 12] = b"KYBER512_R3\0";
pub const NID_KYBER512_R3: i32 = 972;
pub const SN_KYBER768_R3: &[u8; 12] = b"KYBER768_R3\0";
pub const NID_KYBER768_R3: i32 = 973;
pub const SN_KYBER1024_R3: &[u8; 13] = b"KYBER1024_R3\0";
pub const NID_KYBER1024_R3: i32 = 974;
pub const SN_DILITHIUM3_R3: &[u8; 14] = b"DILITHIUM3_R3\0";
pub const NID_DILITHIUM3_R3: i32 = 975;
pub const SN_ffdhe2048: &[u8; 10] = b"ffdhe2048\0";
pub const NID_ffdhe2048: i32 = 976;
pub const SN_ffdhe4096: &[u8; 10] = b"ffdhe4096\0";
pub const NID_ffdhe4096: i32 = 977;
pub const SN_sha512_224: &[u8; 11] = b"SHA512-224\0";
pub const LN_sha512_224: &[u8; 11] = b"sha512-224\0";
pub const NID_sha512_224: i32 = 978;
pub const SN_shake128: &[u8; 9] = b"SHAKE128\0";
pub const LN_shake128: &[u8; 9] = b"shake128\0";
pub const NID_shake128: i32 = 979;
pub const SN_shake256: &[u8; 9] = b"SHAKE256\0";
pub const LN_shake256: &[u8; 9] = b"shake256\0";
pub const NID_shake256: i32 = 980;
pub const SN_SecP256r1Kyber768Draft00: &[u8; 25] = b"SecP256r1Kyber768Draft00\0";
pub const NID_SecP256r1Kyber768Draft00: i32 = 981;
pub const SN_X25519Kyber768Draft00: &[u8; 22] = b"X25519Kyber768Draft00\0";
pub const NID_X25519Kyber768Draft00: i32 = 982;
pub const SN_ffdhe3072: &[u8; 10] = b"ffdhe3072\0";
pub const NID_ffdhe3072: i32 = 983;
pub const SN_ffdhe8192: &[u8; 10] = b"ffdhe8192\0";
pub const NID_ffdhe8192: i32 = 984;
pub const SN_MLKEM512IPD: &[u8; 12] = b"MLKEM512IPD\0";
pub const NID_MLKEM512IPD: i32 = 985;
pub const SN_MLKEM768IPD: &[u8; 12] = b"MLKEM768IPD\0";
pub const NID_MLKEM768IPD: i32 = 986;
pub const SN_MLKEM1024IPD: &[u8; 13] = b"MLKEM1024IPD\0";
pub const NID_MLKEM1024IPD: i32 = 987;
pub const SN_MLKEM512: &[u8; 9] = b"MLKEM512\0";
pub const NID_MLKEM512: i32 = 988;
pub const SN_MLKEM768: &[u8; 9] = b"MLKEM768\0";
pub const NID_MLKEM768: i32 = 989;
pub const SN_MLKEM1024: &[u8; 10] = b"MLKEM1024\0";
pub const NID_MLKEM1024: i32 = 990;
pub const SN_X25519MLKEM768: &[u8; 15] = b"X25519MLKEM768\0";
pub const NID_X25519MLKEM768: i32 = 991;
pub const SN_SecP256r1MLKEM768: &[u8; 18] = b"SecP256r1MLKEM768\0";
pub const NID_SecP256r1MLKEM768: i32 = 992;
pub const SN_PQDSA: &[u8; 6] = b"PQDSA\0";
pub const NID_PQDSA: i32 = 993;
pub const SN_MLDSA44: &[u8; 8] = b"MLDSA44\0";
pub const NID_MLDSA44: i32 = 994;
pub const SN_MLDSA65: &[u8; 8] = b"MLDSA65\0";
pub const NID_MLDSA65: i32 = 995;
pub const SN_MLDSA87: &[u8; 8] = b"MLDSA87\0";
pub const NID_MLDSA87: i32 = 996;
pub const SN_ED25519ph: &[u8; 10] = b"ED25519ph\0";
pub const NID_ED25519ph: i32 = 997;
pub const SN_SecP384r1MLKEM1024: &[u8; 19] = b"SecP384r1MLKEM1024\0";
pub const NID_SecP384r1MLKEM1024: i32 = 998;
pub const HMAC_MD5_PRECOMPUTED_KEY_SIZE: i32 = 32;
pub const HMAC_SHA1_PRECOMPUTED_KEY_SIZE: i32 = 40;
pub const HMAC_SHA224_PRECOMPUTED_KEY_SIZE: i32 = 64;
pub const HMAC_SHA256_PRECOMPUTED_KEY_SIZE: i32 = 64;
pub const HMAC_SHA384_PRECOMPUTED_KEY_SIZE: i32 = 128;
pub const HMAC_SHA512_PRECOMPUTED_KEY_SIZE: i32 = 128;
pub const HMAC_SHA512_224_PRECOMPUTED_KEY_SIZE: i32 = 128;
pub const HMAC_SHA512_256_PRECOMPUTED_KEY_SIZE: i32 = 128;
pub const HMAC_MAX_PRECOMPUTED_KEY_SIZE: i32 = 128;
pub const HMAC_R_MISSING_PARAMETERS: i32 = 100;
pub const HMAC_R_BUFFER_TOO_SMALL: i32 = 102;
pub const HMAC_R_SET_PRECOMPUTED_KEY_EXPORT_NOT_CALLED: i32 = 103;
pub const HMAC_R_NOT_CALLED_JUST_AFTER_INIT: i32 = 104;
pub const HMAC_R_PRECOMPUTED_KEY_NOT_SUPPORTED_FOR_DIGEST: i32 = 105;
pub const EVP_PKEY_NONE: i32 = 0;
pub const EVP_PKEY_RSA: i32 = 6;
pub const EVP_PKEY_RSA_PSS: i32 = 912;
pub const EVP_PKEY_EC: i32 = 408;
pub const EVP_PKEY_ED25519: i32 = 949;
pub const EVP_PKEY_ED25519PH: i32 = 997;
pub const EVP_PKEY_X25519: i32 = 948;
pub const EVP_PKEY_HKDF: i32 = 969;
pub const EVP_PKEY_HMAC: i32 = 855;
pub const EVP_PKEY_DH: i32 = 28;
pub const EVP_PKEY_PQDSA: i32 = 993;
pub const EVP_PKEY_KEM: i32 = 970;
pub const PKCS5_SALT_LEN: i32 = 8;
pub const EVP_PKEY_RSA2: i32 = 19;
pub const EVP_PKEY_X448: i32 = 961;
pub const EVP_PKEY_ED448: i32 = 960;
pub const EVP_PKEY_DSA: i32 = 116;
pub const EVP_PKEY_HKDEF_MODE_EXTRACT_AND_EXPAND: i32 = 0;
pub const EVP_PKEY_HKDEF_MODE_EXTRACT_ONLY: i32 = 1;
pub const EVP_PKEY_HKDEF_MODE_EXPAND_ONLY: i32 = 2;
pub const HKDF_R_OUTPUT_TOO_LARGE: i32 = 100;
pub const RSA_PKCS1_PADDING: i32 = 1;
pub const RSA_NO_PADDING: i32 = 3;
pub const RSA_PKCS1_OAEP_PADDING: i32 = 4;
pub const RSA_PKCS1_PSS_PADDING: i32 = 6;
pub const RSA_PSS_SALTLEN_DIGEST: i32 = -1;
pub const RSA_FLAG_OPAQUE: i32 = 1;
pub const RSA_FLAG_NO_BLINDING: i32 = 8;
pub const RSA_FLAG_EXT_PKEY: i32 = 32;
pub const RSA_FLAG_NO_PUBLIC_EXPONENT: i32 = 64;
pub const RSA_FLAG_LARGE_PUBLIC_EXPONENT: i32 = 128;
pub const RSA_3: i32 = 3;
pub const RSA_F4: i32 = 65537;
pub const RSA_METHOD_FLAG_NO_CHECK: i32 = 1;
pub const RSA_R_BAD_ENCODING: i32 = 100;
pub const RSA_R_BAD_E_VALUE: i32 = 101;
pub const RSA_R_BAD_FIXED_HEADER_DECRYPT: i32 = 102;
pub const RSA_R_BAD_PAD_BYTE_COUNT: i32 = 103;
pub const RSA_R_BAD_RSA_PARAMETERS: i32 = 104;
pub const RSA_R_BAD_SIGNATURE: i32 = 105;
pub const RSA_R_BAD_VERSION: i32 = 106;
pub const RSA_R_BLOCK_TYPE_IS_NOT_01: i32 = 107;
pub const RSA_R_BN_NOT_INITIALIZED: i32 = 108;
pub const RSA_R_CANNOT_RECOVER_MULTI_PRIME_KEY: i32 = 109;
pub const RSA_R_CRT_PARAMS_ALREADY_GIVEN: i32 = 110;
pub const RSA_R_CRT_VALUES_INCORRECT: i32 = 111;
pub const RSA_R_DATA_LEN_NOT_EQUAL_TO_MOD_LEN: i32 = 112;
pub const RSA_R_DATA_TOO_LARGE: i32 = 113;
pub const RSA_R_DATA_TOO_LARGE_FOR_KEY_SIZE: i32 = 114;
pub const RSA_R_DATA_TOO_LARGE_FOR_MODULUS: i32 = 115;
pub const RSA_R_DATA_TOO_SMALL: i32 = 116;
pub const RSA_R_DATA_TOO_SMALL_FOR_KEY_SIZE: i32 = 117;
pub const RSA_R_DIGEST_TOO_BIG_FOR_RSA_KEY: i32 = 118;
pub const RSA_R_D_E_NOT_CONGRUENT_TO_1: i32 = 119;
pub const RSA_R_EMPTY_PUBLIC_KEY: i32 = 120;
pub const RSA_R_ENCODE_ERROR: i32 = 121;
pub const RSA_R_FIRST_OCTET_INVALID: i32 = 122;
pub const RSA_R_INCONSISTENT_SET_OF_CRT_VALUES: i32 = 123;
pub const RSA_R_INTERNAL_ERROR: i32 = 124;
pub const RSA_R_INVALID_MESSAGE_LENGTH: i32 = 125;
pub const RSA_R_KEY_SIZE_TOO_SMALL: i32 = 126;
pub const RSA_R_LAST_OCTET_INVALID: i32 = 127;
pub const RSA_R_MODULUS_TOO_LARGE: i32 = 128;
pub const RSA_R_MUST_HAVE_AT_LEAST_TWO_PRIMES: i32 = 129;
pub const RSA_R_NO_PUBLIC_EXPONENT: i32 = 130;
pub const RSA_R_NULL_BEFORE_BLOCK_MISSING: i32 = 131;
pub const RSA_R_N_NOT_EQUAL_P_Q: i32 = 132;
pub const RSA_R_OAEP_DECODING_ERROR: i32 = 133;
pub const RSA_R_ONLY_ONE_OF_P_Q_GIVEN: i32 = 134;
pub const RSA_R_OUTPUT_BUFFER_TOO_SMALL: i32 = 135;
pub const RSA_R_PADDING_CHECK_FAILED: i32 = 136;
pub const RSA_R_PKCS_DECODING_ERROR: i32 = 137;
pub const RSA_R_SLEN_CHECK_FAILED: i32 = 138;
pub const RSA_R_SLEN_RECOVERY_FAILED: i32 = 139;
pub const RSA_R_TOO_LONG: i32 = 140;
pub const RSA_R_TOO_MANY_ITERATIONS: i32 = 141;
pub const RSA_R_UNKNOWN_ALGORITHM_TYPE: i32 = 142;
pub const RSA_R_UNKNOWN_PADDING_TYPE: i32 = 143;
pub const RSA_R_VALUE_MISSING: i32 = 144;
pub const RSA_R_WRONG_SIGNATURE_LENGTH: i32 = 145;
pub const RSA_R_PUBLIC_KEY_VALIDATION_FAILED: i32 = 146;
pub const RSA_R_D_OUT_OF_RANGE: i32 = 147;
pub const RSA_R_BLOCK_TYPE_IS_NOT_02: i32 = 148;
pub const RSA_R_MISMATCHED_SIGNATURE: i32 = 248;
pub const RSA_F_RSA_OSSL_PRIVATE_ENCRYPT: i32 = 0;
pub const RAND_PRED_RESISTANCE_LEN: i32 = 32;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type ossl_ssize_t = isize;
pub type CBS_ASN1_TAG = u32;
pub type CRYPTO_THREADID = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asn1_null_st {
    _unused: [u8; 0],
}
pub type ASN1_NULL = asn1_null_st;
pub type ASN1_BOOLEAN = ::std::os::raw::c_int;
pub type ASN1_ITEM = ASN1_ITEM_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asn1_object_st {
    _unused: [u8; 0],
}
pub type ASN1_OBJECT = asn1_object_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct asn1_pctx_st {
    _unused: [u8; 0],
}
pub type ASN1_PCTX = asn1_pctx_st;
pub type ASN1_BIT_STRING = asn1_string_st;
pub type ASN1_BMPSTRING = asn1_string_st;
pub type ASN1_ENUMERATED = asn1_string_st;
pub type ASN1_GENERALIZEDTIME = asn1_string_st;
pub type ASN1_GENERALSTRING = asn1_string_st;
pub type ASN1_IA5STRING = asn1_string_st;
pub type ASN1_INTEGER = asn1_string_st;
pub type ASN1_OCTET_STRING = asn1_string_st;
pub type ASN1_PRINTABLESTRING = asn1_string_st;
pub type ASN1_STRING = asn1_string_st;
pub type ASN1_T61STRING = asn1_string_st;
pub type ASN1_TIME = asn1_string_st;
pub type ASN1_UNIVERSALSTRING = asn1_string_st;
pub type ASN1_UTCTIME = asn1_string_st;
pub type ASN1_UTF8STRING = asn1_string_st;
pub type ASN1_VISIBLESTRING = asn1_string_st;
pub type ASN1_TYPE = asn1_type_st;
pub type AUTHORITY_KEYID = AUTHORITY_KEYID_st;
pub type BASIC_CONSTRAINTS = BASIC_CONSTRAINTS_st;
pub type DIST_POINT = DIST_POINT_st;
pub type DSA_SIG = DSA_SIG_st;
pub type GENERAL_NAME = GENERAL_NAME_st;
pub type ISSUING_DIST_POINT = ISSUING_DIST_POINT_st;
pub type NAME_CONSTRAINTS = NAME_CONSTRAINTS_st;
pub type NETSCAPE_SPKAC = Netscape_spkac_st;
pub type NETSCAPE_SPKI = Netscape_spki_st;
pub type RIPEMD160_CTX = RIPEMD160state_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_VERIFY_PARAM_st {
    _unused: [u8; 0],
}
pub type X509_VERIFY_PARAM = X509_VERIFY_PARAM_st;
pub type X509_ALGOR = X509_algor_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_crl_st {
    _unused: [u8; 0],
}
pub type X509_CRL = X509_crl_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_extension_st {
    _unused: [u8; 0],
}
pub type X509_EXTENSION = X509_extension_st;
pub type X509_INFO = X509_info_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_name_entry_st {
    _unused: [u8; 0],
}
pub type X509_NAME_ENTRY = X509_name_entry_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_name_st {
    _unused: [u8; 0],
}
pub type X509_NAME = X509_name_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_pubkey_st {
    _unused: [u8; 0],
}
pub type X509_PUBKEY = X509_pubkey_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_req_st {
    _unused: [u8; 0],
}
pub type X509_REQ = X509_req_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_sig_info_st {
    _unused: [u8; 0],
}
pub type X509_SIG_INFO = x509_sig_info_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct X509_sig_st {
    _unused: [u8; 0],
}
pub type X509_SIG = X509_sig_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct bignum_ctx {
    _unused: [u8; 0],
}
pub type BN_CTX = bignum_ctx;
pub type BIGNUM = bignum_st;
pub type BIO_METHOD = bio_method_st;
pub type BIO = bio_st;
pub type BLAKE2B_CTX = blake2b_state_st;
pub type BN_GENCB = bn_gencb_st;
pub type BN_MONT_CTX = bn_mont_ctx_st;
pub type BUF_MEM = buf_mem_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cast_key_st {
    _unused: [u8; 0],
}
pub type CAST_KEY = cast_key_st;
pub type CBB = cbb_st;
pub type CBS = cbs_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct cmac_ctx_st {
    _unused: [u8; 0],
}
pub type CMAC_CTX = cmac_ctx_st;
pub type CONF = conf_st;
pub type CONF_VALUE = conf_value_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crypto_buffer_pool_st {
    _unused: [u8; 0],
}
pub type CRYPTO_BUFFER_POOL = crypto_buffer_pool_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct crypto_buffer_st {
    _unused: [u8; 0],
}
pub type CRYPTO_BUFFER = crypto_buffer_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ctr_drbg_state_st {
    _unused: [u8; 0],
}
pub type CTR_DRBG_STATE = ctr_drbg_state_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dh_st {
    _unused: [u8; 0],
}
pub type DH = dh_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct dsa_st {
    _unused: [u8; 0],
}
pub type DSA = dsa_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ec_group_st {
    _unused: [u8; 0],
}
pub type EC_GROUP = ec_group_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ec_key_st {
    _unused: [u8; 0],
}
pub type EC_KEY = ec_key_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ec_point_st {
    _unused: [u8; 0],
}
pub type EC_POINT = ec_point_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ec_key_method_st {
    _unused: [u8; 0],
}
pub type EC_KEY_METHOD = ec_key_method_st;
pub type ECDSA_SIG = ecdsa_sig_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct engine_st {
    _unused: [u8; 0],
}
pub type ENGINE = engine_st;
pub type EVP_MD_CTX = env_md_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct env_md_st {
    _unused: [u8; 0],
}
pub type EVP_MD = env_md_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_aead_st {
    _unused: [u8; 0],
}
pub type EVP_AEAD = evp_aead_st;
pub type EVP_AEAD_CTX = evp_aead_ctx_st;
pub type EVP_CIPHER_CTX = evp_cipher_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_cipher_st {
    _unused: [u8; 0],
}
pub type EVP_CIPHER = evp_cipher_st;
pub type EVP_ENCODE_CTX = evp_encode_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_hpke_aead_st {
    _unused: [u8; 0],
}
pub type EVP_HPKE_AEAD = evp_hpke_aead_st;
pub type EVP_HPKE_CTX = evp_hpke_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_hpke_kdf_st {
    _unused: [u8; 0],
}
pub type EVP_HPKE_KDF = evp_hpke_kdf_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_hpke_kem_st {
    _unused: [u8; 0],
}
pub type EVP_HPKE_KEM = evp_hpke_kem_st;
pub type EVP_HPKE_KEY = evp_hpke_key_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_kem_st {
    _unused: [u8; 0],
}
pub type EVP_KEM = evp_kem_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct kem_key_st {
    _unused: [u8; 0],
}
pub type KEM_KEY = kem_key_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_pkey_ctx_st {
    _unused: [u8; 0],
}
pub type EVP_PKEY_CTX = evp_pkey_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_pkey_asn1_method_st {
    _unused: [u8; 0],
}
pub type EVP_PKEY_ASN1_METHOD = evp_pkey_asn1_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_pkey_st {
    _unused: [u8; 0],
}
pub type EVP_PKEY = evp_pkey_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_pkey_ctx_signature_context_params_st {
    _unused: [u8; 0],
}
pub type EVP_PKEY_CTX_SIGNATURE_CONTEXT_PARAMS = evp_pkey_ctx_signature_context_params_st;
pub type HMAC_CTX = hmac_ctx_st;
pub type MD4_CTX = md4_state_st;
pub type MD5_CTX = md5_state_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pqdsa_key_st {
    _unused: [u8; 0],
}
pub type PQDSA_KEY = pqdsa_key_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ocsp_req_ctx_st {
    _unused: [u8; 0],
}
pub type OCSP_REQ_CTX = ocsp_req_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ossl_init_settings_st {
    _unused: [u8; 0],
}
pub type OPENSSL_INIT_SETTINGS = ossl_init_settings_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pkcs7_digest_st {
    _unused: [u8; 0],
}
pub type PKCS7_DIGEST = pkcs7_digest_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pkcs7_enc_content_st {
    _unused: [u8; 0],
}
pub type PKCS7_ENC_CONTENT = pkcs7_enc_content_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pkcs7_encrypt_st {
    _unused: [u8; 0],
}
pub type PKCS7_ENCRYPT = pkcs7_encrypt_st;
pub type PKCS7_ENVELOPE = pkcs7_envelope_st;
pub type PKCS7_ISSUER_AND_SERIAL = pkcs7_issuer_and_serial_st;
pub type PKCS7_RECIP_INFO = pkcs7_recip_info_st;
pub type PKCS7_SIGN_ENVELOPE = pkcs7_sign_envelope_st;
pub type PKCS7_SIGNED = pkcs7_signed_st;
pub type PKCS7_SIGNER_INFO = pkcs7_signer_info_st;
pub type PKCS7 = pkcs7_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pkcs12_st {
    _unused: [u8; 0],
}
pub type PKCS12 = pkcs12_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct pkcs8_priv_key_info_st {
    _unused: [u8; 0],
}
pub type PKCS8_PRIV_KEY_INFO = pkcs8_priv_key_info_st;
pub type X509_PKEY = private_key_st;
pub type RAND_METHOD = rand_meth_st;
pub type RC4_KEY = rc4_key_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rsa_meth_st {
    _unused: [u8; 0],
}
pub type RSA_METHOD = rsa_meth_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rsassa_pss_params_st {
    _unused: [u8; 0],
}
pub type RSASSA_PSS_PARAMS = rsassa_pss_params_st;
pub type RSA_PSS_PARAMS = rsa_pss_params_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct rsa_st {
    _unused: [u8; 0],
}
pub type RSA = rsa_st;
pub type SHA256_CTX = sha256_state_st;
pub type SHA512_CTX = sha512_state_st;
pub type SHA_CTX = sha_state_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct spake2_ctx_st {
    _unused: [u8; 0],
}
pub type SPAKE2_CTX = spake2_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct srtp_protection_profile_st {
    _unused: [u8; 0],
}
pub type SRTP_PROTECTION_PROFILE = srtp_protection_profile_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_cipher_st {
    _unused: [u8; 0],
}
pub type SSL_CIPHER = ssl_cipher_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_ctx_st {
    _unused: [u8; 0],
}
pub type SSL_CTX = ssl_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_early_callback_ctx {
    _unused: [u8; 0],
}
pub type SSL_CLIENT_HELLO = ssl_early_callback_ctx;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_ech_keys_st {
    _unused: [u8; 0],
}
pub type SSL_ECH_KEYS = ssl_ech_keys_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_method_st {
    _unused: [u8; 0],
}
pub type SSL_METHOD = ssl_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_private_key_method_st {
    _unused: [u8; 0],
}
pub type SSL_PRIVATE_KEY_METHOD = ssl_private_key_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_quic_method_st {
    _unused: [u8; 0],
}
pub type SSL_QUIC_METHOD = ssl_quic_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_session_st {
    _unused: [u8; 0],
}
pub type SSL_SESSION = ssl_session_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_st {
    _unused: [u8; 0],
}
pub type SSL = ssl_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ssl_ticket_aead_method_st {
    _unused: [u8; 0],
}
pub type SSL_TICKET_AEAD_METHOD = ssl_ticket_aead_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_ERR_FNS {
    _unused: [u8; 0],
}
pub type ERR_FNS = st_ERR_FNS;
pub type TRUST_TOKEN = trust_token_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct trust_token_client_st {
    _unused: [u8; 0],
}
pub type TRUST_TOKEN_CLIENT = trust_token_client_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct trust_token_issuer_st {
    _unused: [u8; 0],
}
pub type TRUST_TOKEN_ISSUER = trust_token_issuer_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct trust_token_method_st {
    _unused: [u8; 0],
}
pub type TRUST_TOKEN_METHOD = trust_token_method_st;
pub type X509V3_CTX = v3_ext_ctx;
pub type X509V3_EXT_METHOD = v3_ext_method;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_attributes_st {
    _unused: [u8; 0],
}
pub type X509_ATTRIBUTE = x509_attributes_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_lookup_st {
    _unused: [u8; 0],
}
pub type X509_LOOKUP = x509_lookup_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_lookup_method_st {
    _unused: [u8; 0],
}
pub type X509_LOOKUP_METHOD = x509_lookup_method_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_object_st {
    _unused: [u8; 0],
}
pub type X509_OBJECT = x509_object_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_revoked_st {
    _unused: [u8; 0],
}
pub type X509_REVOKED = x509_revoked_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_st {
    _unused: [u8; 0],
}
pub type X509 = x509_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_store_ctx_st {
    _unused: [u8; 0],
}
pub type X509_STORE_CTX = x509_store_ctx_st;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct x509_store_st {
    _unused: [u8; 0],
}
pub type X509_STORE = x509_store_st;
pub type X509_TRUST = x509_trust_st;
pub type OPENSSL_BLOCK = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct aes_key_st {
    pub rd_key: [u32; 60usize],
    pub rounds: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_aes_key_st() {
    const UNINIT: ::std::mem::MaybeUninit<aes_key_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<aes_key_st>(),
        244usize,
        "Size of aes_key_st"
    );
    assert_eq!(
        ::std::mem::align_of::<aes_key_st>(),
        4usize,
        "Alignment of aes_key_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rd_key) as usize - ptr as usize },
        0usize,
        "Offset of field: aes_key_st::rd_key"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rounds) as usize - ptr as usize },
        240usize,
        "Offset of field: aes_key_st::rounds"
    );
}
impl Default for aes_key_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type AES_KEY = aes_key_st;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_set_encrypt_key"]
    pub fn AES_set_encrypt_key(
        key: *const u8,
        bits: ::std::os::raw::c_uint,
        aeskey: *mut AES_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_set_decrypt_key"]
    pub fn AES_set_decrypt_key(
        key: *const u8,
        bits: ::std::os::raw::c_uint,
        aeskey: *mut AES_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_encrypt"]
    pub fn AES_encrypt(in_: *const u8, out: *mut u8, key: *const AES_KEY);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_decrypt"]
    pub fn AES_decrypt(in_: *const u8, out: *mut u8, key: *const AES_KEY);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_ctr128_encrypt"]
    pub fn AES_ctr128_encrypt(
        in_: *const u8,
        out: *mut u8,
        len: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        ecount_buf: *mut u8,
        num: *mut ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_ecb_encrypt"]
    pub fn AES_ecb_encrypt(
        in_: *const u8,
        out: *mut u8,
        key: *const AES_KEY,
        enc: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_cbc_encrypt"]
    pub fn AES_cbc_encrypt(
        in_: *const u8,
        out: *mut u8,
        len: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        enc: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_ofb128_encrypt"]
    pub fn AES_ofb128_encrypt(
        in_: *const u8,
        out: *mut u8,
        len: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        num: *mut ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_cfb1_encrypt"]
    pub fn AES_cfb1_encrypt(
        in_: *const u8,
        out: *mut u8,
        bits: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        num: *mut ::std::os::raw::c_int,
        enc: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_cfb8_encrypt"]
    pub fn AES_cfb8_encrypt(
        in_: *const u8,
        out: *mut u8,
        len: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        num: *mut ::std::os::raw::c_int,
        enc: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_cfb128_encrypt"]
    pub fn AES_cfb128_encrypt(
        in_: *const u8,
        out: *mut u8,
        len: usize,
        key: *const AES_KEY,
        ivec: *mut u8,
        num: *mut ::std::os::raw::c_int,
        enc: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_wrap_key"]
    pub fn AES_wrap_key(
        key: *const AES_KEY,
        iv: *const u8,
        out: *mut u8,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_unwrap_key"]
    pub fn AES_unwrap_key(
        key: *const AES_KEY,
        iv: *const u8,
        out: *mut u8,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_wrap_key_padded"]
    pub fn AES_wrap_key_padded(
        key: *const AES_KEY,
        out: *mut u8,
        out_len: *mut usize,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_unwrap_key_padded"]
    pub fn AES_unwrap_key_padded(
        key: *const AES_KEY,
        out: *mut u8,
        out_len: *mut usize,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
pub type __gnuc_va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_marker {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_codecvt {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _IO_wide_data {
    _unused: [u8; 0],
}
pub type _IO_lock_t = ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct _IO_FILE {
    pub _flags: ::std::os::raw::c_int,
    pub _IO_read_ptr: *mut ::std::os::raw::c_char,
    pub _IO_read_end: *mut ::std::os::raw::c_char,
    pub _IO_read_base: *mut ::std::os::raw::c_char,
    pub _IO_write_base: *mut ::std::os::raw::c_char,
    pub _IO_write_ptr: *mut ::std::os::raw::c_char,
    pub _IO_write_end: *mut ::std::os::raw::c_char,
    pub _IO_buf_base: *mut ::std::os::raw::c_char,
    pub _IO_buf_end: *mut ::std::os::raw::c_char,
    pub _IO_save_base: *mut ::std::os::raw::c_char,
    pub _IO_backup_base: *mut ::std::os::raw::c_char,
    pub _IO_save_end: *mut ::std::os::raw::c_char,
    pub _markers: *mut _IO_marker,
    pub _chain: *mut _IO_FILE,
    pub _fileno: ::std::os::raw::c_int,
    pub _flags2: ::std::os::raw::c_int,
    pub _old_offset: __off_t,
    pub _cur_column: ::std::os::raw::c_ushort,
    pub _vtable_offset: ::std::os::raw::c_schar,
    pub _shortbuf: [::std::os::raw::c_char; 1usize],
    pub _lock: *mut _IO_lock_t,
    pub _offset: __off64_t,
    pub _codecvt: *mut _IO_codecvt,
    pub _wide_data: *mut _IO_wide_data,
    pub _freeres_list: *mut _IO_FILE,
    pub _freeres_buf: *mut ::std::os::raw::c_void,
    pub __pad5: usize,
    pub _mode: ::std::os::raw::c_int,
    pub _unused2: [::std::os::raw::c_char; 20usize],
}
#[test]
fn bindgen_test_layout__IO_FILE() {
    const UNINIT: ::std::mem::MaybeUninit<_IO_FILE> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<_IO_FILE>(),
        216usize,
        "Size of _IO_FILE"
    );
    assert_eq!(
        ::std::mem::align_of::<_IO_FILE>(),
        8usize,
        "Alignment of _IO_FILE"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags) as usize - ptr as usize },
        0usize,
        "Offset of field: _IO_FILE::_flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_ptr) as usize - ptr as usize },
        8usize,
        "Offset of field: _IO_FILE::_IO_read_ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_end) as usize - ptr as usize },
        16usize,
        "Offset of field: _IO_FILE::_IO_read_end"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_read_base) as usize - ptr as usize },
        24usize,
        "Offset of field: _IO_FILE::_IO_read_base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_base) as usize - ptr as usize },
        32usize,
        "Offset of field: _IO_FILE::_IO_write_base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_ptr) as usize - ptr as usize },
        40usize,
        "Offset of field: _IO_FILE::_IO_write_ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_write_end) as usize - ptr as usize },
        48usize,
        "Offset of field: _IO_FILE::_IO_write_end"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_base) as usize - ptr as usize },
        56usize,
        "Offset of field: _IO_FILE::_IO_buf_base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_buf_end) as usize - ptr as usize },
        64usize,
        "Offset of field: _IO_FILE::_IO_buf_end"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_base) as usize - ptr as usize },
        72usize,
        "Offset of field: _IO_FILE::_IO_save_base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_backup_base) as usize - ptr as usize },
        80usize,
        "Offset of field: _IO_FILE::_IO_backup_base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._IO_save_end) as usize - ptr as usize },
        88usize,
        "Offset of field: _IO_FILE::_IO_save_end"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._markers) as usize - ptr as usize },
        96usize,
        "Offset of field: _IO_FILE::_markers"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._chain) as usize - ptr as usize },
        104usize,
        "Offset of field: _IO_FILE::_chain"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._fileno) as usize - ptr as usize },
        112usize,
        "Offset of field: _IO_FILE::_fileno"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._flags2) as usize - ptr as usize },
        116usize,
        "Offset of field: _IO_FILE::_flags2"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._old_offset) as usize - ptr as usize },
        120usize,
        "Offset of field: _IO_FILE::_old_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._cur_column) as usize - ptr as usize },
        128usize,
        "Offset of field: _IO_FILE::_cur_column"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._vtable_offset) as usize - ptr as usize },
        130usize,
        "Offset of field: _IO_FILE::_vtable_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._shortbuf) as usize - ptr as usize },
        131usize,
        "Offset of field: _IO_FILE::_shortbuf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._lock) as usize - ptr as usize },
        136usize,
        "Offset of field: _IO_FILE::_lock"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._offset) as usize - ptr as usize },
        144usize,
        "Offset of field: _IO_FILE::_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._codecvt) as usize - ptr as usize },
        152usize,
        "Offset of field: _IO_FILE::_codecvt"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._wide_data) as usize - ptr as usize },
        160usize,
        "Offset of field: _IO_FILE::_wide_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_list) as usize - ptr as usize },
        168usize,
        "Offset of field: _IO_FILE::_freeres_list"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._freeres_buf) as usize - ptr as usize },
        176usize,
        "Offset of field: _IO_FILE::_freeres_buf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).__pad5) as usize - ptr as usize },
        184usize,
        "Offset of field: _IO_FILE::__pad5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._mode) as usize - ptr as usize },
        192usize,
        "Offset of field: _IO_FILE::_mode"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr)._unused2) as usize - ptr as usize },
        196usize,
        "Offset of field: _IO_FILE::_unused2"
    );
}
impl Default for _IO_FILE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type va_list = __gnuc_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct buf_mem_st {
    pub length: usize,
    pub data: *mut ::std::os::raw::c_char,
    pub max: usize,
}
#[test]
fn bindgen_test_layout_buf_mem_st() {
    const UNINIT: ::std::mem::MaybeUninit<buf_mem_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<buf_mem_st>(),
        24usize,
        "Size of buf_mem_st"
    );
    assert_eq!(
        ::std::mem::align_of::<buf_mem_st>(),
        8usize,
        "Alignment of buf_mem_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        0usize,
        "Offset of field: buf_mem_st::length"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        "Offset of field: buf_mem_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max) as usize - ptr as usize },
        16usize,
        "Offset of field: buf_mem_st::max"
    );
}
impl Default for buf_mem_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA1_Init"]
    pub fn SHA1_Init(sha: *mut SHA_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA1_Update"]
    pub fn SHA1_Update(
        sha: *mut SHA_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA1_Final"]
    pub fn SHA1_Final(out: *mut u8, sha: *mut SHA_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA1"]
    pub fn SHA1(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA1_Transform"]
    pub fn SHA1_Transform(sha: *mut SHA_CTX, block: *const u8);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sha_state_st {
    pub h: [u32; 5usize],
    pub Nl: u32,
    pub Nh: u32,
    pub data: [u8; 64usize],
    pub num: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_sha_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<sha_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sha_state_st>(),
        96usize,
        "Size of sha_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<sha_state_st>(),
        4usize,
        "Alignment of sha_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: sha_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        20usize,
        "Offset of field: sha_state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        24usize,
        "Offset of field: sha_state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        28usize,
        "Offset of field: sha_state_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        92usize,
        "Offset of field: sha_state_st::num"
    );
}
impl Default for sha_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA224_Init"]
    pub fn SHA224_Init(sha: *mut SHA256_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA224_Update"]
    pub fn SHA224_Update(
        sha: *mut SHA256_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA224_Final"]
    pub fn SHA224_Final(out: *mut u8, sha: *mut SHA256_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA224"]
    pub fn SHA224(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256_Init"]
    pub fn SHA256_Init(sha: *mut SHA256_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256_Update"]
    pub fn SHA256_Update(
        sha: *mut SHA256_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256_Final"]
    pub fn SHA256_Final(out: *mut u8, sha: *mut SHA256_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256"]
    pub fn SHA256(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256_Transform"]
    pub fn SHA256_Transform(sha: *mut SHA256_CTX, block: *const u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA256_TransformBlocks"]
    pub fn SHA256_TransformBlocks(state: *mut u32, data: *const u8, num_blocks: usize);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sha256_state_st {
    pub h: [u32; 8usize],
    pub Nl: u32,
    pub Nh: u32,
    pub data: [u8; 64usize],
    pub num: ::std::os::raw::c_uint,
    pub md_len: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_sha256_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<sha256_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sha256_state_st>(),
        112usize,
        "Size of sha256_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<sha256_state_st>(),
        4usize,
        "Alignment of sha256_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: sha256_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        32usize,
        "Offset of field: sha256_state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        36usize,
        "Offset of field: sha256_state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        40usize,
        "Offset of field: sha256_state_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        104usize,
        "Offset of field: sha256_state_st::num"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_len) as usize - ptr as usize },
        108usize,
        "Offset of field: sha256_state_st::md_len"
    );
}
impl Default for sha256_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA384_Init"]
    pub fn SHA384_Init(sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA384_Update"]
    pub fn SHA384_Update(
        sha: *mut SHA512_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA384_Final"]
    pub fn SHA384_Final(out: *mut u8, sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA384"]
    pub fn SHA384(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_Init"]
    pub fn SHA512_Init(sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_Update"]
    pub fn SHA512_Update(
        sha: *mut SHA512_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_Final"]
    pub fn SHA512_Final(out: *mut u8, sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512"]
    pub fn SHA512(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_Transform"]
    pub fn SHA512_Transform(sha: *mut SHA512_CTX, block: *const u8);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct sha512_state_st {
    pub h: [u64; 8usize],
    pub Nl: u64,
    pub Nh: u64,
    pub p: [u8; 128usize],
    pub num: ::std::os::raw::c_uint,
    pub md_len: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_sha512_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<sha512_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<sha512_state_st>(),
        216usize,
        "Size of sha512_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<sha512_state_st>(),
        8usize,
        "Alignment of sha512_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: sha512_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        64usize,
        "Offset of field: sha512_state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        72usize,
        "Offset of field: sha512_state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).p) as usize - ptr as usize },
        80usize,
        "Offset of field: sha512_state_st::p"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        208usize,
        "Offset of field: sha512_state_st::num"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_len) as usize - ptr as usize },
        212usize,
        "Offset of field: sha512_state_st::md_len"
    );
}
impl Default for sha512_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_224_Init"]
    pub fn SHA512_224_Init(sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_224_Update"]
    pub fn SHA512_224_Update(
        sha: *mut SHA512_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_224_Final"]
    pub fn SHA512_224_Final(out: *mut u8, sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_224"]
    pub fn SHA512_224(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_256_Init"]
    pub fn SHA512_256_Init(sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_256_Update"]
    pub fn SHA512_256_Update(
        sha: *mut SHA512_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_256_Final"]
    pub fn SHA512_256_Final(out: *mut u8, sha: *mut SHA512_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SHA512_256"]
    pub fn SHA512_256(data: *const u8, len: usize, out: *mut u8) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_malloc"]
    pub fn OPENSSL_malloc(size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_zalloc"]
    pub fn OPENSSL_zalloc(size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_calloc"]
    pub fn OPENSSL_calloc(num: usize, size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_realloc"]
    pub fn OPENSSL_realloc(
        ptr: *mut ::std::os::raw::c_void,
        new_size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_free"]
    pub fn OPENSSL_free(ptr: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_cleanse"]
    pub fn OPENSSL_cleanse(ptr: *mut ::std::os::raw::c_void, len: usize);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_memcmp"]
    pub fn CRYPTO_memcmp(
        a: *const ::std::os::raw::c_void,
        b: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_hash32"]
    pub fn OPENSSL_hash32(ptr: *const ::std::os::raw::c_void, len: usize) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strhash"]
    pub fn OPENSSL_strhash(s: *const ::std::os::raw::c_char) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strdup"]
    pub fn OPENSSL_strdup(s: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strnlen"]
    pub fn OPENSSL_strnlen(s: *const ::std::os::raw::c_char, len: usize) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_isalpha"]
    pub fn OPENSSL_isalpha(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_isdigit"]
    pub fn OPENSSL_isdigit(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_isxdigit"]
    pub fn OPENSSL_isxdigit(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_fromxdigit"]
    pub fn OPENSSL_fromxdigit(out: *mut u8, c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_hexstr2buf"]
    pub fn OPENSSL_hexstr2buf(str_: *const ::std::os::raw::c_char, len: *mut usize) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_isalnum"]
    pub fn OPENSSL_isalnum(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_tolower"]
    pub fn OPENSSL_tolower(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_isspace"]
    pub fn OPENSSL_isspace(c: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strcasecmp"]
    pub fn OPENSSL_strcasecmp(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strncasecmp"]
    pub fn OPENSSL_strncasecmp(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
        n: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BIO_snprintf"]
    pub fn BIO_snprintf(
        buf: *mut ::std::os::raw::c_char,
        n: usize,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BIO_vsnprintf"]
    pub fn BIO_vsnprintf(
        buf: *mut ::std::os::raw::c_char,
        n: usize,
        format: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_vasprintf"]
    pub fn OPENSSL_vasprintf(
        str_: *mut *mut ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_asprintf"]
    pub fn OPENSSL_asprintf(
        str_: *mut *mut ::std::os::raw::c_char,
        format: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strndup"]
    pub fn OPENSSL_strndup(
        str_: *const ::std::os::raw::c_char,
        size: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_memdup"]
    pub fn OPENSSL_memdup(
        data: *const ::std::os::raw::c_void,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strlcpy"]
    pub fn OPENSSL_strlcpy(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        dst_size: usize,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_strlcat"]
    pub fn OPENSSL_strlcat(
        dst: *mut ::std::os::raw::c_char,
        src: *const ::std::os::raw::c_char,
        dst_size: usize,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_malloc"]
    pub fn CRYPTO_malloc(
        size: usize,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_realloc"]
    pub fn CRYPTO_realloc(
        ptr: *mut ::std::os::raw::c_void,
        new_size: usize,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_free"]
    pub fn CRYPTO_free(
        ptr: *mut ::std::os::raw::c_void,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_int,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_clear_free"]
    pub fn OPENSSL_clear_free(ptr: *mut ::std::os::raw::c_void, len: usize);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_set_mem_functions"]
    pub fn CRYPTO_set_mem_functions(
        m: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: usize,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void,
        >,
        r: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: usize,
                arg3: *const ::std::os::raw::c_char,
                arg4: ::std::os::raw::c_int,
            ) -> *mut ::std::os::raw::c_void,
        >,
        f: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_int,
            ),
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_secure_malloc_init"]
    pub fn CRYPTO_secure_malloc_init(size: usize, min_size: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_secure_malloc_initialized"]
    pub fn CRYPTO_secure_malloc_initialized() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_secure_used"]
    pub fn CRYPTO_secure_used() -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_secure_malloc"]
    pub fn OPENSSL_secure_malloc(size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_secure_zalloc"]
    pub fn OPENSSL_secure_zalloc(size: usize) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_secure_clear_free"]
    pub fn OPENSSL_secure_clear_free(ptr: *mut ::std::os::raw::c_void, len: usize);
}
pub type CRYPTO_refcount_t = u32;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_library_init"]
    pub fn CRYPTO_library_init();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_is_confidential_build"]
    pub fn CRYPTO_is_confidential_build() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_has_asm"]
    pub fn CRYPTO_has_asm() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BORINGSSL_self_test"]
    pub fn BORINGSSL_self_test() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn BORINGSSL_integrity_test() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_pre_sandbox_init"]
    pub fn CRYPTO_pre_sandbox_init();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_FIPS_mode"]
    pub fn FIPS_mode() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_FIPS_is_entropy_cpu_jitter"]
    pub fn FIPS_is_entropy_cpu_jitter() -> ::std::os::raw::c_int;
}
pub const fips_counter_t_fips_counter_evp_aes_128_gcm: fips_counter_t = 0;
pub const fips_counter_t_fips_counter_evp_aes_256_gcm: fips_counter_t = 1;
pub const fips_counter_t_fips_counter_evp_aes_128_ctr: fips_counter_t = 2;
pub const fips_counter_t_fips_counter_evp_aes_256_ctr: fips_counter_t = 3;
pub const fips_counter_t_fips_counter_max: fips_counter_t = 3;
pub type fips_counter_t = ::std::os::raw::c_uint;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_FIPS_read_counter"]
    pub fn FIPS_read_counter(counter: fips_counter_t) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OpenSSL_version"]
    pub fn OpenSSL_version(which: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SSLeay_version"]
    pub fn SSLeay_version(which: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SSLeay"]
    pub fn SSLeay() -> ::std::os::raw::c_ulong;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OpenSSL_version_num"]
    pub fn OpenSSL_version_num() -> ::std::os::raw::c_ulong;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_awslc_api_version_num"]
    pub fn awslc_api_version_num() -> ::std::os::raw::c_ulong;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_malloc_init"]
    pub fn CRYPTO_malloc_init() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_malloc_init"]
    pub fn OPENSSL_malloc_init() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ENGINE_load_builtin_engines"]
    pub fn ENGINE_load_builtin_engines();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ENGINE_register_all_ciphers"]
    pub fn ENGINE_register_all_ciphers();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ENGINE_register_all_digests"]
    pub fn ENGINE_register_all_digests();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ENGINE_register_all_complete"]
    pub fn ENGINE_register_all_complete() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_load_builtin_modules"]
    pub fn OPENSSL_load_builtin_modules();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_init_crypto"]
    pub fn OPENSSL_init_crypto(
        opts: u64,
        settings: *const OPENSSL_INIT_SETTINGS,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_init"]
    pub fn OPENSSL_init();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_cleanup"]
    pub fn OPENSSL_cleanup();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_FIPS_mode_set"]
    pub fn FIPS_mode_set(on: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_mem_ctrl"]
    pub fn CRYPTO_mem_ctrl(mode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_load_BIO_strings"]
    pub fn ERR_load_BIO_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_load_ERR_strings"]
    pub fn ERR_load_ERR_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_load_CRYPTO_strings"]
    pub fn ERR_load_CRYPTO_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_load_crypto_strings"]
    pub fn ERR_load_crypto_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_load_RAND_strings"]
    pub fn ERR_load_RAND_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_free_strings"]
    pub fn ERR_free_strings();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_get_error"]
    pub fn ERR_get_error() -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_get_error_line"]
    pub fn ERR_get_error_line(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_get_error_line_data"]
    pub fn ERR_get_error_line_data(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
        data: *mut *const ::std::os::raw::c_char,
        flags: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_error"]
    pub fn ERR_peek_error() -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_error_line"]
    pub fn ERR_peek_error_line(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_error_line_data"]
    pub fn ERR_peek_error_line_data(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
        data: *mut *const ::std::os::raw::c_char,
        flags: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_last_error"]
    pub fn ERR_peek_last_error() -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_last_error_line"]
    pub fn ERR_peek_last_error_line(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_peek_last_error_line_data"]
    pub fn ERR_peek_last_error_line_data(
        file: *mut *const ::std::os::raw::c_char,
        line: *mut ::std::os::raw::c_int,
        data: *mut *const ::std::os::raw::c_char,
        flags: *mut ::std::os::raw::c_int,
    ) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_error_string_n"]
    pub fn ERR_error_string_n(
        packed_error: u32,
        buf: *mut ::std::os::raw::c_char,
        len: usize,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_lib_error_string"]
    pub fn ERR_lib_error_string(packed_error: u32) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_reason_error_string"]
    pub fn ERR_reason_error_string(packed_error: u32) -> *const ::std::os::raw::c_char;
}
pub type ERR_print_errors_callback_t = ::std::option::Option<
    unsafe extern "C" fn(
        str_: *const ::std::os::raw::c_char,
        len: usize,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_print_errors_cb"]
    pub fn ERR_print_errors_cb(
        callback: ERR_print_errors_callback_t,
        ctx: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_clear_error"]
    pub fn ERR_clear_error();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_set_mark"]
    pub fn ERR_set_mark() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_pop_to_mark"]
    pub fn ERR_pop_to_mark() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_get_next_error_library"]
    pub fn ERR_get_next_error_library() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_remove_state"]
    pub fn ERR_remove_state(pid: ::std::os::raw::c_ulong);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_remove_thread_state"]
    pub fn ERR_remove_thread_state(tid: *const CRYPTO_THREADID);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_func_error_string"]
    pub fn ERR_func_error_string(packed_error: u32) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_error_string"]
    pub fn ERR_error_string(
        packed_error: u32,
        buf: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_clear_system_error"]
    pub fn ERR_clear_system_error();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_put_error"]
    pub fn ERR_put_error(
        library: ::std::os::raw::c_int,
        unused: ::std::os::raw::c_int,
        reason: ::std::os::raw::c_int,
        file: *const ::std::os::raw::c_char,
        line: ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_add_error_data"]
    pub fn ERR_add_error_data(count: ::std::os::raw::c_uint, ...);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_add_error_dataf"]
    pub fn ERR_add_error_dataf(format: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_set_error_data"]
    pub fn ERR_set_error_data(data: *mut ::std::os::raw::c_char, flags: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_void {
    _unused: [u8; 0],
}
pub type CRYPTO_EX_DATA = crypto_ex_data_st;
pub type CRYPTO_EX_free = ::std::option::Option<
    unsafe extern "C" fn(
        parent: *mut ::std::os::raw::c_void,
        ptr: *mut ::std::os::raw::c_void,
        ad: *mut CRYPTO_EX_DATA,
        index: ::std::os::raw::c_int,
        argl: ::std::os::raw::c_long,
        argp: *mut ::std::os::raw::c_void,
    ),
>;
pub type CRYPTO_EX_dup = ::std::option::Option<
    unsafe extern "C" fn(
        to: *mut CRYPTO_EX_DATA,
        from: *const CRYPTO_EX_DATA,
        from_d: *mut *mut ::std::os::raw::c_void,
        index: ::std::os::raw::c_int,
        argl: ::std::os::raw::c_long,
        argp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
pub type CRYPTO_EX_unused = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct crypto_ex_data_st {
    pub sk: *mut stack_st_void,
}
#[test]
fn bindgen_test_layout_crypto_ex_data_st() {
    const UNINIT: ::std::mem::MaybeUninit<crypto_ex_data_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<crypto_ex_data_st>(),
        8usize,
        "Size of crypto_ex_data_st"
    );
    assert_eq!(
        ::std::mem::align_of::<crypto_ex_data_st>(),
        8usize,
        "Alignment of crypto_ex_data_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sk) as usize - ptr as usize },
        0usize,
        "Offset of field: crypto_ex_data_st::sk"
    );
}
impl Default for crypto_ex_data_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type bio_info_cb = ::std::option::Option<
    unsafe extern "C" fn(
        b: *mut BIO,
        state: ::std::os::raw::c_int,
        res: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long,
>;
pub type BIO_callback_fn_ex = ::std::option::Option<
    unsafe extern "C" fn(
        bio: *mut BIO,
        oper: ::std::os::raw::c_int,
        argp: *const ::std::os::raw::c_char,
        len: usize,
        argi: ::std::os::raw::c_int,
        argl: ::std::os::raw::c_long,
        bio_ret: ::std::os::raw::c_int,
        processed: *mut usize,
    ) -> ::std::os::raw::c_long,
>;
pub type BIO_callback_fn = ::std::option::Option<
    unsafe extern "C" fn(
        bio: *mut BIO,
        oper: ::std::os::raw::c_int,
        argp: *const ::std::os::raw::c_char,
        argi: ::std::os::raw::c_int,
        argl: ::std::os::raw::c_long,
        bio_ret: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_long,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct bio_method_st {
    pub type_: ::std::os::raw::c_int,
    pub name: *const ::std::os::raw::c_char,
    pub bwrite: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: *const ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub bread: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub bputs: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: *const ::std::os::raw::c_char,
        ) -> ::std::os::raw::c_int,
    >,
    pub bgets: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    pub ctrl: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_long,
            arg4: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_long,
    >,
    pub create:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut BIO) -> ::std::os::raw::c_int>,
    pub destroy:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut BIO) -> ::std::os::raw::c_int>,
    pub callback_ctrl: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut BIO,
            arg2: ::std::os::raw::c_int,
            arg3: bio_info_cb,
        ) -> ::std::os::raw::c_long,
    >,
}
#[test]
fn bindgen_test_layout_bio_method_st() {
    const UNINIT: ::std::mem::MaybeUninit<bio_method_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bio_method_st>(),
        80usize,
        "Size of bio_method_st"
    );
    assert_eq!(
        ::std::mem::align_of::<bio_method_st>(),
        8usize,
        "Alignment of bio_method_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: bio_method_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        "Offset of field: bio_method_st::name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bwrite) as usize - ptr as usize },
        16usize,
        "Offset of field: bio_method_st::bwrite"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bread) as usize - ptr as usize },
        24usize,
        "Offset of field: bio_method_st::bread"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bputs) as usize - ptr as usize },
        32usize,
        "Offset of field: bio_method_st::bputs"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bgets) as usize - ptr as usize },
        40usize,
        "Offset of field: bio_method_st::bgets"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ctrl) as usize - ptr as usize },
        48usize,
        "Offset of field: bio_method_st::ctrl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).create) as usize - ptr as usize },
        56usize,
        "Offset of field: bio_method_st::create"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).destroy) as usize - ptr as usize },
        64usize,
        "Offset of field: bio_method_st::destroy"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback_ctrl) as usize - ptr as usize },
        72usize,
        "Offset of field: bio_method_st::callback_ctrl"
    );
}
impl Default for bio_method_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct bio_st {
    pub method: *const BIO_METHOD,
    pub ex_data: CRYPTO_EX_DATA,
    pub callback_ex: BIO_callback_fn_ex,
    pub callback: BIO_callback_fn,
    pub cb_arg: *mut ::std::os::raw::c_char,
    pub init: ::std::os::raw::c_int,
    pub shutdown: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    pub retry_reason: ::std::os::raw::c_int,
    pub num: ::std::os::raw::c_int,
    pub references: CRYPTO_refcount_t,
    pub ptr: *mut ::std::os::raw::c_void,
    pub next_bio: *mut BIO,
    pub num_read: u64,
    pub num_write: u64,
}
#[test]
fn bindgen_test_layout_bio_st() {
    const UNINIT: ::std::mem::MaybeUninit<bio_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(::std::mem::size_of::<bio_st>(), 96usize, "Size of bio_st");
    assert_eq!(
        ::std::mem::align_of::<bio_st>(),
        8usize,
        "Alignment of bio_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).method) as usize - ptr as usize },
        0usize,
        "Offset of field: bio_st::method"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ex_data) as usize - ptr as usize },
        8usize,
        "Offset of field: bio_st::ex_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback_ex) as usize - ptr as usize },
        16usize,
        "Offset of field: bio_st::callback_ex"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        24usize,
        "Offset of field: bio_st::callback"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cb_arg) as usize - ptr as usize },
        32usize,
        "Offset of field: bio_st::cb_arg"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init) as usize - ptr as usize },
        40usize,
        "Offset of field: bio_st::init"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shutdown) as usize - ptr as usize },
        44usize,
        "Offset of field: bio_st::shutdown"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        48usize,
        "Offset of field: bio_st::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).retry_reason) as usize - ptr as usize },
        52usize,
        "Offset of field: bio_st::retry_reason"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        56usize,
        "Offset of field: bio_st::num"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).references) as usize - ptr as usize },
        60usize,
        "Offset of field: bio_st::references"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        64usize,
        "Offset of field: bio_st::ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next_bio) as usize - ptr as usize },
        72usize,
        "Offset of field: bio_st::next_bio"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_read) as usize - ptr as usize },
        80usize,
        "Offset of field: bio_st::num_read"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num_write) as usize - ptr as usize },
        88usize,
        "Offset of field: bio_st::num_write"
    );
}
impl Default for bio_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type BN_ULONG = u64;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_new"]
    pub fn BN_new() -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_init"]
    pub fn BN_init(bn: *mut BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_free"]
    pub fn BN_free(bn: *mut BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_clear_free"]
    pub fn BN_clear_free(bn: *mut BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_dup"]
    pub fn BN_dup(src: *const BIGNUM) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_copy"]
    pub fn BN_copy(dest: *mut BIGNUM, src: *const BIGNUM) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_clear"]
    pub fn BN_clear(bn: *mut BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_value_one"]
    pub fn BN_value_one() -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_num_bits"]
    pub fn BN_num_bits(bn: *const BIGNUM) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_num_bytes"]
    pub fn BN_num_bytes(bn: *const BIGNUM) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_get_minimal_width"]
    pub fn BN_get_minimal_width(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_zero"]
    pub fn BN_zero(bn: *mut BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_one"]
    pub fn BN_one(bn: *mut BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_set_word"]
    pub fn BN_set_word(bn: *mut BIGNUM, value: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_set_u64"]
    pub fn BN_set_u64(bn: *mut BIGNUM, value: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_set_negative"]
    pub fn BN_set_negative(bn: *mut BIGNUM, sign: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_negative"]
    pub fn BN_is_negative(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bin2bn"]
    pub fn BN_bin2bn(in_: *const u8, len: usize, ret: *mut BIGNUM) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2bin"]
    pub fn BN_bn2bin(in_: *const BIGNUM, out: *mut u8) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_le2bn"]
    pub fn BN_le2bn(in_: *const u8, len: usize, ret: *mut BIGNUM) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2le_padded"]
    pub fn BN_bn2le_padded(out: *mut u8, len: usize, in_: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2bin_padded"]
    pub fn BN_bn2bin_padded(out: *mut u8, len: usize, in_: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2cbb_padded"]
    pub fn BN_bn2cbb_padded(out: *mut CBB, len: usize, in_: *const BIGNUM)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2hex"]
    pub fn BN_bn2hex(bn: *const BIGNUM) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_hex2bn"]
    pub fn BN_hex2bn(
        outp: *mut *mut BIGNUM,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2dec"]
    pub fn BN_bn2dec(a: *const BIGNUM) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_dec2bn"]
    pub fn BN_dec2bn(
        outp: *mut *mut BIGNUM,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_asc2bn"]
    pub fn BN_asc2bn(
        outp: *mut *mut BIGNUM,
        in_: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_print"]
    pub fn BN_print(bio: *mut BIO, a: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_get_word"]
    pub fn BN_get_word(bn: *const BIGNUM) -> BN_ULONG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_get_u64"]
    pub fn BN_get_u64(bn: *const BIGNUM, out: *mut u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_get_flags"]
    pub fn BN_get_flags(bn: *const BIGNUM, flags: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_parse_asn1_unsigned"]
    pub fn BN_parse_asn1_unsigned(cbs: *mut CBS, ret: *mut BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_marshal_asn1"]
    pub fn BN_marshal_asn1(cbb: *mut CBB, bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_new"]
    pub fn BN_CTX_new() -> *mut BN_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_free"]
    pub fn BN_CTX_free(ctx: *mut BN_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_start"]
    pub fn BN_CTX_start(ctx: *mut BN_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_get"]
    pub fn BN_CTX_get(ctx: *mut BN_CTX) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_end"]
    pub fn BN_CTX_end(ctx: *mut BN_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_add"]
    pub fn BN_add(r: *mut BIGNUM, a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_uadd"]
    pub fn BN_uadd(r: *mut BIGNUM, a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_add_word"]
    pub fn BN_add_word(a: *mut BIGNUM, w: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_sub"]
    pub fn BN_sub(r: *mut BIGNUM, a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_usub"]
    pub fn BN_usub(r: *mut BIGNUM, a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_sub_word"]
    pub fn BN_sub_word(a: *mut BIGNUM, w: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mul"]
    pub fn BN_mul(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mul_word"]
    pub fn BN_mul_word(bn: *mut BIGNUM, w: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_sqr"]
    pub fn BN_sqr(r: *mut BIGNUM, a: *const BIGNUM, ctx: *mut BN_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_div"]
    pub fn BN_div(
        quotient: *mut BIGNUM,
        rem: *mut BIGNUM,
        numerator: *const BIGNUM,
        divisor: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_div_word"]
    pub fn BN_div_word(numerator: *mut BIGNUM, divisor: BN_ULONG) -> BN_ULONG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_sqrt"]
    pub fn BN_sqrt(
        out_sqrt: *mut BIGNUM,
        in_: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_cmp"]
    pub fn BN_cmp(a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_cmp_word"]
    pub fn BN_cmp_word(a: *const BIGNUM, b: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_ucmp"]
    pub fn BN_ucmp(a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_equal_consttime"]
    pub fn BN_equal_consttime(a: *const BIGNUM, b: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_abs_is_word"]
    pub fn BN_abs_is_word(bn: *const BIGNUM, w: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_zero"]
    pub fn BN_is_zero(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_one"]
    pub fn BN_is_one(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_word"]
    pub fn BN_is_word(bn: *const BIGNUM, w: BN_ULONG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_odd"]
    pub fn BN_is_odd(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_pow2"]
    pub fn BN_is_pow2(a: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_lshift"]
    pub fn BN_lshift(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_lshift1"]
    pub fn BN_lshift1(r: *mut BIGNUM, a: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_rshift"]
    pub fn BN_rshift(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_rshift1"]
    pub fn BN_rshift1(r: *mut BIGNUM, a: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_set_bit"]
    pub fn BN_set_bit(a: *mut BIGNUM, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_clear_bit"]
    pub fn BN_clear_bit(a: *mut BIGNUM, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_bit_set"]
    pub fn BN_is_bit_set(a: *const BIGNUM, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mask_bits"]
    pub fn BN_mask_bits(a: *mut BIGNUM, n: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_count_low_zero_bits"]
    pub fn BN_count_low_zero_bits(bn: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_word"]
    pub fn BN_mod_word(a: *const BIGNUM, w: BN_ULONG) -> BN_ULONG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_pow2"]
    pub fn BN_mod_pow2(r: *mut BIGNUM, a: *const BIGNUM, e: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_nnmod_pow2"]
    pub fn BN_nnmod_pow2(r: *mut BIGNUM, a: *const BIGNUM, e: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_nnmod"]
    pub fn BN_nnmod(
        rem: *mut BIGNUM,
        numerator: *const BIGNUM,
        divisor: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_add"]
    pub fn BN_mod_add(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_add_quick"]
    pub fn BN_mod_add_quick(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        m: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_sub"]
    pub fn BN_mod_sub(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_sub_quick"]
    pub fn BN_mod_sub_quick(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        m: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_mul"]
    pub fn BN_mod_mul(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_sqr"]
    pub fn BN_mod_sqr(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_lshift"]
    pub fn BN_mod_lshift(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        n: ::std::os::raw::c_int,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_lshift_quick"]
    pub fn BN_mod_lshift_quick(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        n: ::std::os::raw::c_int,
        m: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_lshift1"]
    pub fn BN_mod_lshift1(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_lshift1_quick"]
    pub fn BN_mod_lshift1_quick(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        m: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_sqrt"]
    pub fn BN_mod_sqrt(
        in_: *mut BIGNUM,
        a: *const BIGNUM,
        p: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_rand"]
    pub fn BN_rand(
        rnd: *mut BIGNUM,
        bits: ::std::os::raw::c_int,
        top: ::std::os::raw::c_int,
        bottom: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_pseudo_rand"]
    pub fn BN_pseudo_rand(
        rnd: *mut BIGNUM,
        bits: ::std::os::raw::c_int,
        top: ::std::os::raw::c_int,
        bottom: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_rand_range"]
    pub fn BN_rand_range(rnd: *mut BIGNUM, range: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_rand_range_ex"]
    pub fn BN_rand_range_ex(
        r: *mut BIGNUM,
        min_inclusive: BN_ULONG,
        max_exclusive: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_pseudo_rand_range"]
    pub fn BN_pseudo_rand_range(rnd: *mut BIGNUM, range: *const BIGNUM) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct bn_gencb_st {
    pub type_: u8,
    pub arg: *mut ::std::os::raw::c_void,
    pub callback: bn_gencb_st__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union bn_gencb_st__bindgen_ty_1 {
    pub new_style: ::std::option::Option<
        unsafe extern "C" fn(
            event: ::std::os::raw::c_int,
            n: ::std::os::raw::c_int,
            arg1: *mut bn_gencb_st,
        ) -> ::std::os::raw::c_int,
    >,
    pub old_style: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_bn_gencb_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<bn_gencb_st__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bn_gencb_st__bindgen_ty_1>(),
        8usize,
        "Size of bn_gencb_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<bn_gencb_st__bindgen_ty_1>(),
        8usize,
        "Alignment of bn_gencb_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).new_style) as usize - ptr as usize },
        0usize,
        "Offset of field: bn_gencb_st__bindgen_ty_1::new_style"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).old_style) as usize - ptr as usize },
        0usize,
        "Offset of field: bn_gencb_st__bindgen_ty_1::old_style"
    );
}
impl Default for bn_gencb_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_bn_gencb_st() {
    const UNINIT: ::std::mem::MaybeUninit<bn_gencb_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bn_gencb_st>(),
        24usize,
        "Size of bn_gencb_st"
    );
    assert_eq!(
        ::std::mem::align_of::<bn_gencb_st>(),
        8usize,
        "Alignment of bn_gencb_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: bn_gencb_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arg) as usize - ptr as usize },
        8usize,
        "Offset of field: bn_gencb_st::arg"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).callback) as usize - ptr as usize },
        16usize,
        "Offset of field: bn_gencb_st::callback"
    );
}
impl Default for bn_gencb_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_new"]
    pub fn BN_GENCB_new() -> *mut BN_GENCB;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_free"]
    pub fn BN_GENCB_free(callback: *mut BN_GENCB);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_set"]
    pub fn BN_GENCB_set(
        callback: *mut BN_GENCB,
        f: ::std::option::Option<
            unsafe extern "C" fn(
                event: ::std::os::raw::c_int,
                n: ::std::os::raw::c_int,
                arg1: *mut BN_GENCB,
            ) -> ::std::os::raw::c_int,
        >,
        arg: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_call"]
    pub fn BN_GENCB_call(
        callback: *mut BN_GENCB,
        event: ::std::os::raw::c_int,
        n: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_get_arg"]
    pub fn BN_GENCB_get_arg(callback: *const BN_GENCB) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_generate_prime_ex"]
    pub fn BN_generate_prime_ex(
        ret: *mut BIGNUM,
        bits: ::std::os::raw::c_int,
        safe: ::std::os::raw::c_int,
        add: *const BIGNUM,
        rem: *const BIGNUM,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
pub const bn_primality_result_t_bn_probably_prime: bn_primality_result_t = 0;
pub const bn_primality_result_t_bn_composite: bn_primality_result_t = 1;
pub const bn_primality_result_t_bn_non_prime_power_composite: bn_primality_result_t = 2;
pub type bn_primality_result_t = ::std::os::raw::c_uint;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_enhanced_miller_rabin_primality_test"]
    pub fn BN_enhanced_miller_rabin_primality_test(
        out_result: *mut bn_primality_result_t,
        w: *const BIGNUM,
        checks: ::std::os::raw::c_int,
        ctx: *mut BN_CTX,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_primality_test"]
    pub fn BN_primality_test(
        is_probably_prime: *mut ::std::os::raw::c_int,
        candidate: *const BIGNUM,
        checks: ::std::os::raw::c_int,
        ctx: *mut BN_CTX,
        do_trial_division: ::std::os::raw::c_int,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_prime_fasttest_ex"]
    pub fn BN_is_prime_fasttest_ex(
        candidate: *const BIGNUM,
        checks: ::std::os::raw::c_int,
        ctx: *mut BN_CTX,
        do_trial_division: ::std::os::raw::c_int,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_is_prime_ex"]
    pub fn BN_is_prime_ex(
        candidate: *const BIGNUM,
        checks: ::std::os::raw::c_int,
        ctx: *mut BN_CTX,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_gcd"]
    pub fn BN_gcd(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_inverse"]
    pub fn BN_mod_inverse(
        out: *mut BIGNUM,
        a: *const BIGNUM,
        n: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_inverse_blinded"]
    pub fn BN_mod_inverse_blinded(
        out: *mut BIGNUM,
        out_no_inverse: *mut ::std::os::raw::c_int,
        a: *const BIGNUM,
        mont: *const BN_MONT_CTX,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_inverse_odd"]
    pub fn BN_mod_inverse_odd(
        out: *mut BIGNUM,
        out_no_inverse: *mut ::std::os::raw::c_int,
        a: *const BIGNUM,
        n: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_new_for_modulus"]
    pub fn BN_MONT_CTX_new_for_modulus(mod_: *const BIGNUM, ctx: *mut BN_CTX) -> *mut BN_MONT_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_new_consttime"]
    pub fn BN_MONT_CTX_new_consttime(mod_: *const BIGNUM, ctx: *mut BN_CTX) -> *mut BN_MONT_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_free"]
    pub fn BN_MONT_CTX_free(mont: *mut BN_MONT_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_copy"]
    pub fn BN_MONT_CTX_copy(to: *mut BN_MONT_CTX, from: *const BN_MONT_CTX) -> *mut BN_MONT_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_to_montgomery"]
    pub fn BN_to_montgomery(
        ret: *mut BIGNUM,
        a: *const BIGNUM,
        mont: *const BN_MONT_CTX,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_from_montgomery"]
    pub fn BN_from_montgomery(
        ret: *mut BIGNUM,
        a: *const BIGNUM,
        mont: *const BN_MONT_CTX,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_mul_montgomery"]
    pub fn BN_mod_mul_montgomery(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        mont: *const BN_MONT_CTX,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_exp"]
    pub fn BN_exp(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        p: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp"]
    pub fn BN_mod_exp(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        p: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp_mont"]
    pub fn BN_mod_exp_mont(
        r: *mut BIGNUM,
        a: *const BIGNUM,
        p: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
        mont: *const BN_MONT_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp_mont_consttime"]
    pub fn BN_mod_exp_mont_consttime(
        rr: *mut BIGNUM,
        a: *const BIGNUM,
        p: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
        mont: *const BN_MONT_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_GENCB_set_old"]
    pub fn BN_GENCB_set_old(
        callback: *mut BN_GENCB,
        f: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: ::std::os::raw::c_int,
                arg2: ::std::os::raw::c_int,
                arg3: *mut ::std::os::raw::c_void,
            ),
        >,
        cb_arg: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2mpi"]
    pub fn BN_bn2mpi(in_: *const BIGNUM, out: *mut u8) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mpi2bn"]
    pub fn BN_mpi2bn(in_: *const u8, len: usize, out: *mut BIGNUM) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp_mont_word"]
    pub fn BN_mod_exp_mont_word(
        r: *mut BIGNUM,
        a: BN_ULONG,
        p: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
        mont: *const BN_MONT_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp2_mont"]
    pub fn BN_mod_exp2_mont(
        r: *mut BIGNUM,
        a1: *const BIGNUM,
        p1: *const BIGNUM,
        a2: *const BIGNUM,
        p2: *const BIGNUM,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
        mont: *const BN_MONT_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_new"]
    pub fn BN_MONT_CTX_new() -> *mut BN_MONT_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_MONT_CTX_set"]
    pub fn BN_MONT_CTX_set(
        mont: *mut BN_MONT_CTX,
        mod_: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_bn2binpad"]
    pub fn BN_bn2binpad(
        in_: *const BIGNUM,
        out: *mut u8,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_secure_new"]
    pub fn BN_secure_new() -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_CTX_secure_new"]
    pub fn BN_CTX_secure_new() -> *mut BN_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_mod_exp_mont_consttime_x2"]
    pub fn BN_mod_exp_mont_consttime_x2(
        rr1: *mut BIGNUM,
        a1: *const BIGNUM,
        p1: *const BIGNUM,
        m1: *const BIGNUM,
        in_mont1: *const BN_MONT_CTX,
        rr2: *mut BIGNUM,
        a2: *const BIGNUM,
        p2: *const BIGNUM,
        m2: *const BIGNUM,
        in_mont2: *const BN_MONT_CTX,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_set_flags"]
    pub fn BN_set_flags(b: *mut BIGNUM, n: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct bignum_st {
    pub d: *mut BN_ULONG,
    pub width: ::std::os::raw::c_int,
    pub dmax: ::std::os::raw::c_int,
    pub neg: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_bignum_st() {
    const UNINIT: ::std::mem::MaybeUninit<bignum_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bignum_st>(),
        24usize,
        "Size of bignum_st"
    );
    assert_eq!(
        ::std::mem::align_of::<bignum_st>(),
        8usize,
        "Alignment of bignum_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        0usize,
        "Offset of field: bignum_st::d"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).width) as usize - ptr as usize },
        8usize,
        "Offset of field: bignum_st::width"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dmax) as usize - ptr as usize },
        12usize,
        "Offset of field: bignum_st::dmax"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).neg) as usize - ptr as usize },
        16usize,
        "Offset of field: bignum_st::neg"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        20usize,
        "Offset of field: bignum_st::flags"
    );
}
impl Default for bignum_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct bn_mont_ctx_st {
    pub RR: BIGNUM,
    pub N: BIGNUM,
    pub n0: [BN_ULONG; 2usize],
}
#[test]
fn bindgen_test_layout_bn_mont_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<bn_mont_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<bn_mont_ctx_st>(),
        64usize,
        "Size of bn_mont_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<bn_mont_ctx_st>(),
        8usize,
        "Alignment of bn_mont_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).RR) as usize - ptr as usize },
        0usize,
        "Offset of field: bn_mont_ctx_st::RR"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).N) as usize - ptr as usize },
        24usize,
        "Offset of field: bn_mont_ctx_st::N"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).n0) as usize - ptr as usize },
        48usize,
        "Offset of field: bn_mont_ctx_st::n0"
    );
}
impl Default for bn_mont_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_BN_num_bits_word"]
    pub fn BN_num_bits_word(l: BN_ULONG) -> ::std::os::raw::c_uint;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ASN1_VALUE_st {
    _unused: [u8; 0],
}
pub type ASN1_VALUE = ASN1_VALUE_st;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct asn1_string_st {
    pub length: ::std::os::raw::c_int,
    pub type_: ::std::os::raw::c_int,
    pub data: *mut ::std::os::raw::c_uchar,
    pub flags: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_asn1_string_st() {
    const UNINIT: ::std::mem::MaybeUninit<asn1_string_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<asn1_string_st>(),
        24usize,
        "Size of asn1_string_st"
    );
    assert_eq!(
        ::std::mem::align_of::<asn1_string_st>(),
        8usize,
        "Alignment of asn1_string_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_string_st::length"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        4usize,
        "Offset of field: asn1_string_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        "Offset of field: asn1_string_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        16usize,
        "Offset of field: asn1_string_st::flags"
    );
}
impl Default for asn1_string_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct asn1_type_st {
    pub type_: ::std::os::raw::c_int,
    pub value: asn1_type_st__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union asn1_type_st__bindgen_ty_1 {
    pub ptr: *mut ::std::os::raw::c_char,
    pub boolean: ASN1_BOOLEAN,
    pub asn1_string: *mut ASN1_STRING,
    pub object: *mut ASN1_OBJECT,
    pub integer: *mut ASN1_INTEGER,
    pub enumerated: *mut ASN1_ENUMERATED,
    pub bit_string: *mut ASN1_BIT_STRING,
    pub octet_string: *mut ASN1_OCTET_STRING,
    pub printablestring: *mut ASN1_PRINTABLESTRING,
    pub t61string: *mut ASN1_T61STRING,
    pub ia5string: *mut ASN1_IA5STRING,
    pub generalstring: *mut ASN1_GENERALSTRING,
    pub bmpstring: *mut ASN1_BMPSTRING,
    pub universalstring: *mut ASN1_UNIVERSALSTRING,
    pub utctime: *mut ASN1_UTCTIME,
    pub generalizedtime: *mut ASN1_GENERALIZEDTIME,
    pub visiblestring: *mut ASN1_VISIBLESTRING,
    pub utf8string: *mut ASN1_UTF8STRING,
    pub set: *mut ASN1_STRING,
    pub sequence: *mut ASN1_STRING,
    pub asn1_value: *mut ASN1_VALUE,
}
#[test]
fn bindgen_test_layout_asn1_type_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<asn1_type_st__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<asn1_type_st__bindgen_ty_1>(),
        8usize,
        "Size of asn1_type_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<asn1_type_st__bindgen_ty_1>(),
        8usize,
        "Alignment of asn1_type_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).boolean) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::boolean"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).asn1_string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::asn1_string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).object) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::object"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).integer) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::integer"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enumerated) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::enumerated"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bit_string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::bit_string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).octet_string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::octet_string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).printablestring) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::printablestring"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).t61string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::t61string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ia5string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::ia5string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).generalstring) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::generalstring"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bmpstring) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::bmpstring"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).universalstring) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::universalstring"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).utctime) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::utctime"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).generalizedtime) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::generalizedtime"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).visiblestring) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::visiblestring"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).utf8string) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::utf8string"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).set) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::set"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sequence) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::sequence"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).asn1_value) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st__bindgen_ty_1::asn1_value"
    );
}
impl Default for asn1_type_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_asn1_type_st() {
    const UNINIT: ::std::mem::MaybeUninit<asn1_type_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<asn1_type_st>(),
        16usize,
        "Size of asn1_type_st"
    );
    assert_eq!(
        ::std::mem::align_of::<asn1_type_st>(),
        8usize,
        "Alignment of asn1_type_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: asn1_type_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        8usize,
        "Offset of field: asn1_type_st::value"
    );
}
impl Default for asn1_type_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ASN1_TEMPLATE = ASN1_TEMPLATE_st;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct ASN1_TEMPLATE_st {
    pub flags: u32,
    pub tag: ::std::os::raw::c_int,
    pub offset: ::std::os::raw::c_ulong,
    pub field_name: *const ::std::os::raw::c_char,
    pub item: *const ASN1_ITEM_st,
}
#[test]
fn bindgen_test_layout_ASN1_TEMPLATE_st() {
    const UNINIT: ::std::mem::MaybeUninit<ASN1_TEMPLATE_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ASN1_TEMPLATE_st>(),
        32usize,
        "Size of ASN1_TEMPLATE_st"
    );
    assert_eq!(
        ::std::mem::align_of::<ASN1_TEMPLATE_st>(),
        8usize,
        "Alignment of ASN1_TEMPLATE_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        "Offset of field: ASN1_TEMPLATE_st::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag) as usize - ptr as usize },
        4usize,
        "Offset of field: ASN1_TEMPLATE_st::tag"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        "Offset of field: ASN1_TEMPLATE_st::offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_name) as usize - ptr as usize },
        16usize,
        "Offset of field: ASN1_TEMPLATE_st::field_name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).item) as usize - ptr as usize },
        24usize,
        "Offset of field: ASN1_TEMPLATE_st::item"
    );
}
impl Default for ASN1_TEMPLATE_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct ASN1_ITEM_st {
    pub itype: ::std::os::raw::c_char,
    pub utype: ::std::os::raw::c_int,
    pub templates: *const ASN1_TEMPLATE,
    pub tcount: ::std::os::raw::c_long,
    pub funcs: *const ::std::os::raw::c_void,
    pub size: ::std::os::raw::c_long,
    pub sname: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_ASN1_ITEM_st() {
    const UNINIT: ::std::mem::MaybeUninit<ASN1_ITEM_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ASN1_ITEM_st>(),
        48usize,
        "Size of ASN1_ITEM_st"
    );
    assert_eq!(
        ::std::mem::align_of::<ASN1_ITEM_st>(),
        8usize,
        "Alignment of ASN1_ITEM_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).itype) as usize - ptr as usize },
        0usize,
        "Offset of field: ASN1_ITEM_st::itype"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).utype) as usize - ptr as usize },
        4usize,
        "Offset of field: ASN1_ITEM_st::utype"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).templates) as usize - ptr as usize },
        8usize,
        "Offset of field: ASN1_ITEM_st::templates"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tcount) as usize - ptr as usize },
        16usize,
        "Offset of field: ASN1_ITEM_st::tcount"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).funcs) as usize - ptr as usize },
        24usize,
        "Offset of field: ASN1_ITEM_st::funcs"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        32usize,
        "Offset of field: ASN1_ITEM_st::size"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sname) as usize - ptr as usize },
        40usize,
        "Offset of field: ASN1_ITEM_st::sname"
    );
}
impl Default for ASN1_ITEM_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct evp_encode_ctx_st {
    pub data_used: ::std::os::raw::c_uint,
    pub data: [u8; 48usize],
    pub eof_seen: ::std::os::raw::c_char,
    pub error_encountered: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_evp_encode_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_encode_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_encode_ctx_st>(),
        56usize,
        "Size of evp_encode_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_encode_ctx_st>(),
        4usize,
        "Alignment of evp_encode_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_used) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_encode_ctx_st::data_used"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        4usize,
        "Offset of field: evp_encode_ctx_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eof_seen) as usize - ptr as usize },
        52usize,
        "Offset of field: evp_encode_ctx_st::eof_seen"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_encountered) as usize - ptr as usize },
        53usize,
        "Offset of field: evp_encode_ctx_st::error_encountered"
    );
}
impl Default for evp_encode_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct blake2b_state_st {
    pub h: [u64; 8usize],
    pub t_low: u64,
    pub t_high: u64,
    pub block: [u8; 128usize],
    pub block_used: usize,
}
#[test]
fn bindgen_test_layout_blake2b_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<blake2b_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<blake2b_state_st>(),
        216usize,
        "Size of blake2b_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<blake2b_state_st>(),
        8usize,
        "Alignment of blake2b_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: blake2b_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).t_low) as usize - ptr as usize },
        64usize,
        "Offset of field: blake2b_state_st::t_low"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).t_high) as usize - ptr as usize },
        72usize,
        "Offset of field: blake2b_state_st::t_high"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block) as usize - ptr as usize },
        80usize,
        "Offset of field: blake2b_state_st::block"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).block_used) as usize - ptr as usize },
        208usize,
        "Offset of field: blake2b_state_st::block_used"
    );
}
impl Default for blake2b_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct cbs_st {
    pub data: *const u8,
    pub len: usize,
}
#[test]
fn bindgen_test_layout_cbs_st() {
    const UNINIT: ::std::mem::MaybeUninit<cbs_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(::std::mem::size_of::<cbs_st>(), 16usize, "Size of cbs_st");
    assert_eq!(
        ::std::mem::align_of::<cbs_st>(),
        8usize,
        "Alignment of cbs_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        "Offset of field: cbs_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        "Offset of field: cbs_st::len"
    );
}
impl Default for cbs_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_init"]
    pub fn CBS_init(cbs: *mut CBS, data: *const u8, len: usize);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_skip"]
    pub fn CBS_skip(cbs: *mut CBS, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_data"]
    pub fn CBS_data(cbs: *const CBS) -> *const u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_len"]
    pub fn CBS_len(cbs: *const CBS) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_stow"]
    pub fn CBS_stow(
        cbs: *const CBS,
        out_ptr: *mut *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_strdup"]
    pub fn CBS_strdup(
        cbs: *const CBS,
        out_ptr: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_contains_zero_byte"]
    pub fn CBS_contains_zero_byte(cbs: *const CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_mem_equal"]
    pub fn CBS_mem_equal(cbs: *const CBS, data: *const u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u8"]
    pub fn CBS_get_u8(cbs: *mut CBS, out: *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u16"]
    pub fn CBS_get_u16(cbs: *mut CBS, out: *mut u16) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u16le"]
    pub fn CBS_get_u16le(cbs: *mut CBS, out: *mut u16) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u24"]
    pub fn CBS_get_u24(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u32"]
    pub fn CBS_get_u32(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u32le"]
    pub fn CBS_get_u32le(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u64"]
    pub fn CBS_get_u64(cbs: *mut CBS, out: *mut u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u64le"]
    pub fn CBS_get_u64le(cbs: *mut CBS, out: *mut u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_last_u8"]
    pub fn CBS_get_last_u8(cbs: *mut CBS, out: *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_bytes"]
    pub fn CBS_get_bytes(cbs: *mut CBS, out: *mut CBS, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_copy_bytes"]
    pub fn CBS_copy_bytes(cbs: *mut CBS, out: *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u8_length_prefixed"]
    pub fn CBS_get_u8_length_prefixed(cbs: *mut CBS, out: *mut CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u16_length_prefixed"]
    pub fn CBS_get_u16_length_prefixed(cbs: *mut CBS, out: *mut CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u24_length_prefixed"]
    pub fn CBS_get_u24_length_prefixed(cbs: *mut CBS, out: *mut CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_until_first"]
    pub fn CBS_get_until_first(cbs: *mut CBS, out: *mut CBS, c: u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_u64_decimal"]
    pub fn CBS_get_u64_decimal(cbs: *mut CBS, out: *mut u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_asn1"]
    pub fn CBS_get_asn1(
        cbs: *mut CBS,
        out: *mut CBS,
        tag_value: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_asn1_element"]
    pub fn CBS_get_asn1_element(
        cbs: *mut CBS,
        out: *mut CBS,
        tag_value: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_peek_asn1_tag"]
    pub fn CBS_peek_asn1_tag(cbs: *const CBS, tag_value: CBS_ASN1_TAG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_any_asn1"]
    pub fn CBS_get_any_asn1(
        cbs: *mut CBS,
        out: *mut CBS,
        out_tag: *mut CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_any_asn1_element"]
    pub fn CBS_get_any_asn1_element(
        cbs: *mut CBS,
        out: *mut CBS,
        out_tag: *mut CBS_ASN1_TAG,
        out_header_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_any_ber_asn1_element"]
    pub fn CBS_get_any_ber_asn1_element(
        cbs: *mut CBS,
        out: *mut CBS,
        out_tag: *mut CBS_ASN1_TAG,
        out_header_len: *mut usize,
        out_ber_found: *mut ::std::os::raw::c_int,
        out_indefinite: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_asn1_uint64"]
    pub fn CBS_get_asn1_uint64(cbs: *mut CBS, out: *mut u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_asn1_int64"]
    pub fn CBS_get_asn1_int64(cbs: *mut CBS, out: *mut i64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_asn1_bool"]
    pub fn CBS_get_asn1_bool(
        cbs: *mut CBS,
        out: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_optional_asn1"]
    pub fn CBS_get_optional_asn1(
        cbs: *mut CBS,
        out: *mut CBS,
        out_present: *mut ::std::os::raw::c_int,
        tag: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_optional_asn1_octet_string"]
    pub fn CBS_get_optional_asn1_octet_string(
        cbs: *mut CBS,
        out: *mut CBS,
        out_present: *mut ::std::os::raw::c_int,
        tag: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_optional_asn1_uint64"]
    pub fn CBS_get_optional_asn1_uint64(
        cbs: *mut CBS,
        out: *mut u64,
        tag: CBS_ASN1_TAG,
        default_value: u64,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_optional_asn1_bool"]
    pub fn CBS_get_optional_asn1_bool(
        cbs: *mut CBS,
        out: *mut ::std::os::raw::c_int,
        tag: CBS_ASN1_TAG,
        default_value: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_is_valid_asn1_bitstring"]
    pub fn CBS_is_valid_asn1_bitstring(cbs: *const CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_asn1_bitstring_has_bit"]
    pub fn CBS_asn1_bitstring_has_bit(
        cbs: *const CBS,
        bit: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_is_valid_asn1_integer"]
    pub fn CBS_is_valid_asn1_integer(
        cbs: *const CBS,
        out_is_negative: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_is_unsigned_asn1_integer"]
    pub fn CBS_is_unsigned_asn1_integer(cbs: *const CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_is_valid_asn1_oid"]
    pub fn CBS_is_valid_asn1_oid(cbs: *const CBS) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_asn1_oid_to_text"]
    pub fn CBS_asn1_oid_to_text(cbs: *const CBS) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBS_get_optional_asn1_int64"]
    pub fn CBS_get_optional_asn1_int64(
        cbs: *mut CBS,
        out: *mut i64,
        tag: CBS_ASN1_TAG,
        default_value: i64,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct cbb_buffer_st {
    pub buf: *mut u8,
    pub len: usize,
    pub cap: usize,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u8; 7usize],
}
#[test]
fn bindgen_test_layout_cbb_buffer_st() {
    const UNINIT: ::std::mem::MaybeUninit<cbb_buffer_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cbb_buffer_st>(),
        32usize,
        "Size of cbb_buffer_st"
    );
    assert_eq!(
        ::std::mem::align_of::<cbb_buffer_st>(),
        8usize,
        "Alignment of cbb_buffer_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        0usize,
        "Offset of field: cbb_buffer_st::buf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        "Offset of field: cbb_buffer_st::len"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cap) as usize - ptr as usize },
        16usize,
        "Offset of field: cbb_buffer_st::cap"
    );
}
impl Default for cbb_buffer_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl cbb_buffer_st {
    #[inline]
    pub fn can_resize(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_can_resize(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn can_resize_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_can_resize_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn error(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_error(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn error_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_error_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        can_resize: ::std::os::raw::c_uint,
        error: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let can_resize: u32 = unsafe { ::std::mem::transmute(can_resize) };
            can_resize as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let error: u32 = unsafe { ::std::mem::transmute(error) };
            error as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct cbb_child_st {
    pub base: *mut cbb_buffer_st,
    pub offset: usize,
    pub pending_len_len: u8,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub __bindgen_padding_0: [u16; 3usize],
}
#[test]
fn bindgen_test_layout_cbb_child_st() {
    const UNINIT: ::std::mem::MaybeUninit<cbb_child_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cbb_child_st>(),
        24usize,
        "Size of cbb_child_st"
    );
    assert_eq!(
        ::std::mem::align_of::<cbb_child_st>(),
        8usize,
        "Alignment of cbb_child_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        "Offset of field: cbb_child_st::base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        8usize,
        "Offset of field: cbb_child_st::offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pending_len_len) as usize - ptr as usize },
        16usize,
        "Offset of field: cbb_child_st::pending_len_len"
    );
}
impl Default for cbb_child_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
impl cbb_child_st {
    #[inline]
    pub fn pending_is_asn1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_pending_is_asn1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn pending_is_asn1_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_pending_is_asn1_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        pending_is_asn1: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let pending_is_asn1: u32 = unsafe { ::std::mem::transmute(pending_is_asn1) };
            pending_is_asn1 as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct cbb_st {
    pub child: *mut CBB,
    pub is_child: ::std::os::raw::c_char,
    pub u: cbb_st__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union cbb_st__bindgen_ty_1 {
    pub base: cbb_buffer_st,
    pub child: cbb_child_st,
}
#[test]
fn bindgen_test_layout_cbb_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<cbb_st__bindgen_ty_1> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<cbb_st__bindgen_ty_1>(),
        32usize,
        "Size of cbb_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<cbb_st__bindgen_ty_1>(),
        8usize,
        "Alignment of cbb_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base) as usize - ptr as usize },
        0usize,
        "Offset of field: cbb_st__bindgen_ty_1::base"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child) as usize - ptr as usize },
        0usize,
        "Offset of field: cbb_st__bindgen_ty_1::child"
    );
}
impl Default for cbb_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_cbb_st() {
    const UNINIT: ::std::mem::MaybeUninit<cbb_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(::std::mem::size_of::<cbb_st>(), 48usize, "Size of cbb_st");
    assert_eq!(
        ::std::mem::align_of::<cbb_st>(),
        8usize,
        "Alignment of cbb_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).child) as usize - ptr as usize },
        0usize,
        "Offset of field: cbb_st::child"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_child) as usize - ptr as usize },
        8usize,
        "Offset of field: cbb_st::is_child"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        16usize,
        "Offset of field: cbb_st::u"
    );
}
impl Default for cbb_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_zero"]
    pub fn CBB_zero(cbb: *mut CBB);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_init"]
    pub fn CBB_init(cbb: *mut CBB, initial_capacity: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_init_fixed"]
    pub fn CBB_init_fixed(cbb: *mut CBB, buf: *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_cleanup"]
    pub fn CBB_cleanup(cbb: *mut CBB);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_finish"]
    pub fn CBB_finish(
        cbb: *mut CBB,
        out_data: *mut *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_flush"]
    pub fn CBB_flush(cbb: *mut CBB) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_data"]
    pub fn CBB_data(cbb: *const CBB) -> *const u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_len"]
    pub fn CBB_len(cbb: *const CBB) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u8_length_prefixed"]
    pub fn CBB_add_u8_length_prefixed(
        cbb: *mut CBB,
        out_contents: *mut CBB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u16_length_prefixed"]
    pub fn CBB_add_u16_length_prefixed(
        cbb: *mut CBB,
        out_contents: *mut CBB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u24_length_prefixed"]
    pub fn CBB_add_u24_length_prefixed(
        cbb: *mut CBB,
        out_contents: *mut CBB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1"]
    pub fn CBB_add_asn1(
        cbb: *mut CBB,
        out_contents: *mut CBB,
        tag: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_bytes"]
    pub fn CBB_add_bytes(cbb: *mut CBB, data: *const u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_zeros"]
    pub fn CBB_add_zeros(cbb: *mut CBB, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_space"]
    pub fn CBB_add_space(
        cbb: *mut CBB,
        out_data: *mut *mut u8,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_reserve"]
    pub fn CBB_reserve(cbb: *mut CBB, out_data: *mut *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_did_write"]
    pub fn CBB_did_write(cbb: *mut CBB, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u8"]
    pub fn CBB_add_u8(cbb: *mut CBB, value: u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u16"]
    pub fn CBB_add_u16(cbb: *mut CBB, value: u16) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u16le"]
    pub fn CBB_add_u16le(cbb: *mut CBB, value: u16) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u24"]
    pub fn CBB_add_u24(cbb: *mut CBB, value: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u32"]
    pub fn CBB_add_u32(cbb: *mut CBB, value: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u32le"]
    pub fn CBB_add_u32le(cbb: *mut CBB, value: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u64"]
    pub fn CBB_add_u64(cbb: *mut CBB, value: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_u64le"]
    pub fn CBB_add_u64le(cbb: *mut CBB, value: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_discard_child"]
    pub fn CBB_discard_child(cbb: *mut CBB);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_uint64"]
    pub fn CBB_add_asn1_uint64(cbb: *mut CBB, value: u64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_uint64_with_tag"]
    pub fn CBB_add_asn1_uint64_with_tag(
        cbb: *mut CBB,
        value: u64,
        tag: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_int64"]
    pub fn CBB_add_asn1_int64(cbb: *mut CBB, value: i64) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_int64_with_tag"]
    pub fn CBB_add_asn1_int64_with_tag(
        cbb: *mut CBB,
        value: i64,
        tag: CBS_ASN1_TAG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_octet_string"]
    pub fn CBB_add_asn1_octet_string(
        cbb: *mut CBB,
        data: *const u8,
        data_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_bool"]
    pub fn CBB_add_asn1_bool(cbb: *mut CBB, value: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_add_asn1_oid_from_text"]
    pub fn CBB_add_asn1_oid_from_text(
        cbb: *mut CBB,
        text: *const ::std::os::raw::c_char,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CBB_flush_asn1_set_of"]
    pub fn CBB_flush_asn1_set_of(cbb: *mut CBB) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBS_get_utf8(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBS_get_latin1(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBS_get_ucs2_be(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBS_get_utf32_be(cbs: *mut CBS, out: *mut u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBB_get_utf8_len(u: u32) -> usize;
}
extern "C" {
    pub fn CBB_add_utf8(cbb: *mut CBB, u: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBB_add_latin1(cbb: *mut CBB, u: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBB_add_ucs2_be(cbb: *mut CBB, u: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn CBB_add_utf32_be(cbb: *mut CBB, u: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_chacha_20"]
    pub fn CRYPTO_chacha_20(
        out: *mut u8,
        in_: *const u8,
        in_len: usize,
        key: *const u8,
        nonce: *const u8,
        counter: u32,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_rc4"]
    pub fn EVP_rc4() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_cbc"]
    pub fn EVP_des_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ecb"]
    pub fn EVP_des_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ede"]
    pub fn EVP_des_ede() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ede3"]
    pub fn EVP_des_ede3() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ede_cbc"]
    pub fn EVP_des_ede_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ede3_cbc"]
    pub fn EVP_des_ede3_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_ecb"]
    pub fn EVP_aes_128_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cbc"]
    pub fn EVP_aes_128_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_ctr"]
    pub fn EVP_aes_128_ctr() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_ofb"]
    pub fn EVP_aes_128_ofb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_ecb"]
    pub fn EVP_aes_256_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cbc"]
    pub fn EVP_aes_256_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_ctr"]
    pub fn EVP_aes_256_ctr() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_ofb"]
    pub fn EVP_aes_256_ofb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_xts"]
    pub fn EVP_aes_256_xts() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_wrap"]
    pub fn EVP_aes_256_wrap() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_enc_null"]
    pub fn EVP_enc_null() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_rc2_cbc"]
    pub fn EVP_rc2_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_rc2_40_cbc"]
    pub fn EVP_rc2_40_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_chacha20_poly1305"]
    pub fn EVP_chacha20_poly1305() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_cipherbynid"]
    pub fn EVP_get_cipherbynid(nid: ::std::os::raw::c_int) -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_init"]
    pub fn EVP_CIPHER_CTX_init(ctx: *mut EVP_CIPHER_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_new"]
    pub fn EVP_CIPHER_CTX_new() -> *mut EVP_CIPHER_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_cleanup"]
    pub fn EVP_CIPHER_CTX_cleanup(ctx: *mut EVP_CIPHER_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_free"]
    pub fn EVP_CIPHER_CTX_free(ctx: *mut EVP_CIPHER_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_copy"]
    pub fn EVP_CIPHER_CTX_copy(
        out: *mut EVP_CIPHER_CTX,
        in_: *const EVP_CIPHER_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_reset"]
    pub fn EVP_CIPHER_CTX_reset(ctx: *mut EVP_CIPHER_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CipherInit_ex"]
    pub fn EVP_CipherInit_ex(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        engine: *mut ENGINE,
        key: *const u8,
        iv: *const u8,
        enc: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_EncryptInit_ex"]
    pub fn EVP_EncryptInit_ex(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        impl_: *mut ENGINE,
        key: *const u8,
        iv: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DecryptInit_ex"]
    pub fn EVP_DecryptInit_ex(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        impl_: *mut ENGINE,
        key: *const u8,
        iv: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_EncryptUpdate"]
    pub fn EVP_EncryptUpdate(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
        in_: *const u8,
        in_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_EncryptFinal_ex"]
    pub fn EVP_EncryptFinal_ex(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DecryptUpdate"]
    pub fn EVP_DecryptUpdate(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
        in_: *const u8,
        in_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DecryptFinal_ex"]
    pub fn EVP_DecryptFinal_ex(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CipherUpdate"]
    pub fn EVP_CipherUpdate(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
        in_: *const u8,
        in_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CipherFinal_ex"]
    pub fn EVP_CipherFinal_ex(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_cipher"]
    pub fn EVP_CIPHER_CTX_cipher(ctx: *const EVP_CIPHER_CTX) -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_nid"]
    pub fn EVP_CIPHER_CTX_nid(ctx: *const EVP_CIPHER_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_encrypting"]
    pub fn EVP_CIPHER_CTX_encrypting(ctx: *const EVP_CIPHER_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_block_size"]
    pub fn EVP_CIPHER_CTX_block_size(ctx: *const EVP_CIPHER_CTX) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_key_length"]
    pub fn EVP_CIPHER_CTX_key_length(ctx: *const EVP_CIPHER_CTX) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_iv_length"]
    pub fn EVP_CIPHER_CTX_iv_length(ctx: *const EVP_CIPHER_CTX) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_get_app_data"]
    pub fn EVP_CIPHER_CTX_get_app_data(ctx: *const EVP_CIPHER_CTX) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_set_app_data"]
    pub fn EVP_CIPHER_CTX_set_app_data(ctx: *mut EVP_CIPHER_CTX, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_flags"]
    pub fn EVP_CIPHER_CTX_flags(ctx: *const EVP_CIPHER_CTX) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_mode"]
    pub fn EVP_CIPHER_CTX_mode(ctx: *const EVP_CIPHER_CTX) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_ctrl"]
    pub fn EVP_CIPHER_CTX_ctrl(
        ctx: *mut EVP_CIPHER_CTX,
        command: ::std::os::raw::c_int,
        arg: ::std::os::raw::c_int,
        ptr: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_set_padding"]
    pub fn EVP_CIPHER_CTX_set_padding(
        ctx: *mut EVP_CIPHER_CTX,
        pad: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_set_key_length"]
    pub fn EVP_CIPHER_CTX_set_key_length(
        ctx: *mut EVP_CIPHER_CTX,
        key_len: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_nid"]
    pub fn EVP_CIPHER_nid(cipher: *const EVP_CIPHER) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_name"]
    pub fn EVP_CIPHER_name(cipher: *const EVP_CIPHER) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_block_size"]
    pub fn EVP_CIPHER_block_size(cipher: *const EVP_CIPHER) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_key_length"]
    pub fn EVP_CIPHER_key_length(cipher: *const EVP_CIPHER) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_iv_length"]
    pub fn EVP_CIPHER_iv_length(cipher: *const EVP_CIPHER) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_flags"]
    pub fn EVP_CIPHER_flags(cipher: *const EVP_CIPHER) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_mode"]
    pub fn EVP_CIPHER_mode(cipher: *const EVP_CIPHER) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_BytesToKey"]
    pub fn EVP_BytesToKey(
        type_: *const EVP_CIPHER,
        md: *const EVP_MD,
        salt: *const u8,
        data: *const u8,
        data_len: usize,
        count: ::std::os::raw::c_uint,
        key: *mut u8,
        iv: *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cbc_hmac_sha1"]
    pub fn EVP_aes_128_cbc_hmac_sha1() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cbc_hmac_sha1"]
    pub fn EVP_aes_256_cbc_hmac_sha1() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cbc_hmac_sha256"]
    pub fn EVP_aes_128_cbc_hmac_sha256() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cbc_hmac_sha256"]
    pub fn EVP_aes_256_cbc_hmac_sha256() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CipherInit"]
    pub fn EVP_CipherInit(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        key: *const u8,
        iv: *const u8,
        enc: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_EncryptInit"]
    pub fn EVP_EncryptInit(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        key: *const u8,
        iv: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DecryptInit"]
    pub fn EVP_DecryptInit(
        ctx: *mut EVP_CIPHER_CTX,
        cipher: *const EVP_CIPHER,
        key: *const u8,
        iv: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CipherFinal"]
    pub fn EVP_CipherFinal(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_EncryptFinal"]
    pub fn EVP_EncryptFinal(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DecryptFinal"]
    pub fn EVP_DecryptFinal(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_Cipher"]
    pub fn EVP_Cipher(
        ctx: *mut EVP_CIPHER_CTX,
        out: *mut u8,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_cipherbyname"]
    pub fn EVP_get_cipherbyname(name: *const ::std::os::raw::c_char) -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_gcm"]
    pub fn EVP_aes_128_gcm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_gcm"]
    pub fn EVP_aes_256_gcm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_ccm"]
    pub fn EVP_aes_128_ccm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_ccm"]
    pub fn EVP_aes_192_ccm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_ccm"]
    pub fn EVP_aes_256_ccm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_ecb"]
    pub fn EVP_aes_192_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_cbc"]
    pub fn EVP_aes_192_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_ctr"]
    pub fn EVP_aes_192_ctr() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_gcm"]
    pub fn EVP_aes_192_gcm() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_ofb"]
    pub fn EVP_aes_192_ofb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_des_ede3_ecb"]
    pub fn EVP_des_ede3_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cfb128"]
    pub fn EVP_aes_128_cfb128() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cfb"]
    pub fn EVP_aes_128_cfb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cfb1"]
    pub fn EVP_aes_128_cfb1() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_128_cfb8"]
    pub fn EVP_aes_128_cfb8() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_cfb128"]
    pub fn EVP_aes_192_cfb128() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_cfb"]
    pub fn EVP_aes_192_cfb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_cfb1"]
    pub fn EVP_aes_192_cfb1() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_192_cfb8"]
    pub fn EVP_aes_192_cfb8() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cfb128"]
    pub fn EVP_aes_256_cfb128() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cfb"]
    pub fn EVP_aes_256_cfb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cfb1"]
    pub fn EVP_aes_256_cfb1() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aes_256_cfb8"]
    pub fn EVP_aes_256_cfb8() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_bf_ecb"]
    pub fn EVP_bf_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_bf_cbc"]
    pub fn EVP_bf_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_bf_cfb"]
    pub fn EVP_bf_cfb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_cast5_ecb"]
    pub fn EVP_cast5_ecb() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_cast5_cbc"]
    pub fn EVP_cast5_cbc() -> *const EVP_CIPHER;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_CTX_set_flags"]
    pub fn EVP_CIPHER_CTX_set_flags(ctx: *const EVP_CIPHER_CTX, flags: u32);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_add_cipher_alias"]
    pub fn EVP_add_cipher_alias(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct evp_cipher_ctx_st {
    pub cipher: *const EVP_CIPHER,
    pub app_data: *mut ::std::os::raw::c_void,
    pub cipher_data: *mut ::std::os::raw::c_void,
    pub key_len: ::std::os::raw::c_uint,
    pub encrypt: ::std::os::raw::c_int,
    pub flags: u32,
    pub oiv: [u8; 16usize],
    pub iv: [u8; 16usize],
    pub buf: [u8; 32usize],
    pub buf_len: ::std::os::raw::c_int,
    pub num: ::std::os::raw::c_uint,
    pub final_used: ::std::os::raw::c_int,
    pub final_: [u8; 32usize],
    pub poisoned: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_evp_cipher_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_cipher_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_cipher_ctx_st>(),
        152usize,
        "Size of evp_cipher_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_cipher_ctx_st>(),
        8usize,
        "Alignment of evp_cipher_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cipher) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_cipher_ctx_st::cipher"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).app_data) as usize - ptr as usize },
        8usize,
        "Offset of field: evp_cipher_ctx_st::app_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cipher_data) as usize - ptr as usize },
        16usize,
        "Offset of field: evp_cipher_ctx_st::cipher_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_len) as usize - ptr as usize },
        24usize,
        "Offset of field: evp_cipher_ctx_st::key_len"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).encrypt) as usize - ptr as usize },
        28usize,
        "Offset of field: evp_cipher_ctx_st::encrypt"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        32usize,
        "Offset of field: evp_cipher_ctx_st::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).oiv) as usize - ptr as usize },
        36usize,
        "Offset of field: evp_cipher_ctx_st::oiv"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iv) as usize - ptr as usize },
        52usize,
        "Offset of field: evp_cipher_ctx_st::iv"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf) as usize - ptr as usize },
        68usize,
        "Offset of field: evp_cipher_ctx_st::buf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_len) as usize - ptr as usize },
        100usize,
        "Offset of field: evp_cipher_ctx_st::buf_len"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        104usize,
        "Offset of field: evp_cipher_ctx_st::num"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).final_used) as usize - ptr as usize },
        108usize,
        "Offset of field: evp_cipher_ctx_st::final_used"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).final_) as usize - ptr as usize },
        112usize,
        "Offset of field: evp_cipher_ctx_st::final_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).poisoned) as usize - ptr as usize },
        144usize,
        "Offset of field: evp_cipher_ctx_st::poisoned"
    );
}
impl Default for evp_cipher_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct evp_cipher_info_st {
    pub cipher: *const EVP_CIPHER,
    pub iv: [::std::os::raw::c_uchar; 16usize],
}
#[test]
fn bindgen_test_layout_evp_cipher_info_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_cipher_info_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_cipher_info_st>(),
        24usize,
        "Size of evp_cipher_info_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_cipher_info_st>(),
        8usize,
        "Alignment of evp_cipher_info_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cipher) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_cipher_info_st::cipher"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iv) as usize - ptr as usize },
        8usize,
        "Offset of field: evp_cipher_info_st::iv"
    );
}
impl Default for evp_cipher_info_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EVP_CIPHER_INFO = evp_cipher_info_st;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_AES_CMAC"]
    pub fn AES_CMAC(
        out: *mut u8,
        key: *const u8,
        key_len: usize,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_CTX_new"]
    pub fn CMAC_CTX_new() -> *mut CMAC_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_CTX_free"]
    pub fn CMAC_CTX_free(ctx: *mut CMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_CTX_copy"]
    pub fn CMAC_CTX_copy(out: *mut CMAC_CTX, in_: *const CMAC_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_Init"]
    pub fn CMAC_Init(
        ctx: *mut CMAC_CTX,
        key: *const ::std::os::raw::c_void,
        key_len: usize,
        cipher: *const EVP_CIPHER,
        engine: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_Reset"]
    pub fn CMAC_Reset(ctx: *mut CMAC_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_Update"]
    pub fn CMAC_Update(ctx: *mut CMAC_CTX, in_: *const u8, in_len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_Final"]
    pub fn CMAC_Final(
        ctx: *mut CMAC_CTX,
        out: *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CMAC_CTX_get0_cipher_ctx"]
    pub fn CMAC_CTX_get0_cipher_ctx(ctx: *mut CMAC_CTX) -> *mut EVP_CIPHER_CTX;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct conf_value_st {
    pub section: *mut ::std::os::raw::c_char,
    pub name: *mut ::std::os::raw::c_char,
    pub value: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_conf_value_st() {
    const UNINIT: ::std::mem::MaybeUninit<conf_value_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<conf_value_st>(),
        24usize,
        "Size of conf_value_st"
    );
    assert_eq!(
        ::std::mem::align_of::<conf_value_st>(),
        8usize,
        "Alignment of conf_value_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).section) as usize - ptr as usize },
        0usize,
        "Offset of field: conf_value_st::section"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        "Offset of field: conf_value_st::name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        16usize,
        "Offset of field: conf_value_st::value"
    );
}
impl Default for conf_value_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_CONF_VALUE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct lhash_st_CONF_VALUE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct conf_st {
    pub data: *mut lhash_st_CONF_VALUE,
}
#[test]
fn bindgen_test_layout_conf_st() {
    const UNINIT: ::std::mem::MaybeUninit<conf_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(::std::mem::size_of::<conf_st>(), 8usize, "Size of conf_st");
    assert_eq!(
        ::std::mem::align_of::<conf_st>(),
        8usize,
        "Alignment of conf_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        "Offset of field: conf_st::data"
    );
}
impl Default for conf_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_X25519_keypair"]
    pub fn X25519_keypair(out_public_value: *mut u8, out_private_key: *mut u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_X25519"]
    pub fn X25519(
        out_shared_key: *mut u8,
        private_key: *const u8,
        peer_public_value: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_X25519_public_from_private"]
    pub fn X25519_public_from_private(out_public_value: *mut u8, private_key: *const u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519_keypair"]
    pub fn ED25519_keypair(out_public_key: *mut u8, out_private_key: *mut u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519_sign"]
    pub fn ED25519_sign(
        out_sig: *mut u8,
        message: *const u8,
        message_len: usize,
        private_key: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519_verify"]
    pub fn ED25519_verify(
        message: *const u8,
        message_len: usize,
        signature: *const u8,
        public_key: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ctx_sign"]
    pub fn ED25519ctx_sign(
        out_sig: *mut u8,
        message: *const u8,
        message_len: usize,
        private_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ctx_verify"]
    pub fn ED25519ctx_verify(
        message: *const u8,
        message_len: usize,
        signature: *const u8,
        public_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ph_sign"]
    pub fn ED25519ph_sign(
        out_sig: *mut u8,
        message: *const u8,
        message_len: usize,
        private_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ph_verify"]
    pub fn ED25519ph_verify(
        message: *const u8,
        message_len: usize,
        signature: *const u8,
        public_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ph_sign_digest"]
    pub fn ED25519ph_sign_digest(
        out_sig: *mut u8,
        digest: *const u8,
        private_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519ph_verify_digest"]
    pub fn ED25519ph_verify_digest(
        digest: *const u8,
        signature: *const u8,
        public_key: *const u8,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ED25519_keypair_from_seed"]
    pub fn ED25519_keypair_from_seed(
        out_public_key: *mut u8,
        out_private_key: *mut u8,
        seed: *const u8,
    );
}
pub const spake2_role_t_spake2_role_alice: spake2_role_t = 0;
pub const spake2_role_t_spake2_role_bob: spake2_role_t = 1;
pub type spake2_role_t = ::std::os::raw::c_uint;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SPAKE2_CTX_new"]
    pub fn SPAKE2_CTX_new(
        my_role: spake2_role_t,
        my_name: *const u8,
        my_name_len: usize,
        their_name: *const u8,
        their_name_len: usize,
    ) -> *mut SPAKE2_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SPAKE2_CTX_free"]
    pub fn SPAKE2_CTX_free(ctx: *mut SPAKE2_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SPAKE2_generate_msg"]
    pub fn SPAKE2_generate_msg(
        ctx: *mut SPAKE2_CTX,
        out: *mut u8,
        out_len: *mut usize,
        max_out_len: usize,
        password: *const u8,
        password_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SPAKE2_process_msg"]
    pub fn SPAKE2_process_msg(
        ctx: *mut SPAKE2_CTX,
        out_key: *mut u8,
        out_key_len: *mut usize,
        max_out_key_len: usize,
        their_msg: *const u8,
        their_msg_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_md4"]
    pub fn EVP_md4() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_md5"]
    pub fn EVP_md5() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_ripemd160"]
    pub fn EVP_ripemd160() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha1"]
    pub fn EVP_sha1() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha224"]
    pub fn EVP_sha224() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha256"]
    pub fn EVP_sha256() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha384"]
    pub fn EVP_sha384() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha512"]
    pub fn EVP_sha512() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha512_224"]
    pub fn EVP_sha512_224() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha512_256"]
    pub fn EVP_sha512_256() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha3_224"]
    pub fn EVP_sha3_224() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha3_256"]
    pub fn EVP_sha3_256() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha3_384"]
    pub fn EVP_sha3_384() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_sha3_512"]
    pub fn EVP_sha3_512() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_shake128"]
    pub fn EVP_shake128() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_shake256"]
    pub fn EVP_shake256() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_blake2b256"]
    pub fn EVP_blake2b256() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_md5_sha1"]
    pub fn EVP_md5_sha1() -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_digestbynid"]
    pub fn EVP_get_digestbynid(nid: ::std::os::raw::c_int) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_digestbyobj"]
    pub fn EVP_get_digestbyobj(obj: *const ASN1_OBJECT) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_init"]
    pub fn EVP_MD_CTX_init(ctx: *mut EVP_MD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_new"]
    pub fn EVP_MD_CTX_new() -> *mut EVP_MD_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_cleanup"]
    pub fn EVP_MD_CTX_cleanup(ctx: *mut EVP_MD_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_cleanse"]
    pub fn EVP_MD_CTX_cleanse(ctx: *mut EVP_MD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_free"]
    pub fn EVP_MD_CTX_free(ctx: *mut EVP_MD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_copy_ex"]
    pub fn EVP_MD_CTX_copy_ex(
        out: *mut EVP_MD_CTX,
        in_: *const EVP_MD_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_move"]
    pub fn EVP_MD_CTX_move(out: *mut EVP_MD_CTX, in_: *mut EVP_MD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_reset"]
    pub fn EVP_MD_CTX_reset(ctx: *mut EVP_MD_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestInit_ex"]
    pub fn EVP_DigestInit_ex(
        ctx: *mut EVP_MD_CTX,
        type_: *const EVP_MD,
        engine: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestInit"]
    pub fn EVP_DigestInit(ctx: *mut EVP_MD_CTX, type_: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestUpdate"]
    pub fn EVP_DigestUpdate(
        ctx: *mut EVP_MD_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestFinal_ex"]
    pub fn EVP_DigestFinal_ex(
        ctx: *mut EVP_MD_CTX,
        md_out: *mut u8,
        out_size: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestFinal"]
    pub fn EVP_DigestFinal(
        ctx: *mut EVP_MD_CTX,
        md_out: *mut u8,
        out_size: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_Digest"]
    pub fn EVP_Digest(
        data: *const ::std::os::raw::c_void,
        len: usize,
        md_out: *mut u8,
        out_size: *mut ::std::os::raw::c_uint,
        type_: *const EVP_MD,
        impl_: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_type"]
    pub fn EVP_MD_type(md: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_flags"]
    pub fn EVP_MD_flags(md: *const EVP_MD) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_size"]
    pub fn EVP_MD_size(md: *const EVP_MD) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_block_size"]
    pub fn EVP_MD_block_size(md: *const EVP_MD) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_md"]
    pub fn EVP_MD_CTX_md(ctx: *const EVP_MD_CTX) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_size"]
    pub fn EVP_MD_CTX_size(ctx: *const EVP_MD_CTX) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_block_size"]
    pub fn EVP_MD_CTX_block_size(ctx: *const EVP_MD_CTX) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_type"]
    pub fn EVP_MD_CTX_type(ctx: *const EVP_MD_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_parse_digest_algorithm"]
    pub fn EVP_parse_digest_algorithm(cbs: *mut CBS) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_marshal_digest_algorithm"]
    pub fn EVP_marshal_digest_algorithm(cbb: *mut CBB, md: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_copy"]
    pub fn EVP_MD_CTX_copy(out: *mut EVP_MD_CTX, in_: *const EVP_MD_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_digestbyname"]
    pub fn EVP_get_digestbyname(arg1: *const ::std::os::raw::c_char) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_create"]
    pub fn EVP_MD_CTX_create() -> *mut EVP_MD_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_destroy"]
    pub fn EVP_MD_CTX_destroy(ctx: *mut EVP_MD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestFinalXOF"]
    pub fn EVP_DigestFinalXOF(
        ctx: *mut EVP_MD_CTX,
        out: *mut u8,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestSqueeze"]
    pub fn EVP_DigestSqueeze(
        ctx: *mut EVP_MD_CTX,
        out: *mut u8,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_meth_get_flags"]
    pub fn EVP_MD_meth_get_flags(md: *const EVP_MD) -> u32;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_nid"]
    pub fn EVP_MD_nid(md: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_set_pkey_ctx"]
    pub fn EVP_MD_CTX_set_pkey_ctx(ctx: *mut EVP_MD_CTX, pctx: *mut EVP_PKEY_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_get_pkey_ctx"]
    pub fn EVP_MD_CTX_get_pkey_ctx(ctx: *const EVP_MD_CTX) -> *mut EVP_PKEY_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_pkey_ctx"]
    pub fn EVP_MD_CTX_pkey_ctx(ctx: *const EVP_MD_CTX) -> *mut EVP_PKEY_CTX;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct evp_md_pctx_ops {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct env_md_ctx_st {
    pub digest: *const EVP_MD,
    pub md_data: *mut ::std::os::raw::c_void,
    pub update: ::std::option::Option<
        unsafe extern "C" fn(
            ctx: *mut EVP_MD_CTX,
            data: *const ::std::os::raw::c_void,
            count: usize,
        ) -> ::std::os::raw::c_int,
    >,
    pub pctx: *mut EVP_PKEY_CTX,
    pub pctx_ops: *const evp_md_pctx_ops,
    pub flags: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_env_md_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<env_md_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<env_md_ctx_st>(),
        48usize,
        "Size of env_md_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<env_md_ctx_st>(),
        8usize,
        "Alignment of env_md_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digest) as usize - ptr as usize },
        0usize,
        "Offset of field: env_md_ctx_st::digest"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_data) as usize - ptr as usize },
        8usize,
        "Offset of field: env_md_ctx_st::md_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).update) as usize - ptr as usize },
        16usize,
        "Offset of field: env_md_ctx_st::update"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pctx) as usize - ptr as usize },
        24usize,
        "Offset of field: env_md_ctx_st::pctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pctx_ops) as usize - ptr as usize },
        32usize,
        "Offset of field: env_md_ctx_st::pctx_ops"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        40usize,
        "Offset of field: env_md_ctx_st::flags"
    );
}
impl Default for env_md_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_unstable_sha3_enable"]
    pub fn EVP_MD_unstable_sha3_enable(enable: bool);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_unstable_sha3_is_enabled"]
    pub fn EVP_MD_unstable_sha3_is_enabled() -> bool;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_CTX_set_flags"]
    pub fn EVP_MD_CTX_set_flags(ctx: *mut EVP_MD_CTX, flags: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_add_digest"]
    pub fn EVP_add_digest(digest: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_md_null"]
    pub fn EVP_md_null() -> *const EVP_MD;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct DSA_SIG_st {
    pub r: *mut BIGNUM,
    pub s: *mut BIGNUM,
}
#[test]
fn bindgen_test_layout_DSA_SIG_st() {
    const UNINIT: ::std::mem::MaybeUninit<DSA_SIG_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DSA_SIG_st>(),
        16usize,
        "Size of DSA_SIG_st"
    );
    assert_eq!(
        ::std::mem::align_of::<DSA_SIG_st>(),
        8usize,
        "Alignment of DSA_SIG_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r) as usize - ptr as usize },
        0usize,
        "Offset of field: DSA_SIG_st::r"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s) as usize - ptr as usize },
        8usize,
        "Offset of field: DSA_SIG_st::s"
    );
}
impl Default for DSA_SIG_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum point_conversion_form_t {
    POINT_CONVERSION_COMPRESSED = 2,
    POINT_CONVERSION_UNCOMPRESSED = 4,
    POINT_CONVERSION_HYBRID = 6,
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_group_p224"]
    pub fn EC_group_p224() -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_group_p256"]
    pub fn EC_group_p256() -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_group_p384"]
    pub fn EC_group_p384() -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_group_p521"]
    pub fn EC_group_p521() -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_group_secp256k1"]
    pub fn EC_group_secp256k1() -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_new_by_curve_name"]
    pub fn EC_GROUP_new_by_curve_name(nid: ::std::os::raw::c_int) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_new_by_curve_name_mutable"]
    pub fn EC_GROUP_new_by_curve_name_mutable(nid: ::std::os::raw::c_int) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_cmp"]
    pub fn EC_GROUP_cmp(
        a: *const EC_GROUP,
        b: *const EC_GROUP,
        ignored: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get0_generator"]
    pub fn EC_GROUP_get0_generator(group: *const EC_GROUP) -> *const EC_POINT;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get0_order"]
    pub fn EC_GROUP_get0_order(group: *const EC_GROUP) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_order_bits"]
    pub fn EC_GROUP_order_bits(group: *const EC_GROUP) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_cofactor"]
    pub fn EC_GROUP_get_cofactor(
        group: *const EC_GROUP,
        cofactor: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_curve_GFp"]
    pub fn EC_GROUP_get_curve_GFp(
        group: *const EC_GROUP,
        out_p: *mut BIGNUM,
        out_a: *mut BIGNUM,
        out_b: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_curve_name"]
    pub fn EC_GROUP_get_curve_name(group: *const EC_GROUP) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_degree"]
    pub fn EC_GROUP_get_degree(group: *const EC_GROUP) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_curve_nid2nist"]
    pub fn EC_curve_nid2nist(nid: ::std::os::raw::c_int) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_curve_nist2nid"]
    pub fn EC_curve_nist2nid(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_new"]
    pub fn EC_POINT_new(group: *const EC_GROUP) -> *mut EC_POINT;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_free"]
    pub fn EC_POINT_free(point: *mut EC_POINT);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_copy"]
    pub fn EC_POINT_copy(dest: *mut EC_POINT, src: *const EC_POINT) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_dup"]
    pub fn EC_POINT_dup(src: *const EC_POINT, group: *const EC_GROUP) -> *mut EC_POINT;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_set_to_infinity"]
    pub fn EC_POINT_set_to_infinity(
        group: *const EC_GROUP,
        point: *mut EC_POINT,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_is_at_infinity"]
    pub fn EC_POINT_is_at_infinity(
        group: *const EC_GROUP,
        point: *const EC_POINT,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_is_on_curve"]
    pub fn EC_POINT_is_on_curve(
        group: *const EC_GROUP,
        point: *const EC_POINT,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_cmp"]
    pub fn EC_POINT_cmp(
        group: *const EC_GROUP,
        a: *const EC_POINT,
        b: *const EC_POINT,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_get_affine_coordinates_GFp"]
    pub fn EC_POINT_get_affine_coordinates_GFp(
        group: *const EC_GROUP,
        point: *const EC_POINT,
        x: *mut BIGNUM,
        y: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_get_affine_coordinates"]
    pub fn EC_POINT_get_affine_coordinates(
        group: *const EC_GROUP,
        point: *const EC_POINT,
        x: *mut BIGNUM,
        y: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_set_affine_coordinates_GFp"]
    pub fn EC_POINT_set_affine_coordinates_GFp(
        group: *const EC_GROUP,
        point: *mut EC_POINT,
        x: *const BIGNUM,
        y: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_set_affine_coordinates"]
    pub fn EC_POINT_set_affine_coordinates(
        group: *const EC_GROUP,
        point: *mut EC_POINT,
        x: *const BIGNUM,
        y: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_point2oct"]
    pub fn EC_POINT_point2oct(
        group: *const EC_GROUP,
        point: *const EC_POINT,
        form: point_conversion_form_t,
        buf: *mut u8,
        len: usize,
        ctx: *mut BN_CTX,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_point2cbb"]
    pub fn EC_POINT_point2cbb(
        out: *mut CBB,
        group: *const EC_GROUP,
        point: *const EC_POINT,
        form: point_conversion_form_t,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_oct2point"]
    pub fn EC_POINT_oct2point(
        group: *const EC_GROUP,
        point: *mut EC_POINT,
        buf: *const u8,
        len: usize,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_set_compressed_coordinates_GFp"]
    pub fn EC_POINT_set_compressed_coordinates_GFp(
        group: *const EC_GROUP,
        point: *mut EC_POINT,
        x: *const BIGNUM,
        y_bit: ::std::os::raw::c_int,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_add"]
    pub fn EC_POINT_add(
        group: *const EC_GROUP,
        r: *mut EC_POINT,
        a: *const EC_POINT,
        b: *const EC_POINT,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_dbl"]
    pub fn EC_POINT_dbl(
        group: *const EC_GROUP,
        r: *mut EC_POINT,
        a: *const EC_POINT,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_invert"]
    pub fn EC_POINT_invert(
        group: *const EC_GROUP,
        a: *mut EC_POINT,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_mul"]
    pub fn EC_POINT_mul(
        group: *const EC_GROUP,
        r: *mut EC_POINT,
        n: *const BIGNUM,
        q: *const EC_POINT,
        m: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_hash_to_curve_p256_xmd_sha256_sswu"]
    pub fn EC_hash_to_curve_p256_xmd_sha256_sswu(
        group: *const EC_GROUP,
        out: *mut EC_POINT,
        dst: *const u8,
        dst_len: usize,
        msg: *const u8,
        msg_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_hash_to_curve_p384_xmd_sha384_sswu"]
    pub fn EC_hash_to_curve_p384_xmd_sha384_sswu(
        group: *const EC_GROUP,
        out: *mut EC_POINT,
        dst: *const u8,
        dst_len: usize,
        msg: *const u8,
        msg_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_free"]
    pub fn EC_GROUP_free(group: *mut EC_GROUP);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_dup"]
    pub fn EC_GROUP_dup(group: *const EC_GROUP) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_new_curve_GFp"]
    pub fn EC_GROUP_new_curve_GFp(
        p: *const BIGNUM,
        a: *const BIGNUM,
        b: *const BIGNUM,
        ctx: *mut BN_CTX,
    ) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_set_generator"]
    pub fn EC_GROUP_set_generator(
        group: *mut EC_GROUP,
        generator: *const EC_POINT,
        order: *const BIGNUM,
        cofactor: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_point2bn"]
    pub fn EC_POINT_point2bn(
        group: *const EC_GROUP,
        point: *const EC_POINT,
        form: point_conversion_form_t,
        ret: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> *mut BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_bn2point"]
    pub fn EC_POINT_bn2point(
        group: *const EC_GROUP,
        bn: *const BIGNUM,
        point: *mut EC_POINT,
        ctx: *mut BN_CTX,
    ) -> *mut EC_POINT;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_order"]
    pub fn EC_GROUP_get_order(
        group: *const EC_GROUP,
        order: *mut BIGNUM,
        ctx: *mut BN_CTX,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct EC_builtin_curve {
    pub nid: ::std::os::raw::c_int,
    pub comment: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_EC_builtin_curve() {
    const UNINIT: ::std::mem::MaybeUninit<EC_builtin_curve> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<EC_builtin_curve>(),
        16usize,
        "Size of EC_builtin_curve"
    );
    assert_eq!(
        ::std::mem::align_of::<EC_builtin_curve>(),
        8usize,
        "Alignment of EC_builtin_curve"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nid) as usize - ptr as usize },
        0usize,
        "Offset of field: EC_builtin_curve::nid"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).comment) as usize - ptr as usize },
        8usize,
        "Offset of field: EC_builtin_curve::comment"
    );
}
impl Default for EC_builtin_curve {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_get_builtin_curves"]
    pub fn EC_get_builtin_curves(out_curves: *mut EC_builtin_curve, max_num_curves: usize)
        -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_POINT_clear_free"]
    pub fn EC_POINT_clear_free(point: *mut EC_POINT);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_set_seed"]
    pub fn EC_GROUP_set_seed(
        group: *mut EC_GROUP,
        p: *const ::std::os::raw::c_uchar,
        len: usize,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get0_seed"]
    pub fn EC_GROUP_get0_seed(group: *const EC_GROUP) -> *mut ::std::os::raw::c_uchar;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_seed_len"]
    pub fn EC_GROUP_get_seed_len(group: *const EC_GROUP) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECPKParameters_print"]
    pub fn ECPKParameters_print(
        bio: *mut BIO,
        group: *const EC_GROUP,
        offset: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_set_asn1_flag"]
    pub fn EC_GROUP_set_asn1_flag(group: *mut EC_GROUP, flag: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_asn1_flag"]
    pub fn EC_GROUP_get_asn1_flag(group: *const EC_GROUP) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_set_point_conversion_form"]
    pub fn EC_GROUP_set_point_conversion_form(group: *mut EC_GROUP, form: point_conversion_form_t);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_get_point_conversion_form"]
    pub fn EC_GROUP_get_point_conversion_form(group: *const EC_GROUP) -> point_conversion_form_t;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_decoded_from_explicit_params"]
    pub fn EC_KEY_decoded_from_explicit_params(key: *const EC_KEY) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ec_method_st {
    _unused: [u8; 0],
}
pub type EC_METHOD = ec_method_st;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_GROUP_method_of"]
    pub fn EC_GROUP_method_of(group: *const EC_GROUP) -> *const EC_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_METHOD_get_field_type"]
    pub fn EC_METHOD_get_field_type(meth: *const EC_METHOD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_new"]
    pub fn EC_KEY_new() -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_new_method"]
    pub fn EC_KEY_new_method(engine: *const ENGINE) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_new_by_curve_name"]
    pub fn EC_KEY_new_by_curve_name(nid: ::std::os::raw::c_int) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_free"]
    pub fn EC_KEY_free(key: *mut EC_KEY);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_dup"]
    pub fn EC_KEY_dup(src: *const EC_KEY) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_up_ref"]
    pub fn EC_KEY_up_ref(key: *mut EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_is_opaque"]
    pub fn EC_KEY_is_opaque(key: *const EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get0_group"]
    pub fn EC_KEY_get0_group(key: *const EC_KEY) -> *const EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_group"]
    pub fn EC_KEY_set_group(key: *mut EC_KEY, group: *const EC_GROUP) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get0_private_key"]
    pub fn EC_KEY_get0_private_key(key: *const EC_KEY) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_private_key"]
    pub fn EC_KEY_set_private_key(key: *mut EC_KEY, priv_: *const BIGNUM) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get0_public_key"]
    pub fn EC_KEY_get0_public_key(key: *const EC_KEY) -> *const EC_POINT;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_public_key"]
    pub fn EC_KEY_set_public_key(key: *mut EC_KEY, pub_: *const EC_POINT) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_enc_flags"]
    pub fn EC_KEY_get_enc_flags(key: *const EC_KEY) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_enc_flags"]
    pub fn EC_KEY_set_enc_flags(key: *mut EC_KEY, flags: ::std::os::raw::c_uint);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_conv_form"]
    pub fn EC_KEY_get_conv_form(key: *const EC_KEY) -> point_conversion_form_t;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_conv_form"]
    pub fn EC_KEY_set_conv_form(key: *mut EC_KEY, cform: point_conversion_form_t);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_check_key"]
    pub fn EC_KEY_check_key(key: *const EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_check_fips"]
    pub fn EC_KEY_check_fips(key: *const EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_public_key_affine_coordinates"]
    pub fn EC_KEY_set_public_key_affine_coordinates(
        key: *mut EC_KEY,
        x: *const BIGNUM,
        y: *const BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_key2buf"]
    pub fn EC_KEY_key2buf(
        key: *const EC_KEY,
        form: point_conversion_form_t,
        out_buf: *mut *mut ::std::os::raw::c_uchar,
        ctx: *mut BN_CTX,
    ) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_generate_key"]
    pub fn EC_KEY_generate_key(key: *mut EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_generate_key_fips"]
    pub fn EC_KEY_generate_key_fips(key: *mut EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_derive_from_secret"]
    pub fn EC_KEY_derive_from_secret(
        group: *const EC_GROUP,
        secret: *const u8,
        secret_len: usize,
    ) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_parse_private_key"]
    pub fn EC_KEY_parse_private_key(cbs: *mut CBS, group: *const EC_GROUP) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_marshal_private_key"]
    pub fn EC_KEY_marshal_private_key(
        cbb: *mut CBB,
        key: *const EC_KEY,
        enc_flags: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_parse_curve_name"]
    pub fn EC_KEY_parse_curve_name(cbs: *mut CBS) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_marshal_curve_name"]
    pub fn EC_KEY_marshal_curve_name(
        cbb: *mut CBB,
        group: *const EC_GROUP,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_parse_parameters"]
    pub fn EC_KEY_parse_parameters(cbs: *mut CBS) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_ex_new_index"]
    pub fn EC_KEY_get_ex_new_index(
        argl: ::std::os::raw::c_long,
        argp: *mut ::std::os::raw::c_void,
        unused: *mut CRYPTO_EX_unused,
        dup_unused: CRYPTO_EX_dup,
        free_func: CRYPTO_EX_free,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_ex_data"]
    pub fn EC_KEY_set_ex_data(
        r: *mut EC_KEY,
        idx: ::std::os::raw::c_int,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_ex_data"]
    pub fn EC_KEY_get_ex_data(
        r: *const EC_KEY,
        idx: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_ECPrivateKey"]
    pub fn d2i_ECPrivateKey(
        out_key: *mut *mut EC_KEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_ECPrivateKey"]
    pub fn i2d_ECPrivateKey(key: *const EC_KEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_ECParameters"]
    pub fn d2i_ECParameters(
        out_key: *mut *mut EC_KEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_ECParameters"]
    pub fn i2d_ECParameters(key: *const EC_KEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_ECPKParameters_bio"]
    pub fn d2i_ECPKParameters_bio(bio: *mut BIO, out_group: *mut *mut EC_GROUP) -> *mut EC_GROUP;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_ECPKParameters_bio"]
    pub fn i2d_ECPKParameters_bio(bio: *mut BIO, group: *const EC_GROUP) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_o2i_ECPublicKey"]
    pub fn o2i_ECPublicKey(
        out_key: *mut *mut EC_KEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2o_ECPublicKey"]
    pub fn i2o_ECPublicKey(
        key: *const EC_KEY,
        outp: *mut *mut ::std::os::raw::c_uchar,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_default_method"]
    pub fn EC_KEY_get_default_method() -> *const EC_KEY_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_OpenSSL"]
    pub fn EC_KEY_OpenSSL() -> *const EC_KEY_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_METHOD_new"]
    pub fn EC_KEY_METHOD_new(eckey_meth: *const EC_KEY_METHOD) -> *mut EC_KEY_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_METHOD_free"]
    pub fn EC_KEY_METHOD_free(eckey_meth: *mut EC_KEY_METHOD);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_method"]
    pub fn EC_KEY_set_method(ec: *mut EC_KEY, meth: *const EC_KEY_METHOD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_get_method"]
    pub fn EC_KEY_get_method(ec: *const EC_KEY) -> *const EC_KEY_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_METHOD_set_sign_awslc"]
    pub fn EC_KEY_METHOD_set_sign_awslc(
        meth: *mut EC_KEY_METHOD,
        sign: ::std::option::Option<
            unsafe extern "C" fn(
                type_: ::std::os::raw::c_int,
                digest: *const u8,
                digest_len: ::std::os::raw::c_int,
                sig: *mut u8,
                siglen: *mut ::std::os::raw::c_uint,
                k_inv: *const BIGNUM,
                r: *const BIGNUM,
                eckey: *mut EC_KEY,
            ) -> ::std::os::raw::c_int,
        >,
        sign_sig: ::std::option::Option<
            unsafe extern "C" fn(
                digest: *const u8,
                digest_len: ::std::os::raw::c_int,
                in_kinv: *const BIGNUM,
                in_r: *const BIGNUM,
                eckey: *mut EC_KEY,
            ) -> *mut ECDSA_SIG,
        >,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_METHOD_set_init_awslc"]
    pub fn EC_KEY_METHOD_set_init_awslc(
        meth: *mut EC_KEY_METHOD,
        init: ::std::option::Option<
            unsafe extern "C" fn(key: *mut EC_KEY) -> ::std::os::raw::c_int,
        >,
        finish: ::std::option::Option<unsafe extern "C" fn(key: *mut EC_KEY)>,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_METHOD_set_flags"]
    pub fn EC_KEY_METHOD_set_flags(
        meth: *mut EC_KEY_METHOD,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EC_KEY_set_asn1_flag"]
    pub fn EC_KEY_set_asn1_flag(key: *mut EC_KEY, flag: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDH_compute_key"]
    pub fn ECDH_compute_key(
        out: *mut ::std::os::raw::c_void,
        outlen: usize,
        pub_key: *const EC_POINT,
        priv_key: *const EC_KEY,
        kdf: ::std::option::Option<
            unsafe extern "C" fn(
                in_: *const ::std::os::raw::c_void,
                inlen: usize,
                out: *mut ::std::os::raw::c_void,
                outlen: *mut usize,
            ) -> *mut ::std::os::raw::c_void,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDH_compute_key_fips"]
    pub fn ECDH_compute_key_fips(
        out: *mut u8,
        out_len: usize,
        pub_key: *const EC_POINT,
        priv_key: *const EC_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_sign"]
    pub fn ECDSA_sign(
        type_: ::std::os::raw::c_int,
        digest: *const u8,
        digest_len: usize,
        sig: *mut u8,
        sig_len: *mut ::std::os::raw::c_uint,
        key: *const EC_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_verify"]
    pub fn ECDSA_verify(
        type_: ::std::os::raw::c_int,
        digest: *const u8,
        digest_len: usize,
        sig: *const u8,
        sig_len: usize,
        key: *const EC_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_size"]
    pub fn ECDSA_size(key: *const EC_KEY) -> usize;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct ecdsa_sig_st {
    pub r: *mut BIGNUM,
    pub s: *mut BIGNUM,
}
#[test]
fn bindgen_test_layout_ecdsa_sig_st() {
    const UNINIT: ::std::mem::MaybeUninit<ecdsa_sig_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ecdsa_sig_st>(),
        16usize,
        "Size of ecdsa_sig_st"
    );
    assert_eq!(
        ::std::mem::align_of::<ecdsa_sig_st>(),
        8usize,
        "Alignment of ecdsa_sig_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r) as usize - ptr as usize },
        0usize,
        "Offset of field: ecdsa_sig_st::r"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s) as usize - ptr as usize },
        8usize,
        "Offset of field: ecdsa_sig_st::s"
    );
}
impl Default for ecdsa_sig_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_new"]
    pub fn ECDSA_SIG_new() -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_free"]
    pub fn ECDSA_SIG_free(sig: *mut ECDSA_SIG);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_get0_r"]
    pub fn ECDSA_SIG_get0_r(sig: *const ECDSA_SIG) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_get0_s"]
    pub fn ECDSA_SIG_get0_s(sig: *const ECDSA_SIG) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_get0"]
    pub fn ECDSA_SIG_get0(
        sig: *const ECDSA_SIG,
        out_r: *mut *const BIGNUM,
        out_s: *mut *const BIGNUM,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_set0"]
    pub fn ECDSA_SIG_set0(
        sig: *mut ECDSA_SIG,
        r: *mut BIGNUM,
        s: *mut BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_do_sign"]
    pub fn ECDSA_do_sign(
        digest: *const u8,
        digest_len: usize,
        key: *const EC_KEY,
    ) -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_do_verify"]
    pub fn ECDSA_do_verify(
        digest: *const u8,
        digest_len: usize,
        sig: *const ECDSA_SIG,
        key: *const EC_KEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_parse"]
    pub fn ECDSA_SIG_parse(cbs: *mut CBS) -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_from_bytes"]
    pub fn ECDSA_SIG_from_bytes(in_: *const u8, in_len: usize) -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_marshal"]
    pub fn ECDSA_SIG_marshal(cbb: *mut CBB, sig: *const ECDSA_SIG) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_to_bytes"]
    pub fn ECDSA_SIG_to_bytes(
        out_bytes: *mut *mut u8,
        out_len: *mut usize,
        sig: *const ECDSA_SIG,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_SIG_max_len"]
    pub fn ECDSA_SIG_max_len(order_len: usize) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ECDSA_sign_with_nonce_and_leak_private_key_for_testing"]
    pub fn ECDSA_sign_with_nonce_and_leak_private_key_for_testing(
        digest: *const u8,
        digest_len: usize,
        eckey: *const EC_KEY,
        nonce: *const u8,
        nonce_len: usize,
    ) -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_ECDSA_SIG"]
    pub fn d2i_ECDSA_SIG(
        out: *mut *mut ECDSA_SIG,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut ECDSA_SIG;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_ECDSA_SIG"]
    pub fn i2d_ECDSA_SIG(sig: *const ECDSA_SIG, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_gcm"]
    pub fn EVP_aead_aes_128_gcm() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_192_gcm"]
    pub fn EVP_aead_aes_192_gcm() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_gcm"]
    pub fn EVP_aead_aes_256_gcm() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_chacha20_poly1305"]
    pub fn EVP_aead_chacha20_poly1305() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_xchacha20_poly1305"]
    pub fn EVP_aead_xchacha20_poly1305() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_ctr_hmac_sha256"]
    pub fn EVP_aead_aes_128_ctr_hmac_sha256() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_ctr_hmac_sha256"]
    pub fn EVP_aead_aes_256_ctr_hmac_sha256() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_gcm_siv"]
    pub fn EVP_aead_aes_128_gcm_siv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_gcm_siv"]
    pub fn EVP_aead_aes_256_gcm_siv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_gcm_randnonce"]
    pub fn EVP_aead_aes_128_gcm_randnonce() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_gcm_randnonce"]
    pub fn EVP_aead_aes_256_gcm_randnonce() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_ccm_bluetooth"]
    pub fn EVP_aead_aes_128_ccm_bluetooth() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_ccm_bluetooth_8"]
    pub fn EVP_aead_aes_128_ccm_bluetooth_8() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_ccm_matter"]
    pub fn EVP_aead_aes_128_ccm_matter() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_has_aes_hardware"]
    pub fn EVP_has_aes_hardware() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_key_length"]
    pub fn EVP_AEAD_key_length(aead: *const EVP_AEAD) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_nonce_length"]
    pub fn EVP_AEAD_nonce_length(aead: *const EVP_AEAD) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_max_overhead"]
    pub fn EVP_AEAD_max_overhead(aead: *const EVP_AEAD) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_max_tag_len"]
    pub fn EVP_AEAD_max_tag_len(aead: *const EVP_AEAD) -> usize;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union evp_aead_ctx_st_state {
    pub opaque: [u8; 564usize],
    pub alignment: u64,
    pub ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_evp_aead_ctx_st_state() {
    const UNINIT: ::std::mem::MaybeUninit<evp_aead_ctx_st_state> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_aead_ctx_st_state>(),
        568usize,
        "Size of evp_aead_ctx_st_state"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_aead_ctx_st_state>(),
        8usize,
        "Alignment of evp_aead_ctx_st_state"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).opaque) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_aead_ctx_st_state::opaque"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alignment) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_aead_ctx_st_state::alignment"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_aead_ctx_st_state::ptr"
    );
}
impl Default for evp_aead_ctx_st_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct evp_aead_ctx_st {
    pub aead: *const EVP_AEAD,
    pub state: evp_aead_ctx_st_state,
    pub state_offset: u8,
    pub tag_len: u8,
}
#[test]
fn bindgen_test_layout_evp_aead_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_aead_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_aead_ctx_st>(),
        584usize,
        "Size of evp_aead_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_aead_ctx_st>(),
        8usize,
        "Alignment of evp_aead_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aead) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_aead_ctx_st::aead"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        8usize,
        "Offset of field: evp_aead_ctx_st::state"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state_offset) as usize - ptr as usize },
        576usize,
        "Offset of field: evp_aead_ctx_st::state_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).tag_len) as usize - ptr as usize },
        577usize,
        "Offset of field: evp_aead_ctx_st::tag_len"
    );
}
impl Default for evp_aead_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_zero"]
    pub fn EVP_AEAD_CTX_zero(ctx: *mut EVP_AEAD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_new"]
    pub fn EVP_AEAD_CTX_new(
        aead: *const EVP_AEAD,
        key: *const u8,
        key_len: usize,
        tag_len: usize,
    ) -> *mut EVP_AEAD_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_free"]
    pub fn EVP_AEAD_CTX_free(ctx: *mut EVP_AEAD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_init"]
    pub fn EVP_AEAD_CTX_init(
        ctx: *mut EVP_AEAD_CTX,
        aead: *const EVP_AEAD,
        key: *const u8,
        key_len: usize,
        tag_len: usize,
        impl_: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_cleanup"]
    pub fn EVP_AEAD_CTX_cleanup(ctx: *mut EVP_AEAD_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_seal"]
    pub fn EVP_AEAD_CTX_seal(
        ctx: *const EVP_AEAD_CTX,
        out: *mut u8,
        out_len: *mut usize,
        max_out_len: usize,
        nonce: *const u8,
        nonce_len: usize,
        in_: *const u8,
        in_len: usize,
        ad: *const u8,
        ad_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_open"]
    pub fn EVP_AEAD_CTX_open(
        ctx: *const EVP_AEAD_CTX,
        out: *mut u8,
        out_len: *mut usize,
        max_out_len: usize,
        nonce: *const u8,
        nonce_len: usize,
        in_: *const u8,
        in_len: usize,
        ad: *const u8,
        ad_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_seal_scatter"]
    pub fn EVP_AEAD_CTX_seal_scatter(
        ctx: *const EVP_AEAD_CTX,
        out: *mut u8,
        out_tag: *mut u8,
        out_tag_len: *mut usize,
        max_out_tag_len: usize,
        nonce: *const u8,
        nonce_len: usize,
        in_: *const u8,
        in_len: usize,
        extra_in: *const u8,
        extra_in_len: usize,
        ad: *const u8,
        ad_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_open_gather"]
    pub fn EVP_AEAD_CTX_open_gather(
        ctx: *const EVP_AEAD_CTX,
        out: *mut u8,
        nonce: *const u8,
        nonce_len: usize,
        in_: *const u8,
        in_len: usize,
        in_tag: *const u8,
        in_tag_len: usize,
        ad: *const u8,
        ad_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_aead"]
    pub fn EVP_AEAD_CTX_aead(ctx: *const EVP_AEAD_CTX) -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_cbc_sha1_tls"]
    pub fn EVP_aead_aes_128_cbc_sha1_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_cbc_sha1_tls_implicit_iv"]
    pub fn EVP_aead_aes_128_cbc_sha1_tls_implicit_iv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_cbc_sha1_tls"]
    pub fn EVP_aead_aes_256_cbc_sha1_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_cbc_sha1_tls_implicit_iv"]
    pub fn EVP_aead_aes_256_cbc_sha1_tls_implicit_iv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_cbc_sha256_tls"]
    pub fn EVP_aead_aes_128_cbc_sha256_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_cbc_sha256_tls_implicit_iv"]
    pub fn EVP_aead_aes_128_cbc_sha256_tls_implicit_iv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_cbc_sha384_tls"]
    pub fn EVP_aead_aes_256_cbc_sha384_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_des_ede3_cbc_sha1_tls"]
    pub fn EVP_aead_des_ede3_cbc_sha1_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv"]
    pub fn EVP_aead_des_ede3_cbc_sha1_tls_implicit_iv() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_null_sha1_tls"]
    pub fn EVP_aead_null_sha1_tls() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_gcm_tls12"]
    pub fn EVP_aead_aes_128_gcm_tls12() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_gcm_tls12"]
    pub fn EVP_aead_aes_256_gcm_tls12() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_128_gcm_tls13"]
    pub fn EVP_aead_aes_128_gcm_tls13() -> *const EVP_AEAD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_aead_aes_256_gcm_tls13"]
    pub fn EVP_aead_aes_256_gcm_tls13() -> *const EVP_AEAD;
}
pub const evp_aead_direction_t_evp_aead_open: evp_aead_direction_t = 0;
pub const evp_aead_direction_t_evp_aead_seal: evp_aead_direction_t = 1;
pub type evp_aead_direction_t = ::std::os::raw::c_uint;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_init_with_direction"]
    pub fn EVP_AEAD_CTX_init_with_direction(
        ctx: *mut EVP_AEAD_CTX,
        aead: *const EVP_AEAD,
        key: *const u8,
        key_len: usize,
        tag_len: usize,
        dir: evp_aead_direction_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_get_iv"]
    pub fn EVP_AEAD_CTX_get_iv(
        ctx: *const EVP_AEAD_CTX,
        out_iv: *mut *const u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_CTX_tag_len"]
    pub fn EVP_AEAD_CTX_tag_len(
        ctx: *const EVP_AEAD_CTX,
        out_tag_len: *mut usize,
        in_len: usize,
        extra_in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_AEAD_get_iv_from_ipv4_nanosecs"]
    pub fn EVP_AEAD_get_iv_from_ipv4_nanosecs(
        ipv4_address: u32,
        nanosecs: u64,
        out_iv: *mut u8,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct md5_state_st {
    pub h: [u32; 4usize],
    pub Nl: u32,
    pub Nh: u32,
    pub data: [u8; 64usize],
    pub num: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_md5_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<md5_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<md5_state_st>(),
        92usize,
        "Size of md5_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<md5_state_st>(),
        4usize,
        "Alignment of md5_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: md5_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        16usize,
        "Offset of field: md5_state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        20usize,
        "Offset of field: md5_state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        24usize,
        "Offset of field: md5_state_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        88usize,
        "Offset of field: md5_state_st::num"
    );
}
impl Default for md5_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC"]
    pub fn HMAC(
        evp_md: *const EVP_MD,
        key: *const ::std::os::raw::c_void,
        key_len: usize,
        data: *const u8,
        data_len: usize,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_uint,
    ) -> *mut u8;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_init"]
    pub fn HMAC_CTX_init(ctx: *mut HMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_new"]
    pub fn HMAC_CTX_new() -> *mut HMAC_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_cleanup"]
    pub fn HMAC_CTX_cleanup(ctx: *mut HMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_cleanse"]
    pub fn HMAC_CTX_cleanse(ctx: *mut HMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_free"]
    pub fn HMAC_CTX_free(ctx: *mut HMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_Init_ex"]
    pub fn HMAC_Init_ex(
        ctx: *mut HMAC_CTX,
        key: *const ::std::os::raw::c_void,
        key_len: usize,
        md: *const EVP_MD,
        impl_: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_Update"]
    pub fn HMAC_Update(
        ctx: *mut HMAC_CTX,
        data: *const u8,
        data_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_Final"]
    pub fn HMAC_Final(
        ctx: *mut HMAC_CTX,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_size"]
    pub fn HMAC_size(ctx: *const HMAC_CTX) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_get_md"]
    pub fn HMAC_CTX_get_md(ctx: *const HMAC_CTX) -> *const EVP_MD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_copy_ex"]
    pub fn HMAC_CTX_copy_ex(dest: *mut HMAC_CTX, src: *const HMAC_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_reset"]
    pub fn HMAC_CTX_reset(ctx: *mut HMAC_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_set_precomputed_key_export"]
    pub fn HMAC_set_precomputed_key_export(ctx: *mut HMAC_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_get_precomputed_key"]
    pub fn HMAC_get_precomputed_key(
        ctx: *mut HMAC_CTX,
        out: *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_Init_from_precomputed_key"]
    pub fn HMAC_Init_from_precomputed_key(
        ctx: *mut HMAC_CTX,
        precomputed_key: *const u8,
        precompute_key_len: usize,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_Init"]
    pub fn HMAC_Init(
        ctx: *mut HMAC_CTX,
        key: *const ::std::os::raw::c_void,
        key_len: ::std::os::raw::c_int,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HMAC_CTX_copy"]
    pub fn HMAC_CTX_copy(dest: *mut HMAC_CTX, src: *const HMAC_CTX) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct hmac_methods_st {
    _unused: [u8; 0],
}
pub type HmacMethods = hmac_methods_st;
#[repr(C)]
#[derive(Copy, Clone)]
pub union md_ctx_union {
    pub md5: MD5_CTX,
    pub sha1: SHA_CTX,
    pub sha256: SHA256_CTX,
    pub sha512: SHA512_CTX,
    pub sha3: [u8; 400usize],
}
#[test]
fn bindgen_test_layout_md_ctx_union() {
    const UNINIT: ::std::mem::MaybeUninit<md_ctx_union> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<md_ctx_union>(),
        400usize,
        "Size of md_ctx_union"
    );
    assert_eq!(
        ::std::mem::align_of::<md_ctx_union>(),
        8usize,
        "Alignment of md_ctx_union"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md5) as usize - ptr as usize },
        0usize,
        "Offset of field: md_ctx_union::md5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sha1) as usize - ptr as usize },
        0usize,
        "Offset of field: md_ctx_union::sha1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sha256) as usize - ptr as usize },
        0usize,
        "Offset of field: md_ctx_union::sha256"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sha512) as usize - ptr as usize },
        0usize,
        "Offset of field: md_ctx_union::sha512"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sha3) as usize - ptr as usize },
        0usize,
        "Offset of field: md_ctx_union::sha3"
    );
}
impl Default for md_ctx_union {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct hmac_ctx_st {
    pub md: *const EVP_MD,
    pub methods: *const HmacMethods,
    pub md_ctx: md_ctx_union,
    pub i_ctx: md_ctx_union,
    pub o_ctx: md_ctx_union,
    pub state: i8,
}
#[test]
fn bindgen_test_layout_hmac_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<hmac_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<hmac_ctx_st>(),
        1224usize,
        "Size of hmac_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<hmac_ctx_st>(),
        8usize,
        "Alignment of hmac_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md) as usize - ptr as usize },
        0usize,
        "Offset of field: hmac_ctx_st::md"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).methods) as usize - ptr as usize },
        8usize,
        "Offset of field: hmac_ctx_st::methods"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_ctx) as usize - ptr as usize },
        16usize,
        "Offset of field: hmac_ctx_st::md_ctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i_ctx) as usize - ptr as usize },
        416usize,
        "Offset of field: hmac_ctx_st::i_ctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).o_ctx) as usize - ptr as usize },
        816usize,
        "Offset of field: hmac_ctx_st::o_ctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        1216usize,
        "Offset of field: hmac_ctx_st::state"
    );
}
impl Default for hmac_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_new"]
    pub fn EVP_PKEY_new() -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_free"]
    pub fn EVP_PKEY_free(pkey: *mut EVP_PKEY);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_up_ref"]
    pub fn EVP_PKEY_up_ref(pkey: *mut EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_is_opaque"]
    pub fn EVP_PKEY_is_opaque(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_cmp"]
    pub fn EVP_PKEY_cmp(a: *const EVP_PKEY, b: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_copy_parameters"]
    pub fn EVP_PKEY_copy_parameters(
        to: *mut EVP_PKEY,
        from: *const EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_missing_parameters"]
    pub fn EVP_PKEY_missing_parameters(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_size"]
    pub fn EVP_PKEY_size(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_bits"]
    pub fn EVP_PKEY_bits(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_id"]
    pub fn EVP_PKEY_id(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_get0_name"]
    pub fn EVP_MD_get0_name(md: *const EVP_MD) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_name"]
    pub fn EVP_MD_name(md: *const EVP_MD) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_get_pw_prompt"]
    pub fn EVP_get_pw_prompt() -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_read_pw_string"]
    pub fn EVP_read_pw_string(
        buf: *mut ::std::os::raw::c_char,
        length: ::std::os::raw::c_int,
        prompt: *const ::std::os::raw::c_char,
        verify: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_read_pw_string_min"]
    pub fn EVP_read_pw_string_min(
        buf: *mut ::std::os::raw::c_char,
        min_length: ::std::os::raw::c_int,
        length: ::std::os::raw::c_int,
        prompt: *const ::std::os::raw::c_char,
        verify: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set1_RSA"]
    pub fn EVP_PKEY_set1_RSA(pkey: *mut EVP_PKEY, key: *mut RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_assign_RSA"]
    pub fn EVP_PKEY_assign_RSA(pkey: *mut EVP_PKEY, key: *mut RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get0_RSA"]
    pub fn EVP_PKEY_get0_RSA(pkey: *const EVP_PKEY) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get1_RSA"]
    pub fn EVP_PKEY_get1_RSA(pkey: *const EVP_PKEY) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set1_DSA"]
    pub fn EVP_PKEY_set1_DSA(pkey: *mut EVP_PKEY, key: *mut DSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_assign_DSA"]
    pub fn EVP_PKEY_assign_DSA(pkey: *mut EVP_PKEY, key: *mut DSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get0_DSA"]
    pub fn EVP_PKEY_get0_DSA(pkey: *const EVP_PKEY) -> *mut DSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get1_DSA"]
    pub fn EVP_PKEY_get1_DSA(pkey: *const EVP_PKEY) -> *mut DSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set1_EC_KEY"]
    pub fn EVP_PKEY_set1_EC_KEY(pkey: *mut EVP_PKEY, key: *mut EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_assign_EC_KEY"]
    pub fn EVP_PKEY_assign_EC_KEY(pkey: *mut EVP_PKEY, key: *mut EC_KEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get0_EC_KEY"]
    pub fn EVP_PKEY_get0_EC_KEY(pkey: *const EVP_PKEY) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get1_EC_KEY"]
    pub fn EVP_PKEY_get1_EC_KEY(pkey: *const EVP_PKEY) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set1_DH"]
    pub fn EVP_PKEY_set1_DH(pkey: *mut EVP_PKEY, key: *mut DH) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_assign_DH"]
    pub fn EVP_PKEY_assign_DH(pkey: *mut EVP_PKEY, key: *mut DH) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get0_DH"]
    pub fn EVP_PKEY_get0_DH(pkey: *const EVP_PKEY) -> *mut DH;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get1_DH"]
    pub fn EVP_PKEY_get1_DH(pkey: *const EVP_PKEY) -> *mut DH;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dh_paramgen_prime_len"]
    pub fn EVP_PKEY_CTX_set_dh_paramgen_prime_len(
        ctx: *mut EVP_PKEY_CTX,
        pbits: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dh_paramgen_generator"]
    pub fn EVP_PKEY_CTX_set_dh_paramgen_generator(
        ctx: *mut EVP_PKEY_CTX,
        gen_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set_type"]
    pub fn EVP_PKEY_set_type(
        pkey: *mut EVP_PKEY,
        type_: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set_type_str"]
    pub fn EVP_PKEY_set_type_str(
        pkey: *mut EVP_PKEY,
        str_: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_cmp_parameters"]
    pub fn EVP_PKEY_cmp_parameters(a: *const EVP_PKEY, b: *const EVP_PKEY)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_parse_public_key"]
    pub fn EVP_parse_public_key(cbs: *mut CBS) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_marshal_public_key"]
    pub fn EVP_marshal_public_key(cbb: *mut CBB, key: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_parse_private_key"]
    pub fn EVP_parse_private_key(cbs: *mut CBS) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_marshal_private_key"]
    pub fn EVP_marshal_private_key(cbb: *mut CBB, key: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_marshal_private_key_v2"]
    pub fn EVP_marshal_private_key_v2(cbb: *mut CBB, key: *const EVP_PKEY)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_new_raw_private_key"]
    pub fn EVP_PKEY_new_raw_private_key(
        type_: ::std::os::raw::c_int,
        unused: *mut ENGINE,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_new_raw_public_key"]
    pub fn EVP_PKEY_new_raw_public_key(
        type_: ::std::os::raw::c_int,
        unused: *mut ENGINE,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get_raw_private_key"]
    pub fn EVP_PKEY_get_raw_private_key(
        pkey: *const EVP_PKEY,
        out: *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get_raw_public_key"]
    pub fn EVP_PKEY_get_raw_public_key(
        pkey: *const EVP_PKEY,
        out: *mut u8,
        out_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestSignInit"]
    pub fn EVP_DigestSignInit(
        ctx: *mut EVP_MD_CTX,
        pctx: *mut *mut EVP_PKEY_CTX,
        type_: *const EVP_MD,
        e: *mut ENGINE,
        pkey: *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestSignUpdate"]
    pub fn EVP_DigestSignUpdate(
        ctx: *mut EVP_MD_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestSignFinal"]
    pub fn EVP_DigestSignFinal(
        ctx: *mut EVP_MD_CTX,
        out_sig: *mut u8,
        out_sig_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestSign"]
    pub fn EVP_DigestSign(
        ctx: *mut EVP_MD_CTX,
        out_sig: *mut u8,
        out_sig_len: *mut usize,
        data: *const u8,
        data_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestVerifyInit"]
    pub fn EVP_DigestVerifyInit(
        ctx: *mut EVP_MD_CTX,
        pctx: *mut *mut EVP_PKEY_CTX,
        type_: *const EVP_MD,
        e: *mut ENGINE,
        pkey: *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestVerifyUpdate"]
    pub fn EVP_DigestVerifyUpdate(
        ctx: *mut EVP_MD_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestVerifyFinal"]
    pub fn EVP_DigestVerifyFinal(
        ctx: *mut EVP_MD_CTX,
        sig: *const u8,
        sig_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_DigestVerify"]
    pub fn EVP_DigestVerify(
        ctx: *mut EVP_MD_CTX,
        sig: *const u8,
        sig_len: usize,
        data: *const u8,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_SignInit_ex"]
    pub fn EVP_SignInit_ex(
        ctx: *mut EVP_MD_CTX,
        type_: *const EVP_MD,
        impl_: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_SignInit"]
    pub fn EVP_SignInit(ctx: *mut EVP_MD_CTX, type_: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_SignUpdate"]
    pub fn EVP_SignUpdate(
        ctx: *mut EVP_MD_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_SignFinal"]
    pub fn EVP_SignFinal(
        ctx: *const EVP_MD_CTX,
        sig: *mut u8,
        out_sig_len: *mut ::std::os::raw::c_uint,
        pkey: *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_VerifyInit_ex"]
    pub fn EVP_VerifyInit_ex(
        ctx: *mut EVP_MD_CTX,
        type_: *const EVP_MD,
        impl_: *mut ENGINE,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_VerifyInit"]
    pub fn EVP_VerifyInit(ctx: *mut EVP_MD_CTX, type_: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_VerifyUpdate"]
    pub fn EVP_VerifyUpdate(
        ctx: *mut EVP_MD_CTX,
        data: *const ::std::os::raw::c_void,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_VerifyFinal"]
    pub fn EVP_VerifyFinal(
        ctx: *mut EVP_MD_CTX,
        sig: *const u8,
        sig_len: usize,
        pkey: *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_print_public"]
    pub fn EVP_PKEY_print_public(
        out: *mut BIO,
        pkey: *const EVP_PKEY,
        indent: ::std::os::raw::c_int,
        pctx: *mut ASN1_PCTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_print_private"]
    pub fn EVP_PKEY_print_private(
        out: *mut BIO,
        pkey: *const EVP_PKEY,
        indent: ::std::os::raw::c_int,
        pctx: *mut ASN1_PCTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_print_params"]
    pub fn EVP_PKEY_print_params(
        out: *mut BIO,
        pkey: *const EVP_PKEY,
        indent: ::std::os::raw::c_int,
        pctx: *mut ASN1_PCTX,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_PKCS5_PBKDF2_HMAC"]
    pub fn PKCS5_PBKDF2_HMAC(
        password: *const ::std::os::raw::c_char,
        password_len: usize,
        salt: *const u8,
        salt_len: usize,
        iterations: u32,
        digest: *const EVP_MD,
        key_len: usize,
        out_key: *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_PKCS5_PBKDF2_HMAC_SHA1"]
    pub fn PKCS5_PBKDF2_HMAC_SHA1(
        password: *const ::std::os::raw::c_char,
        password_len: usize,
        salt: *const u8,
        salt_len: usize,
        iterations: u32,
        key_len: usize,
        out_key: *mut u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PBE_scrypt"]
    pub fn EVP_PBE_scrypt(
        password: *const ::std::os::raw::c_char,
        password_len: usize,
        salt: *const u8,
        salt_len: usize,
        N: u64,
        r: u64,
        p: u64,
        max_mem: usize,
        out_key: *mut u8,
        key_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_new"]
    pub fn EVP_PKEY_CTX_new(pkey: *mut EVP_PKEY, e: *mut ENGINE) -> *mut EVP_PKEY_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_new_id"]
    pub fn EVP_PKEY_CTX_new_id(id: ::std::os::raw::c_int, e: *mut ENGINE) -> *mut EVP_PKEY_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_free"]
    pub fn EVP_PKEY_CTX_free(ctx: *mut EVP_PKEY_CTX);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_dup"]
    pub fn EVP_PKEY_CTX_dup(ctx: *mut EVP_PKEY_CTX) -> *mut EVP_PKEY_CTX;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get0_pkey"]
    pub fn EVP_PKEY_CTX_get0_pkey(ctx: *mut EVP_PKEY_CTX) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_sign_init"]
    pub fn EVP_PKEY_sign_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_sign"]
    pub fn EVP_PKEY_sign(
        ctx: *mut EVP_PKEY_CTX,
        sig: *mut u8,
        sig_len: *mut usize,
        digest: *const u8,
        digest_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_verify_init"]
    pub fn EVP_PKEY_verify_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_verify"]
    pub fn EVP_PKEY_verify(
        ctx: *mut EVP_PKEY_CTX,
        sig: *const u8,
        sig_len: usize,
        digest: *const u8,
        digest_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_encrypt_init"]
    pub fn EVP_PKEY_encrypt_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_encrypt"]
    pub fn EVP_PKEY_encrypt(
        ctx: *mut EVP_PKEY_CTX,
        out: *mut u8,
        out_len: *mut usize,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_decrypt_init"]
    pub fn EVP_PKEY_decrypt_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_decrypt"]
    pub fn EVP_PKEY_decrypt(
        ctx: *mut EVP_PKEY_CTX,
        out: *mut u8,
        out_len: *mut usize,
        in_: *const u8,
        in_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_verify_recover_init"]
    pub fn EVP_PKEY_verify_recover_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_verify_recover"]
    pub fn EVP_PKEY_verify_recover(
        ctx: *mut EVP_PKEY_CTX,
        out: *mut u8,
        out_len: *mut usize,
        sig: *const u8,
        siglen: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_derive_init"]
    pub fn EVP_PKEY_derive_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_derive_set_peer"]
    pub fn EVP_PKEY_derive_set_peer(
        ctx: *mut EVP_PKEY_CTX,
        peer: *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_derive"]
    pub fn EVP_PKEY_derive(
        ctx: *mut EVP_PKEY_CTX,
        key: *mut u8,
        out_key_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_check"]
    pub fn EVP_PKEY_check(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_public_check"]
    pub fn EVP_PKEY_public_check(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_param_check"]
    pub fn EVP_PKEY_param_check(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_keygen_init"]
    pub fn EVP_PKEY_keygen_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_keygen"]
    pub fn EVP_PKEY_keygen(
        ctx: *mut EVP_PKEY_CTX,
        out_pkey: *mut *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_encapsulate"]
    pub fn EVP_PKEY_encapsulate(
        ctx: *mut EVP_PKEY_CTX,
        ciphertext: *mut u8,
        ciphertext_len: *mut usize,
        shared_secret: *mut u8,
        shared_secret_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_decapsulate"]
    pub fn EVP_PKEY_decapsulate(
        ctx: *mut EVP_PKEY_CTX,
        shared_secret: *mut u8,
        shared_secret_len: *mut usize,
        ciphertext: *const u8,
        ciphertext_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_paramgen_init"]
    pub fn EVP_PKEY_paramgen_init(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_paramgen"]
    pub fn EVP_PKEY_paramgen(
        ctx: *mut EVP_PKEY_CTX,
        out_pkey: *mut *mut EVP_PKEY,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_signature_md"]
    pub fn EVP_PKEY_CTX_set_signature_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_signature_md"]
    pub fn EVP_PKEY_CTX_get_signature_md(
        ctx: *mut EVP_PKEY_CTX,
        out_md: *mut *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_signature_context"]
    pub fn EVP_PKEY_CTX_set_signature_context(
        ctx: *mut EVP_PKEY_CTX,
        context: *const u8,
        context_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get0_signature_context"]
    pub fn EVP_PKEY_CTX_get0_signature_context(
        ctx: *mut EVP_PKEY_CTX,
        context: *mut *const u8,
        context_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_padding"]
    pub fn EVP_PKEY_CTX_set_rsa_padding(
        ctx: *mut EVP_PKEY_CTX,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_rsa_padding"]
    pub fn EVP_PKEY_CTX_get_rsa_padding(
        ctx: *mut EVP_PKEY_CTX,
        out_padding: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_pss_saltlen"]
    pub fn EVP_PKEY_CTX_set_rsa_pss_saltlen(
        ctx: *mut EVP_PKEY_CTX,
        salt_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_rsa_pss_saltlen"]
    pub fn EVP_PKEY_CTX_get_rsa_pss_saltlen(
        ctx: *mut EVP_PKEY_CTX,
        out_salt_len: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_keygen_bits"]
    pub fn EVP_PKEY_CTX_set_rsa_keygen_bits(
        ctx: *mut EVP_PKEY_CTX,
        bits: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_keygen_pubexp"]
    pub fn EVP_PKEY_CTX_set_rsa_keygen_pubexp(
        ctx: *mut EVP_PKEY_CTX,
        e: *mut BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_oaep_md"]
    pub fn EVP_PKEY_CTX_set_rsa_oaep_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_rsa_oaep_md"]
    pub fn EVP_PKEY_CTX_get_rsa_oaep_md(
        ctx: *mut EVP_PKEY_CTX,
        out_md: *mut *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_mgf1_md"]
    pub fn EVP_PKEY_CTX_set_rsa_mgf1_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_rsa_mgf1_md"]
    pub fn EVP_PKEY_CTX_get_rsa_mgf1_md(
        ctx: *mut EVP_PKEY_CTX,
        out_md: *mut *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set0_rsa_oaep_label"]
    pub fn EVP_PKEY_CTX_set0_rsa_oaep_label(
        ctx: *mut EVP_PKEY_CTX,
        label: *mut u8,
        label_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get0_rsa_oaep_label"]
    pub fn EVP_PKEY_CTX_get0_rsa_oaep_label(
        ctx: *mut EVP_PKEY_CTX,
        out_label: *mut *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_ec_paramgen_curve_nid"]
    pub fn EVP_PKEY_CTX_set_ec_paramgen_curve_nid(
        ctx: *mut EVP_PKEY_CTX,
        nid: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_kem_set_params"]
    pub fn EVP_PKEY_CTX_kem_set_params(
        ctx: *mut EVP_PKEY_CTX,
        nid: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_kem_new_raw_public_key"]
    pub fn EVP_PKEY_kem_new_raw_public_key(
        nid: ::std::os::raw::c_int,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_kem_new_raw_secret_key"]
    pub fn EVP_PKEY_kem_new_raw_secret_key(
        nid: ::std::os::raw::c_int,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_kem_new_raw_key"]
    pub fn EVP_PKEY_kem_new_raw_key(
        nid: ::std::os::raw::c_int,
        in_public: *const u8,
        len_public: usize,
        in_secret: *const u8,
        len_secret: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_kem_check_key"]
    pub fn EVP_PKEY_kem_check_key(key: *mut EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_pqdsa_set_params"]
    pub fn EVP_PKEY_CTX_pqdsa_set_params(
        ctx: *mut EVP_PKEY_CTX,
        nid: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_pqdsa_new_raw_public_key"]
    pub fn EVP_PKEY_pqdsa_new_raw_public_key(
        nid: ::std::os::raw::c_int,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_pqdsa_new_raw_private_key"]
    pub fn EVP_PKEY_pqdsa_new_raw_private_key(
        nid: ::std::os::raw::c_int,
        in_: *const u8,
        len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dh_pad"]
    pub fn EVP_PKEY_CTX_set_dh_pad(
        ctx: *mut EVP_PKEY_CTX,
        pad: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_asn1_get_count"]
    pub fn EVP_PKEY_asn1_get_count() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_asn1_get0"]
    pub fn EVP_PKEY_asn1_get0(idx: ::std::os::raw::c_int) -> *const EVP_PKEY_ASN1_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_asn1_find"]
    pub fn EVP_PKEY_asn1_find(
        _pe: *mut *mut ENGINE,
        type_: ::std::os::raw::c_int,
    ) -> *const EVP_PKEY_ASN1_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_asn1_find_str"]
    pub fn EVP_PKEY_asn1_find_str(
        _pe: *mut *mut ENGINE,
        name: *const ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *const EVP_PKEY_ASN1_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_asn1_get0_info"]
    pub fn EVP_PKEY_asn1_get0_info(
        ppkey_id: *mut ::std::os::raw::c_int,
        pkey_base_id: *mut ::std::os::raw::c_int,
        ppkey_flags: *mut ::std::os::raw::c_int,
        pinfo: *mut *const ::std::os::raw::c_char,
        ppem_str: *mut *const ::std::os::raw::c_char,
        ameth: *const EVP_PKEY_ASN1_METHOD,
    ) -> ::std::os::raw::c_int;
}
pub type EVP_PKEY_gen_cb =
    ::std::option::Option<unsafe extern "C" fn(ctx: *mut EVP_PKEY_CTX) -> ::std::os::raw::c_int>;
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_cb"]
    pub fn EVP_PKEY_CTX_set_cb(ctx: *mut EVP_PKEY_CTX, cb: EVP_PKEY_gen_cb);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_keygen_info"]
    pub fn EVP_PKEY_CTX_get_keygen_info(
        ctx: *mut EVP_PKEY_CTX,
        idx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_app_data"]
    pub fn EVP_PKEY_CTX_set_app_data(ctx: *mut EVP_PKEY_CTX, data: *mut ::std::os::raw::c_void);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_get_app_data"]
    pub fn EVP_PKEY_CTX_get_app_data(ctx: *mut EVP_PKEY_CTX) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_get_pkey_type"]
    pub fn EVP_MD_get_pkey_type(md: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_pkey_type"]
    pub fn EVP_MD_pkey_type(md: *const EVP_MD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_CIPHER_do_all_sorted"]
    pub fn EVP_CIPHER_do_all_sorted(
        callback: ::std::option::Option<
            unsafe extern "C" fn(
                cipher: *const EVP_CIPHER,
                name: *const ::std::os::raw::c_char,
                unused: *const ::std::os::raw::c_char,
                arg: *mut ::std::os::raw::c_void,
            ),
        >,
        arg: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_do_all_sorted"]
    pub fn EVP_MD_do_all_sorted(
        callback: ::std::option::Option<
            unsafe extern "C" fn(
                cipher: *const EVP_MD,
                name: *const ::std::os::raw::c_char,
                unused: *const ::std::os::raw::c_char,
                arg: *mut ::std::os::raw::c_void,
            ),
        >,
        arg: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_MD_do_all"]
    pub fn EVP_MD_do_all(
        callback: ::std::option::Option<
            unsafe extern "C" fn(
                cipher: *const EVP_MD,
                name: *const ::std::os::raw::c_char,
                unused: *const ::std::os::raw::c_char,
                arg: *mut ::std::os::raw::c_void,
            ),
        >,
        arg: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_PrivateKey"]
    pub fn i2d_PrivateKey(key: *const EVP_PKEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_PublicKey"]
    pub fn i2d_PublicKey(key: *const EVP_PKEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_PrivateKey"]
    pub fn d2i_PrivateKey(
        type_: ::std::os::raw::c_int,
        out: *mut *mut EVP_PKEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_AutoPrivateKey"]
    pub fn d2i_AutoPrivateKey(
        out: *mut *mut EVP_PKEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_PublicKey"]
    pub fn d2i_PublicKey(
        type_: ::std::os::raw::c_int,
        out: *mut *mut EVP_PKEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_ec_param_enc"]
    pub fn EVP_PKEY_CTX_set_ec_param_enc(
        ctx: *mut EVP_PKEY_CTX,
        encoding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_set1_tls_encodedpoint"]
    pub fn EVP_PKEY_set1_tls_encodedpoint(
        pkey: *mut EVP_PKEY,
        in_: *const u8,
        len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get1_tls_encodedpoint"]
    pub fn EVP_PKEY_get1_tls_encodedpoint(pkey: *const EVP_PKEY, out_ptr: *mut *mut u8) -> usize;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_base_id"]
    pub fn EVP_PKEY_base_id(pkey: *const EVP_PKEY) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_pss_keygen_md"]
    pub fn EVP_PKEY_CTX_set_rsa_pss_keygen_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen"]
    pub fn EVP_PKEY_CTX_set_rsa_pss_keygen_saltlen(
        ctx: *mut EVP_PKEY_CTX,
        salt_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md"]
    pub fn EVP_PKEY_CTX_set_rsa_pss_keygen_mgf1_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_PUBKEY"]
    pub fn i2d_PUBKEY(pkey: *const EVP_PKEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_PUBKEY"]
    pub fn d2i_PUBKEY(
        out: *mut *mut EVP_PKEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_RSA_PUBKEY"]
    pub fn i2d_RSA_PUBKEY(rsa: *const RSA, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_RSA_PUBKEY"]
    pub fn d2i_RSA_PUBKEY(
        out: *mut *mut RSA,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_DSA_PUBKEY"]
    pub fn i2d_DSA_PUBKEY(dsa: *const DSA, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_DSA_PUBKEY"]
    pub fn d2i_DSA_PUBKEY(
        out: *mut *mut DSA,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut DSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_EC_PUBKEY"]
    pub fn i2d_EC_PUBKEY(ec_key: *const EC_KEY, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_EC_PUBKEY"]
    pub fn d2i_EC_PUBKEY(
        out: *mut *mut EC_KEY,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut EC_KEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_assign"]
    pub fn EVP_PKEY_assign(
        pkey: *mut EVP_PKEY,
        type_: ::std::os::raw::c_int,
        key: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_type"]
    pub fn EVP_PKEY_type(nid: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_new_mac_key"]
    pub fn EVP_PKEY_new_mac_key(
        type_: ::std::os::raw::c_int,
        engine: *mut ENGINE,
        mac_key: *const u8,
        mac_key_len: usize,
    ) -> *mut EVP_PKEY;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_get0"]
    pub fn EVP_PKEY_get0(pkey: *const EVP_PKEY) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OpenSSL_add_all_algorithms"]
    pub fn OpenSSL_add_all_algorithms();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OPENSSL_add_all_algorithms_conf"]
    pub fn OPENSSL_add_all_algorithms_conf();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OpenSSL_add_all_ciphers"]
    pub fn OpenSSL_add_all_ciphers();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_OpenSSL_add_all_digests"]
    pub fn OpenSSL_add_all_digests();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_cleanup"]
    pub fn EVP_cleanup();
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dsa_paramgen_bits"]
    pub fn EVP_PKEY_CTX_set_dsa_paramgen_bits(
        ctx: *mut EVP_PKEY_CTX,
        nbits: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dsa_paramgen_md"]
    pub fn EVP_PKEY_CTX_set_dsa_paramgen_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_dsa_paramgen_q_bits"]
    pub fn EVP_PKEY_CTX_set_dsa_paramgen_q_bits(
        ctx: *mut EVP_PKEY_CTX,
        qbits: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_ctrl_str"]
    pub fn EVP_PKEY_CTX_ctrl_str(
        ctx: *mut EVP_PKEY_CTX,
        type_: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_tls1_prf"]
    pub fn CRYPTO_tls1_prf(
        digest: *const EVP_MD,
        out: *mut u8,
        out_len: usize,
        secret: *const u8,
        secret_len: usize,
        label: *const ::std::os::raw::c_char,
        label_len: usize,
        seed1: *const u8,
        seed1_len: usize,
        seed2: *const u8,
        seed2_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SSKDF_digest"]
    pub fn SSKDF_digest(
        out_key: *mut u8,
        out_len: usize,
        digest: *const EVP_MD,
        secret: *const u8,
        secret_len: usize,
        info: *const u8,
        info_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_SSKDF_hmac"]
    pub fn SSKDF_hmac(
        out_key: *mut u8,
        out_len: usize,
        digest: *const EVP_MD,
        secret: *const u8,
        secret_len: usize,
        info: *const u8,
        info_len: usize,
        salt: *const u8,
        salt_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_KBKDF_ctr_hmac"]
    pub fn KBKDF_ctr_hmac(
        out_key: *mut u8,
        out_len: usize,
        digest: *const EVP_MD,
        secret: *const u8,
        secret_len: usize,
        info: *const u8,
        info_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_hkdf_mode"]
    pub fn EVP_PKEY_CTX_hkdf_mode(
        ctx: *mut EVP_PKEY_CTX,
        mode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set_hkdf_md"]
    pub fn EVP_PKEY_CTX_set_hkdf_md(
        ctx: *mut EVP_PKEY_CTX,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set1_hkdf_key"]
    pub fn EVP_PKEY_CTX_set1_hkdf_key(
        ctx: *mut EVP_PKEY_CTX,
        key: *const u8,
        key_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_set1_hkdf_salt"]
    pub fn EVP_PKEY_CTX_set1_hkdf_salt(
        ctx: *mut EVP_PKEY_CTX,
        salt: *const u8,
        salt_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_EVP_PKEY_CTX_add1_hkdf_info"]
    pub fn EVP_PKEY_CTX_add1_hkdf_info(
        ctx: *mut EVP_PKEY_CTX,
        info: *const u8,
        info_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HKDF"]
    pub fn HKDF(
        out_key: *mut u8,
        out_len: usize,
        digest: *const EVP_MD,
        secret: *const u8,
        secret_len: usize,
        salt: *const u8,
        salt_len: usize,
        info: *const u8,
        info_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HKDF_extract"]
    pub fn HKDF_extract(
        out_key: *mut u8,
        out_len: *mut usize,
        digest: *const EVP_MD,
        secret: *const u8,
        secret_len: usize,
        salt: *const u8,
        salt_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_HKDF_expand"]
    pub fn HKDF_expand(
        out_key: *mut u8,
        out_len: usize,
        digest: *const EVP_MD,
        prk: *const u8,
        prk_len: usize,
        info: *const u8,
        info_len: usize,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct evp_hpke_ctx_st {
    pub kem: *const EVP_HPKE_KEM,
    pub aead: *const EVP_HPKE_AEAD,
    pub kdf: *const EVP_HPKE_KDF,
    pub aead_ctx: EVP_AEAD_CTX,
    pub base_nonce: [u8; 24usize],
    pub exporter_secret: [u8; 64usize],
    pub seq: u64,
    pub is_sender: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_evp_hpke_ctx_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_hpke_ctx_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_hpke_ctx_st>(),
        712usize,
        "Size of evp_hpke_ctx_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_hpke_ctx_st>(),
        8usize,
        "Alignment of evp_hpke_ctx_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kem) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_hpke_ctx_st::kem"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aead) as usize - ptr as usize },
        8usize,
        "Offset of field: evp_hpke_ctx_st::aead"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kdf) as usize - ptr as usize },
        16usize,
        "Offset of field: evp_hpke_ctx_st::kdf"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).aead_ctx) as usize - ptr as usize },
        24usize,
        "Offset of field: evp_hpke_ctx_st::aead_ctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).base_nonce) as usize - ptr as usize },
        608usize,
        "Offset of field: evp_hpke_ctx_st::base_nonce"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).exporter_secret) as usize - ptr as usize },
        632usize,
        "Offset of field: evp_hpke_ctx_st::exporter_secret"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seq) as usize - ptr as usize },
        696usize,
        "Offset of field: evp_hpke_ctx_st::seq"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_sender) as usize - ptr as usize },
        704usize,
        "Offset of field: evp_hpke_ctx_st::is_sender"
    );
}
impl Default for evp_hpke_ctx_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct evp_hpke_key_st {
    pub kem: *const EVP_HPKE_KEM,
    pub private_key: [u8; 32usize],
    pub public_key: [u8; 32usize],
}
#[test]
fn bindgen_test_layout_evp_hpke_key_st() {
    const UNINIT: ::std::mem::MaybeUninit<evp_hpke_key_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<evp_hpke_key_st>(),
        72usize,
        "Size of evp_hpke_key_st"
    );
    assert_eq!(
        ::std::mem::align_of::<evp_hpke_key_st>(),
        8usize,
        "Alignment of evp_hpke_key_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).kem) as usize - ptr as usize },
        0usize,
        "Offset of field: evp_hpke_key_st::kem"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).private_key) as usize - ptr as usize },
        8usize,
        "Offset of field: evp_hpke_key_st::private_key"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).public_key) as usize - ptr as usize },
        40usize,
        "Offset of field: evp_hpke_key_st::public_key"
    );
}
impl Default for evp_hpke_key_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct md4_state_st {
    pub h: [u32; 4usize],
    pub Nl: u32,
    pub Nh: u32,
    pub data: [u8; 64usize],
    pub num: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_md4_state_st() {
    const UNINIT: ::std::mem::MaybeUninit<md4_state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<md4_state_st>(),
        92usize,
        "Size of md4_state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<md4_state_st>(),
        4usize,
        "Alignment of md4_state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: md4_state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        16usize,
        "Offset of field: md4_state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        20usize,
        "Offset of field: md4_state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        24usize,
        "Offset of field: md4_state_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        88usize,
        "Offset of field: md4_state_st::num"
    );
}
impl Default for md4_state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_X509 {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_X509_CRL {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct pkcs7_st {
    pub type_: *mut ASN1_OBJECT,
    pub d: pkcs7_st__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pkcs7_st__bindgen_ty_1 {
    pub ptr: *mut ::std::os::raw::c_char,
    pub data: *mut ASN1_OCTET_STRING,
    pub sign: *mut PKCS7_SIGNED,
    pub enveloped: *mut PKCS7_ENVELOPE,
    pub signed_and_enveloped: *mut PKCS7_SIGN_ENVELOPE,
    pub digest: *mut PKCS7_DIGEST,
    pub encrypted: *mut PKCS7_ENCRYPT,
    pub other: *mut ASN1_TYPE,
}
#[test]
fn bindgen_test_layout_pkcs7_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_st__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_st__bindgen_ty_1>(),
        8usize,
        "Size of pkcs7_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_st__bindgen_ty_1>(),
        8usize,
        "Alignment of pkcs7_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sign) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::sign"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enveloped) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::enveloped"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signed_and_enveloped) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::signed_and_enveloped"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digest) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::digest"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).encrypted) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::encrypted"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).other) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st__bindgen_ty_1::other"
    );
}
impl Default for pkcs7_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_pkcs7_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_st>(),
        16usize,
        "Size of pkcs7_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_st>(),
        8usize,
        "Alignment of pkcs7_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_st::d"
    );
}
impl Default for pkcs7_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_signed_st {
    pub version: *mut ASN1_INTEGER,
    pub md_algs: *mut stack_st_X509_ALGOR,
    pub contents: *mut PKCS7,
    pub cert: *mut stack_st_X509,
    pub crl: *mut stack_st_X509_CRL,
    pub signer_info: *mut stack_st_PKCS7_SIGNER_INFO,
}
#[test]
fn bindgen_test_layout_pkcs7_signed_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_signed_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_signed_st>(),
        48usize,
        "Size of pkcs7_signed_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_signed_st>(),
        8usize,
        "Alignment of pkcs7_signed_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_signed_st::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_algs) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_signed_st::md_algs"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).contents) as usize - ptr as usize },
        16usize,
        "Offset of field: pkcs7_signed_st::contents"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cert) as usize - ptr as usize },
        24usize,
        "Offset of field: pkcs7_signed_st::cert"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crl) as usize - ptr as usize },
        32usize,
        "Offset of field: pkcs7_signed_st::crl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signer_info) as usize - ptr as usize },
        40usize,
        "Offset of field: pkcs7_signed_st::signer_info"
    );
}
impl Default for pkcs7_signed_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_signer_info_st {
    pub version: *mut ASN1_INTEGER,
    pub issuer_and_serial: *mut PKCS7_ISSUER_AND_SERIAL,
    pub digest_alg: *mut X509_ALGOR,
    pub auth_attr: *mut stack_st_X509_ATTRIBUTE,
    pub digest_enc_alg: *mut X509_ALGOR,
    pub enc_digest: *mut ASN1_OCTET_STRING,
    pub unauth_attr: *mut stack_st_X509_ATTRIBUTE,
    pub pkey: *mut EVP_PKEY,
}
#[test]
fn bindgen_test_layout_pkcs7_signer_info_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_signer_info_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_signer_info_st>(),
        64usize,
        "Size of pkcs7_signer_info_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_signer_info_st>(),
        8usize,
        "Alignment of pkcs7_signer_info_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_signer_info_st::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).issuer_and_serial) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_signer_info_st::issuer_and_serial"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digest_alg) as usize - ptr as usize },
        16usize,
        "Offset of field: pkcs7_signer_info_st::digest_alg"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).auth_attr) as usize - ptr as usize },
        24usize,
        "Offset of field: pkcs7_signer_info_st::auth_attr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).digest_enc_alg) as usize - ptr as usize },
        32usize,
        "Offset of field: pkcs7_signer_info_st::digest_enc_alg"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_digest) as usize - ptr as usize },
        40usize,
        "Offset of field: pkcs7_signer_info_st::enc_digest"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unauth_attr) as usize - ptr as usize },
        48usize,
        "Offset of field: pkcs7_signer_info_st::unauth_attr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pkey) as usize - ptr as usize },
        56usize,
        "Offset of field: pkcs7_signer_info_st::pkey"
    );
}
impl Default for pkcs7_signer_info_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_sign_envelope_st {
    pub version: *mut ASN1_INTEGER,
    pub recipientinfo: *mut stack_st_PKCS7_RECIP_INFO,
    pub md_algs: *mut stack_st_X509_ALGOR,
    pub enc_data: *mut PKCS7_ENC_CONTENT,
    pub cert: *mut stack_st_X509,
    pub crl: *mut stack_st_X509_CRL,
    pub signer_info: *mut stack_st_PKCS7_SIGNER_INFO,
}
#[test]
fn bindgen_test_layout_pkcs7_sign_envelope_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_sign_envelope_st> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_sign_envelope_st>(),
        56usize,
        "Size of pkcs7_sign_envelope_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_sign_envelope_st>(),
        8usize,
        "Alignment of pkcs7_sign_envelope_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_sign_envelope_st::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recipientinfo) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_sign_envelope_st::recipientinfo"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).md_algs) as usize - ptr as usize },
        16usize,
        "Offset of field: pkcs7_sign_envelope_st::md_algs"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_data) as usize - ptr as usize },
        24usize,
        "Offset of field: pkcs7_sign_envelope_st::enc_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cert) as usize - ptr as usize },
        32usize,
        "Offset of field: pkcs7_sign_envelope_st::cert"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crl) as usize - ptr as usize },
        40usize,
        "Offset of field: pkcs7_sign_envelope_st::crl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signer_info) as usize - ptr as usize },
        48usize,
        "Offset of field: pkcs7_sign_envelope_st::signer_info"
    );
}
impl Default for pkcs7_sign_envelope_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_envelope_st {
    pub version: *mut ASN1_INTEGER,
    pub enc_data: *mut PKCS7_ENC_CONTENT,
    pub recipientinfo: *mut stack_st_PKCS7_RECIP_INFO,
}
#[test]
fn bindgen_test_layout_pkcs7_envelope_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_envelope_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_envelope_st>(),
        24usize,
        "Size of pkcs7_envelope_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_envelope_st>(),
        8usize,
        "Alignment of pkcs7_envelope_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_envelope_st::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_data) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_envelope_st::enc_data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).recipientinfo) as usize - ptr as usize },
        16usize,
        "Offset of field: pkcs7_envelope_st::recipientinfo"
    );
}
impl Default for pkcs7_envelope_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_recip_info_st {
    pub version: *mut ASN1_INTEGER,
    pub issuer_and_serial: *mut PKCS7_ISSUER_AND_SERIAL,
    pub key_enc_algor: *mut X509_ALGOR,
    pub enc_key: *mut ASN1_OCTET_STRING,
    pub cert: *mut X509,
}
#[test]
fn bindgen_test_layout_pkcs7_recip_info_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_recip_info_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_recip_info_st>(),
        40usize,
        "Size of pkcs7_recip_info_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_recip_info_st>(),
        8usize,
        "Alignment of pkcs7_recip_info_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_recip_info_st::version"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).issuer_and_serial) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_recip_info_st::issuer_and_serial"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).key_enc_algor) as usize - ptr as usize },
        16usize,
        "Offset of field: pkcs7_recip_info_st::key_enc_algor"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_key) as usize - ptr as usize },
        24usize,
        "Offset of field: pkcs7_recip_info_st::enc_key"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cert) as usize - ptr as usize },
        32usize,
        "Offset of field: pkcs7_recip_info_st::cert"
    );
}
impl Default for pkcs7_recip_info_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct pkcs7_issuer_and_serial_st {
    pub issuer: *mut X509_NAME,
    pub serial: *mut ASN1_INTEGER,
}
#[test]
fn bindgen_test_layout_pkcs7_issuer_and_serial_st() {
    const UNINIT: ::std::mem::MaybeUninit<pkcs7_issuer_and_serial_st> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<pkcs7_issuer_and_serial_st>(),
        16usize,
        "Size of pkcs7_issuer_and_serial_st"
    );
    assert_eq!(
        ::std::mem::align_of::<pkcs7_issuer_and_serial_st>(),
        8usize,
        "Alignment of pkcs7_issuer_and_serial_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).issuer) as usize - ptr as usize },
        0usize,
        "Offset of field: pkcs7_issuer_and_serial_st::issuer"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).serial) as usize - ptr as usize },
        8usize,
        "Offset of field: pkcs7_issuer_and_serial_st::serial"
    );
}
impl Default for pkcs7_issuer_and_serial_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_PKCS7_RECIP_INFO {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_PKCS7_SIGNER_INFO {
    _unused: [u8; 0],
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_public_key"]
    pub fn RSA_new_public_key(n: *const BIGNUM, e: *const BIGNUM) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_private_key"]
    pub fn RSA_new_private_key(
        n: *const BIGNUM,
        e: *const BIGNUM,
        d: *const BIGNUM,
        p: *const BIGNUM,
        q: *const BIGNUM,
        dmp1: *const BIGNUM,
        dmq1: *const BIGNUM,
        iqmp: *const BIGNUM,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new"]
    pub fn RSA_new() -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_method"]
    pub fn RSA_new_method(engine: *const ENGINE) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_free"]
    pub fn RSA_free(rsa: *mut RSA);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_up_ref"]
    pub fn RSA_up_ref(rsa: *mut RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_bits"]
    pub fn RSA_bits(rsa: *const RSA) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_n"]
    pub fn RSA_get0_n(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_e"]
    pub fn RSA_get0_e(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_d"]
    pub fn RSA_get0_d(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_p"]
    pub fn RSA_get0_p(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_q"]
    pub fn RSA_get0_q(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_dmp1"]
    pub fn RSA_get0_dmp1(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_dmq1"]
    pub fn RSA_get0_dmq1(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_iqmp"]
    pub fn RSA_get0_iqmp(rsa: *const RSA) -> *const BIGNUM;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_key"]
    pub fn RSA_get0_key(
        rsa: *const RSA,
        out_n: *mut *const BIGNUM,
        out_e: *mut *const BIGNUM,
        out_d: *mut *const BIGNUM,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_factors"]
    pub fn RSA_get0_factors(rsa: *const RSA, out_p: *mut *const BIGNUM, out_q: *mut *const BIGNUM);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_crt_params"]
    pub fn RSA_get0_crt_params(
        rsa: *const RSA,
        out_dmp1: *mut *const BIGNUM,
        out_dmq1: *mut *const BIGNUM,
        out_iqmp: *mut *const BIGNUM,
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set0_key"]
    pub fn RSA_set0_key(
        rsa: *mut RSA,
        n: *mut BIGNUM,
        e: *mut BIGNUM,
        d: *mut BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set0_factors"]
    pub fn RSA_set0_factors(rsa: *mut RSA, p: *mut BIGNUM, q: *mut BIGNUM)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set0_crt_params"]
    pub fn RSA_set0_crt_params(
        rsa: *mut RSA,
        dmp1: *mut BIGNUM,
        dmq1: *mut BIGNUM,
        iqmp: *mut BIGNUM,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get_default_method"]
    pub fn RSA_get_default_method() -> *const RSA_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_new"]
    pub fn RSA_meth_new(
        name: *const ::std::os::raw::c_char,
        flags: ::std::os::raw::c_int,
    ) -> *mut RSA_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set_method"]
    pub fn RSA_set_method(rsa: *mut RSA, meth: *const RSA_METHOD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get_method"]
    pub fn RSA_get_method(rsa: *const RSA) -> *const RSA_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_free"]
    pub fn RSA_meth_free(meth: *mut RSA_METHOD);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_init"]
    pub fn RSA_meth_set_init(
        meth: *mut RSA_METHOD,
        init: ::std::option::Option<unsafe extern "C" fn(rsa: *mut RSA) -> ::std::os::raw::c_int>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_finish"]
    pub fn RSA_meth_set_finish(
        meth: *mut RSA_METHOD,
        finish: ::std::option::Option<unsafe extern "C" fn(rsa: *mut RSA) -> ::std::os::raw::c_int>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_priv_dec"]
    pub fn RSA_meth_set_priv_dec(
        meth: *mut RSA_METHOD,
        priv_dec: ::std::option::Option<
            unsafe extern "C" fn(
                max_out: ::std::os::raw::c_int,
                from: *const u8,
                to: *mut u8,
                rsa: *mut RSA,
                padding: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_priv_enc"]
    pub fn RSA_meth_set_priv_enc(
        meth: *mut RSA_METHOD,
        priv_enc: ::std::option::Option<
            unsafe extern "C" fn(
                max_out: ::std::os::raw::c_int,
                from: *const u8,
                to: *mut u8,
                rsa: *mut RSA,
                padding: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_pub_dec"]
    pub fn RSA_meth_set_pub_dec(
        meth: *mut RSA_METHOD,
        pub_dec: ::std::option::Option<
            unsafe extern "C" fn(
                max_out: ::std::os::raw::c_int,
                from: *const u8,
                to: *mut u8,
                rsa: *mut RSA,
                padding: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_pub_enc"]
    pub fn RSA_meth_set_pub_enc(
        meth: *mut RSA_METHOD,
        pub_enc: ::std::option::Option<
            unsafe extern "C" fn(
                max_out: ::std::os::raw::c_int,
                from: *const u8,
                to: *mut u8,
                rsa: *mut RSA,
                padding: ::std::os::raw::c_int,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set0_app_data"]
    pub fn RSA_meth_set0_app_data(
        meth: *mut RSA_METHOD,
        app_data: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_meth_set_sign"]
    pub fn RSA_meth_set_sign(
        meth: *mut RSA_METHOD,
        sign: ::std::option::Option<
            unsafe extern "C" fn(
                type_: ::std::os::raw::c_int,
                m: *const ::std::os::raw::c_uchar,
                m_length: ::std::os::raw::c_uint,
                sigret: *mut ::std::os::raw::c_uchar,
                siglen: *mut ::std::os::raw::c_uint,
                rsa: *const RSA,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_generate_key_ex"]
    pub fn RSA_generate_key_ex(
        rsa: *mut RSA,
        bits: ::std::os::raw::c_int,
        e: *const BIGNUM,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_generate_key_fips"]
    pub fn RSA_generate_key_fips(
        rsa: *mut RSA,
        bits: ::std::os::raw::c_int,
        cb: *mut BN_GENCB,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_encrypt"]
    pub fn RSA_encrypt(
        rsa: *mut RSA,
        out_len: *mut usize,
        out: *mut u8,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_decrypt"]
    pub fn RSA_decrypt(
        rsa: *mut RSA,
        out_len: *mut usize,
        out: *mut u8,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_public_encrypt"]
    pub fn RSA_public_encrypt(
        flen: usize,
        from: *const u8,
        to: *mut u8,
        rsa: *mut RSA,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_private_decrypt"]
    pub fn RSA_private_decrypt(
        flen: usize,
        from: *const u8,
        to: *mut u8,
        rsa: *mut RSA,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_sign"]
    pub fn RSA_sign(
        hash_nid: ::std::os::raw::c_int,
        digest: *const u8,
        digest_len: usize,
        out: *mut u8,
        out_len: *mut ::std::os::raw::c_uint,
        rsa: *mut RSA,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_sign_pss_mgf1"]
    pub fn RSA_sign_pss_mgf1(
        rsa: *mut RSA,
        out_len: *mut usize,
        out: *mut u8,
        max_out: usize,
        digest: *const u8,
        digest_len: usize,
        md: *const EVP_MD,
        mgf1_md: *const EVP_MD,
        salt_len: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_sign_raw"]
    pub fn RSA_sign_raw(
        rsa: *mut RSA,
        out_len: *mut usize,
        out: *mut u8,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_verify"]
    pub fn RSA_verify(
        hash_nid: ::std::os::raw::c_int,
        digest: *const u8,
        digest_len: usize,
        sig: *const u8,
        sig_len: usize,
        rsa: *mut RSA,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_verify_pss_mgf1"]
    pub fn RSA_verify_pss_mgf1(
        rsa: *mut RSA,
        digest: *const u8,
        digest_len: usize,
        md: *const EVP_MD,
        mgf1_md: *const EVP_MD,
        salt_len: ::std::os::raw::c_int,
        sig: *const u8,
        sig_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_verify_raw"]
    pub fn RSA_verify_raw(
        rsa: *mut RSA,
        out_len: *mut usize,
        out: *mut u8,
        max_out: usize,
        in_: *const u8,
        in_len: usize,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_private_encrypt"]
    pub fn RSA_private_encrypt(
        flen: usize,
        from: *const u8,
        to: *mut u8,
        rsa: *mut RSA,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_public_decrypt"]
    pub fn RSA_public_decrypt(
        flen: usize,
        from: *const u8,
        to: *mut u8,
        rsa: *mut RSA,
        padding: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_size"]
    pub fn RSA_size(rsa: *const RSA) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_is_opaque"]
    pub fn RSA_is_opaque(rsa: *const RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSAPublicKey_dup"]
    pub fn RSAPublicKey_dup(rsa: *const RSA) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSAPrivateKey_dup"]
    pub fn RSAPrivateKey_dup(rsa: *const RSA) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_check_key"]
    pub fn RSA_check_key(rsa: *const RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_check_fips"]
    pub fn RSA_check_fips(key: *mut RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_verify_PKCS1_PSS_mgf1"]
    pub fn RSA_verify_PKCS1_PSS_mgf1(
        rsa: *const RSA,
        mHash: *const u8,
        Hash: *const EVP_MD,
        mgf1Hash: *const EVP_MD,
        EM: *const u8,
        sLen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_padding_add_PKCS1_PSS_mgf1"]
    pub fn RSA_padding_add_PKCS1_PSS_mgf1(
        rsa: *const RSA,
        EM: *mut u8,
        mHash: *const u8,
        Hash: *const EVP_MD,
        mgf1Hash: *const EVP_MD,
        sLen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_padding_add_PKCS1_OAEP_mgf1"]
    pub fn RSA_padding_add_PKCS1_OAEP_mgf1(
        to: *mut u8,
        to_len: usize,
        from: *const u8,
        from_len: usize,
        param: *const u8,
        param_len: usize,
        md: *const EVP_MD,
        mgf1md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_PKCS1_MGF1"]
    pub fn PKCS1_MGF1(
        out: *mut u8,
        len: usize,
        seed: *const u8,
        seed_len: usize,
        md: *const EVP_MD,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_add_pkcs1_prefix"]
    pub fn RSA_add_pkcs1_prefix(
        out_msg: *mut *mut u8,
        out_msg_len: *mut usize,
        is_alloced: *mut ::std::os::raw::c_int,
        hash_nid: ::std::os::raw::c_int,
        digest: *const u8,
        digest_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_parse_public_key"]
    pub fn RSA_parse_public_key(cbs: *mut CBS) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_public_key_from_bytes"]
    pub fn RSA_public_key_from_bytes(in_: *const u8, in_len: usize) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_marshal_public_key"]
    pub fn RSA_marshal_public_key(cbb: *mut CBB, rsa: *const RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_public_key_to_bytes"]
    pub fn RSA_public_key_to_bytes(
        out_bytes: *mut *mut u8,
        out_len: *mut usize,
        rsa: *const RSA,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_parse_private_key"]
    pub fn RSA_parse_private_key(cbs: *mut CBS) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_private_key_from_bytes"]
    pub fn RSA_private_key_from_bytes(in_: *const u8, in_len: usize) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_marshal_private_key"]
    pub fn RSA_marshal_private_key(cbb: *mut CBB, rsa: *const RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_private_key_to_bytes"]
    pub fn RSA_private_key_to_bytes(
        out_bytes: *mut *mut u8,
        out_len: *mut usize,
        rsa: *const RSA,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_private_key_no_crt"]
    pub fn RSA_new_private_key_no_crt(
        n: *const BIGNUM,
        e: *const BIGNUM,
        d: *const BIGNUM,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_private_key_no_e"]
    pub fn RSA_new_private_key_no_e(n: *const BIGNUM, d: *const BIGNUM) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_public_key_large_e"]
    pub fn RSA_new_public_key_large_e(n: *const BIGNUM, e: *const BIGNUM) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_private_key_large_e"]
    pub fn RSA_new_private_key_large_e(
        n: *const BIGNUM,
        e: *const BIGNUM,
        d: *const BIGNUM,
        p: *const BIGNUM,
        q: *const BIGNUM,
        dmp1: *const BIGNUM,
        dmq1: *const BIGNUM,
        iqmp: *const BIGNUM,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get_ex_new_index"]
    pub fn RSA_get_ex_new_index(
        argl: ::std::os::raw::c_long,
        argp: *mut ::std::os::raw::c_void,
        unused: *mut CRYPTO_EX_unused,
        dup_unused: CRYPTO_EX_dup,
        free_func: CRYPTO_EX_free,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set_ex_data"]
    pub fn RSA_set_ex_data(
        rsa: *mut RSA,
        idx: ::std::os::raw::c_int,
        arg: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get_ex_data"]
    pub fn RSA_get_ex_data(
        rsa: *const RSA,
        idx: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_flags"]
    pub fn RSA_flags(rsa: *const RSA) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_set_flags"]
    pub fn RSA_set_flags(rsa: *mut RSA, flags: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_test_flags"]
    pub fn RSA_test_flags(rsa: *const RSA, flags: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_blinding_on"]
    pub fn RSA_blinding_on(rsa: *mut RSA, ctx: *mut BN_CTX) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_blinding_off_temp_for_accp_compatibility"]
    pub fn RSA_blinding_off_temp_for_accp_compatibility(rsa: *mut RSA);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_pkey_ctx_ctrl"]
    pub fn RSA_pkey_ctx_ctrl(
        ctx: *mut EVP_PKEY_CTX,
        optype: ::std::os::raw::c_int,
        cmd: ::std::os::raw::c_int,
        p1: ::std::os::raw::c_int,
        p2: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_generate_key"]
    pub fn RSA_generate_key(
        bits: ::std::os::raw::c_int,
        e: u64,
        callback: *mut ::std::os::raw::c_void,
        cb_arg: *mut ::std::os::raw::c_void,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_RSAPublicKey"]
    pub fn d2i_RSAPublicKey(
        out: *mut *mut RSA,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_RSAPublicKey"]
    pub fn i2d_RSAPublicKey(in_: *const RSA, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_d2i_RSAPrivateKey"]
    pub fn d2i_RSAPrivateKey(
        out: *mut *mut RSA,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut RSA;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_i2d_RSAPrivateKey"]
    pub fn i2d_RSAPrivateKey(in_: *const RSA, outp: *mut *mut u8) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_padding_add_PKCS1_PSS"]
    pub fn RSA_padding_add_PKCS1_PSS(
        rsa: *const RSA,
        EM: *mut u8,
        mHash: *const u8,
        Hash: *const EVP_MD,
        sLen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_verify_PKCS1_PSS"]
    pub fn RSA_verify_PKCS1_PSS(
        rsa: *const RSA,
        mHash: *const u8,
        Hash: *const EVP_MD,
        EM: *const u8,
        sLen: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_padding_add_PKCS1_OAEP"]
    pub fn RSA_padding_add_PKCS1_OAEP(
        to: *mut u8,
        to_len: usize,
        from: *const u8,
        from_len: usize,
        param: *const u8,
        param_len: usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_print"]
    pub fn RSA_print(
        bio: *mut BIO,
        rsa: *const RSA,
        indent: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_get0_pss_params"]
    pub fn RSA_get0_pss_params(rsa: *const RSA) -> *const RSA_PSS_PARAMS;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RSA_new_method_no_e"]
    pub fn RSA_new_method_no_e(engine: *const ENGINE, n: *const BIGNUM) -> *mut RSA;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_GENERAL_NAME {
    _unused: [u8; 0],
}
pub type GENERAL_NAMES = stack_st_GENERAL_NAME;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_X509_NAME_ENTRY {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct otherName_st {
    pub type_id: *mut ASN1_OBJECT,
    pub value: *mut ASN1_TYPE,
}
#[test]
fn bindgen_test_layout_otherName_st() {
    const UNINIT: ::std::mem::MaybeUninit<otherName_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<otherName_st>(),
        16usize,
        "Size of otherName_st"
    );
    assert_eq!(
        ::std::mem::align_of::<otherName_st>(),
        8usize,
        "Alignment of otherName_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_id) as usize - ptr as usize },
        0usize,
        "Offset of field: otherName_st::type_id"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).value) as usize - ptr as usize },
        8usize,
        "Offset of field: otherName_st::value"
    );
}
impl Default for otherName_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type OTHERNAME = otherName_st;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct EDIPartyName_st {
    pub nameAssigner: *mut ASN1_STRING,
    pub partyName: *mut ASN1_STRING,
}
#[test]
fn bindgen_test_layout_EDIPartyName_st() {
    const UNINIT: ::std::mem::MaybeUninit<EDIPartyName_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<EDIPartyName_st>(),
        16usize,
        "Size of EDIPartyName_st"
    );
    assert_eq!(
        ::std::mem::align_of::<EDIPartyName_st>(),
        8usize,
        "Alignment of EDIPartyName_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).nameAssigner) as usize - ptr as usize },
        0usize,
        "Offset of field: EDIPartyName_st::nameAssigner"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).partyName) as usize - ptr as usize },
        8usize,
        "Offset of field: EDIPartyName_st::partyName"
    );
}
impl Default for EDIPartyName_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type EDIPARTYNAME = EDIPartyName_st;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct GENERAL_NAME_st {
    pub type_: ::std::os::raw::c_int,
    pub d: GENERAL_NAME_st__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union GENERAL_NAME_st__bindgen_ty_1 {
    pub ptr: *mut ::std::os::raw::c_char,
    pub otherName: *mut OTHERNAME,
    pub rfc822Name: *mut ASN1_IA5STRING,
    pub dNSName: *mut ASN1_IA5STRING,
    pub x400Address: *mut ASN1_STRING,
    pub directoryName: *mut X509_NAME,
    pub ediPartyName: *mut EDIPARTYNAME,
    pub uniformResourceIdentifier: *mut ASN1_IA5STRING,
    pub iPAddress: *mut ASN1_OCTET_STRING,
    pub registeredID: *mut ASN1_OBJECT,
    pub ip: *mut ASN1_OCTET_STRING,
    pub dirn: *mut X509_NAME,
    pub ia5: *mut ASN1_IA5STRING,
    pub rid: *mut ASN1_OBJECT,
}
#[test]
fn bindgen_test_layout_GENERAL_NAME_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<GENERAL_NAME_st__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GENERAL_NAME_st__bindgen_ty_1>(),
        8usize,
        "Size of GENERAL_NAME_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<GENERAL_NAME_st__bindgen_ty_1>(),
        8usize,
        "Alignment of GENERAL_NAME_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ptr) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::ptr"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).otherName) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::otherName"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rfc822Name) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::rfc822Name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dNSName) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::dNSName"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x400Address) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::x400Address"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).directoryName) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::directoryName"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ediPartyName) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::ediPartyName"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).uniformResourceIdentifier) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::uniformResourceIdentifier"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).iPAddress) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::iPAddress"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).registeredID) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::registeredID"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ip) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::ip"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dirn) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::dirn"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ia5) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::ia5"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rid) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st__bindgen_ty_1::rid"
    );
}
impl Default for GENERAL_NAME_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_GENERAL_NAME_st() {
    const UNINIT: ::std::mem::MaybeUninit<GENERAL_NAME_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<GENERAL_NAME_st>(),
        16usize,
        "Size of GENERAL_NAME_st"
    );
    assert_eq!(
        ::std::mem::align_of::<GENERAL_NAME_st>(),
        8usize,
        "Alignment of GENERAL_NAME_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: GENERAL_NAME_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d) as usize - ptr as usize },
        8usize,
        "Offset of field: GENERAL_NAME_st::d"
    );
}
impl Default for GENERAL_NAME_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_X509_ALGOR {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_X509_ATTRIBUTE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Netscape_spki_st {
    pub spkac: *mut NETSCAPE_SPKAC,
    pub sig_algor: *mut X509_ALGOR,
    pub signature: *mut ASN1_BIT_STRING,
}
#[test]
fn bindgen_test_layout_Netscape_spki_st() {
    const UNINIT: ::std::mem::MaybeUninit<Netscape_spki_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Netscape_spki_st>(),
        24usize,
        "Size of Netscape_spki_st"
    );
    assert_eq!(
        ::std::mem::align_of::<Netscape_spki_st>(),
        8usize,
        "Alignment of Netscape_spki_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).spkac) as usize - ptr as usize },
        0usize,
        "Offset of field: Netscape_spki_st::spkac"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sig_algor) as usize - ptr as usize },
        8usize,
        "Offset of field: Netscape_spki_st::sig_algor"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).signature) as usize - ptr as usize },
        16usize,
        "Offset of field: Netscape_spki_st::signature"
    );
}
impl Default for Netscape_spki_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct Netscape_spkac_st {
    pub pubkey: *mut X509_PUBKEY,
    pub challenge: *mut ASN1_IA5STRING,
}
#[test]
fn bindgen_test_layout_Netscape_spkac_st() {
    const UNINIT: ::std::mem::MaybeUninit<Netscape_spkac_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<Netscape_spkac_st>(),
        16usize,
        "Size of Netscape_spkac_st"
    );
    assert_eq!(
        ::std::mem::align_of::<Netscape_spkac_st>(),
        8usize,
        "Alignment of Netscape_spkac_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pubkey) as usize - ptr as usize },
        0usize,
        "Offset of field: Netscape_spkac_st::pubkey"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).challenge) as usize - ptr as usize },
        8usize,
        "Offset of field: Netscape_spkac_st::challenge"
    );
}
impl Default for Netscape_spkac_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct rsa_pss_params_st {
    pub hashAlgorithm: *mut X509_ALGOR,
    pub maskGenAlgorithm: *mut X509_ALGOR,
    pub saltLength: *mut ASN1_INTEGER,
    pub trailerField: *mut ASN1_INTEGER,
    pub maskHash: *mut X509_ALGOR,
}
#[test]
fn bindgen_test_layout_rsa_pss_params_st() {
    const UNINIT: ::std::mem::MaybeUninit<rsa_pss_params_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rsa_pss_params_st>(),
        40usize,
        "Size of rsa_pss_params_st"
    );
    assert_eq!(
        ::std::mem::align_of::<rsa_pss_params_st>(),
        8usize,
        "Alignment of rsa_pss_params_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hashAlgorithm) as usize - ptr as usize },
        0usize,
        "Offset of field: rsa_pss_params_st::hashAlgorithm"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).maskGenAlgorithm) as usize - ptr as usize },
        8usize,
        "Offset of field: rsa_pss_params_st::maskGenAlgorithm"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).saltLength) as usize - ptr as usize },
        16usize,
        "Offset of field: rsa_pss_params_st::saltLength"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trailerField) as usize - ptr as usize },
        24usize,
        "Offset of field: rsa_pss_params_st::trailerField"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).maskHash) as usize - ptr as usize },
        32usize,
        "Offset of field: rsa_pss_params_st::maskHash"
    );
}
impl Default for rsa_pss_params_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct private_key_st {
    pub dec_pkey: *mut EVP_PKEY,
}
#[test]
fn bindgen_test_layout_private_key_st() {
    const UNINIT: ::std::mem::MaybeUninit<private_key_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<private_key_st>(),
        8usize,
        "Size of private_key_st"
    );
    assert_eq!(
        ::std::mem::align_of::<private_key_st>(),
        8usize,
        "Alignment of private_key_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dec_pkey) as usize - ptr as usize },
        0usize,
        "Offset of field: private_key_st::dec_pkey"
    );
}
impl Default for private_key_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct X509_info_st {
    pub x509: *mut X509,
    pub crl: *mut X509_CRL,
    pub x_pkey: *mut X509_PKEY,
    pub enc_cipher: EVP_CIPHER_INFO,
    pub enc_len: ::std::os::raw::c_int,
    pub enc_data: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout_X509_info_st() {
    const UNINIT: ::std::mem::MaybeUninit<X509_info_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<X509_info_st>(),
        64usize,
        "Size of X509_info_st"
    );
    assert_eq!(
        ::std::mem::align_of::<X509_info_st>(),
        8usize,
        "Alignment of X509_info_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x509) as usize - ptr as usize },
        0usize,
        "Offset of field: X509_info_st::x509"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crl) as usize - ptr as usize },
        8usize,
        "Offset of field: X509_info_st::crl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x_pkey) as usize - ptr as usize },
        16usize,
        "Offset of field: X509_info_st::x_pkey"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_cipher) as usize - ptr as usize },
        24usize,
        "Offset of field: X509_info_st::enc_cipher"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_len) as usize - ptr as usize },
        48usize,
        "Offset of field: X509_info_st::enc_len"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).enc_data) as usize - ptr as usize },
        56usize,
        "Offset of field: X509_info_st::enc_data"
    );
}
impl Default for X509_info_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type X509V3_EXT_NEW =
    ::std::option::Option<unsafe extern "C" fn() -> *mut ::std::os::raw::c_void>;
pub type X509V3_EXT_FREE =
    ::std::option::Option<unsafe extern "C" fn(ext: *mut ::std::os::raw::c_void)>;
pub type X509V3_EXT_D2I = ::std::option::Option<
    unsafe extern "C" fn(
        ext: *mut ::std::os::raw::c_void,
        inp: *mut *const u8,
        len: ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type X509V3_EXT_I2D = ::std::option::Option<
    unsafe extern "C" fn(
        ext: *mut ::std::os::raw::c_void,
        outp: *mut *mut u8,
    ) -> ::std::os::raw::c_int,
>;
pub type X509V3_EXT_I2V = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ext: *mut ::std::os::raw::c_void,
        extlist: *mut stack_st_CONF_VALUE,
    ) -> *mut stack_st_CONF_VALUE,
>;
pub type X509V3_EXT_V2I = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ctx: *const X509V3_CTX,
        values: *const stack_st_CONF_VALUE,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type X509V3_EXT_I2S = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ext: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_char,
>;
pub type X509V3_EXT_S2I = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ctx: *const X509V3_CTX,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void,
>;
pub type X509V3_EXT_I2R = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ext: *mut ::std::os::raw::c_void,
        out: *mut BIO,
        indent: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
pub type X509V3_EXT_R2I = ::std::option::Option<
    unsafe extern "C" fn(
        method: *const X509V3_EXT_METHOD,
        ctx: *const X509V3_CTX,
        str_: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void,
>;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct v3_ext_method {
    pub ext_nid: ::std::os::raw::c_int,
    pub ext_flags: ::std::os::raw::c_int,
    pub it: *const ASN1_ITEM_st,
    pub ext_new: X509V3_EXT_NEW,
    pub ext_free: X509V3_EXT_FREE,
    pub d2i: X509V3_EXT_D2I,
    pub i2d: X509V3_EXT_I2D,
    pub i2s: X509V3_EXT_I2S,
    pub s2i: X509V3_EXT_S2I,
    pub i2v: X509V3_EXT_I2V,
    pub v2i: X509V3_EXT_V2I,
    pub i2r: X509V3_EXT_I2R,
    pub r2i: X509V3_EXT_R2I,
    pub usr_data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_v3_ext_method() {
    const UNINIT: ::std::mem::MaybeUninit<v3_ext_method> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<v3_ext_method>(),
        104usize,
        "Size of v3_ext_method"
    );
    assert_eq!(
        ::std::mem::align_of::<v3_ext_method>(),
        8usize,
        "Alignment of v3_ext_method"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_nid) as usize - ptr as usize },
        0usize,
        "Offset of field: v3_ext_method::ext_nid"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_flags) as usize - ptr as usize },
        4usize,
        "Offset of field: v3_ext_method::ext_flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).it) as usize - ptr as usize },
        8usize,
        "Offset of field: v3_ext_method::it"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_new) as usize - ptr as usize },
        16usize,
        "Offset of field: v3_ext_method::ext_new"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ext_free) as usize - ptr as usize },
        24usize,
        "Offset of field: v3_ext_method::ext_free"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).d2i) as usize - ptr as usize },
        32usize,
        "Offset of field: v3_ext_method::d2i"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i2d) as usize - ptr as usize },
        40usize,
        "Offset of field: v3_ext_method::i2d"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i2s) as usize - ptr as usize },
        48usize,
        "Offset of field: v3_ext_method::i2s"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).s2i) as usize - ptr as usize },
        56usize,
        "Offset of field: v3_ext_method::s2i"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i2v) as usize - ptr as usize },
        64usize,
        "Offset of field: v3_ext_method::i2v"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).v2i) as usize - ptr as usize },
        72usize,
        "Offset of field: v3_ext_method::v2i"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).i2r) as usize - ptr as usize },
        80usize,
        "Offset of field: v3_ext_method::i2r"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).r2i) as usize - ptr as usize },
        88usize,
        "Offset of field: v3_ext_method::r2i"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).usr_data) as usize - ptr as usize },
        96usize,
        "Offset of field: v3_ext_method::usr_data"
    );
}
impl Default for v3_ext_method {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct v3_ext_ctx {
    pub flags: ::std::os::raw::c_int,
    pub issuer_cert: *const X509,
    pub subject_cert: *const X509,
    pub subject_req: *const X509_REQ,
    pub crl: *const X509_CRL,
    pub db: *const CONF,
}
#[test]
fn bindgen_test_layout_v3_ext_ctx() {
    const UNINIT: ::std::mem::MaybeUninit<v3_ext_ctx> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<v3_ext_ctx>(),
        48usize,
        "Size of v3_ext_ctx"
    );
    assert_eq!(
        ::std::mem::align_of::<v3_ext_ctx>(),
        8usize,
        "Alignment of v3_ext_ctx"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        0usize,
        "Offset of field: v3_ext_ctx::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).issuer_cert) as usize - ptr as usize },
        8usize,
        "Offset of field: v3_ext_ctx::issuer_cert"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subject_cert) as usize - ptr as usize },
        16usize,
        "Offset of field: v3_ext_ctx::subject_cert"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).subject_req) as usize - ptr as usize },
        24usize,
        "Offset of field: v3_ext_ctx::subject_req"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).crl) as usize - ptr as usize },
        32usize,
        "Offset of field: v3_ext_ctx::crl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        40usize,
        "Offset of field: v3_ext_ctx::db"
    );
}
impl Default for v3_ext_ctx {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct X509_algor_st {
    pub algorithm: *mut ASN1_OBJECT,
    pub parameter: *mut ASN1_TYPE,
}
#[test]
fn bindgen_test_layout_X509_algor_st() {
    const UNINIT: ::std::mem::MaybeUninit<X509_algor_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<X509_algor_st>(),
        16usize,
        "Size of X509_algor_st"
    );
    assert_eq!(
        ::std::mem::align_of::<X509_algor_st>(),
        8usize,
        "Alignment of X509_algor_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).algorithm) as usize - ptr as usize },
        0usize,
        "Offset of field: X509_algor_st::algorithm"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).parameter) as usize - ptr as usize },
        8usize,
        "Offset of field: X509_algor_st::parameter"
    );
}
impl Default for X509_algor_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct x509_trust_st {
    pub trust: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
    pub check_trust: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const X509_TRUST, arg2: *mut X509) -> ::std::os::raw::c_int,
    >,
    pub name: *mut ::std::os::raw::c_char,
    pub arg1: ::std::os::raw::c_int,
    pub arg2: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_x509_trust_st() {
    const UNINIT: ::std::mem::MaybeUninit<x509_trust_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<x509_trust_st>(),
        40usize,
        "Size of x509_trust_st"
    );
    assert_eq!(
        ::std::mem::align_of::<x509_trust_st>(),
        8usize,
        "Alignment of x509_trust_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).trust) as usize - ptr as usize },
        0usize,
        "Offset of field: x509_trust_st::trust"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        4usize,
        "Offset of field: x509_trust_st::flags"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).check_trust) as usize - ptr as usize },
        8usize,
        "Offset of field: x509_trust_st::check_trust"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        "Offset of field: x509_trust_st::name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arg1) as usize - ptr as usize },
        24usize,
        "Offset of field: x509_trust_st::arg1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).arg2) as usize - ptr as usize },
        32usize,
        "Offset of field: x509_trust_st::arg2"
    );
}
impl Default for x509_trust_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct BASIC_CONSTRAINTS_st {
    pub ca: ASN1_BOOLEAN,
    pub pathlen: *mut ASN1_INTEGER,
}
#[test]
fn bindgen_test_layout_BASIC_CONSTRAINTS_st() {
    const UNINIT: ::std::mem::MaybeUninit<BASIC_CONSTRAINTS_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<BASIC_CONSTRAINTS_st>(),
        16usize,
        "Size of BASIC_CONSTRAINTS_st"
    );
    assert_eq!(
        ::std::mem::align_of::<BASIC_CONSTRAINTS_st>(),
        8usize,
        "Alignment of BASIC_CONSTRAINTS_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ca) as usize - ptr as usize },
        0usize,
        "Offset of field: BASIC_CONSTRAINTS_st::ca"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pathlen) as usize - ptr as usize },
        8usize,
        "Offset of field: BASIC_CONSTRAINTS_st::pathlen"
    );
}
impl Default for BASIC_CONSTRAINTS_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct DIST_POINT_NAME_st {
    pub type_: ::std::os::raw::c_int,
    pub name: DIST_POINT_NAME_st__bindgen_ty_1,
    pub dpname: *mut X509_NAME,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union DIST_POINT_NAME_st__bindgen_ty_1 {
    pub fullname: *mut GENERAL_NAMES,
    pub relativename: *mut stack_st_X509_NAME_ENTRY,
}
#[test]
fn bindgen_test_layout_DIST_POINT_NAME_st__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<DIST_POINT_NAME_st__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DIST_POINT_NAME_st__bindgen_ty_1>(),
        8usize,
        "Size of DIST_POINT_NAME_st__bindgen_ty_1"
    );
    assert_eq!(
        ::std::mem::align_of::<DIST_POINT_NAME_st__bindgen_ty_1>(),
        8usize,
        "Alignment of DIST_POINT_NAME_st__bindgen_ty_1"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fullname) as usize - ptr as usize },
        0usize,
        "Offset of field: DIST_POINT_NAME_st__bindgen_ty_1::fullname"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).relativename) as usize - ptr as usize },
        0usize,
        "Offset of field: DIST_POINT_NAME_st__bindgen_ty_1::relativename"
    );
}
impl Default for DIST_POINT_NAME_st__bindgen_ty_1 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[test]
fn bindgen_test_layout_DIST_POINT_NAME_st() {
    const UNINIT: ::std::mem::MaybeUninit<DIST_POINT_NAME_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DIST_POINT_NAME_st>(),
        24usize,
        "Size of DIST_POINT_NAME_st"
    );
    assert_eq!(
        ::std::mem::align_of::<DIST_POINT_NAME_st>(),
        8usize,
        "Alignment of DIST_POINT_NAME_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        "Offset of field: DIST_POINT_NAME_st::type_"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        "Offset of field: DIST_POINT_NAME_st::name"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dpname) as usize - ptr as usize },
        16usize,
        "Offset of field: DIST_POINT_NAME_st::dpname"
    );
}
impl Default for DIST_POINT_NAME_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type DIST_POINT_NAME = DIST_POINT_NAME_st;
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct DIST_POINT_st {
    pub distpoint: *mut DIST_POINT_NAME,
    pub reasons: *mut ASN1_BIT_STRING,
    pub CRLissuer: *mut GENERAL_NAMES,
}
#[test]
fn bindgen_test_layout_DIST_POINT_st() {
    const UNINIT: ::std::mem::MaybeUninit<DIST_POINT_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<DIST_POINT_st>(),
        24usize,
        "Size of DIST_POINT_st"
    );
    assert_eq!(
        ::std::mem::align_of::<DIST_POINT_st>(),
        8usize,
        "Alignment of DIST_POINT_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).distpoint) as usize - ptr as usize },
        0usize,
        "Offset of field: DIST_POINT_st::distpoint"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reasons) as usize - ptr as usize },
        8usize,
        "Offset of field: DIST_POINT_st::reasons"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).CRLissuer) as usize - ptr as usize },
        16usize,
        "Offset of field: DIST_POINT_st::CRLissuer"
    );
}
impl Default for DIST_POINT_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct AUTHORITY_KEYID_st {
    pub keyid: *mut ASN1_OCTET_STRING,
    pub issuer: *mut GENERAL_NAMES,
    pub serial: *mut ASN1_INTEGER,
}
#[test]
fn bindgen_test_layout_AUTHORITY_KEYID_st() {
    const UNINIT: ::std::mem::MaybeUninit<AUTHORITY_KEYID_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<AUTHORITY_KEYID_st>(),
        24usize,
        "Size of AUTHORITY_KEYID_st"
    );
    assert_eq!(
        ::std::mem::align_of::<AUTHORITY_KEYID_st>(),
        8usize,
        "Alignment of AUTHORITY_KEYID_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).keyid) as usize - ptr as usize },
        0usize,
        "Offset of field: AUTHORITY_KEYID_st::keyid"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).issuer) as usize - ptr as usize },
        8usize,
        "Offset of field: AUTHORITY_KEYID_st::issuer"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).serial) as usize - ptr as usize },
        16usize,
        "Offset of field: AUTHORITY_KEYID_st::serial"
    );
}
impl Default for AUTHORITY_KEYID_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_st_GENERAL_SUBTREE {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct NAME_CONSTRAINTS_st {
    pub permittedSubtrees: *mut stack_st_GENERAL_SUBTREE,
    pub excludedSubtrees: *mut stack_st_GENERAL_SUBTREE,
}
#[test]
fn bindgen_test_layout_NAME_CONSTRAINTS_st() {
    const UNINIT: ::std::mem::MaybeUninit<NAME_CONSTRAINTS_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NAME_CONSTRAINTS_st>(),
        16usize,
        "Size of NAME_CONSTRAINTS_st"
    );
    assert_eq!(
        ::std::mem::align_of::<NAME_CONSTRAINTS_st>(),
        8usize,
        "Alignment of NAME_CONSTRAINTS_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).permittedSubtrees) as usize - ptr as usize },
        0usize,
        "Offset of field: NAME_CONSTRAINTS_st::permittedSubtrees"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).excludedSubtrees) as usize - ptr as usize },
        8usize,
        "Offset of field: NAME_CONSTRAINTS_st::excludedSubtrees"
    );
}
impl Default for NAME_CONSTRAINTS_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct ISSUING_DIST_POINT_st {
    pub distpoint: *mut DIST_POINT_NAME,
    pub onlyuser: ASN1_BOOLEAN,
    pub onlyCA: ASN1_BOOLEAN,
    pub onlysomereasons: *mut ASN1_BIT_STRING,
    pub indirectCRL: ASN1_BOOLEAN,
    pub onlyattr: ASN1_BOOLEAN,
}
#[test]
fn bindgen_test_layout_ISSUING_DIST_POINT_st() {
    const UNINIT: ::std::mem::MaybeUninit<ISSUING_DIST_POINT_st> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<ISSUING_DIST_POINT_st>(),
        32usize,
        "Size of ISSUING_DIST_POINT_st"
    );
    assert_eq!(
        ::std::mem::align_of::<ISSUING_DIST_POINT_st>(),
        8usize,
        "Alignment of ISSUING_DIST_POINT_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).distpoint) as usize - ptr as usize },
        0usize,
        "Offset of field: ISSUING_DIST_POINT_st::distpoint"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onlyuser) as usize - ptr as usize },
        8usize,
        "Offset of field: ISSUING_DIST_POINT_st::onlyuser"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onlyCA) as usize - ptr as usize },
        12usize,
        "Offset of field: ISSUING_DIST_POINT_st::onlyCA"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onlysomereasons) as usize - ptr as usize },
        16usize,
        "Offset of field: ISSUING_DIST_POINT_st::onlysomereasons"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).indirectCRL) as usize - ptr as usize },
        24usize,
        "Offset of field: ISSUING_DIST_POINT_st::indirectCRL"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).onlyattr) as usize - ptr as usize },
        28usize,
        "Offset of field: ISSUING_DIST_POINT_st::onlyattr"
    );
}
impl Default for ISSUING_DIST_POINT_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type poly1305_state = [u8; 512usize];
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_poly1305_init"]
    pub fn CRYPTO_poly1305_init(state: *mut poly1305_state, key: *const u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_poly1305_update"]
    pub fn CRYPTO_poly1305_update(state: *mut poly1305_state, in_: *const u8, in_len: usize);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_CRYPTO_poly1305_finish"]
    pub fn CRYPTO_poly1305_finish(state: *mut poly1305_state, mac: *mut u8);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_bytes"]
    pub fn RAND_bytes(buf: *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_priv_bytes"]
    pub fn RAND_priv_bytes(buf: *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_bytes_with_user_prediction_resistance"]
    pub fn RAND_bytes_with_user_prediction_resistance(
        out: *mut u8,
        out_len: usize,
        user_pred_resistance: *const u8,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RAND_get_system_entropy_for_custom_prng(buf: *mut u8, len: usize);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_pseudo_bytes"]
    pub fn RAND_pseudo_bytes(buf: *mut u8, len: usize) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_seed"]
    pub fn RAND_seed(buf: *const ::std::os::raw::c_void, num: ::std::os::raw::c_int);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_load_file"]
    pub fn RAND_load_file(
        path: *const ::std::os::raw::c_char,
        num: ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_write_file"]
    pub fn RAND_write_file(file: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_file_name"]
    pub fn RAND_file_name(
        buf: *mut ::std::os::raw::c_char,
        num: usize,
    ) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_add"]
    pub fn RAND_add(buf: *const ::std::os::raw::c_void, num: ::std::os::raw::c_int, entropy: f64);
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_egd"]
    pub fn RAND_egd(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_egd_bytes"]
    pub fn RAND_egd_bytes(
        arg1: *const ::std::os::raw::c_char,
        bytes: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_poll"]
    pub fn RAND_poll() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_status"]
    pub fn RAND_status() -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_cleanup"]
    pub fn RAND_cleanup();
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone, PartialEq, Eq)]
pub struct rand_meth_st {
    pub seed: ::std::option::Option<
        unsafe extern "C" fn(buf: *const ::std::os::raw::c_void, num: ::std::os::raw::c_int),
    >,
    pub bytes: ::std::option::Option<
        unsafe extern "C" fn(buf: *mut u8, num: usize) -> ::std::os::raw::c_int,
    >,
    pub cleanup: ::std::option::Option<unsafe extern "C" fn()>,
    pub add: ::std::option::Option<
        unsafe extern "C" fn(
            buf: *const ::std::os::raw::c_void,
            num: ::std::os::raw::c_int,
            entropy: f64,
        ),
    >,
    pub pseudorand: ::std::option::Option<
        unsafe extern "C" fn(buf: *mut u8, num: usize) -> ::std::os::raw::c_int,
    >,
    pub status: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
}
#[test]
fn bindgen_test_layout_rand_meth_st() {
    const UNINIT: ::std::mem::MaybeUninit<rand_meth_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rand_meth_st>(),
        48usize,
        "Size of rand_meth_st"
    );
    assert_eq!(
        ::std::mem::align_of::<rand_meth_st>(),
        8usize,
        "Alignment of rand_meth_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).seed) as usize - ptr as usize },
        0usize,
        "Offset of field: rand_meth_st::seed"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bytes) as usize - ptr as usize },
        8usize,
        "Offset of field: rand_meth_st::bytes"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cleanup) as usize - ptr as usize },
        16usize,
        "Offset of field: rand_meth_st::cleanup"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).add) as usize - ptr as usize },
        24usize,
        "Offset of field: rand_meth_st::add"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pseudorand) as usize - ptr as usize },
        32usize,
        "Offset of field: rand_meth_st::pseudorand"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        40usize,
        "Offset of field: rand_meth_st::status"
    );
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_SSLeay"]
    pub fn RAND_SSLeay() -> *mut RAND_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_OpenSSL"]
    pub fn RAND_OpenSSL() -> *mut RAND_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_get_rand_method"]
    pub fn RAND_get_rand_method() -> *const RAND_METHOD;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_set_rand_method"]
    pub fn RAND_set_rand_method(arg1: *const RAND_METHOD) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_RAND_keep_random_devices_open"]
    pub fn RAND_keep_random_devices_open(a: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct rc4_key_st {
    pub x: u32,
    pub y: u32,
    pub data: [u32; 256usize],
}
#[test]
fn bindgen_test_layout_rc4_key_st() {
    const UNINIT: ::std::mem::MaybeUninit<rc4_key_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<rc4_key_st>(),
        1032usize,
        "Size of rc4_key_st"
    );
    assert_eq!(
        ::std::mem::align_of::<rc4_key_st>(),
        4usize,
        "Alignment of rc4_key_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).x) as usize - ptr as usize },
        0usize,
        "Offset of field: rc4_key_st::x"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).y) as usize - ptr as usize },
        4usize,
        "Offset of field: rc4_key_st::y"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        "Offset of field: rc4_key_st::data"
    );
}
impl Default for rc4_key_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct RIPEMD160state_st {
    pub h: [u32; 5usize],
    pub Nl: u32,
    pub Nh: u32,
    pub data: [u8; 64usize],
    pub num: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_RIPEMD160state_st() {
    const UNINIT: ::std::mem::MaybeUninit<RIPEMD160state_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<RIPEMD160state_st>(),
        96usize,
        "Size of RIPEMD160state_st"
    );
    assert_eq!(
        ::std::mem::align_of::<RIPEMD160state_st>(),
        4usize,
        "Alignment of RIPEMD160state_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).h) as usize - ptr as usize },
        0usize,
        "Offset of field: RIPEMD160state_st::h"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nl) as usize - ptr as usize },
        20usize,
        "Offset of field: RIPEMD160state_st::Nl"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).Nh) as usize - ptr as usize },
        24usize,
        "Offset of field: RIPEMD160state_st::Nh"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        28usize,
        "Offset of field: RIPEMD160state_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).num) as usize - ptr as usize },
        92usize,
        "Offset of field: RIPEMD160state_st::num"
    );
}
impl Default for RIPEMD160state_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct trust_token_st {
    pub data: *mut u8,
    pub len: usize,
}
#[test]
fn bindgen_test_layout_trust_token_st() {
    const UNINIT: ::std::mem::MaybeUninit<trust_token_st> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<trust_token_st>(),
        16usize,
        "Size of trust_token_st"
    );
    assert_eq!(
        ::std::mem::align_of::<trust_token_st>(),
        8usize,
        "Alignment of trust_token_st"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        "Offset of field: trust_token_st::data"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).len) as usize - ptr as usize },
        8usize,
        "Offset of field: trust_token_st::len"
    );
}
impl Default for trust_token_st {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_GET_LIB_RUST"]
    pub fn ERR_GET_LIB_RUST(packed_error: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_GET_REASON_RUST"]
    pub fn ERR_GET_REASON_RUST(packed_error: u32) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}aws_lc_0_34_0_ERR_GET_FUNC_RUST"]
    pub fn ERR_GET_FUNC_RUST(packed_error: u32) -> ::std::os::raw::c_int;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone, PartialEq, Eq)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    const UNINIT: ::std::mem::MaybeUninit<__va_list_tag> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        "Size of __va_list_tag"
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        "Alignment of __va_list_tag"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gp_offset) as usize - ptr as usize },
        0usize,
        "Offset of field: __va_list_tag::gp_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fp_offset) as usize - ptr as usize },
        4usize,
        "Offset of field: __va_list_tag::fp_offset"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).overflow_arg_area) as usize - ptr as usize },
        8usize,
        "Offset of field: __va_list_tag::overflow_arg_area"
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reg_save_area) as usize - ptr as usize },
        16usize,
        "Offset of field: __va_list_tag::reg_save_area"
    );
}
impl Default for __va_list_tag {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
