/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.parser.jackson;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.dto.RuleTemplateDTO;
import org.openhab.core.automation.dto.RuleTemplateDTOMapper;
import org.openhab.core.automation.internal.parser.jackson.AbstractJacksonYAMLParser;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.automation.parser.ParsingException;
import org.openhab.core.automation.parser.ParsingNestedException;
import org.openhab.core.automation.template.Template;
import org.osgi.service.component.annotations.Component;

@NonNullByDefault
@Component(immediate=true, service={Parser.class}, property={"parser.type=parser.template", "format=yaml"})
public class TemplateYAMLParser
extends AbstractJacksonYAMLParser<Template> {
    @Override
    public Set<Template> parse(InputStreamReader reader) throws ParsingException {
        try {
            HashSet<Template> templates = new HashSet<Template>();
            JsonNode rootNode = YAML_MAPPER.readTree((Reader)reader);
            if (rootNode.isArray()) {
                List templateDtos = (List)YAML_MAPPER.convertValue((Object)rootNode, (TypeReference)new TypeReference<List<RuleTemplateDTO>>(){});
                for (RuleTemplateDTO templateDTO : templateDtos) {
                    templates.add(RuleTemplateDTOMapper.map(templateDTO));
                }
            } else {
                RuleTemplateDTO templateDto = (RuleTemplateDTO)YAML_MAPPER.convertValue((Object)rootNode, (TypeReference)new TypeReference<RuleTemplateDTO>(){});
                templates.add(RuleTemplateDTOMapper.map(templateDto));
            }
            HashSet<Template> hashSet = templates;
            return hashSet;
        }
        catch (Exception e) {
            throw new ParsingException(new ParsingNestedException(2, null, e));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

