/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScriptModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenResponseMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.scripting.EvaluatableScriptAdapter;
import org.keycloak.scripting.ScriptCompilationException;
import org.keycloak.scripting.ScriptingProvider;

public class ScriptBasedOIDCProtocolMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper,
OIDCAccessTokenResponseMapper,
TokenIntrospectionTokenMapper,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "oidc-script-based-protocol-mapper";
    private static final Logger LOGGER = Logger.getLogger(ScriptBasedOIDCProtocolMapper.class);
    public static final String SCRIPT = "script";
    private static final List<ProviderConfigProperty> configProperties = ProviderConfigurationBuilder.create().property().name("script").type("Script").label("Script").helpText("Script to compute the claim value. \n Available variables: \n 'user' - the current user.\n 'realm' - the current realm.\n 'token' - the current token.\n 'userSession' - the current userSession.\n 'keycloakSession' - the current keycloakSession.\n").defaultValue((Object)"/**\n * Available variables: \n * user - the current user\n * realm - the current realm\n * token - the current token\n * userSession - the current userSession\n * keycloakSession - the current keycloakSession\n */\n\n\n//insert your code here...").add().property().name("multivalued").label("multivalued.label").helpText("multivalued.tooltip").type("boolean").defaultValue((Object)false).add().build();

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Script Mapper";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Evaluates a JavaScript function to produce a token claim based on context information.";
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }

    public int getPriority() {
        return 50;
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        Object claimValue = this.evaluateScript(token, mappingModel, userSession, keycloakSession);
        OIDCAttributeMapperHelper.mapClaim(token, mappingModel, claimValue);
    }

    @Override
    protected void setClaim(AccessTokenResponse accessTokenResponse, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        Object claimValue = this.evaluateScript(accessTokenResponse, mappingModel, userSession, keycloakSession);
        OIDCAttributeMapperHelper.mapClaim(accessTokenResponse, mappingModel, claimValue);
    }

    private Object evaluateScript(Object tokenBinding, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession) {
        Object claimValue;
        UserModel user = userSession.getUser();
        String scriptSource = this.getScriptCode(mappingModel);
        RealmModel realm = userSession.getRealm();
        ScriptingProvider scripting = (ScriptingProvider)keycloakSession.getProvider(ScriptingProvider.class);
        ScriptModel scriptModel = scripting.createScript(realm.getId(), "text/javascript", "token-mapper-script_" + mappingModel.getName(), scriptSource, null);
        EvaluatableScriptAdapter script = scripting.prepareEvaluatableScript(scriptModel);
        try {
            claimValue = script.eval(bindings -> {
                bindings.put("user", (Object)user);
                bindings.put("realm", (Object)realm);
                if (tokenBinding instanceof IDToken) {
                    bindings.put("token", tokenBinding);
                } else if (tokenBinding instanceof AccessTokenResponse) {
                    bindings.put("tokenResponse", tokenBinding);
                }
                bindings.put("userSession", (Object)userSession);
                bindings.put("keycloakSession", (Object)keycloakSession);
            });
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error during execution of ProtocolMapper script", (Throwable)ex);
            claimValue = null;
        }
        return claimValue;
    }

    public void validateConfig(KeycloakSession session, RealmModel realm, ProtocolMapperContainerModel client, ProtocolMapperModel mapperModel) throws ProtocolMapperConfigException {
        String scriptCode = this.getScriptCode(mapperModel);
        if (scriptCode == null) {
            return;
        }
        ScriptingProvider scripting = (ScriptingProvider)session.getProvider(ScriptingProvider.class);
        ScriptModel scriptModel = scripting.createScript(realm.getId(), "text/javascript", mapperModel.getName() + "-script", scriptCode, "");
        try {
            scripting.prepareEvaluatableScript(scriptModel);
        }
        catch (ScriptCompilationException ex) {
            throw new ProtocolMapperConfigException("error", "{0}", new Object[]{ex.getMessage()});
        }
    }

    protected String getScriptCode(ProtocolMapperModel mapperModel) {
        return (String)mapperModel.getConfig().get(SCRIPT);
    }

    public static ProtocolMapperModel create(String name, String userAttribute, String tokenClaimName, String claimType, boolean accessToken, boolean idToken, boolean introspectionEndpoint, String script, boolean multiValued) {
        ProtocolMapperModel mapper = OIDCAttributeMapperHelper.createClaimMapper(name, userAttribute, tokenClaimName, claimType, accessToken, idToken, introspectionEndpoint, script);
        mapper.getConfig().put("multivalued", String.valueOf(multiValued));
        return mapper;
    }

    static {
        OIDCAttributeMapperHelper.addAttributeConfig(configProperties, UserPropertyMapper.class);
    }
}

