/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.userprofile.AttributeContext;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.utils.StringUtil;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class MultiValueValidator
implements SimpleValidator,
ConfiguredProvider {
    public static final String ID = "multivalued";
    public static final String MESSAGE_INVALID_SIZE = "error-invalid-multivalued-size";
    public static final String KEY_MIN = "min";
    public static final String KEY_MAX = "max";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object value, String inputHint, ValidationContext context, ValidatorConfig config) {
        AttributeContext attributeContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        Long min = Optional.ofNullable(config.getLong(KEY_MIN)).orElse(this.getDefaultMinSize(context));
        Long max = config.getLong(KEY_MAX);
        if (!(value instanceof Collection)) {
            this.addError(inputHint, context, min, max);
            return context;
        }
        long length = ((Collection)value).stream().filter(StringUtil::isNotBlank).count();
        if (length == 0L && attributeContext.getMetadata().isRequired(attributeContext)) {
            return context;
        }
        if (length < min || length > max) {
            this.addError(inputHint, context, min, max);
            return context;
        }
        return context;
    }

    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        if (ValidatorConfig.isEmpty((ValidatorConfig)config)) {
            return ValidationResult.of((ValidationError[])new ValidationError[]{new ValidationError(ID, KEY_MAX, "error-validator-config-missing-value")});
        }
        HashSet<ValidationError> errors = new HashSet<ValidationError>();
        Long min = config.getLong(KEY_MIN);
        Long max = config.getLong(KEY_MAX);
        if (min == null && config.containsKey(KEY_MIN)) {
            errors.add(new ValidationError(ID, KEY_MIN, "error-validator-config-invalid-number-value"));
        }
        if (max == null) {
            errors.add(new ValidationError(ID, KEY_MAX, config.containsKey(KEY_MAX) ? "error-validator-config-invalid-number-value" : "error-validator-config-missing-value"));
        } else if (min != null && min > max) {
            errors.add(new ValidationError(ID, KEY_MAX, "error-validator-config-invalid-value"));
        }
        return ValidationResult.of(errors);
    }

    public String getHelpText() {
        return "Multivalued validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        ArrayList<ProviderConfigProperty> properties = new ArrayList<ProviderConfigProperty>();
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(KEY_MIN);
        property.setLabel("Minimum size");
        property.setHelpText("The minimum size");
        property.setType("String");
        properties.add(property);
        property = new ProviderConfigProperty();
        property.setName(KEY_MAX);
        property.setLabel("Maximum size");
        property.setHelpText("The maximum size");
        property.setType("String");
        properties.add(property);
        return properties;
    }

    private long getDefaultMinSize(ValidationContext context) {
        AttributeContext attributeContext = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext();
        AttributeMetadata metadata = attributeContext.getMetadata();
        return metadata.isRequired(attributeContext) ? 1L : 0L;
    }

    private void addError(String inputHint, ValidationContext context, Long min, Long max) {
        context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_SIZE, new Object[]{min, max}));
    }
}

