/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal.implicit;

import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderEmbeddable;
import org.hibernate.query.results.internal.DomainResultCreationStateImpl;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class ImplicitModelPartResultBuilderEmbeddable
implements ImplicitModelPartResultBuilder,
ResultBuilderEmbeddable {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart modelPart;

    public ImplicitModelPartResultBuilderEmbeddable(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getJavaType().getJavaTypeClass();
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }

    @Override
    public EmbeddableResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        creationStateImpl.disallowPositionalSelections();
        return (EmbeddableResult)this.modelPart.createDomainResult(this.navigablePath, this.tableGroup(creationStateImpl), null, domainResultCreationState);
    }

    private TableGroup tableGroup(DomainResultCreationStateImpl creationStateImpl) {
        return creationStateImpl.getFromClauseAccess().resolveTableGroup(this.navigablePath, np -> {
            if (this.navigablePath.getParent() == null) {
                throw new IllegalStateException("Could not determine LHS for implicit embeddable result builder - " + String.valueOf(this.navigablePath));
            }
            TableGroup parentTableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
            TableGroupJoin tableGroupJoin = this.modelPart.createTableGroupJoin(this.navigablePath, parentTableGroup, null, null, SqlAstJoinType.INNER, true, false, creationStateImpl);
            parentTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitModelPartResultBuilderEmbeddable that = (ImplicitModelPartResultBuilderEmbeddable)o;
        return this.navigablePath.equals(that.navigablePath) && this.modelPart.equals(that.modelPart);
    }

    public int hashCode() {
        int result = this.navigablePath.hashCode();
        result = 31 * result + this.modelPart.hashCode();
        return result;
    }
}

