/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.util.ECUtil;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.NamedParameterSpec;
import org.jetbrains.annotations.NotNull;

public enum Curve {
    SECP256R1(1, 32),
    SECP384R1(2, 48),
    SECP521R1(3, 66),
    ED25519(6, 32);

    private final int value;
    private final int size;

    private Curve(int value, int size) {
        this.value = value;
        this.size = size;
    }

    @NotNull
    public static Curve create(int value) {
        switch (value) {
            case 1: {
                return SECP256R1;
            }
            case 2: {
                return SECP384R1;
            }
            case 3: {
                return SECP521R1;
            }
            case 6: {
                return ED25519;
            }
        }
        throw new IllegalArgumentException("value '" + value + "' is out of range");
    }

    @JsonCreator
    @NotNull
    public static Curve deserialize(int value) throws InvalidFormatException {
        try {
            return Curve.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, Curve.class);
        }
    }

    @JsonValue
    public int getValue() {
        return this.value;
    }

    public int getSize() {
        return this.size;
    }

    @NotNull
    public AlgorithmParameterSpec getParameterSpec() {
        switch (this) {
            case SECP256R1: {
                return ECUtil.P_256_SPEC;
            }
            case SECP384R1: {
                return ECUtil.P_384_SPEC;
            }
            case SECP521R1: {
                return ECUtil.P_521_SPEC;
            }
            case ED25519: {
                return new NamedParameterSpec("Ed25519");
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        switch (this) {
            case SECP256R1: {
                return "SECP256R1";
            }
            case SECP384R1: {
                return "SECP384R1";
            }
            case SECP521R1: {
                return "SECP521R1";
            }
            case ED25519: {
                return "ED25519";
            }
        }
        return "Unknown Curve";
    }
}

