/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.model.ReferenceType;
import io.smallrye.openapi.runtime.io.JsonIO;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.Reference;
import org.jboss.jandex.AnnotationInstance;

public interface ReferenceIO<V, A extends V, O extends V, AB, OB> {
    public static final String REF = "$ref";

    public JsonIO<V, A, O, AB, OB> jsonIO();

    default public boolean isReference(Object model) {
        return model instanceof Reference && this.isReference((Reference)model);
    }

    default public boolean isReference(String name) {
        return REF.equals(name);
    }

    default public boolean isReference(Map.Entry<String, ?> entry) {
        return this.isReference(entry.getKey());
    }

    default public boolean isReference(AnnotationInstance annotation) {
        return ReferenceType.isReference((AnnotationInstance)annotation);
    }

    default public boolean isReference(Reference<?> model) {
        String ref = model.getRef();
        return ref != null && !ref.trim().isEmpty();
    }

    default public String readReference(O node) {
        return this.jsonIO().getString(node, REF);
    }

    default public void setReference(OB object, Reference<?> model) {
        this.jsonIO().toJson(model.getRef()).ifPresent(value -> this.jsonIO().set(object, REF, value));
    }
}

