/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.AbstractTaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveException;
import org.gradle.api.internal.tasks.WorkDependencyResolver;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;

@NonNullApi
public class CachingTaskDependencyResolveContext<T>
extends AbstractTaskDependencyResolveContext {
    private final Deque<Object> queue = new ArrayDeque<Object>();
    private final CachingDirectedGraphWalker<Object, T> walker;
    private Task task;

    public CachingTaskDependencyResolveContext(Collection<? extends WorkDependencyResolver<T>> workResolvers) {
        this.walker = new CachingDirectedGraphWalker((DirectedGraph)new TaskGraphImpl(workResolvers));
    }

    public Set<T> getDependencies(@Nullable Task task, Object dependencies) {
        Preconditions.checkState((this.task == null ? 1 : 0) != 0);
        this.task = task;
        try {
            this.walker.add(new Object[]{dependencies});
            Set set = this.walker.findValues();
            return set;
        }
        catch (Exception e) {
            if (task != null) {
                throw new TaskDependencyResolveException(String.format("Could not determine the dependencies of %s.", task), e);
            }
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.queue.clear();
            this.task = null;
        }
    }

    @Override
    @Nullable
    public Task getTask() {
        return this.task;
    }

    @Override
    public void add(Object dependency) {
        Preconditions.checkNotNull((Object)dependency);
        if (dependency == TaskDependencyContainer.EMPTY) {
            return;
        }
        this.queue.add(dependency);
    }

    private class TaskGraphImpl
    implements DirectedGraph<Object, T> {
        private final Collection<? extends WorkDependencyResolver<T>> workResolvers;

        public TaskGraphImpl(Collection<? extends WorkDependencyResolver<T>> workResolvers) {
            this.workResolvers = workResolvers;
        }

        public void getNodeValues(Object node, Collection<? super T> values, Collection<? super Object> connectedNodes) {
            if (node instanceof TaskDependencyContainer) {
                TaskDependencyContainer taskDependency = (TaskDependencyContainer)node;
                CachingTaskDependencyResolveContext.this.queue.clear();
                taskDependency.visitDependencies(CachingTaskDependencyResolveContext.this);
                connectedNodes.addAll(CachingTaskDependencyResolveContext.this.queue);
                return;
            }
            if (node instanceof Buildable) {
                Buildable buildable = (Buildable)node;
                connectedNodes.add(buildable.getBuildDependencies());
                return;
            }
            for (WorkDependencyResolver workResolver : this.workResolvers) {
                if (!workResolver.resolve(CachingTaskDependencyResolveContext.this.task, node, values::add)) continue;
                return;
            }
            throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s to a Task.", node.getClass().getSimpleName()));
        }
    }
}

