/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal.pgp;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryFactory;
import org.gradle.security.internal.BaseSignatoryProvider;

public class BasePgpSignatoryProvider
implements BaseSignatoryProvider<PgpSignatory> {
    private final PgpSignatoryFactory factory = new PgpSignatoryFactory();
    private final Map<String, PgpSignatory> signatories = new LinkedHashMap<String, PgpSignatory>();

    @Override
    public PgpSignatory getDefaultSignatory(Project project) {
        return this.factory.createSignatory(project);
    }

    @Override
    public PgpSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    public PgpSignatory createSignatory(String name, String keyId, File keyRing, String password) {
        return this.signatories.put(name, this.factory.createSignatory(name, keyId, keyRing, password));
    }

    public PgpSignatory createSignatory(Project project, String name, boolean required) {
        return this.signatories.put(name, this.factory.createSignatory(project, name, required));
    }
}

