/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public class NameSpaceSymbTableTest
extends TestCase {
    static Attr node1;
    static Attr node2;
    static /* synthetic */ Class class$org$apache$xml$security$c14n$implementations$NameSpaceSymbTableTest;

    public static Test suite() {
        return new TestSuite(class$org$apache$xml$security$c14n$implementations$NameSpaceSymbTableTest == null ? (class$org$apache$xml$security$c14n$implementations$NameSpaceSymbTableTest = NameSpaceSymbTableTest.class$("org.apache.xml.security.c14n.implementations.NameSpaceSymbTableTest")) : class$org$apache$xml$security$c14n$implementations$NameSpaceSymbTableTest);
    }

    public void testNullFirstXmlns() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        NameSpaceSymbTableTest.assertNull((Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testXmlnsPut() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testXmlnsMap() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("xmlns"));
        nameSpaceSymbTable.pop();
        NameSpaceSymbTableTest.assertEquals(null, (Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testXmlnsMap2() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        nameSpaceSymbTable.pop();
        nameSpaceSymbTable.pop();
        NameSpaceSymbTableTest.assertEquals(null, (Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testXmlnsPrefix() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("xmlns"));
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals(null, (Object)nameSpaceSymbTable.getMapping("xmlns"));
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://b", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testXmlnsRemovePrefix() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("xmlns"));
        nameSpaceSymbTable.pop();
        NameSpaceSymbTableTest.assertNull((Object)nameSpaceSymbTable.getMapping("xmlns"));
    }

    public void testPrefix() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("a", "http://a", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
        nameSpaceSymbTable.push();
        NameSpaceSymbTableTest.assertNull((Object)nameSpaceSymbTable.getMapping("a"));
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("a", "http://c", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
        nameSpaceSymbTable.pop();
        nameSpaceSymbTable.push();
        NameSpaceSymbTableTest.assertNull((Object)nameSpaceSymbTable.getMapping("a"));
        nameSpaceSymbTable.addMapping("a", "http://c", node1);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
    }

    public void testSeveralPrefixes() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("a", "http://a", node1);
        nameSpaceSymbTable.addMapping("b", "http://b", node2);
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
        NameSpaceSymbTableTest.assertEquals((Object)node2, (Object)nameSpaceSymbTable.getMapping("b"));
        nameSpaceSymbTable.push();
        NameSpaceSymbTableTest.assertNull((Object)nameSpaceSymbTable.getMapping("a"));
    }

    public void testSeveralPrefixes2() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("a", "http://a", node1);
        nameSpaceSymbTable.push();
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
        nameSpaceSymbTable.pop();
        NameSpaceSymbTableTest.assertEquals((Object)node1, (Object)nameSpaceSymbTable.getMapping("a"));
    }

    public void testGetUnrenderedNodes() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        ArrayList arrayList = new ArrayList();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.getUnrenderedNodes(arrayList);
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.contains(node1));
        Attr attr = (Attr)nameSpaceSymbTable.addMappingAndRender("xmlns", "", node2);
        NameSpaceSymbTableTest.assertNotNull((String)"xmlns=\"\" not rendered", (Object)attr);
        NameSpaceSymbTableTest.assertEquals((Object)attr, (Object)node2);
    }

    public void testUnrederedNodes() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        ArrayList arrayList = new ArrayList();
        nameSpaceSymbTable.getUnrenderedNodes(arrayList);
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.isEmpty());
        arrayList.clear();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMapping("xmlns", "http://a", node1);
        nameSpaceSymbTable.addMapping("a", "http://a", node2);
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.getUnrenderedNodes(arrayList);
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.contains(node1));
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.contains(node2));
        nameSpaceSymbTable.push();
        arrayList.clear();
        nameSpaceSymbTable.getUnrenderedNodes(arrayList);
        NameSpaceSymbTableTest.assertFalse((boolean)arrayList.contains(node1));
        NameSpaceSymbTableTest.assertFalse((boolean)arrayList.contains(node2));
        nameSpaceSymbTable.pop();
        nameSpaceSymbTable.pop();
        arrayList.clear();
        nameSpaceSymbTable.getUnrenderedNodes(arrayList);
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.contains(node1));
        NameSpaceSymbTableTest.assertTrue((boolean)arrayList.contains(node2));
    }

    public void testBug38655() {
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        nameSpaceSymbTable.push();
        nameSpaceSymbTable.addMappingAndRender("generated-command", "http://foo.com/command", node1);
        nameSpaceSymbTable.addMappingAndRender("generated-event", "http://foo.com/event", node1);
        nameSpaceSymbTable.addMappingAndRender("command", "http://foo.com/command", node1);
        nameSpaceSymbTable.addMappingAndRender("ui", "http://foo.com/ui", node1);
        nameSpaceSymbTable.addMappingAndRender("event", "http://foo.com/event", node1);
        nameSpaceSymbTable.addMappingAndRender("instruction", "http://foo/instruction", node1);
        nameSpaceSymbTable.addMappingAndRender("directory", "http://foo.com/io/directory", node1);
        nameSpaceSymbTable.addMappingAndRender("function", "http://foo.com/function", node1);
        nameSpaceSymbTable.addMappingAndRender("xmlns", "http://www.w3.org/1999/xhtml", node1);
        nameSpaceSymbTable.addMappingAndRender("ctrl", "http://foo.com/controls", node1);
        nameSpaceSymbTable.addMappingAndRender("wiki", "http://foo.com/samples/wiki", node1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            node1 = document.createAttributeNS("a", "b");
            node2 = document.createAttributeNS("b", "c");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

