/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordTag;
import org.parosproxy.paros.db.TableTag;
import org.zaproxy.zap.db.sql.DbSQL;
import org.zaproxy.zap.db.sql.SqlAbstractTable;
import org.zaproxy.zap.db.sql.SqlPreparedStatementWrapper;

public class SqlTableTag
extends SqlAbstractTable
implements TableTag {
    private static final String TABLE_NAME = DbSQL.getSQL("tag.table_name");
    private static final String TAGID = DbSQL.getSQL("tag.field.tagid");
    private static final String HISTORYID = DbSQL.getSQL("tag.field.historyid");
    private static final String TAG = DbSQL.getSQL("tag.field.tag");

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, DbSQL.getSQL("tag.ps.createtable"));
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordTag read(long tagId) throws DatabaseException {
        SqlPreparedStatementWrapper psRead = null;
        try {
            RecordTag recordTag;
            block11: {
                psRead = DbSQL.getSingleton().getPreparedStatement("tag.ps.read");
                psRead.getPs().setLong(1, tagId);
                ResultSet rs = psRead.getPs().executeQuery();
                try {
                    recordTag = this.build(rs);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordTag;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psRead);
        }
    }

    @Override
    public synchronized RecordTag insert(long historyId, String tag) throws DatabaseException {
        SqlPreparedStatementWrapper psInsertTag = null;
        try {
            RecordTag recordTag;
            block11: {
                psInsertTag = DbSQL.getSingleton().getPreparedStatement("tag.ps.insert");
                psInsertTag.getPs().setLong(1, historyId);
                psInsertTag.getPs().setString(2, tag);
                psInsertTag.getPs().executeUpdate();
                ResultSet rs = psInsertTag.getLastInsertedId();
                try {
                    rs.next();
                    long id = rs.getLong(1);
                    recordTag = this.read(id);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DatabaseException(e);
                    }
                }
                rs.close();
            }
            return recordTag;
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psInsertTag);
        }
    }

    @Override
    public synchronized void delete(long historyId, String tag) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteTag = null;
        try {
            psDeleteTag = DbSQL.getSingleton().getPreparedStatement("tag.ps.delete");
            psDeleteTag.getPs().setLong(1, historyId);
            psDeleteTag.getPs().setString(2, tag);
            psDeleteTag.getPs().executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteTag);
        }
    }

    @Override
    public List<RecordTag> getTagsForHistoryID(long historyId) throws DatabaseException {
        SqlPreparedStatementWrapper psGetTagsForHistoryId = null;
        try {
            psGetTagsForHistoryId = DbSQL.getSingleton().getPreparedStatement("tag.ps.gettagsforhid");
            ArrayList<RecordTag> result = new ArrayList<RecordTag>();
            psGetTagsForHistoryId.getPs().setLong(1, historyId);
            try (ResultSet rs = psGetTagsForHistoryId.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(new RecordTag(rs.getLong(TAGID), rs.getLong(TAGID), rs.getString(TAG)));
                }
            }
            ArrayList<RecordTag> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetTagsForHistoryId);
        }
    }

    @Override
    public List<String> getAllTags() throws DatabaseException {
        SqlPreparedStatementWrapper psGetAllTags = null;
        try {
            psGetAllTags = DbSQL.getSingleton().getPreparedStatement("tag.ps.getalltags");
            ArrayList<String> result = new ArrayList<String>();
            try (ResultSet rs = psGetAllTags.getPs().executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(TAG));
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psGetAllTags);
        }
    }

    @Override
    public void deleteTagsForHistoryID(long historyId) throws DatabaseException {
        SqlPreparedStatementWrapper psDeleteTagsForHistoryId = null;
        try {
            psDeleteTagsForHistoryId = DbSQL.getSingleton().getPreparedStatement("tag.ps.deletetagsforhid");
            psDeleteTagsForHistoryId.getPs().setLong(1, historyId);
            psDeleteTagsForHistoryId.getPs().execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
        finally {
            DbSQL.getSingleton().releasePreparedStatement(psDeleteTagsForHistoryId);
        }
    }

    private RecordTag build(ResultSet rs) throws SQLException {
        RecordTag rt = null;
        if (rs.next()) {
            rt = new RecordTag(rs.getLong(TAGID), rs.getLong(HISTORYID), rs.getString(TAG));
        }
        return rt;
    }
}

