/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.openide.util.NbBundle;

class OpenDataSourceAction
extends MultiDataSourceAction<DataSource> {
    private static OpenDataSourceAction instance;

    public static synchronized OpenDataSourceAction instance() {
        if (instance == null) {
            instance = new OpenDataSourceAction();
        }
        return instance;
    }

    @Override
    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        List<DataSource> sortedDataSources = Utils.getSortedDataSources(dataSources);
        for (DataSource dataSource : sortedDataSources) {
            DataSourceWindowManager.sharedInstance().openDataSource(dataSource);
        }
    }

    @Override
    protected boolean isEnabled(Set<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            if (DataSourceWindowManager.sharedInstance().canOpenDataSource(dataSource)) continue;
            return false;
        }
        return true;
    }

    private OpenDataSourceAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(OpenDataSourceAction.class, (String)"LBL_Open"));
        this.putValue("ShortDescription", NbBundle.getMessage(OpenDataSourceAction.class, (String)"DESCR_Open"));
    }
}

