/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.core.windows.options.WinSysPrefs;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;

class DragWindow
extends JWindow {
    private boolean useFadeEffects = !Boolean.getBoolean("winsys.dnd.nofadeeffects");
    private Tabbed container;
    private Rectangle tabRectangle;
    private BufferedImage tabImage;
    private BufferedImage contentImage;
    private BufferedImage imageBuffer;
    private float contentAlpha = 0.15f;
    private Color contentBackground = Color.white;
    private Timer currentEffect;
    private boolean dropEnabled = true;
    private static final float NO_DROP_ALPHA = 0.5f;
    private static final float ALPHA_INCREMENT = 0.085f;

    public DragWindow(Tabbed tabbed, Rectangle rectangle, Dimension dimension, Component component) {
        this.tabRectangle = rectangle;
        this.container = tabbed;
        this.setAlwaysOnTop(true);
        this.tabImage = this.createTabImage();
        this.contentImage = this.createContentImage(component, dimension);
        if (this.useFadeEffects) {
            this.imageBuffer = this.createImageBuffer(this.contentImage);
            this.currentEffect = this.createInitialEffect();
            this.currentEffect.start();
        } else {
            this.contentAlpha = 1.0f;
        }
    }

    private BufferedImage createTabImage() {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Window window = SwingUtilities.getWindowAncestor(this.container.getComponent());
        Rectangle rectangle = SwingUtilities.convertRectangle(this.container.getComponent(), this.tabRectangle, window);
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(this.tabRectangle.width, this.tabRectangle.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(-rectangle.x, -rectangle.y);
        graphics2D.setClip(rectangle);
        window.paint(graphics2D);
        return bufferedImage;
    }

    private BufferedImage createContentImage(Component component, Dimension dimension) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(dimension.width, dimension.height);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        if (WinSysPrefs.HANDLER.getBoolean("dnd.smallwindows", true) && component.getWidth() > 0 && component.getHeight() > 0) {
            double d = dimension.getWidth() / (double)component.getWidth();
            double d2 = dimension.getHeight() / (double)component.getHeight();
            graphics2D.setTransform(AffineTransform.getScaleInstance(d, d2));
        }
        component.paint(graphics2D);
        return bufferedImage;
    }

    private BufferedImage createImageBuffer(BufferedImage bufferedImage) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setColor(this.contentBackground);
        graphics2D.fillRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.contentAlpha));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, this.getWidth(), this.tabRectangle.height);
        graphics2D.setColor(Color.gray);
        graphics2D.drawRect(0, this.tabRectangle.height, this.getWidth() - 1, this.getHeight() - this.tabRectangle.height - 1);
        if (WinSysPrefs.HANDLER.getBoolean("dnd.smallwindows", true)) {
            graphics2D.drawImage((Image)this.tabImage, 0, 0, null);
        } else {
            graphics2D.drawImage((Image)this.tabImage, this.tabRectangle.x, this.tabRectangle.y, null);
        }
        if (!this.useFadeEffects || null == this.imageBuffer) {
            graphics2D.setColor(Color.black);
            graphics2D.fillRect(1, this.tabRectangle.height + 1, this.getWidth() - 2, this.getHeight() - this.tabRectangle.height - 2);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.contentAlpha));
            graphics2D.drawImage((Image)this.contentImage, 1, this.tabRectangle.height + 1, null);
        } else if (null != this.imageBuffer) {
            graphics2D.drawImage((Image)this.imageBuffer, 1, this.tabRectangle.height + 1, null);
        }
        graphics2D.dispose();
    }

    public void setDropFeedback(boolean bl) {
        boolean bl2 = this.dropEnabled;
        this.dropEnabled = bl;
        if (bl2 != this.dropEnabled) {
            if (null != this.currentEffect) {
                this.currentEffect.stop();
            }
            if (this.useFadeEffects) {
                this.contentBackground = Color.black;
                this.currentEffect = bl ? this.createDropEnabledEffect() : this.createNoDropEffect();
                this.currentEffect.start();
                this.repaint();
            } else {
                this.contentAlpha = bl ? 1.0f : 0.5f;
                this.repaint();
            }
        }
    }

    private Timer createInitialEffect() {
        final Timer timer = new Timer(100, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DragWindow.this.contentAlpha < 1.0f) {
                    DragWindow.this.contentAlpha = DragWindow.this.contentAlpha + 0.085f;
                } else {
                    timer.stop();
                }
                if (DragWindow.this.contentAlpha > 1.0f) {
                    DragWindow.this.contentAlpha = 1.0f;
                }
                DragWindow.this.repaintImageBuffer();
                DragWindow.this.repaint();
            }
        });
        timer.setInitialDelay(0);
        return timer;
    }

    private Timer createDropEnabledEffect() {
        return this.createInitialEffect();
    }

    private Timer createNoDropEffect() {
        final Timer timer = new Timer(100, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DragWindow.this.contentAlpha > 0.5f) {
                    DragWindow.this.contentAlpha = DragWindow.this.contentAlpha - 0.085f;
                } else {
                    timer.stop();
                }
                if (DragWindow.this.contentAlpha < 0.5f) {
                    DragWindow.this.contentAlpha = 0.5f;
                }
                DragWindow.this.repaintImageBuffer();
                DragWindow.this.repaint();
            }
        });
        timer.setInitialDelay(0);
        return timer;
    }

    private void repaintImageBuffer() {
        if (!this.useFadeEffects) {
            return;
        }
        if (null == this.imageBuffer) {
            return;
        }
        Graphics2D graphics2D = this.imageBuffer.createGraphics();
        graphics2D.setColor(this.contentBackground);
        graphics2D.fillRect(0, 0, this.imageBuffer.getWidth(), this.imageBuffer.getHeight());
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.contentAlpha));
        graphics2D.drawImage((Image)this.contentImage, 0, 0, null);
        graphics2D.dispose();
    }

    void abort() {
        if (null != this.currentEffect) {
            this.currentEffect.stop();
            this.currentEffect = null;
        }
        this.dropEnabled = true;
        this.contentAlpha = 1.0f;
        this.repaintImageBuffer();
        this.repaint();
    }
}

