/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.jfreechart.ValueSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueSegment<T extends Comparable, V extends Comparable>
implements ValueSegment<T, V> {
    private final T start;
    private final T end;
    private final V value;

    public DefaultValueSegment(T start, T end, V value) {
        if (start == null) {
            throw new IllegalArgumentException("start may not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end may not be null");
        }
        this.start = start;
        this.end = end;
        this.value = value;
    }

    @Override
    public T getStart() {
        return this.start;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public int compareTo(ValueSegment<T, V> o) {
        int valueComparison = GlazedLists.comparableComparator().compare((Comparable)this.value, (Comparable)o.getValue());
        if (valueComparison != 0) {
            return valueComparison;
        }
        int startComparison = this.start.compareTo(o.getStart());
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.getEnd());
    }

    public String toString() {
        return "(" + this.start + ", " + this.end + ")";
    }
}

