Distributed sccache on FreeBSD
==============================

Please read the [the distributed quickstart](DistributedQuickstart.md)
guide first.

Build and install from source
-----------------------------

```
cargo install --features="dist-client,dist-server" --path=.
```

Configure a FreeBSD build server
--------------------------------

On FreeBSD, the build server requires [pot](https://github.com/bsdpot/pot)
to sandbox execution:

```sh
pkg install pot
```

It's up to the user to create the reference pot that serves as a template
to clone from when instantiating image and build containers, e.g.:

```sh
pot create -p sccache-template -N alias -i "lo0|127.0.0.2" -t single -b 14.1
pot set-cmd -p sccache-template -c /usr/bin/true
pot set-attr -p sccache-template -A no-rc-script -V YES
pot snapshot -p sccache-template
```

Then, a server.conf like the one below is created, making use of the `pot`
builder type (commented out options show defaults):

```toml
# This is where client toolchains will be stored.
cache_dir = "/tmp/toolchains"
# The maximum size of the toolchain cache, in bytes.
# If unspecified the default is 10GB.
# toolchain_cache_size = 10737418240
# A public IP address and port that clients will use to connect to this builder.
public_addr = "192.168.1.1:10501"
# The URL used to connect to the scheduler (should use https, given an ideal
# setup of a HTTPS server in front of the scheduler)
scheduler_url = "https://192.168.1.1"

[builder]
type = "pot"
# Pot filesystem root
#pot_fs_root = "/opt/pot"
# Reference pot cloned when creating containers
#clone_from = "sccache-template"
# Command to invoke when calling pot
#pot_cmd = "pot"
# Arguments passed to `pot clone` command
#pot_clone_args = ["-i", "lo0|127.0.0.2"]

[scheduler_auth]
type = "jwt_token"
# This will be generated by calling
# `sccache-dist auth generate-jwt-hs256-server-token` or
# provided by an administrator of the sccache cluster.
token = "my server's token"
```

FreeBSD as a build client
-------------------------

On a FreeBSD client, make sure to add the right toolchains to to
`~/.config/sccache/config`:

```toml
[dist]
# The URL used to connect to the scheduler (should use https, given an ideal
# setup of a HTTPS server in front of the scheduler)
scheduler_url = "http://127.0.0.1:10600"
# Used for mapping local toolchains to remote cross-compile toolchains. Empty in
# this example where the client and build server are both Linux.
#toolchains = []
# Size of the local toolchain cache, in bytes (5GB here, 10GB if unspecified).
toolchain_cache_size = 5368709120
cache_dir = "/home/user/.cache/sccache-dist-client"

[dist.auth]
type = "token"
# This should match the `client_auth` section of the scheduler config
# and was generated by calling `sccache-dist auth generate-jwt-hs256-key`
token = "my client token"

[[dist.toolchains]]
type = "path_override"
compiler_executable = "/usr/bin/cc"
archive = "/path/to/empty.tar.gz"
archive_compiler_executable = "/usr/bin/cc"

[[dist.toolchains]]
type = "path_override"
compiler_executable = "/usr/local/bin/rustc"
archive = "/path/to/rust-toolchain.tgz"
archive_compiler_executable = "/usr/local/bin/rustc"
```

Creating toolchain archives
---------------------------

The toolchain files from the examples above can be created like this:

```sh
pkg install gtar
gtar cvf - --files-from /dev/null | gzip >empty.tar.gz
pkg info -lq rust | gtar -cf - -T - | gzip >rust-toolchain.tgz
```

This just creates an empty file for the system compiler (as it is
included in the pot image anyway) and the toolchain for rustc is
created from the rust package installed on the system.

See [the distributed quickstart](DistributedQuickstart.md) guide for
instructions how to create other C toolchains using icecc-create-env.

Note: We use `gtar` (GNU tar) here, as the [flate2](
https://github.com/rust-lang/flate2-rs) crate has issues processing
sparse files created with `bsdtar`.

Cargo invocation example
------------------------

```sh
RUSTC_WRAPPER=~/.cargo/bin/sccache \
cargo build
```
