/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan.scanner;

import java.lang.reflect.UndeclaredThrowableException;
import net.htmlparser.jericho.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.pscan.PassiveScript;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.ScriptWrapper;
import org.zaproxy.zap.extension.script.ScriptsCache;

public class ScriptsPassiveScanner
extends PluginPassiveScanner {
    private static final Logger logger = LogManager.getLogger(ScriptsPassiveScanner.class);
    private final ScriptsCache<PassiveScript> scripts;
    private int currentHistoryType;

    public ScriptsPassiveScanner() {
        ExtensionScript extension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionScript.class);
        this.scripts = extension != null ? extension.createScriptsCache(ScriptsCache.Configuration.builder().setScriptType("passive").setTargetInterface(PassiveScript.class).setInterfaceErrorMessageProvider(sw -> Constant.messages.getString("pscan.scripts.interface.passive.error", sw.getName())).build()) : null;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("pscan.scripts.passivescanner.title");
    }

    @Override
    public int getPluginId() {
        return 50001;
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage msg, int id, Source source) {
        if (this.scripts == null) {
            return;
        }
        this.scripts.refreshAndExecute((sw, script) -> {
            if (this.appliesToCurrentHistoryType(sw, (PassiveScript)script)) {
                script.scan(this, msg, source);
            }
        });
    }

    private boolean appliesToCurrentHistoryType(ScriptWrapper wrapper, PassiveScript ps) {
        try {
            return ps.appliesToHistoryType(this.currentHistoryType);
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof NoSuchMethodException && "appliesToHistoryType".equals(e.getCause().getMessage())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Script [Name=" + wrapper.getName() + ", Engine=" + wrapper.getEngineName() + "]  does not implement the optional method appliesToHistoryType: ", (Throwable)e);
                }
                return super.appliesToHistoryType(this.currentHistoryType);
            }
            throw e;
        }
    }

    @Override
    public PluginPassiveScanner.AlertBuilder newAlert() {
        return super.newAlert();
    }

    @Deprecated
    public void raiseAlert(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, int cweId, int wascId, HttpMessage msg) {
        this.raiseAlert(risk, confidence, name, description, uri, param, attack, otherInfo, solution, evidence, null, cweId, wascId, msg);
    }

    @Deprecated
    public void raiseAlert(int risk, int confidence, String name, String description, String uri, String param, String attack, String otherInfo, String solution, String evidence, String reference, int cweId, int wascId, HttpMessage msg) {
        this.newAlert().setRisk(risk).setConfidence(confidence).setName(name).setDescription(description).setParam(param).setOtherInfo(otherInfo).setSolution(solution).setReference(reference).setEvidence(evidence).setCweId(cweId).setWascId(wascId).setMessage(msg).raise();
    }

    @Override
    public void addTag(String tag) {
        super.addTag(tag);
    }

    @Override
    public boolean appliesToHistoryType(int historyType) {
        this.currentHistoryType = historyType;
        return true;
    }
}

