/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.lang.ref.SoftReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;

public class AntiCsrfToken
implements Cloneable {
    private static final Logger LOGGER = LogManager.getLogger(AntiCsrfToken.class);
    private HttpMessage msg;
    private SoftReference<HttpMessage> msgReference;
    private int historyReferenceId;
    private String name;
    private String value;
    private String targetURL;
    private int formIndex;
    private static ExtensionAntiCSRF.HistoryReferenceFactory historyReferenceFactory;

    static void setHistoryReferenceFactory(ExtensionAntiCSRF.HistoryReferenceFactory historyReferenceFactory) {
        AntiCsrfToken.historyReferenceFactory = historyReferenceFactory;
    }

    public AntiCsrfToken(HttpMessage msg, String name, String value, int formIndex) {
        this(msg, null, -1, name, value, formIndex);
    }

    private AntiCsrfToken(HttpMessage msg, SoftReference<HttpMessage> msgReference, int historyReferenceId, String name, String value, int formIndex) {
        this.msg = msg;
        this.msgReference = msgReference;
        this.historyReferenceId = historyReferenceId;
        this.name = name;
        this.value = value;
        this.formIndex = formIndex;
    }

    public HttpMessage getMsg() {
        HttpMessage msg;
        if (this.msg != null) {
            return this.msg;
        }
        if (this.msgReference != null) {
            msg = this.msgReference.get();
            if (msg != null) {
                return msg;
            }
            this.msgReference.clear();
            this.msgReference = null;
        }
        if (this.historyReferenceId == -1) {
            return null;
        }
        try {
            msg = historyReferenceFactory.createHistoryReference(this.historyReferenceId).getHttpMessage();
            this.msgReference = new SoftReference<HttpMessage>(msg);
            return msg;
        }
        catch (DatabaseException | HttpMalformedHeaderException e) {
            LOGGER.error("Failed to load the persisted message: ", (Throwable)e);
            return null;
        }
    }

    public void setMsg(HttpMessage msg) {
        this.msg = msg;
        if (this.msgReference != null) {
            this.msgReference.clear();
            this.msgReference = null;
        }
        this.historyReferenceId = -1;
    }

    void setHistoryReferenceId(int historyReferenceId) {
        if (historyReferenceId < 0) {
            throw new IllegalArgumentException("Parameter historyReferenceId must be equal or greater than zero.");
        }
        this.setMsg(null);
        this.historyReferenceId = historyReferenceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setTargetURL(String targetUrl) {
        this.targetURL = targetUrl;
    }

    public String getTargetURL() {
        return this.targetURL;
    }

    public int getFormIndex() {
        return this.formIndex;
    }

    public void setFormIndex(int formIndex) {
        this.formIndex = formIndex;
    }

    public AntiCsrfToken clone() {
        return new AntiCsrfToken(this.msg, this.msgReference, this.historyReferenceId, this.name, this.value, this.formIndex);
    }
}

