/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder.mpmetrics;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.micrometer.deployment.RootMeterRegistryBuildItem;
import io.quarkus.micrometer.deployment.binder.mpmetrics.AnnotationHandler;
import io.quarkus.micrometer.deployment.binder.mpmetrics.GaugeAnnotationHandler;
import io.quarkus.micrometer.deployment.binder.mpmetrics.MetricDotNames;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetricsRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import jakarta.enterprise.context.Dependent;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

@BuildSteps(onlyIf={MicroprofileMetricsEnabled.class})
public class MicroprofileMetricsProcessor {
    private static final Logger log = Logger.getLogger(MicroprofileMetricsProcessor.class);
    static final Class<?> METRIC_ANNOTATION_CLASS = MicrometerRecorder.getClassForName((String)MetricDotNames.METRIC_ANNOTATION.toString());

    @BuildStep
    IndexDependencyBuildItem addDependencies() {
        return new IndexDependencyBuildItem("org.eclipse.microprofile.metrics", "microprofile-metrics-api");
    }

    @BuildStep
    AutoInjectAnnotationBuildItem autoInjectMetric() {
        return new AutoInjectAnnotationBuildItem(new DotName[]{MetricDotNames.METRIC});
    }

    @BuildStep
    AdditionalBeanBuildItem registerBeanClasses() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(MetricDotNames.MP_METRICS_BINDER.toString()).addBeanClass(MetricDotNames.CONCURRENT_GAUGE_INTERCEPTOR.toString()).addBeanClass(MetricDotNames.COUNTED_INTERCEPTOR.toString()).addBeanClass(MetricDotNames.INJECTED_METRIC_PRODUCER.toString()).addBeanClass(MetricDotNames.TIMED_INTERCEPTOR.toString()).addBeanClass(MetricDotNames.MP_METRICS_REGISTRY_PRODUCER.toString()).build();
    }

    @BuildStep
    void logWarningForMpMetricsUsage(CombinedIndexBuildItem combinedIndexBuildItem, BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> errors) {
        IndexView index = combinedIndexBuildItem.getIndex();
        boolean mpMetricsPresent = false;
        for (DotName annotation : MetricDotNames.individualMetrics) {
            if (index.getAnnotations(annotation).size() <= 0) continue;
            mpMetricsPresent = true;
            break;
        }
        if (!mpMetricsPresent && index.getAnnotations(MetricDotNames.METRIC_ANNOTATION).size() > 0) {
            mpMetricsPresent = true;
        }
        if (!mpMetricsPresent) {
            for (InjectionPointInfo injectionPoint : beanRegistrationPhase.getInjectionPoints()) {
                if (!injectionPoint.getRequiredType().name().equals((Object)MetricDotNames.METRIC_REGISTRY)) continue;
                mpMetricsPresent = true;
                break;
            }
        }
        if (mpMetricsPresent) {
            log.warn((Object)"This application uses the MP Metrics API. The micrometer extension currently provides a compatibility layer that supports the MP Metrics API, but metric names and recorded values will be different. Note that the MP Metrics compatibility layer will move to a different extension in the future.");
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem transformBeanScope(final BeanArchiveIndexBuildItem index, final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public int getPriority() {
                return 900;
            }

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                if (scopes.isScopeIn(ctx.getAnnotations())) {
                    return;
                }
                ClassInfo clazz = ctx.getTarget().asClass();
                if (!MetricDotNames.isSingleInstance(clazz)) {
                    while (clazz != null && clazz.superName() != null) {
                        if (!MetricDotNames.knownClass(clazz) && MetricDotNames.containsMetricAnnotation(clazz.annotationsMap())) {
                            log.debugf("Found metrics business methods on a class %s with no scope defined - adding @Dependent", (Object)ctx.getTarget());
                            ctx.transform().add(Dependent.class, new AnnotationValue[0]).done();
                            break;
                        }
                        clazz = index.getIndex().getClassByName(clazz.superName());
                    }
                }
            }
        });
    }

    @BuildStep
    UnremovableBeanBuildItem processAnnotatedMetrics(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers, CombinedIndexBuildItem indexBuildItem) {
        IndexView index = indexBuildItem.getIndex();
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GaugeAnnotationHandler.processAnnotatedGauges(index, (ClassOutput)classOutput);
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.CONCURRENT_GAUGE_ANNOTATION));
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.COUNTED_ANNOTATION));
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.METERED_ANNOTATION, MetricDotNames.COUNTED_ANNOTATION));
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.TIMED_ANNOTATION));
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.SIMPLY_TIMED_ANNOTATION, MetricDotNames.TIMED_ANNOTATION));
        annotationsTransformers.produce((BuildItem)AnnotationHandler.transformAnnotations(index, MetricDotNames.METRIC_ANNOTATION));
        return new UnremovableBeanBuildItem((Predicate)new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo beanInfo) {
                return beanInfo.hasType(MetricDotNames.METRIC) || beanInfo.hasType(MetricDotNames.ANNOTATED_GAUGE_ADAPTER);
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void configureRegistry(MpMetricsRecorder recorder, RootMeterRegistryBuildItem rootMeterRegistryBuildItem) {
        recorder.configureRegistryAdapter(rootMeterRegistryBuildItem.getValue());
    }

    static class MicroprofileMetricsEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        MicroprofileMetricsEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return METRIC_ANNOTATION_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().mpMetrics());
        }
    }
}

