/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.editor.abstractbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class defaultbinaryeditor
extends JFileChooser
implements abstractbinaryeditor {
    protected DN currentDN = null;
    protected editablebinary editMe = null;
    protected byte[] bytes;
    protected JFileChooserAccessory accessory = new JFileChooserAccessory();
    protected Frame owner;
    private static Logger log = Logger.getLogger(defaultbinaryeditor.class.getName());

    public defaultbinaryeditor(Frame owner) {
        super(JXplorer.getProperty("binary.homeDir"));
        this.owner = owner;
        this.setAccessory(this.accessory);
        this.setApproveButtonToolTipText(CBIntText.get("Click here to either load or save the file depending on the option selected."));
        this.setDialogTitle(CBIntText.get("Binary Data"));
    }

    public void showDialog() {
        if (this.bytes == null || this.bytes.length == 0) {
            this.accessory.setSaveEnabled(false);
            this.accessory.setSaveRadioSelected(false);
        } else {
            this.accessory.setSaveEnabled(true);
            this.accessory.setSaveRadioSelected(true);
        }
        if (this.showDialog(this.owner, CBIntText.get("OK")) != 0) {
            return;
        }
        if (this.accessory.isSaveSelected()) {
            this.save();
        } else if (this.accessory.isLoadSelected()) {
            this.load();
        }
        this.quit();
    }

    public void save() {
        File file = this.getSelectedFile();
        JXplorer.setProperty("binary.homeDir", this.getSelectedFile().getParent());
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(this.bytes);
            output.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error writing to the file!", e);
            return;
        }
        JOptionPane.showMessageDialog(this.owner, CBIntText.get("File ''{0}'' was successfully saved.", new String[]{file.getName()}), CBIntText.get("File Saved"), 1);
    }

    protected void load() {
        CBCache.cleanCache(this.currentDN.toString());
        File file = this.getSelectedFile();
        JXplorer.setProperty("binary.homeDir", this.getSelectedFile().getParent());
        try {
            FileInputStream input = new FileInputStream(file);
            int length = (int)file.length();
            if (length > 0) {
                this.bytes = new byte[length];
                int read = input.read(this.bytes);
                this.editMe.setValue(this.bytes);
            }
            input.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error opening the file!", e);
            return;
        }
        JOptionPane.showMessageDialog(this.owner, CBIntText.get("File ''{0}'' was successfully loaded.  Don't forget to click Submit in the Table Editor to save the data to the DSA.", new String[]{file.getName()}), CBIntText.get("File Loaded"), 1);
    }

    public void quit() {
    }

    public void setValue(editablebinary editMe) {
        this.editMe = editMe;
        this.bytes = editMe.getValue();
    }

    public void setDN(DN dn) {
        this.currentDN = dn;
    }

    public JComponent addComponent() {
        return null;
    }

    public class JFileChooserAccessory
    extends JPanel {
        protected JLabel label;
        protected CBButton helpButton;
        protected CBButton btnCustom = null;
        protected JRadioButton saveRadio = new JRadioButton(CBIntText.get("Save"));
        protected JRadioButton loadRadio = new JRadioButton(CBIntText.get("Load"));

        public JFileChooserAccessory() {
            CBPanel mainPanel = new CBPanel();
            this.helpButton = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
            CBHelpSystem.useDefaultHelp(this.helpButton, "attr.binary");
            this.saveRadio.setToolTipText(CBIntText.get("To save to an external file, select this option then click OK."));
            this.loadRadio.setToolTipText(CBIntText.get("To load from an external file, select this option then click OK."));
            this.loadRadio.setSelected(true);
            ButtonGroup radioGroup = new ButtonGroup();
            radioGroup.add(this.loadRadio);
            radioGroup.add(this.saveRadio);
            CBPanel radioPanel = new CBPanel();
            radioPanel.setBorder(new TitledBorder(CBIntText.get(" Options ")));
            radioPanel.addln(this.saveRadio);
            radioPanel.addln(this.loadRadio);
            mainPanel.addln(radioPanel);
            JComponent c = defaultbinaryeditor.this.addComponent();
            if (c != null) {
                mainPanel.addln(c);
            }
            mainPanel.addln(this.helpButton);
            this.add((Component)mainPanel, "Center");
        }

        public void setSaveEnabled(boolean b) {
            this.saveRadio.setEnabled(b);
        }

        public void setSaveRadioSelected(boolean b) {
            this.saveRadio.setSelected(b);
        }

        public boolean isLoadSelected() {
            return this.loadRadio.isSelected();
        }

        public boolean isSaveSelected() {
            return this.saveRadio.isSelected();
        }
    }
}

