/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.videobridge.ReceiveSsrc;
import org.jitsi.videobridge.SendSsrc;
import org.jitsi.videobridge.SourceDesc;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jitsi/videobridge/SendSource;", "", "props", "Lorg/jitsi/videobridge/SourceDesc;", "send1", "Lorg/jitsi/videobridge/SendSsrc;", "send2", "<init>", "(Lorg/jitsi/videobridge/SourceDesc;Lorg/jitsi/videobridge/SendSsrc;Lorg/jitsi/videobridge/SendSsrc;)V", "ssrc1", "", "ssrc2", "(Lorg/jitsi/videobridge/SourceDesc;JJ)V", "getProps", "()Lorg/jitsi/videobridge/SourceDesc;", "getSend1", "()Lorg/jitsi/videobridge/SendSsrc;", "getSend2", "started", "", "getSender", "ssrc", "rewriteRtp", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "start", "recv", "Lorg/jitsi/videobridge/ReceiveSsrc;", "rewriteRtcp", "", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "toString", "", "jitsi-videobridge"})
public final class SendSource {
    @NotNull
    private final SourceDesc props;
    @NotNull
    private final SendSsrc send1;
    @NotNull
    private final SendSsrc send2;
    private boolean started;

    public SendSource(@NotNull SourceDesc props, @NotNull SendSsrc send1, @NotNull SendSsrc send2) {
        Intrinsics.checkNotNullParameter(props, "props");
        Intrinsics.checkNotNullParameter(send1, "send1");
        Intrinsics.checkNotNullParameter(send2, "send2");
        this.props = props;
        this.send1 = send1;
        this.send2 = send2;
    }

    @NotNull
    public final SourceDesc getProps() {
        return this.props;
    }

    @NotNull
    public final SendSsrc getSend1() {
        return this.send1;
    }

    @NotNull
    public final SendSsrc getSend2() {
        return this.send2;
    }

    public SendSource(@NotNull SourceDesc props, long ssrc1, long ssrc2) {
        Intrinsics.checkNotNullParameter(props, "props");
        this(props, new SendSsrc(ssrc1), new SendSsrc(ssrc2));
    }

    private final SendSsrc getSender(long ssrc) {
        return ssrc == this.props.getSsrc2() ? this.send2 : this.send1;
    }

    public final boolean rewriteRtp(@NotNull RtpPacket packet, boolean start2, @NotNull ReceiveSsrc recv) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(recv, "recv");
        if (start2) {
            this.started = true;
        }
        this.getSender(packet.getSsrc()).rewriteRtp(packet, this.started, recv);
        return this.started;
    }

    public final void rewriteRtcp(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        this.getSender(packet.getSenderSsrc()).rewriteRtcp(packet);
    }

    @NotNull
    public String toString() {
        return this.send1 + ", " + this.send2 + (this.started ? "" : " (not started)");
    }
}

