/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.MathFunctions;
import org.armedbear.lisp.Ratio;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class SingleFloat
extends LispObject {
    public static final SingleFloat ZERO = new SingleFloat(0.0f);
    public static final SingleFloat MINUS_ZERO = new SingleFloat(-0.0f);
    public static final SingleFloat ONE = new SingleFloat(1.0f);
    public static final SingleFloat MINUS_ONE = new SingleFloat(-1.0f);
    public static final SingleFloat SINGLE_FLOAT_POSITIVE_INFINITY = new SingleFloat(Float.POSITIVE_INFINITY);
    public static final SingleFloat SINGLE_FLOAT_NEGATIVE_INFINITY = new SingleFloat(Float.NEGATIVE_INFINITY);
    public final float value;

    public static SingleFloat getInstance(float f) {
        if (f == 0.0f) {
            int bits = Float.floatToRawIntBits(f);
            if (bits < 0) {
                return MINUS_ZERO;
            }
            return ZERO;
        }
        if (f == 1.0f) {
            return ONE;
        }
        if (f == -1.0f) {
            return MINUS_ONE;
        }
        return new SingleFloat(f);
    }

    public SingleFloat(float value) {
        this.value = value;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.SINGLE_FLOAT;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SINGLE_FLOAT;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.REAL) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.NUMBER) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.SINGLE_FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.SHORT_FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.FLOAT) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.SINGLE_FLOAT) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    @Override
    public boolean numberp() {
        return true;
    }

    @Override
    public boolean realp() {
        return true;
    }

    @Override
    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingleFloat) {
            if (this.value == 0.0f) {
                float f = ((SingleFloat)obj).value;
                int bits = Float.floatToRawIntBits(f);
                return bits == Float.floatToRawIntBits(this.value);
            }
            if (this.value == ((SingleFloat)obj).value) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equal(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SingleFloat) {
            if (this.value == 0.0f) {
                float f = ((SingleFloat)obj).value;
                int bits = Float.floatToRawIntBits(f);
                return bits == Float.floatToRawIntBits(this.value);
            }
            if (this.value == ((SingleFloat)obj).value) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equalp(int n) {
        return this.value == (float)n;
    }

    @Override
    public boolean equalp(LispObject obj) {
        if (obj != null && obj.numberp()) {
            return this.isEqualTo(obj);
        }
        return false;
    }

    @Override
    public LispObject ABS() {
        if (this.value > 0.0f) {
            return this;
        }
        if (this.value == 0.0f) {
            return ZERO;
        }
        return new SingleFloat(-this.value);
    }

    @Override
    public boolean plusp() {
        return this.value > 0.0f;
    }

    @Override
    public boolean minusp() {
        return this.value < 0.0f;
    }

    @Override
    public boolean zerop() {
        return this.value == 0.0f;
    }

    @Override
    public boolean floatp() {
        return true;
    }

    public static double getValue(LispObject obj) {
        if (obj instanceof SingleFloat) {
            return ((SingleFloat)obj).value;
        }
        Lisp.type_error(obj, Symbol.FLOAT);
        return 0.0;
    }

    public final float getValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Object javaInstance() {
        return Float.valueOf(this.value);
    }

    public Object javaInstance(Class c) {
        if (c == Float.class || c == Float.TYPE) {
            return Float.valueOf(this.value);
        }
        return this.javaInstance();
    }

    @Override
    public final LispObject incr() {
        return new SingleFloat(this.value + 1.0f);
    }

    @Override
    public final LispObject decr() {
        return new SingleFloat(this.value - 1.0f);
    }

    @Override
    public LispObject add(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new SingleFloat(this.value + (float)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.value + ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value + ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new SingleFloat(this.value + ((Bignum)obj).floatValue());
        }
        if (obj instanceof Ratio) {
            return new SingleFloat(this.value + ((Ratio)obj).floatValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.add(c.getRealPart()), c.getImaginaryPart());
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject negate() {
        if (this.value == 0.0f) {
            int bits = Float.floatToRawIntBits(this.value);
            return bits < 0 ? ZERO : MINUS_ZERO;
        }
        return new SingleFloat(-this.value);
    }

    @Override
    public LispObject subtract(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new SingleFloat(this.value - (float)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.value - ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value - ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new SingleFloat(this.value - ((Bignum)obj).floatValue());
        }
        if (obj instanceof Ratio) {
            return new SingleFloat(this.value - ((Ratio)obj).floatValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.subtract(c.getRealPart()), ZERO.subtract(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new SingleFloat(this.value * (float)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.value * ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value * ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new SingleFloat(this.value * ((Bignum)obj).floatValue());
        }
        if (obj instanceof Ratio) {
            return new SingleFloat(this.value * ((Ratio)obj).floatValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.multiplyBy(c.getRealPart()), this.multiplyBy(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public LispObject divideBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new SingleFloat(this.value / (float)((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.value / ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat((double)this.value / ((DoubleFloat)obj).value);
        }
        if (obj instanceof Bignum) {
            return new SingleFloat(this.value / ((Bignum)obj).floatValue());
        }
        if (obj instanceof Ratio) {
            return new SingleFloat(this.value / ((Ratio)obj).floatValue());
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            LispObject re = c.getRealPart();
            LispObject im = c.getImaginaryPart();
            LispObject denom = re.multiplyBy(re).add(im.multiplyBy(im));
            LispObject resX = this.multiplyBy(re).divideBy(denom);
            LispObject resY = this.multiplyBy(Fixnum.MINUS_ONE).multiplyBy(im).divideBy(denom);
            return Complex.getInstance(resX, resY);
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    @Override
    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.rational().isEqualTo(obj);
        }
        if (obj instanceof SingleFloat) {
            return this.value == ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value == ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isEqualTo(obj);
        }
        if (obj instanceof Complex) {
            return obj.isEqualTo(this);
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    @Override
    public boolean isNotEqualTo(LispObject obj) {
        return !this.isEqualTo(obj);
    }

    @Override
    public boolean isLessThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.rational().isLessThan(obj);
        }
        if (obj instanceof SingleFloat) {
            return this.value < ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value < ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isLessThan(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isLessThan(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isGreaterThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.rational().isGreaterThan(obj);
        }
        if (obj instanceof SingleFloat) {
            return this.value > ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value > ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isGreaterThan(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isGreaterThan(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isLessThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.rational().isLessThanOrEqualTo(obj);
        }
        if (obj instanceof SingleFloat) {
            return this.value <= ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value <= ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isLessThanOrEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isLessThanOrEqualTo(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.rational().isGreaterThanOrEqualTo(obj);
        }
        if (obj instanceof SingleFloat) {
            return this.value >= ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return (double)this.value >= ((DoubleFloat)obj).value;
        }
        if (obj instanceof Bignum) {
            return this.rational().isGreaterThanOrEqualTo(obj);
        }
        if (obj instanceof Ratio) {
            return this.rational().isGreaterThanOrEqualTo(obj);
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    @Override
    public LispObject truncate(LispObject obj) {
        if (obj instanceof Fixnum) {
            return this.truncate(new SingleFloat(((Fixnum)obj).value));
        }
        if (obj instanceof Bignum) {
            return this.truncate(new SingleFloat(((Bignum)obj).floatValue()));
        }
        if (obj instanceof Ratio) {
            return this.truncate(new SingleFloat(((Ratio)obj).floatValue()));
        }
        if (obj instanceof SingleFloat) {
            LispThread thread = LispThread.currentThread();
            float divisor = ((SingleFloat)obj).value;
            float quotient = this.value / divisor;
            if (this.value != 0.0f) {
                MathFunctions.OverUnderFlowCheck(quotient);
            }
            if (quotient >= -2.1474836E9f && quotient <= 2.1474836E9f) {
                int q = (int)quotient;
                return thread.setValues(Fixnum.getInstance(q), new SingleFloat(this.value - (float)q * divisor));
            }
            int bits = Float.floatToRawIntBits(quotient);
            int s = bits >> 31 == 0 ? 1 : -1;
            int e = bits >> 23 & 0xFF;
            long m = e == 0 ? (long)((bits & 0x7FFFFF) << 1) : (long)(bits & 0x7FFFFF | 0x800000);
            LispObject significand = Lisp.number(m);
            Fixnum exponent = Fixnum.getInstance(e - 150);
            Fixnum sign = Fixnum.getInstance(s);
            LispObject result = significand;
            result = result.multiplyBy(MathFunctions.EXPT.execute((LispObject)Fixnum.TWO, exponent));
            result = result.multiplyBy(sign);
            LispObject product = result.multiplyBy(obj);
            LispObject remainder = this.subtract(product);
            return thread.setValues(result, remainder);
        }
        if (obj instanceof DoubleFloat) {
            LispThread thread = LispThread.currentThread();
            double divisor = ((DoubleFloat)obj).value;
            double quotient = (double)this.value / divisor;
            if (this.value != 0.0f) {
                MathFunctions.OverUnderFlowCheck(quotient);
            }
            if (quotient >= -2.147483648E9 && quotient <= 2.147483647E9) {
                int q = (int)quotient;
                return thread.setValues(Fixnum.getInstance(q), new DoubleFloat((double)this.value - (double)q * divisor));
            }
            long bits = Double.doubleToRawLongBits(quotient);
            int s = bits >> 63 == 0L ? 1 : -1;
            int e = (int)(bits >> 52 & 0x7FFL);
            long m = e == 0 ? (bits & 0xFFFFFFFFFFFFFL) << 1 : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            LispObject significand = Lisp.number(m);
            Fixnum exponent = Fixnum.getInstance(e - 1075);
            Fixnum sign = Fixnum.getInstance(s);
            LispObject result = significand;
            result = result.multiplyBy(MathFunctions.EXPT.execute((LispObject)Fixnum.TWO, exponent));
            result = result.multiplyBy(sign);
            LispObject product = result.multiplyBy(obj);
            LispObject remainder = this.subtract(product);
            return thread.setValues(result, remainder);
        }
        return Lisp.type_error(obj, Symbol.REAL);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    @Override
    public int psxhash() {
        if (this.value % 1.0f == 0.0f) {
            return (int)this.value & Integer.MAX_VALUE;
        }
        return this.hashCode() & Integer.MAX_VALUE;
    }

    @Override
    public String printObject() {
        boolean printReadably;
        if (this.value == Float.POSITIVE_INFINITY) {
            StringBuffer sb = new StringBuffer("#.");
            sb.append(Symbol.SINGLE_FLOAT_POSITIVE_INFINITY.printObject());
            return sb.toString();
        }
        if (this.value == Float.NEGATIVE_INFINITY) {
            StringBuffer sb = new StringBuffer("#.");
            sb.append(Symbol.SINGLE_FLOAT_NEGATIVE_INFINITY.printObject());
            return sb.toString();
        }
        LispThread thread = LispThread.currentThread();
        boolean bl = printReadably = Symbol.PRINT_READABLY.symbolValue(thread) != Lisp.NIL;
        if (this.value != this.value) {
            if (printReadably) {
                return "#.(CL:PROGN \"Comment: create a NaN.\" (CL:/ 0.0s0 0.0s0))";
            }
            return this.unreadableString("SINGLE-FLOAT NaN", false);
        }
        String s1 = String.valueOf(this.value);
        if (printReadably || !Lisp.memq(Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue(thread), Lisp.list(Symbol.SINGLE_FLOAT, Symbol.SHORT_FLOAT))) {
            if (s1.indexOf(69) >= 0) {
                return s1.replace('E', 'f');
            }
            return s1.concat("f0");
        }
        return s1;
    }

    public LispObject rational() {
        BigInteger denominator;
        BigInteger numerator;
        int exponent;
        int bits = Float.floatToRawIntBits(this.value);
        int sign = bits >> 31 == 0 ? 1 : -1;
        int storedExponent = bits >> 23 & 0xFF;
        long mantissa = storedExponent == 0 ? (long)((bits & 0x7FFFFF) << 1) : (long)(bits & 0x7FFFFF | 0x800000);
        if (mantissa == 0L) {
            return Fixnum.ZERO;
        }
        if (sign < 0) {
            mantissa = -mantissa;
        }
        if ((exponent = storedExponent - 127) < 0) {
            numerator = BigInteger.valueOf(mantissa);
            denominator = BigInteger.valueOf(1L).shiftLeft(23 - exponent);
        } else {
            numerator = BigInteger.valueOf(mantissa).shiftLeft(exponent);
            denominator = BigInteger.valueOf(0x800000L);
        }
        return Lisp.number(numerator, denominator);
    }

    public static SingleFloat coerceToFloat(LispObject obj) {
        if (obj instanceof Fixnum) {
            return new SingleFloat(((Fixnum)obj).value);
        }
        if (obj instanceof SingleFloat) {
            return (SingleFloat)obj;
        }
        if (obj instanceof DoubleFloat) {
            float result = (float)((DoubleFloat)obj).value;
            if (Float.isInfinite(result) && Lisp.TRAP_OVERFLOW) {
                Lisp.type_error(obj, Symbol.SINGLE_FLOAT);
            }
            return new SingleFloat(result);
        }
        if (obj instanceof Bignum) {
            return new SingleFloat(((Bignum)obj).floatValue());
        }
        if (obj instanceof Ratio) {
            return new SingleFloat(((Ratio)obj).floatValue());
        }
        Lisp.error(new TypeError("The value " + obj.princToString() + " cannot be converted to type SINGLE-FLOAT."));
        return null;
    }

    static {
        Symbol.SINGLE_FLOAT_POSITIVE_INFINITY.initializeConstant(SINGLE_FLOAT_POSITIVE_INFINITY);
        Symbol.SINGLE_FLOAT_NEGATIVE_INFINITY.initializeConstant(SINGLE_FLOAT_NEGATIVE_INFINITY);
    }
}

