/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.counters;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.layouter.counters.CounterStyle;
import org.jfree.layouting.layouter.counters.numeric.DecimalCounterStyle;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CounterStyleFactory {
    private static final CounterStyle DEFAULTCOUNTER = new DecimalCounterStyle();
    private static CounterStyleFactory factory;
    public static final String PREFIX = "org.jfree.layouting.numbering.";
    private HashMap knownCounters = new HashMap();

    public static synchronized CounterStyleFactory getInstance() {
        if (factory == null) {
            factory = new CounterStyleFactory();
            factory.registerDefaults();
        }
        return factory;
    }

    private CounterStyleFactory() {
    }

    public void registerDefaults() {
        Configuration configuration = LibLayoutBoot.getInstance().getGlobalConfig();
        Iterator iterator = configuration.findPropertyKeys(PREFIX);
        while (iterator.hasNext()) {
            Object object;
            String string = (String)iterator.next();
            String string2 = configuration.getConfigProperty(string);
            if (string2 == null || !((object = ObjectUtilities.loadAndInstantiate((String)string2, CounterStyleFactory.class, CounterStyle.class)) instanceof CounterStyle)) continue;
            String string3 = string.substring(PREFIX.length());
            this.knownCounters.put(string3, object);
        }
    }

    public CounterStyle getCounterStyle(String string) {
        CounterStyle counterStyle = (CounterStyle)this.knownCounters.get(string);
        if (counterStyle != null) {
            return counterStyle;
        }
        return DEFAULTCOUNTER;
    }
}

