/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.Dot11LinkAdaptationControl;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Dot11HtControl
implements Serializable {
    private static final long serialVersionUID = 8919536873635707080L;
    private final Dot11LinkAdaptationControl linkAdaptationControl;
    private final CalibrationPosition calibrationPosition;
    private final byte calibrationSequence;
    private final boolean bit20;
    private final boolean bit21;
    private final CsiOrSteering csiOrSteering;
    private final boolean ndpAnnouncement;
    private final boolean bit25;
    private final boolean bit26;
    private final boolean bit27;
    private final boolean bit28;
    private final boolean bit29;
    private final boolean acConstraint;
    private final boolean rdgOrMorePpdu;

    public static Dot11HtControl newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11HtControl(rawData, offset, length);
    }

    private Dot11HtControl(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 4) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a Dot11HtControl (").append(2).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.linkAdaptationControl = Dot11LinkAdaptationControl.newInstance(rawData, offset, 2);
        byte data = rawData[offset + 2];
        this.calibrationPosition = CalibrationPosition.getInstance(data & 3);
        this.calibrationSequence = (byte)(data >> 2 & 3);
        this.bit20 = (data & 0x10) != 0;
        this.bit21 = (data & 0x20) != 0;
        this.csiOrSteering = CsiOrSteering.getInstance(data >> 6 & 3);
        data = rawData[offset + 3];
        this.ndpAnnouncement = (data & 1) != 0;
        this.bit25 = (data & 2) != 0;
        this.bit26 = (data & 4) != 0;
        this.bit27 = (data & 8) != 0;
        this.bit28 = (data & 0x10) != 0;
        this.bit29 = (data & 0x20) != 0;
        this.acConstraint = (data & 0x40) != 0;
        this.rdgOrMorePpdu = (data & 0x80) != 0;
    }

    private Dot11HtControl(Builder builder2) {
        if (builder2 == null || builder2.linkAdaptationControl == null || builder2.calibrationPosition == null || builder2.csiOrSteering == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder2).append(" builder.linkAdaptationControl: ").append(builder2.linkAdaptationControl).append(" builder.calibrationPosition: ").append((Object)builder2.calibrationPosition).append(" builder.csiOrSteering: ").append((Object)builder2.csiOrSteering);
            throw new NullPointerException(sb.toString());
        }
        if ((builder2.calibrationSequence & 0xFC) != 0) {
            StringBuilder sb = new StringBuilder(150);
            sb.append("(builder.calibrationSequence & 0xFC) must be zero.").append(" builder.calibrationSequence: ").append(builder2.calibrationSequence);
            throw new IllegalArgumentException(sb.toString());
        }
        this.linkAdaptationControl = builder2.linkAdaptationControl;
        this.calibrationPosition = builder2.calibrationPosition;
        this.calibrationSequence = builder2.calibrationSequence;
        this.bit20 = builder2.bit20;
        this.bit21 = builder2.bit21;
        this.csiOrSteering = builder2.csiOrSteering;
        this.ndpAnnouncement = builder2.ndpAnnouncement;
        this.bit25 = builder2.bit25;
        this.bit26 = builder2.bit26;
        this.bit27 = builder2.bit27;
        this.bit28 = builder2.bit28;
        this.bit29 = builder2.bit29;
        this.acConstraint = builder2.acConstraint;
        this.rdgOrMorePpdu = builder2.rdgOrMorePpdu;
    }

    public Dot11LinkAdaptationControl getLinkAdaptationControl() {
        return this.linkAdaptationControl;
    }

    public CalibrationPosition getCalibrationPosition() {
        return this.calibrationPosition;
    }

    public byte getCalibrationSequence() {
        return this.calibrationSequence;
    }

    public int getCalibrationSequenceAsInt() {
        return this.calibrationSequence;
    }

    public boolean getBit20() {
        return this.bit20;
    }

    public boolean getBit21() {
        return this.bit21;
    }

    public CsiOrSteering getCsiOrSteering() {
        return this.csiOrSteering;
    }

    public boolean getNdpAnnouncement() {
        return this.ndpAnnouncement;
    }

    public boolean getBit25() {
        return this.bit25;
    }

    public boolean getBit26() {
        return this.bit26;
    }

    public boolean getBit27() {
        return this.bit27;
    }

    public boolean getBit28() {
        return this.bit28;
    }

    public boolean getBit29() {
        return this.bit29;
    }

    public boolean getAcConstraint() {
        return this.acConstraint;
    }

    public boolean getRdgOrMorePpdu() {
        return this.rdgOrMorePpdu;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        System.arraycopy(this.linkAdaptationControl.getRawData(), 0, data, 0, 2);
        data[2] = (byte)(this.csiOrSteering.value << 6 | this.calibrationSequence << 2 | this.calibrationPosition.value);
        if (this.bit20) {
            data[2] = (byte)(data[2] | 0x10);
        }
        if (this.bit21) {
            data[2] = (byte)(data[2] | 0x20);
        }
        if (this.ndpAnnouncement) {
            data[3] = (byte)(data[3] | 1);
        }
        if (this.bit25) {
            data[3] = (byte)(data[3] | 2);
        }
        if (this.bit26) {
            data[3] = (byte)(data[3] | 4);
        }
        if (this.bit27) {
            data[3] = (byte)(data[3] | 8);
        }
        if (this.bit28) {
            data[3] = (byte)(data[3] | 0x10);
        }
        if (this.bit29) {
            data[3] = (byte)(data[3] | 0x20);
        }
        if (this.acConstraint) {
            data[3] = (byte)(data[3] | 0x40);
        }
        if (this.rdgOrMorePpdu) {
            data[3] = (byte)(data[3] | 0x80);
        }
        return data;
    }

    public int length() {
        return 4;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Link Adaptation Control: ").append(this.linkAdaptationControl).append(ls).append(indent).append("Calibration Position: ").append((Object)this.calibrationPosition).append(ls).append(indent).append("Calibration Sequence: ").append(this.calibrationSequence).append(ls).append(indent).append("Bit 20: ").append(this.bit20).append(ls).append(indent).append("Bit 21: ").append(this.bit21).append(ls).append(indent).append("CSI/Steering: ").append((Object)this.csiOrSteering).append(ls).append(indent).append("NDP Announcement: ").append(this.ndpAnnouncement).append(ls).append(indent).append("Bit 25: ").append(this.bit25).append(ls).append(indent).append("Bit 26: ").append(this.bit26).append(ls).append(indent).append("Bit 27: ").append(this.bit27).append(ls).append(indent).append("Bit 28: ").append(this.bit28).append(ls).append(indent).append("Bit 29: ").append(this.bit29).append(ls).append(indent).append("AC Constraint: ").append(this.acConstraint).append(ls).append(indent).append("RDG/More PPDU: ").append(this.rdgOrMorePpdu).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acConstraint ? 1231 : 1237);
        result = 31 * result + (this.bit20 ? 1231 : 1237);
        result = 31 * result + (this.bit21 ? 1231 : 1237);
        result = 31 * result + (this.bit25 ? 1231 : 1237);
        result = 31 * result + (this.bit26 ? 1231 : 1237);
        result = 31 * result + (this.bit27 ? 1231 : 1237);
        result = 31 * result + (this.bit28 ? 1231 : 1237);
        result = 31 * result + (this.bit29 ? 1231 : 1237);
        result = 31 * result + this.calibrationPosition.hashCode();
        result = 31 * result + this.calibrationSequence;
        result = 31 * result + this.csiOrSteering.hashCode();
        result = 31 * result + this.linkAdaptationControl.hashCode();
        result = 31 * result + (this.ndpAnnouncement ? 1231 : 1237);
        result = 31 * result + (this.rdgOrMorePpdu ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dot11HtControl other = (Dot11HtControl)obj;
        if (this.acConstraint != other.acConstraint) {
            return false;
        }
        if (this.bit20 != other.bit20) {
            return false;
        }
        if (this.bit21 != other.bit21) {
            return false;
        }
        if (this.bit25 != other.bit25) {
            return false;
        }
        if (this.bit26 != other.bit26) {
            return false;
        }
        if (this.bit27 != other.bit27) {
            return false;
        }
        if (this.bit28 != other.bit28) {
            return false;
        }
        if (this.bit29 != other.bit29) {
            return false;
        }
        if (this.calibrationPosition != other.calibrationPosition) {
            return false;
        }
        if (this.calibrationSequence != other.calibrationSequence) {
            return false;
        }
        if (this.csiOrSteering != other.csiOrSteering) {
            return false;
        }
        if (!this.linkAdaptationControl.equals(other.linkAdaptationControl)) {
            return false;
        }
        if (this.ndpAnnouncement != other.ndpAnnouncement) {
            return false;
        }
        return this.rdgOrMorePpdu == other.rdgOrMorePpdu;
    }

    public static final class Builder {
        private Dot11LinkAdaptationControl linkAdaptationControl;
        private CalibrationPosition calibrationPosition;
        private byte calibrationSequence;
        private boolean bit20;
        private boolean bit21;
        private CsiOrSteering csiOrSteering;
        private boolean ndpAnnouncement;
        private boolean bit25;
        private boolean bit26;
        private boolean bit27;
        private boolean bit28;
        private boolean bit29;
        private boolean acConstraint;
        private boolean rdgOrMorePpdu;

        public Builder() {
        }

        private Builder(Dot11HtControl obj) {
            this.linkAdaptationControl = obj.linkAdaptationControl;
            this.calibrationPosition = obj.calibrationPosition;
            this.calibrationSequence = obj.calibrationSequence;
            this.bit20 = obj.bit20;
            this.bit21 = obj.bit21;
            this.csiOrSteering = obj.csiOrSteering;
            this.ndpAnnouncement = obj.ndpAnnouncement;
            this.bit25 = obj.bit25;
            this.bit26 = obj.bit26;
            this.bit27 = obj.bit27;
            this.bit28 = obj.bit28;
            this.bit29 = obj.bit29;
            this.acConstraint = obj.acConstraint;
            this.rdgOrMorePpdu = obj.rdgOrMorePpdu;
        }

        public Builder linkAdaptationControl(Dot11LinkAdaptationControl linkAdaptationControl) {
            this.linkAdaptationControl = linkAdaptationControl;
            return this;
        }

        public Builder calibrationPosition(CalibrationPosition calibrationPosition) {
            this.calibrationPosition = calibrationPosition;
            return this;
        }

        public Builder calibrationSequence(byte calibrationSequence) {
            this.calibrationSequence = calibrationSequence;
            return this;
        }

        public Builder bit20(boolean bit20) {
            this.bit20 = bit20;
            return this;
        }

        public Builder bit21(boolean bit21) {
            this.bit21 = bit21;
            return this;
        }

        public Builder csiOrSteering(CsiOrSteering csiOrSteering) {
            this.csiOrSteering = csiOrSteering;
            return this;
        }

        public Builder ndpAnnouncement(boolean ndpAnnouncement) {
            this.ndpAnnouncement = ndpAnnouncement;
            return this;
        }

        public Builder bit25(boolean bit25) {
            this.bit25 = bit25;
            return this;
        }

        public Builder bit26(boolean bit26) {
            this.bit26 = bit26;
            return this;
        }

        public Builder bit27(boolean bit27) {
            this.bit27 = bit27;
            return this;
        }

        public Builder bit28(boolean bit28) {
            this.bit28 = bit28;
            return this;
        }

        public Builder bit29(boolean bit29) {
            this.bit29 = bit29;
            return this;
        }

        public Builder acConstraint(boolean acConstraint) {
            this.acConstraint = acConstraint;
            return this;
        }

        public Builder rdgOrMorePpdu(boolean rdgOrMorePpdu) {
            this.rdgOrMorePpdu = rdgOrMorePpdu;
            return this;
        }

        public Dot11HtControl build() {
            return new Dot11HtControl(this);
        }
    }

    public static enum CsiOrSteering {
        NO_FEEDBACK_REQUIRED(0, "No feedback required"),
        CSI(1, "CSI"),
        NONCOMPRESSED_BEAMFORMING(2, "Noncompressed beamforming"),
        COMPRESSED_BEAMFORMING(3, "Compressed beamforming");

        private final int value;
        private final String name;

        private CsiOrSteering(int value2, String name) {
            this.value = value2;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static CsiOrSteering getInstance(int value2) {
            for (CsiOrSteering val : CsiOrSteering.values()) {
                if (val.value != value2) continue;
                return val;
            }
            throw new IllegalArgumentException("Invalid value: " + value2);
        }
    }

    public static enum CalibrationPosition {
        NOT_CALIBRATION(0, "not a calibration frame"),
        CALIBRATION_START(1, "calibration start"),
        SOUNDING_RESPONSE(2, "sounding response"),
        SOUNDING_COMPLETE(3, "sounding complete");

        private final int value;
        private final String name;

        private CalibrationPosition(int value2, String name) {
            this.value = value2;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(50);
            sb.append(this.value).append(" (").append(this.name).append(")");
            return sb.toString();
        }

        public static CalibrationPosition getInstance(int value2) {
            for (CalibrationPosition cp : CalibrationPosition.values()) {
                if (cp.value != value2) continue;
                return cp;
            }
            throw new IllegalArgumentException("Invalid value: " + value2);
        }
    }
}

