/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.HeapHistogram;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.FilterUtils;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.graalvm.visualvm.profiling.actions.ProfiledSourceSelection;
import org.graalvm.visualvm.profiling.actions.ProfilerPopupCustomizer;
import org.graalvm.visualvm.sampler.AbstractSamplerSupport;
import org.graalvm.visualvm.sampler.memory.MemorySamplerSupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class MemoryView
extends JPanel {
    static final int MODE_HEAP = 1;
    static final int MODE_PERMGEN = 2;
    private final int mode;
    private final AbstractSamplerSupport.Refresher refresher;
    private boolean forceRefresh = false;
    private final MemoryMXBean memoryBean;
    private final MemorySamplerSupport.HeapDumper heapDumper;
    private final MemorySamplerSupport.SnapshotDumper snapshotDumper;
    private List<HeapHistogram.ClassInfo> classes = new ArrayList<HeapHistogram.ClassInfo>();
    private List<HeapHistogram.ClassInfo> baseClasses = new ArrayList<HeapHistogram.ClassInfo>();
    private JLabel lrLabel;
    private JToggleButton lrPauseButton;
    private JButton lrRefreshButton;
    private JToggleButton lrDeltasButton;
    private JLabel pdLabel;
    private JButton pdSnapshotButton;
    private AbstractButton gcButton;
    private AbstractButton heapdumpButton;
    private boolean popupPause;
    private JComponent bottomPanel;
    private JComponent filterPanel;
    private JComponent searchPanel;
    private HistogramTableModel tableModel;
    private ProfilerTable table;
    private HideableBarRenderer[] renderers;
    private static final String COL_NAME = NbBundle.getMessage(MemoryView.class, (String)"COL_Class_name");
    private static final String COL_BYTES = NbBundle.getMessage(MemoryView.class, (String)"COL_Bytes");
    private static final String COL_INSTANCES = NbBundle.getMessage(MemoryView.class, (String)"COL_Instances");

    MemoryView(Application application, AbstractSamplerSupport.Refresher refresher, int mode, MemoryMXBean memoryBean, MemorySamplerSupport.SnapshotDumper snapshotDumper, MemorySamplerSupport.HeapDumper heapDumper) {
        this.refresher = refresher;
        this.mode = mode;
        this.memoryBean = memoryBean;
        this.snapshotDumper = snapshotDumper;
        this.heapDumper = heapDumper;
        this.initComponents(application);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && MemoryView.this.isShowing()) {
                    MemoryView.this.refresher.refresh();
                }
            }
        });
    }

    void initSession() {
        if (this.pdSnapshotButton != null) {
            this.pdSnapshotButton.setEnabled(false);
        }
    }

    boolean isPaused() {
        return this.lrPauseButton.isSelected() && !this.forceRefresh;
    }

    boolean isEmpty() {
        return this.tableModel.getRowCount() == 0;
    }

    void refresh(HeapHistogram histogram) {
        if (histogram == null || this.isPaused()) {
            return;
        }
        long bytesMaxValue = 0L;
        long instancesMaxValue = 0L;
        this.forceRefresh = false;
        boolean diff = this.lrDeltasButton.isSelected();
        if (diff) {
            if (this.baseClasses == null) {
                this.baseClasses = new ArrayList<HeapHistogram.ClassInfo>(this.classes);
            }
            Collection<HeapHistogram.ClassInfo> newClasses = this.getHistogram(histogram);
            this.classes = MemoryView.computeDeltaClasses(this.baseClasses, newClasses);
            long maxAbsDiffBytes = 0L;
            long maxAbsDiffInstances = 0L;
            for (HeapHistogram.ClassInfo cInfo : this.classes) {
                maxAbsDiffBytes = Math.max(maxAbsDiffBytes, Math.abs(cInfo.getBytes()));
                maxAbsDiffInstances = Math.max(maxAbsDiffInstances, Math.abs(cInfo.getInstancesCount()));
            }
            bytesMaxValue = maxAbsDiffBytes;
            instancesMaxValue = maxAbsDiffInstances;
        } else {
            if (this.baseClasses != null) {
                this.baseClasses = null;
            }
            this.classes.clear();
            this.classes.addAll(this.getHistogram(histogram));
            bytesMaxValue = this.getTotalBytes(histogram);
            instancesMaxValue = this.getTotalInstances(histogram);
        }
        this.renderers[0].setDiffMode(diff);
        this.renderers[0].setMaxValue(bytesMaxValue);
        this.renderers[1].setDiffMode(diff);
        this.renderers[1].setMaxValue(instancesMaxValue);
        this.tableModel.fireTableDataChanged();
        if (this.pdSnapshotButton != null) {
            this.pdSnapshotButton.setEnabled(true);
        }
    }

    void starting() {
        this.lrPauseButton.setEnabled(true);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(true);
    }

    void stopping() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
    }

    void terminated() {
        this.lrPauseButton.setEnabled(false);
        this.lrRefreshButton.setEnabled(false);
        this.lrDeltasButton.setEnabled(false);
        this.gcButton.setEnabled(false);
        this.heapdumpButton.setEnabled(false);
    }

    private Collection<HeapHistogram.ClassInfo> getHistogram(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getHeapHistogram();
        }
        if (this.mode == 2) {
            return histogram.getPermGenHistogram();
        }
        return null;
    }

    private long getTotalBytes(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getTotalHeapBytes();
        }
        if (this.mode == 2) {
            return histogram.getTotalPermGenHeapBytes();
        }
        return -1L;
    }

    private long getTotalInstances(HeapHistogram histogram) {
        if (this.mode == 1) {
            return histogram.getTotalHeapInstances();
        }
        if (this.mode == 2) {
            return histogram.getTotalPerGenInstances();
        }
        return -1L;
    }

    private static List<HeapHistogram.ClassInfo> computeDeltaClasses(Collection<HeapHistogram.ClassInfo> basis, Collection<HeapHistogram.ClassInfo> changed) {
        HashMap<String, DeltaClassInfo> deltaMap = new HashMap<String, DeltaClassInfo>((int)((double)basis.size() * 1.3));
        for (HeapHistogram.ClassInfo cInfo : basis) {
            deltaMap.put(cInfo.getName(), new DeltaClassInfo(cInfo, true));
        }
        for (HeapHistogram.ClassInfo cInfo : changed) {
            DeltaClassInfo bInfo = (DeltaClassInfo)((Object)deltaMap.get(cInfo.getName()));
            if (bInfo != null) {
                bInfo.add(cInfo);
                continue;
            }
            deltaMap.put(cInfo.getName(), new DeltaClassInfo(cInfo, false));
        }
        return new ArrayList<HeapHistogram.ClassInfo>(deltaMap.values());
    }

    private void initComponents(final Application application) {
        this.tableModel = new HistogramTableModel();
        this.table = new ProfilerTable(this.tableModel, true, true, null){

            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                JMenuItem[] customItems;
                String selectedClass;
                String string = selectedClass = value == null ? null : value.toString();
                if (GoToSource.isAvailable()) {
                    popup.add(new JMenuItem(NbBundle.getMessage(MemoryView.class, (String)"MemoryView_Context_GoToSource")){
                        {
                            super(x0);
                            this.setEnabled(selectedClass != null);
                            this.setFont(this.getFont().deriveFont(1));
                        }

                        @Override
                        protected void fireActionPerformed(ActionEvent e) {
                            GoToSource.openSource(null, (String)selectedClass, null, null);
                        }
                    });
                    popup.addSeparator();
                }
                if (MemoryView.this.snapshotDumper != null && selectedClass != null && (customItems = MemoryView.this.createCustomMenuItems(application, selectedClass)) != null) {
                    for (JMenuItem customItem : customItems) {
                        popup.add(customItem);
                    }
                    popup.addSeparator();
                }
                popup.add(this.createCopyMenuItem());
                popup.addSeparator();
                popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        MemoryView.this.activateFilter();
                    }
                });
                popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        MemoryView.this.activateSearch();
                    }
                });
            }

            protected void popupShowing() {
                if (MemoryView.this.lrPauseButton.isEnabled() && !MemoryView.this.lrRefreshButton.isEnabled()) {
                    MemoryView.this.popupPause = true;
                    MemoryView.this.lrPauseButton.setSelected(true);
                }
            }

            protected void popupHidden() {
                if (MemoryView.this.lrPauseButton.isEnabled() && MemoryView.this.popupPause) {
                    MemoryView.this.popupPause = false;
                    MemoryView.this.lrPauseButton.setSelected(false);
                }
            }
        };
        this.table.setColumnToolTips(new String[]{NbBundle.getMessage(MemoryView.class, (String)"MemoryView_TOOLTIP_Col_name"), NbBundle.getMessage(MemoryView.class, (String)"MemoryView_TOOLTIP_Col_size"), NbBundle.getMessage(MemoryView.class, (String)"MemoryView_TOOLTIP_Col_count")});
        this.table.providePopupMenu(true);
        this.table.setMainColumn(0);
        this.table.setFitWidthColumn(0);
        this.table.setSortColumn(1);
        this.table.setDefaultSortOrder(1, SortOrder.DESCENDING);
        this.renderers = new HideableBarRenderer[2];
        this.renderers[0] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[1] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer());
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        this.table.setColumnRenderer(0, (ProfilerRenderer)new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class")));
        this.table.setColumnRenderer(1, (ProfilerRenderer)this.renderers[0]);
        this.table.setColumnRenderer(2, (ProfilerRenderer)this.renderers[1]);
        this.table.setDefaultColumnWidth(1, this.renderers[0].getOptimalWidth());
        this.table.setDefaultColumnWidth(2, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.table, false, null);
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.activateFilter();
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoryView.this.activateSearch();
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchUtils.enableSearchActions((ProfilerTable)MemoryView.this.table);
            }
        });
        this.lrLabel = new GrayLabel(NbBundle.getMessage(MemoryView.class, (String)"MemoryView_LBL_Results"));
        this.lrPauseButton = new JToggleButton(Icons.getIcon((String)"GeneralIcons.Pause")){

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                boolean paused = this.isSelected();
                MemoryView.this.lrRefreshButton.setEnabled(paused && !MemoryView.this.popupPause);
                if (!paused) {
                    MemoryView.this.refresher.refresh();
                }
            }
        };
        this.lrPauseButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Pause_results"));
        this.lrRefreshButton = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                MemoryView.this.forceRefresh = true;
                MemoryView.this.refresher.refresh();
            }
        };
        this.lrRefreshButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Update_results"));
        this.lrRefreshButton.setEnabled(false);
        Icon icon = Icons.getIcon((String)"ProfilerIcons.DeltaResults");
        this.lrDeltasButton = new JToggleButton(icon){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                if (!MemoryView.this.lrPauseButton.isSelected()) {
                    MemoryView.this.forceRefresh = true;
                    MemoryView.this.refresher.refresh();
                }
            }
        };
        this.lrDeltasButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Deltas"));
        if (this.snapshotDumper != null) {
            this.pdLabel = new GrayLabel(NbBundle.getMessage(MemoryView.class, (String)"MemoryView_LBL_Data"));
            this.pdSnapshotButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Snapshot"), new ImageIcon(ImageUtilities.loadImage((String)"org/graalvm/visualvm/sampler/resources/snapshot.png", (boolean)true))){

                @Override
                protected void fireActionPerformed(ActionEvent event) {
                    MemoryView.this.snapshotDumper.takeSnapshot((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
                }
            };
            this.pdSnapshotButton.setText(NbBundle.getMessage(MemoryView.class, (String)"MemoryView_LBL_Snapshot"));
            this.pdSnapshotButton.putClientProperty("JComponent.sizeVariant", "regular");
        }
        ProfilerToolbar toolbar = ProfilerToolbar.create((boolean)true);
        toolbar.addSpace(5);
        toolbar.add((Component)this.lrLabel);
        toolbar.addSpace(2);
        toolbar.add((Component)this.lrPauseButton);
        toolbar.add((Component)this.lrRefreshButton);
        toolbar.addSpace(5);
        toolbar.add((Component)this.lrDeltasButton);
        if (this.pdSnapshotButton != null) {
            toolbar.addSpace(2);
            toolbar.addSeparator();
            toolbar.addSpace(5);
            toolbar.add((Component)this.pdLabel);
            toolbar.addSpace(2);
            toolbar.add((Component)this.pdSnapshotButton);
        }
        toolbar.addFiller();
        this.gcButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_Gc")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                new RequestProcessor("GC Processor").post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MemoryView.this.memoryBean.gc();
                        }
                        catch (Exception e) {
                            this.setEnabled(false);
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                });
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.gcButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_Gc"));
        this.gcButton.setOpaque(false);
        this.gcButton.setEnabled(this.memoryBean != null);
        toolbar.add((Component)this.gcButton);
        this.heapdumpButton = new JButton(NbBundle.getMessage(MemoryView.class, (String)"LBL_HeapDump")){

            @Override
            protected void fireActionPerformed(ActionEvent event) {
                MemoryView.this.heapDumper.takeHeapDump((event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width += 5;
                return dim;
            }
        };
        this.heapdumpButton.setToolTipText(NbBundle.getMessage(MemoryView.class, (String)"TOOLTIP_HeapDump"));
        this.heapdumpButton.setOpaque(false);
        this.heapdumpButton.setEnabled(this.heapDumper != null);
        toolbar.add((Component)this.heapdumpButton);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)toolbar.getComponent(), "North");
        this.add((Component)tableContainer, "Center");
    }

    private JComponent getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new FilterFindLayout());
            this.bottomPanel.setOpaque(true);
            this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
            this.add((Component)this.bottomPanel, "South");
        }
        return this.bottomPanel;
    }

    private void activateFilter() {
        JComponent panel = this.getBottomPanel();
        if (this.filterPanel == null) {
            this.filterPanel = FilterUtils.createFilterPanel((ProfilerTable)this.table);
            panel.add(this.filterPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.filterPanel.setVisible(true);
        this.filterPanel.requestFocusInWindow();
    }

    private void activateSearch() {
        JComponent panel = this.getBottomPanel();
        if (this.searchPanel == null) {
            this.searchPanel = SearchUtils.createSearchPanel((ProfilerTable)this.table);
            panel.add(this.searchPanel);
            Container parent = panel.getParent();
            parent.invalidate();
            parent.revalidate();
            parent.repaint();
        }
        panel.setVisible(true);
        this.searchPanel.setVisible(true);
        this.searchPanel.requestFocusInWindow();
    }

    private JMenuItem[] createCustomMenuItems(Application application, String className) {
        Collection customizers = Lookup.getDefault().lookupAll(ProfilerPopupCustomizer.class);
        if (customizers.isEmpty()) {
            return null;
        }
        ProfiledSourceSelection pss = new ProfiledSourceSelection(application, className, "*", null);
        ArrayList menuItems = new ArrayList(customizers.size());
        for (ProfilerPopupCustomizer customizer : customizers) {
            JMenuItem[] items;
            if (!customizer.supportsDataView(ProfilerPopupCustomizer.View.MEMORY, ProfilerPopupCustomizer.Mode.LIVE) || (items = customizer.getMenuItems(pss, ProfilerPopupCustomizer.View.MEMORY, ProfilerPopupCustomizer.Mode.LIVE)) == null) continue;
            Collections.addAll(menuItems, items);
        }
        return menuItems.isEmpty() ? null : menuItems.toArray(new JMenuItem[0]);
    }

    private static class DeltaClassInfo
    extends HeapHistogram.ClassInfo {
        String name;
        long instancesCount;
        long bytes;

        DeltaClassInfo(HeapHistogram.ClassInfo cInfo, boolean negative) {
            this.name = cInfo.getName();
            this.instancesCount = negative ? -cInfo.getInstancesCount() : cInfo.getInstancesCount();
            this.bytes = negative ? -cInfo.getBytes() : cInfo.getBytes();
        }

        void add(HeapHistogram.ClassInfo cInfo) {
            this.instancesCount += cInfo.getInstancesCount();
            this.bytes += cInfo.getBytes();
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instancesCount;
        }

        public long getBytes() {
            return this.bytes;
        }
    }

    private final class FilterFindLayout
    implements LayoutManager {
        private FilterFindLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = MemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = MemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getPreferredSize();
                Dimension dim2 = search.getPreferredSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getPreferredSize();
            } else if (search != null) {
                dim = search.getPreferredSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JComponent search;
            JComponent filter = MemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = MemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            Dimension dim = new Dimension();
            if (filter != null && search != null) {
                Dimension dim1 = filter.getMinimumSize();
                Dimension dim2 = search.getMinimumSize();
                dim.width = dim1.width + dim2.width + 1;
                dim.height = Math.max(dim1.height, dim2.height);
            } else if (filter != null) {
                dim = filter.getMinimumSize();
            } else if (search != null) {
                dim = search.getMinimumSize();
            }
            if (filter != null || search != null) {
                ++dim.height;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            JComponent search;
            JComponent filter = MemoryView.this.filterPanel;
            if (filter != null && !filter.isVisible()) {
                filter = null;
            }
            if ((search = MemoryView.this.searchPanel) != null && !search.isVisible()) {
                search = null;
            }
            int bottomOffset = 0;
            if (filter != null && search != null) {
                Dimension size = parent.getSize();
                int w = (size.width - 1) / 2;
                filter.setBounds(0, 0, w, size.height - bottomOffset);
                search.setBounds(w + 1, 0, size.width - w - 1, size.height - bottomOffset);
            } else if (filter != null) {
                Dimension size = parent.getSize();
                filter.setBounds(0, 0, size.width, size.height - bottomOffset);
            } else if (search != null) {
                Dimension size = parent.getSize();
                search.setBounds(0, 0, size.width, size.height - bottomOffset);
            }
        }
    }

    private class HistogramTableModel
    extends AbstractTableModel {
        private HistogramTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return COL_NAME;
            }
            if (columnIndex == 1) {
                return COL_BYTES;
            }
            if (columnIndex == 2) {
                return COL_INSTANCES;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            return Long.class;
        }

        @Override
        public int getRowCount() {
            return MemoryView.this.classes.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((HeapHistogram.ClassInfo)MemoryView.this.classes.get(rowIndex)).getName();
            }
            if (columnIndex == 1) {
                return ((HeapHistogram.ClassInfo)MemoryView.this.classes.get(rowIndex)).getBytes();
            }
            if (columnIndex == 2) {
                return ((HeapHistogram.ClassInfo)MemoryView.this.classes.get(rowIndex)).getInstancesCount();
            }
            return null;
        }
    }
}

