/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.exceptions.AdjustmentException;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.MaxFragmentLengthExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.MaxFragmentLengthExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.MaxFragmentLengthExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.MaxFragmentLengthExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaxFragmentLengthExtensionHandler
extends ExtensionHandler<MaxFragmentLengthExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public MaxFragmentLengthExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public void adjustTLSExtensionContext(MaxFragmentLengthExtensionMessage message) {
        byte[] maxFragmentLengthBytes = (byte[])message.getMaxFragmentLength().getValue();
        if (maxFragmentLengthBytes.length != 1) {
            throw new AdjustmentException("Cannot adjust MaxFragmentLength to a resonable value");
        }
        MaxFragmentLength length = MaxFragmentLength.getMaxFragmentLength(maxFragmentLengthBytes[0]);
        if (length == null) {
            LOGGER.warn("Unknown MaxFragmentLength:" + ArrayConverter.bytesToHexString((byte[])maxFragmentLengthBytes));
        } else {
            this.context.setMaxFragmentLength(length);
        }
    }

    @Override
    public MaxFragmentLengthExtensionParser getParser(byte[] message, int pointer) {
        return new MaxFragmentLengthExtensionParser(pointer, message);
    }

    public MaxFragmentLengthExtensionPreparator getPreparator(MaxFragmentLengthExtensionMessage message) {
        return new MaxFragmentLengthExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public MaxFragmentLengthExtensionSerializer getSerializer(MaxFragmentLengthExtensionMessage message) {
        return new MaxFragmentLengthExtensionSerializer(message);
    }
}

