/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view.save;

import java.io.File;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRRtfSaveContributor
extends JRSaveContributor {
    private static final String EXTENSION_RTF = ".rtf";

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(EXTENSION_RTF);
    }

    public String getDescription() {
        return "RTF (*.rtf)";
    }

    public void save(JasperPrint jasperPrint, File file) throws JRException {
        if (!file.getName().endsWith(EXTENSION_RTF)) {
            file = new File(file.getAbsolutePath() + EXTENSION_RTF);
        }
        JRRtfExporter exporter = new JRRtfExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE, file);
        exporter.exportReport();
    }
}

