function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { KuiTableRowCell } from './table_row_cell';
export const KuiTableRowCheckBoxCell = _ref => {
  let {
    onChange,
    isChecked,
    className,
    ...rest
  } = _ref;
  const classes = classNames('kuiTableRowCell--checkBox', className);
  return /*#__PURE__*/React.createElement(KuiTableRowCell, _extends({
    className: classes
  }, rest), /*#__PURE__*/React.createElement("input", {
    type: "checkbox",
    className: "kuiCheckBox",
    onChange: onChange,
    checked: isChecked,
    "aria-label": `${isChecked ? 'Deselect' : 'Select'} row`
  }));
};
KuiTableRowCheckBoxCell.propTypes = {
  isChecked: PropTypes.bool,
  onChange: PropTypes.func,
  className: PropTypes.string
};
