/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.List;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.elements.util.StringUtil;

public class WebLink
implements Comparable<WebLink> {
    private String uri;
    private final ResourceAttributes attributes;

    public WebLink(String uri) {
        this.uri = uri;
        this.attributes = new ResourceAttributes();
    }

    public String getURI() {
        return this.uri;
    }

    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(this.uri);
        builder.append('>');
        if (this.attributes.containsAttribute("title")) {
            builder.append(' ').append(this.attributes.getTitle());
        }
        this.append(builder, "rt");
        this.append(builder, "if");
        this.append(builder, "ct");
        this.append(builder, "sz");
        this.append(builder, "obs");
        return builder.toString();
    }

    private void append(StringBuilder builder, String attributeName) {
        if (this.attributes.containsAttribute(attributeName)) {
            builder.append(StringUtil.lineSeparator()).append("\t").append(attributeName);
            List<String> values = this.attributes.getAttributeValues(attributeName);
            if (!values.isEmpty()) {
                builder.append(":\t").append(values);
            }
        }
    }

    @Override
    public int compareTo(WebLink other) {
        return this.uri.compareTo(other.getURI());
    }
}

