/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.debugger.registry.ContextAwareServicePath;
import org.netbeans.spi.debugger.ActionsProvider;
import org.netbeans.spi.debugger.ActionsProviderListener;
import org.openide.util.Cancellable;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public final class ActionsManager {
    public static final Object ACTION_STEP_OVER = "stepOver";
    public static final Object ACTION_RUN_INTO_METHOD = "runIntoMethod";
    public static final Object ACTION_STEP_INTO = "stepInto";
    public static final Object ACTION_STEP_OUT = "stepOut";
    public static final Object ACTION_STEP_OPERATION = "stepOperation";
    public static final Object ACTION_CONTINUE = "continue";
    public static final Object ACTION_START = "start";
    public static final Object ACTION_KILL = "kill";
    public static final Object ACTION_MAKE_CALLER_CURRENT = "makeCallerCurrent";
    public static final Object ACTION_MAKE_CALLEE_CURRENT = "makeCalleeCurrent";
    public static final Object ACTION_PAUSE = "pause";
    public static final Object ACTION_RUN_TO_CURSOR = "runToCursor";
    public static final Object ACTION_POP_TOPMOST_CALL = "popTopmostCall";
    public static final Object ACTION_FIX = "fix";
    public static final Object ACTION_RESTART = "restart";
    public static final Object ACTION_TOGGLE_BREAKPOINT = "toggleBreakpoint";
    public static final Object ACTION_NEW_WATCH = "newWatch";
    public static final Object ACTION_EVALUATE = "evaluate";
    private static final Logger logger = Logger.getLogger(ActionsManager.class.getName());
    private final List<ActionsManagerListener> listener = new ArrayList<ActionsManagerListener>();
    private final HashMap<String, List<ActionsManagerListener>> listeners = new HashMap();
    private HashMap<Object, List<ActionsProvider>> actionProviders;
    private final Object actionProvidersLock = new Object();
    private final AtomicBoolean actionProvidersInitialized = new AtomicBoolean(false);
    private final ActionsProviderListener actionListener = (action, enabled) -> this.fireActionStateChanged(action);
    private final Lookup lookup;
    private boolean doiingDo = false;
    private boolean destroy = false;
    private volatile List<? extends ActionsProvider> aps;
    private volatile PropertyChangeListener providersChangeListener;
    private boolean listerersLoaded = false;
    private List<? extends LazyActionsManagerListener> lazyListeners;

    ActionsManager(Lookup lookup) {
        this.lookup = lookup;
        logger.log(Level.FINE, "new ActionsManager({0}) = {1}", new Object[]{lookup, this});
    }

    public final void doAction(Object action) {
        this.doiingDo = true;
        List<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean done = false;
        for (ActionsProvider ap : l) {
            if (!ap.isEnabled(action)) continue;
            this.fireActionToBeRun(action);
            done = true;
            ap.doAction(action);
        }
        if (done) {
            this.fireActionDone(action);
        }
        this.doiingDo = false;
        if (this.destroy) {
            this.destroyIn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task postAction(Object action) {
        boolean inited;
        this.doiingDo = true;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            inited = this.actionProviders != null;
        }
        if (!inited && Mutex.EVENT.isReadAccess()) {
            return this.postActionWithLazyInit(action);
        }
        List<ActionsProvider> l = this.getActionProvidersForActionWithInit(action);
        boolean posted = false;
        List<ActionsProvider> postedActions = new ArrayList<ActionsProvider>(l.size());
        AsynchActionTask task = new AsynchActionTask(postedActions);
        for (ActionsProvider ap : l) {
            if (!ap.isEnabled(action)) continue;
            postedActions.add(ap);
            posted = true;
        }
        if (posted) {
            if (postedActions.size() > 1) {
                postedActions = ActionsManager.selectTheMostSpecific(postedActions);
            }
            AtomicInteger count = new AtomicInteger(postedActions.size());
            Runnable notifier = () -> {
                if (count.decrementAndGet() == 0) {
                    task.actionDone();
                    this.fireActionDone(action);
                    this.doiingDo = false;
                    if (this.destroy) {
                        this.destroyIn();
                    }
                }
            };
            this.fireActionToBeRun(action);
            for (ActionsProvider pa : postedActions) {
                pa.postAction(action, notifier);
            }
        } else {
            this.doiingDo = false;
            if (this.destroy) {
                this.destroyIn();
            }
            task.actionDone();
        }
        return task;
    }

    private Task postActionWithLazyInit(Object action) {
        AsynchActionTask task = new AsynchActionTask(Collections.emptyList());
        new RequestProcessor(ActionsManager.class).post(() -> {
            try {
                this.doAction(action);
            }
            finally {
                task.actionDone();
            }
        });
        return task;
    }

    private static List<ActionsProvider> selectTheMostSpecific(List<ActionsProvider> aps) {
        ArrayList<Pair> providersByPath = new ArrayList<Pair>();
        for (ActionsProvider ap : aps) {
            String path = ActionsManager.getPath(ap);
            if (path == null) {
                return aps;
            }
            providersByPath.add(Pair.of((Object)path, (Object)ap));
        }
        int n = providersByPath.size();
        block1: for (int i = 0; i < n; ++i) {
            String p1 = (String)((Pair)providersByPath.get(i)).first();
            for (int j = 0; j < n; ++j) {
                String p2;
                if (i == j || p1.equals(p2 = (String)((Pair)providersByPath.get(j)).first()) || !p1.startsWith(p2)) continue;
                providersByPath.remove(j);
                --i;
                --n;
                continue block1;
            }
        }
        List<ActionsProvider> ret = aps;
        if (providersByPath.size() < aps.size()) {
            ret = new LinkedList<ActionsProvider>();
            for (Pair pair : providersByPath) {
                ret.add((ActionsProvider)pair.second());
            }
        }
        return ret;
    }

    private static String getPath(ActionsProvider ap) {
        if (ap instanceof ContextAwareServicePath) {
            String path = ((ContextAwareServicePath)((Object)ap)).getServicePath();
            int i = path.lastIndexOf(47);
            if (i > 0) {
                return path.substring(0, i);
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled(Object action) {
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            if (Mutex.EVENT.isReadAccess()) {
                new RequestProcessor(ActionsManager.class).post(() -> this.initActionImpls());
            } else {
                this.initActionImpls();
            }
        }
        List<ActionsProvider> l = this.getActionProvidersForAction(action);
        for (ActionsProvider ap : l) {
            if (!ap.isEnabled(action)) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
        if (!this.doiingDo) {
            this.destroyIn();
        }
        this.destroy = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionsManagerListener(ActionsManagerListener l) {
        List<ActionsManagerListener> list = this.listener;
        synchronized (list) {
            this.listener.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsManagerListener(ActionsManagerListener l) {
        List<ActionsManagerListener> list = this.listener;
        synchronized (list) {
            this.listener.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                ls = new ArrayList<ActionsManagerListener>();
                this.listeners.put(propertyName, ls);
            }
            ls.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionsManagerListener(String propertyName, ActionsManagerListener l) {
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            List<ActionsManagerListener> ls = this.listeners.get(propertyName);
            if (ls == null) {
                return;
            }
            ls.remove(l);
            if (ls.isEmpty()) {
                this.listeners.remove(propertyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionToBeRun(Object action) {
        ArrayList l1;
        this.initListeners();
        HashMap<String, List<ActionsManagerListener>> hashMap = this.listeners;
        synchronized (hashMap) {
            l1 = this.listeners.get("actionToBeRun");
            l1 = l1 != null ? new ArrayList(l1) : Collections.emptyList();
        }
        PropertyChangeEvent e = new PropertyChangeEvent(this, "actionToBeRun", null, action);
        for (ActionsManagerListener aml : l1) {
            if (!(aml instanceof PropertyChangeListener)) continue;
            ((PropertyChangeListener)((Object)aml)).propertyChange(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionDone(Object action) {
        ArrayList l1;
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        Iterator iterator = this.listeners;
        synchronized (iterator) {
            l1 = this.listeners.get("actionPerformed");
            l1 = l1 != null ? new ArrayList(l1) : Collections.emptyList();
        }
        for (ActionsManagerListener aml : l) {
            aml.actionPerformed(action);
        }
        for (ActionsManagerListener aml : l1) {
            aml.actionPerformed(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionStateChanged(Object action) {
        ArrayList l1;
        boolean enabled = this.isEnabled(action);
        this.initListeners();
        ArrayList<ActionsManagerListener> l = new ArrayList<ActionsManagerListener>(this.listener);
        Iterator iterator = this.listeners;
        synchronized (iterator) {
            l1 = this.listeners.get("actionStateChanged");
            l1 = l1 != null ? new ArrayList(l1) : Collections.emptyList();
        }
        for (ActionsManagerListener aml : l) {
            aml.actionStateChanged(action, enabled);
        }
        for (ActionsManagerListener aml : l1) {
            aml.actionStateChanged(action, enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionsProvider> getActionProvidersForAction(Object action) {
        Object object = this.actionProvidersLock;
        synchronized (object) {
            List<ActionsProvider> l = this.actionProviders.get(action);
            return l != null ? new ArrayList<ActionsProvider>(l) : Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActionsProvider> getActionProvidersForActionWithInit(Object action) {
        boolean doInit = false;
        Object object = this.actionProvidersLock;
        synchronized (object) {
            if (this.actionProviders == null) {
                this.actionProviders = new HashMap();
                doInit = true;
            }
        }
        if (doInit) {
            this.initActionImpls();
        } else if (!this.actionProvidersInitialized.get()) {
            object = this.actionProvidersInitialized;
            synchronized (object) {
                if (!this.actionProvidersInitialized.get()) {
                    try {
                        this.actionProvidersInitialized.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.getActionProvidersForAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProvider(Object action, ActionsProvider p) {
        Object object = this.actionProvidersLock;
        synchronized (object) {
            List<ActionsProvider> l = this.actionProviders.get(action);
            if (l == null) {
                l = new ArrayList<ActionsProvider>();
                this.actionProviders.put(action, l);
            }
            l.add(p);
        }
        p.addActionsProviderListener(this.actionListener);
        this.fireActionStateChanged(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerActionsProviders(List<? extends ActionsProvider> aps) {
        List<? extends ActionsProvider> list = aps;
        synchronized (list) {
            if (logger.isLoggable(Level.INFO)) {
                boolean bl;
                StringBuilder sb = new StringBuilder(this.toString());
                boolean bl2 = false;
                sb.append(".registerActionsProviders:");
                for (ActionsProvider actionsProvider : aps) {
                    sb.append("\n  ");
                    if (actionsProvider != null) {
                        sb.append(actionsProvider.toString());
                        continue;
                    }
                    sb.append("NULL element in list ").append(Integer.toHexString(aps.hashCode()));
                    bl = true;
                }
                sb.append("\n");
                if (bl) {
                    logger.info(sb.toString());
                } else {
                    logger.fine(sb.toString());
                }
            }
            for (ActionsProvider actionsProvider : aps) {
                if (actionsProvider == null) continue;
                for (ActionsProvider actionsProvider2 : actionsProvider.getActions()) {
                    this.registerActionsProvider(actionsProvider2, actionsProvider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initActionImpls() {
        try {
            this.aps = this.lookup.lookup(null, ActionsProvider.class);
            this.providersChangeListener = new PropertyChangeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    logger.log(Level.FINE, "{0} Providers lookup changed, aps = {1}", new Object[]{this, ActionsManager.this.aps});
                    Object object = ActionsManager.this.actionProvidersLock;
                    synchronized (object) {
                        ActionsManager.this.actionProviders.clear();
                    }
                    ActionsManager.this.registerActionsProviders(ActionsManager.this.aps);
                }
            };
            logger.log(Level.FINE, "{0}.initActionImpls(): Add ProvidersChangeListener to {1}", new Object[]{this, this.aps});
            ((Customizer)((Object)this.aps)).addPropertyChangeListener(this.providersChangeListener);
            this.registerActionsProviders(this.aps);
        }
        finally {
            AtomicBoolean atomicBoolean = this.actionProvidersInitialized;
            synchronized (atomicBoolean) {
                this.actionProvidersInitialized.set(true);
                this.actionProvidersInitialized.notifyAll();
            }
        }
    }

    private synchronized void initListeners() {
        if (this.listerersLoaded) {
            return;
        }
        this.listerersLoaded = true;
        this.lazyListeners = this.lookup.lookup(null, LazyActionsManagerListener.class);
        for (LazyActionsManagerListener lazyActionsManagerListener : this.lazyListeners) {
            if (lazyActionsManagerListener == null) continue;
            String[] props = lazyActionsManagerListener.getProperties();
            if (props == null) {
                this.addActionsManagerListener(lazyActionsManagerListener);
                continue;
            }
            for (String prop : props) {
                this.addActionsManagerListener(prop, lazyActionsManagerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIn() {
        Customizer caps = (Customizer)((Object)this.aps);
        PropertyChangeListener pchl = this.providersChangeListener;
        if (caps != null && pchl != null) {
            caps.removePropertyChangeListener(pchl);
            logger.log(Level.FINE, "{0}.destroyIn(): ProvidersChangeListener removed from {1}", new Object[]{this, caps});
        }
        Object object = this;
        synchronized (object) {
            if (this.lazyListeners != null) {
                for (LazyActionsManagerListener lazyActionsManagerListener : this.lazyListeners) {
                    if (lazyActionsManagerListener == null) continue;
                    String[] props = lazyActionsManagerListener.getProperties();
                    if (props == null) {
                        this.removeActionsManagerListener(lazyActionsManagerListener);
                        continue;
                    }
                    for (String prop : props) {
                        this.removeActionsManagerListener(prop, lazyActionsManagerListener);
                    }
                    lazyActionsManagerListener.destroy();
                }
                this.lazyListeners = new ArrayList<LazyActionsManagerListener>();
            }
        }
        object = this.actionProvidersLock;
        synchronized (object) {
            Collection<List<ActionsProvider>> apsc = this.actionProviders.values();
            for (List<ActionsProvider> ps : apsc) {
                for (ActionsProvider ap : ps) {
                    ap.removeActionsProviderListener(this.actionListener);
                }
            }
        }
    }

    private static class AsynchActionTask
    extends Task
    implements Cancellable {
        private final Collection<? extends ActionsProvider> postedActions;

        public AsynchActionTask(Collection<? extends ActionsProvider> postedActions) {
            this.postedActions = postedActions;
        }

        void actionDone() {
            this.notifyFinished();
        }

        public boolean cancel() {
            for (ActionsProvider actionsProvider : this.postedActions) {
                Cancellable c = this.getCancellable(actionsProvider);
                if (c != null) {
                    if (c.cancel()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private Cancellable getCancellable(Object action) {
            if (action instanceof Cancellable) {
                return (Cancellable)action;
            }
            try {
                Field delegateField = action.getClass().getDeclaredField("delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(action);
                if (delegate instanceof Cancellable) {
                    return (Cancellable)action;
                }
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
            return null;
        }
    }
}

