/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.Collator;
import java.util.Comparator;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.api.EditableManifest;
import org.netbeans.modules.apisupport.project.layers.PathCompletions;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public final class Util {
    public static final ErrorManager err;

    private Util() {
    }

    public static EditableProperties loadProperties(FileObject propsFO) throws IOException {
        EditableProperties props = new EditableProperties(true);
        try (InputStream propsIS = propsFO.getInputStream();){
            props.load(propsIS);
        }
        return props;
    }

    public static void storeProperties(FileObject propsFO, EditableProperties props) throws IOException {
        try (OutputStream os = propsFO.getOutputStream();){
            props.store(os);
        }
    }

    @NonNull
    public static EditableManifest loadManifest(@NonNull FileObject manifestFO) throws IOException {
        try (InputStream mfIS = manifestFO.getInputStream();){
            EditableManifest editableManifest = new EditableManifest(mfIS);
            return editableManifest;
        }
    }

    public static void storeManifest(FileObject manifestFO, EditableManifest em) throws IOException {
        try (OutputStream os = manifestFO.getOutputStream();){
            em.write(os);
        }
    }

    @CheckForNull
    public static Manifest getManifest(@NullAllowed FileObject manifestFO) {
        if (manifestFO != null) {
            Manifest manifest;
            InputStream is = manifestFO.getInputStream();
            try {
                manifest = new Manifest(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getLogger(Util.class.getName()).log(Level.INFO, "Could not parse: " + manifestFO, e);
                }
            }
            is.close();
            return manifest;
        }
        return null;
    }

    public static Comparator<Project> projectDisplayNameComparator() {
        return new Comparator<Project>(){
            private final Collator LOC_COLLATOR = Collator.getInstance();

            @Override
            public int compare(Project o1, Project o2) {
                ProjectInformation i1 = ProjectUtils.getInformation((Project)o1);
                ProjectInformation i2 = ProjectUtils.getInformation((Project)o2);
                int result = this.LOC_COLLATOR.compare(i1.getDisplayName(), i2.getDisplayName());
                if (result != 0) {
                    return result;
                }
                result = i1.getName().compareTo(i2.getName());
                if (result != 0) {
                    return result;
                }
                return System.identityHashCode(o1) - System.identityHashCode(o2);
            }
        };
    }

    public static FileObject getResourceDirectory(Project prj) {
        Sources srcs = ProjectUtils.getSources((Project)prj);
        SourceGroup[] grps = srcs.getSourceGroups("resources");
        if (grps != null && grps.length > 0) {
            return grps[0].getRootFolder();
        }
        NbModuleProvider prov = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
        assert (prov != null);
        return prov.getSourceDirectory();
    }

    public static FileObject getResource(Project prj, String path) {
        Sources srcs = ProjectUtils.getSources((Project)prj);
        SourceGroup[] grps = srcs.getSourceGroups("resources");
        if (grps != null && grps.length > 0) {
            for (SourceGroup sg : grps) {
                FileObject fo = sg.getRootFolder().getFileObject(path);
                if (fo == null) continue;
                return fo;
            }
        }
        NbModuleProvider prov = (NbModuleProvider)prj.getLookup().lookup(NbModuleProvider.class);
        assert (prov != null);
        return prov.getSourceDirectory().getFileObject(path);
    }

    static {
        PathCompletions.register();
        err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project");
    }
}

