/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.svg.navigation;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.SVGRenderingHints;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.svg.SVGViewerElement;
import org.openide.awt.GraphicsUtils;
import org.openide.util.NbBundle;

public class SVGPreviewPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SVGViewerElement.class.getName());
    private SVGDocument svgDocument;
    private final int stringGapSize = 10;
    private final Color background = UIManager.getColor("Table.background");
    private final Color foreground = UIManager.getColor("Table.foreground");

    public void setSVG(SVGDocument svgDoc) {
        this.svgDocument = svgDoc;
        this.setBackground(this.background);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        super.paintComponent(g);
        if (this.svgDocument != null) {
            g.setColor(this.foreground);
            FloatSize size = this.svgDocument.size();
            int originalWidth = (int)size.getWidth();
            int originalHeight = (int)size.getHeight();
            String sizes = "Dimensions: " + originalWidth + " x " + originalHeight;
            g.drawString(sizes, (int)((double)this.getWidth() * 0.05), this.getHeight() - 10);
            int thumbnailMaxSize = 100;
            double widthRatio = (double)originalWidth / (double)thumbnailMaxSize;
            double heightRatio = (double)originalHeight / (double)thumbnailMaxSize;
            double ratio = 1.0;
            if (widthRatio > 1.0 || heightRatio > 1.0) {
                ratio = widthRatio > heightRatio ? widthRatio : heightRatio;
            }
            int scaledWidth = (int)((double)originalWidth / ratio);
            int scaledHeight = (int)((double)originalHeight / ratio);
            Graphics2D g2d = (Graphics2D)g.create((this.getWidth() - scaledWidth) / 2, (this.getHeight() - scaledHeight) / 2, scaledWidth, scaledHeight);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(SVGRenderingHints.KEY_MASK_CLIP_RENDERING, SVGRenderingHints.VALUE_MASK_CLIP_RENDERING_ACCURACY);
            g2d.scale(1.0 / ratio, 1.0 / ratio);
            try {
                this.svgDocument.render((JComponent)this, g2d);
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, ex.getMessage());
                this.drawErrorMessage(g);
            }
            finally {
                g2d.dispose();
            }
        } else {
            this.drawErrorMessage(g);
        }
    }

    private void drawErrorMessage(Graphics g) {
        g.setColor(Color.RED);
        FontMetrics fm = this.getFontMetrics(g.getFont());
        String errMessage = NbBundle.getMessage(SVGPreviewPanel.class, (String)"ERR_Thumbnail");
        int stringWidth = fm.stringWidth(errMessage);
        g.drawString(errMessage, (this.getWidth() - stringWidth) / 2, this.getHeight() / 2);
        g.dispose();
    }
}

