/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class SharabilityUtility {
    public static final String DEFAULT_LIBRARIES_FILENAME = "nblibraries.properties";

    private SharabilityUtility() {
    }

    public static String getLibraryLocation(String librariesDir) {
        String librariesDefinition = librariesDir;
        if (librariesDefinition != null) {
            if (!librariesDefinition.endsWith(File.separator)) {
                librariesDefinition = librariesDefinition + File.separatorChar;
            }
            librariesDefinition = librariesDefinition + DEFAULT_LIBRARIES_FILENAME;
        }
        return librariesDefinition;
    }

    public static void makeSureProjectHasCopyLibsLibrary(AntProjectHelper helper, final ReferenceHelper refHelper) {
        if (!helper.isSharableProject() || refHelper.getProjectLibraryManager() == null) {
            return;
        }
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Library lib = refHelper.getProjectLibraryManager().getLibrary("CopyLibs");
                if (lib == null) {
                    try {
                        refHelper.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    boolean version61;
                    List roots = lib.getContent("classpath");
                    boolean bl = version61 = ClassPathSupport.createClassPath((URL[])roots.toArray(new URL[0])).findResource("org/netbeans/modules/java/j2seproject/copylibstask/CopyFiles.class") == null;
                    if (!version61) {
                        return;
                    }
                    try {
                        refHelper.getProjectLibraryManager().removeLibrary(lib);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        FileObject parent = null;
                        for (URL u : roots) {
                            FileObject fo;
                            URL u2 = FileUtil.getArchiveFile((URL)u);
                            if (u2 != null) {
                                u = u2;
                            }
                            if ((fo = URLMapper.findFileObject((URL)u)) == null) continue;
                            if (parent == null) {
                                parent = fo.getParent();
                            }
                            fo.delete();
                        }
                        if (parent != null && parent.getChildren().length == 0 && parent.getNameExt().equals("CopyLibs")) {
                            parent.delete();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        refHelper.copyLibrary(LibraryManager.getDefault().getLibrary("CopyLibs"));
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        });
    }
}

