/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.micronaut.MicronautConfigProperties;
import org.netbeans.modules.micronaut.completion.MicronautConfigDocumentation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataProperty;

public class MicronautJavaConfigPropertiesCompletion
implements Processor {
    private static final Set<String> supportedAnnotationTypes = new HashSet<String>(Arrays.asList("io.micronaut.context.annotation.Property", "io.micronaut.context.annotation.Value"));
    private Reference<ProcessingEnvironment> processingEnv;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return false;
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        ProcessingEnvironment env;
        if (member != null && annotation != null && (env = this.processingEnv.get()) != null) {
            Trees trees;
            TreePath path;
            Name annotationTypeSimpleName = annotation.getAnnotationType().asElement().getSimpleName();
            String prefix = null;
            String postfix = null;
            if ("Property".contentEquals(annotationTypeSimpleName)) {
                if ("name".contentEquals(member.getSimpleName())) {
                    postfix = prefix = "\"";
                }
            } else if ("Value".contentEquals(annotationTypeSimpleName)) {
                prefix = "\"${";
                postfix = "}\"";
            }
            if (prefix != null && postfix != null && (path = (trees = Trees.instance(env)).getPath(element)) != null) {
                Project project;
                FileObject fo;
                try {
                    fo = URLMapper.findFileObject((URL)path.getCompilationUnit().getSourceFile().toUri().toURL());
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return Collections.emptyList();
                }
                Project project2 = project = fo != null ? FileOwnerQuery.getOwner((FileObject)fo) : null;
                if (project != null) {
                    Map<String, ConfigurationMetadataProperty> properties = MicronautConfigProperties.getProperties(project);
                    ArrayList<1> ret = new ArrayList<1>(properties.size());
                    final String format = prefix + "%s" + postfix;
                    for (final ConfigurationMetadataProperty property : properties.values()) {
                        if (property.getId().contains("*")) continue;
                        ret.add(new Completion(){

                            @Override
                            public String getValue() {
                                return String.format(format, property.getId());
                            }

                            @Override
                            public String getMessage() {
                                return new MicronautConfigDocumentation(property).getText();
                            }
                        });
                    }
                    return ret;
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.processingEnv = new WeakReference<ProcessingEnvironment>(processingEnv);
    }
}

