/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.internal;

import com.oracle.bmc.http.client.internal.DelegationTokenClientFilterProvider;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

class DefaultHolder {
    private static DelegationTokenClientFilterProvider DEFAULT = null;

    DefaultHolder() {
    }

    public static synchronized DelegationTokenClientFilterProvider getDefault() {
        if (DEFAULT == null) {
            DEFAULT = DefaultHolder.findProvider();
        }
        return DEFAULT;
    }

    private static DelegationTokenClientFilterProvider findProvider() {
        Iterator<DelegationTokenClientFilterProvider> itr = ServiceLoader.load(DelegationTokenClientFilterProvider.class).iterator();
        ServiceConfigurationError lastException = null;
        while (itr.hasNext()) {
            try {
                return itr.next();
            }
            catch (ServiceConfigurationError e) {
                lastException = e;
            }
        }
        if (lastException == null) {
            throw new NoSuchElementException("No DelegationTokenClientFilter provider available; add dependency on one of the oci-java-sdk-common-httpclient-* choices, e.g. oci-java-sdk-common-httpclient-jersey");
        }
        throw lastException;
    }
}

