/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.ui.completion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.dbgp.ui.completion.ExceptionCompletionItem;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.filesystems.FileObject;

public class ExceptionCompletionProvider
implements CompletionProvider {
    private static final Logger LOG = Logger.getLogger(ExceptionCompletionProvider.class.getName());
    private final Set<String> builtinErrors = new HashSet<String>(Arrays.asList("Deprecated", "Notice", "Warning"));

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType != 1) {
            return null;
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                String text;
                if (caretOffset < 0) {
                    caretOffset = 0;
                }
                try {
                    text = doc.getText(0, caretOffset);
                }
                catch (BadLocationException ex) {
                    LOG.log(Level.WARNING, "Invalid offset: {0}", ex.offsetRequested());
                    text = "";
                }
                for (String builtinError : ExceptionCompletionProvider.this.builtinErrors) {
                    resultSet.addItem((CompletionItem)new ExceptionCompletionItem.Builtin(builtinError));
                }
                HashSet<ClassElement> items = new HashSet<ClassElement>();
                for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                    PhpModule module = PhpModule.Factory.lookupPhpModule((Project)project);
                    if (module != null) {
                        FileObject source = module.getProjectDirectory();
                        ElementQuery.Index index = ElementQueryFactory.createIndexQuery((QuerySupport)QuerySupportFactory.get((FileObject)source));
                        NameKind nameQuery = NameKind.create((String)text, (QuerySupport.Kind)QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                        Set classes = index.getClasses(nameQuery);
                        block4: for (ClassElement classElement : classes) {
                            if (CancelSupport.getDefault().isCancelled()) {
                                return;
                            }
                            if (ExceptionCompletionProvider.this.isException(classElement)) {
                                items.add(classElement);
                                continue;
                            }
                            if (classElement.getSuperClassName() == null) continue;
                            Set inheritedClasses = index.getInheritedClasses((TypeElement)classElement);
                            for (ClassElement inheritedClass : inheritedClasses) {
                                if (CancelSupport.getDefault().isCancelled()) {
                                    return;
                                }
                                if (!ExceptionCompletionProvider.this.isException(inheritedClass)) continue;
                                items.add(classElement);
                                continue block4;
                            }
                        }
                        continue;
                    }
                    LOG.log(Level.WARNING, "No php module found for the project {0}", project);
                }
                for (ClassElement item : items) {
                    resultSet.addItem((CompletionItem)new ExceptionCompletionItem(item));
                }
                resultSet.finish();
            }
        }, component);
    }

    private boolean isException(ClassElement element) {
        return element.getFullyQualifiedName().toString().equals("\\Exception");
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 1;
    }
}

