/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeRequest
extends BmcRequest<Void> {
    private String volumeId;

    public String getVolumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new Builder().volumeId(this.volumeId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeId=").append(String.valueOf(this.volumeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeRequest)) {
            return false;
        }
        GetVolumeRequest other = (GetVolumeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeId, other.volumeId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeId == null ? 43 : this.volumeId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeId = null;

        public Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeRequest o) {
            this.volumeId(o.getVolumeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeRequest build() {
            GetVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeRequest buildWithoutInvocationCallback() {
            GetVolumeRequest request = new GetVolumeRequest();
            request.volumeId = this.volumeId;
            return request;
        }
    }
}

