/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetFastConnectProviderServiceRequest
extends BmcRequest<Void> {
    private String providerServiceId;

    public String getProviderServiceId() {
        return this.providerServiceId;
    }

    public Builder toBuilder() {
        return new Builder().providerServiceId(this.providerServiceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",providerServiceId=").append(String.valueOf(this.providerServiceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFastConnectProviderServiceRequest)) {
            return false;
        }
        GetFastConnectProviderServiceRequest other = (GetFastConnectProviderServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.providerServiceId, other.providerServiceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.providerServiceId == null ? 43 : this.providerServiceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetFastConnectProviderServiceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String providerServiceId = null;

        public Builder providerServiceId(String providerServiceId) {
            this.providerServiceId = providerServiceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetFastConnectProviderServiceRequest o) {
            this.providerServiceId(o.getProviderServiceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetFastConnectProviderServiceRequest build() {
            GetFastConnectProviderServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetFastConnectProviderServiceRequest buildWithoutInvocationCallback() {
            GetFastConnectProviderServiceRequest request = new GetFastConnectProviderServiceRequest();
            request.providerServiceId = this.providerServiceId;
            return request;
        }
    }
}

