/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetConsoleHistoryContentRequest
extends BmcRequest<Void> {
    private String instanceConsoleHistoryId;
    private Integer offset;
    private Integer length;

    public String getInstanceConsoleHistoryId() {
        return this.instanceConsoleHistoryId;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLength() {
        return this.length;
    }

    public Builder toBuilder() {
        return new Builder().instanceConsoleHistoryId(this.instanceConsoleHistoryId).offset(this.offset).length(this.length);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",instanceConsoleHistoryId=").append(String.valueOf(this.instanceConsoleHistoryId));
        sb.append(",offset=").append(String.valueOf(this.offset));
        sb.append(",length=").append(String.valueOf(this.length));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetConsoleHistoryContentRequest)) {
            return false;
        }
        GetConsoleHistoryContentRequest other = (GetConsoleHistoryContentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.instanceConsoleHistoryId, other.instanceConsoleHistoryId) && Objects.equals(this.offset, other.offset) && Objects.equals(this.length, other.length);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.instanceConsoleHistoryId == null ? 43 : this.instanceConsoleHistoryId.hashCode());
        result = result * 59 + (this.offset == null ? 43 : this.offset.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetConsoleHistoryContentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String instanceConsoleHistoryId = null;
        private Integer offset = null;
        private Integer length = null;

        public Builder instanceConsoleHistoryId(String instanceConsoleHistoryId) {
            this.instanceConsoleHistoryId = instanceConsoleHistoryId;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetConsoleHistoryContentRequest o) {
            this.instanceConsoleHistoryId(o.getInstanceConsoleHistoryId());
            this.offset(o.getOffset());
            this.length(o.getLength());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetConsoleHistoryContentRequest build() {
            GetConsoleHistoryContentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetConsoleHistoryContentRequest buildWithoutInvocationCallback() {
            GetConsoleHistoryContentRequest request = new GetConsoleHistoryContentRequest();
            request.instanceConsoleHistoryId = this.instanceConsoleHistoryId;
            request.offset = this.offset;
            request.length = this.length;
            return request;
        }
    }
}

