/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.core.model.ChangeDhcpOptionsCompartmentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ChangeDhcpOptionsCompartmentRequest
extends BmcRequest<ChangeDhcpOptionsCompartmentDetails> {
    private String dhcpId;
    private ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDhcpId() {
        return this.dhcpId;
    }

    public ChangeDhcpOptionsCompartmentDetails getChangeDhcpOptionsCompartmentDetails() {
        return this.changeDhcpOptionsCompartmentDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ChangeDhcpOptionsCompartmentDetails getBody$() {
        return this.changeDhcpOptionsCompartmentDetails;
    }

    public Builder toBuilder() {
        return new Builder().dhcpId(this.dhcpId).changeDhcpOptionsCompartmentDetails(this.changeDhcpOptionsCompartmentDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dhcpId=").append(String.valueOf(this.dhcpId));
        sb.append(",changeDhcpOptionsCompartmentDetails=").append(String.valueOf((Object)this.changeDhcpOptionsCompartmentDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeDhcpOptionsCompartmentRequest)) {
            return false;
        }
        ChangeDhcpOptionsCompartmentRequest other = (ChangeDhcpOptionsCompartmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dhcpId, other.dhcpId) && Objects.equals((Object)this.changeDhcpOptionsCompartmentDetails, (Object)other.changeDhcpOptionsCompartmentDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dhcpId == null ? 43 : this.dhcpId.hashCode());
        result = result * 59 + (this.changeDhcpOptionsCompartmentDetails == null ? 43 : this.changeDhcpOptionsCompartmentDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ChangeDhcpOptionsCompartmentRequest, ChangeDhcpOptionsCompartmentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dhcpId = null;
        private ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder dhcpId(String dhcpId) {
            this.dhcpId = dhcpId;
            return this;
        }

        public Builder changeDhcpOptionsCompartmentDetails(ChangeDhcpOptionsCompartmentDetails changeDhcpOptionsCompartmentDetails) {
            this.changeDhcpOptionsCompartmentDetails = changeDhcpOptionsCompartmentDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ChangeDhcpOptionsCompartmentRequest o) {
            this.dhcpId(o.getDhcpId());
            this.changeDhcpOptionsCompartmentDetails(o.getChangeDhcpOptionsCompartmentDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ChangeDhcpOptionsCompartmentRequest build() {
            ChangeDhcpOptionsCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ChangeDhcpOptionsCompartmentDetails body) {
            this.changeDhcpOptionsCompartmentDetails(body);
            return this;
        }

        public ChangeDhcpOptionsCompartmentRequest buildWithoutInvocationCallback() {
            ChangeDhcpOptionsCompartmentRequest request = new ChangeDhcpOptionsCompartmentRequest();
            request.dhcpId = this.dhcpId;
            request.changeDhcpOptionsCompartmentDetails = this.changeDhcpOptionsCompartmentDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

