/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.CreateMacsecKey;
import com.oracle.bmc.core.model.MacsecEncryptionCipher;
import com.oracle.bmc.core.model.MacsecState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateMacsecProperties
extends ExplicitlySetBmcModel {
    @JsonProperty(value="state")
    private final MacsecState state;
    @JsonProperty(value="primaryKey")
    private final CreateMacsecKey primaryKey;
    @JsonProperty(value="encryptionCipher")
    private final MacsecEncryptionCipher encryptionCipher;
    @JsonProperty(value="isUnprotectedTrafficAllowed")
    private final Boolean isUnprotectedTrafficAllowed;

    @Deprecated
    @ConstructorProperties(value={"state", "primaryKey", "encryptionCipher", "isUnprotectedTrafficAllowed"})
    public CreateMacsecProperties(MacsecState state, CreateMacsecKey primaryKey, MacsecEncryptionCipher encryptionCipher, Boolean isUnprotectedTrafficAllowed) {
        this.state = state;
        this.primaryKey = primaryKey;
        this.encryptionCipher = encryptionCipher;
        this.isUnprotectedTrafficAllowed = isUnprotectedTrafficAllowed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MacsecState getState() {
        return this.state;
    }

    public CreateMacsecKey getPrimaryKey() {
        return this.primaryKey;
    }

    public MacsecEncryptionCipher getEncryptionCipher() {
        return this.encryptionCipher;
    }

    public Boolean getIsUnprotectedTrafficAllowed() {
        return this.isUnprotectedTrafficAllowed;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateMacsecProperties(");
        sb.append("super=").append(super.toString());
        sb.append("state=").append(String.valueOf((Object)this.state));
        sb.append(", primaryKey=").append(String.valueOf((Object)this.primaryKey));
        sb.append(", encryptionCipher=").append(String.valueOf((Object)this.encryptionCipher));
        sb.append(", isUnprotectedTrafficAllowed=").append(String.valueOf(this.isUnprotectedTrafficAllowed));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMacsecProperties)) {
            return false;
        }
        CreateMacsecProperties other = (CreateMacsecProperties)((Object)o);
        return Objects.equals((Object)this.state, (Object)other.state) && Objects.equals((Object)this.primaryKey, (Object)other.primaryKey) && Objects.equals((Object)this.encryptionCipher, (Object)other.encryptionCipher) && Objects.equals(this.isUnprotectedTrafficAllowed, other.isUnprotectedTrafficAllowed) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.primaryKey == null ? 43 : this.primaryKey.hashCode());
        result = result * 59 + (this.encryptionCipher == null ? 43 : this.encryptionCipher.hashCode());
        result = result * 59 + (this.isUnprotectedTrafficAllowed == null ? 43 : this.isUnprotectedTrafficAllowed.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="state")
        private MacsecState state;
        @JsonProperty(value="primaryKey")
        private CreateMacsecKey primaryKey;
        @JsonProperty(value="encryptionCipher")
        private MacsecEncryptionCipher encryptionCipher;
        @JsonProperty(value="isUnprotectedTrafficAllowed")
        private Boolean isUnprotectedTrafficAllowed;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder state(MacsecState state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder primaryKey(CreateMacsecKey primaryKey) {
            this.primaryKey = primaryKey;
            this.__explicitlySet__.add("primaryKey");
            return this;
        }

        public Builder encryptionCipher(MacsecEncryptionCipher encryptionCipher) {
            this.encryptionCipher = encryptionCipher;
            this.__explicitlySet__.add("encryptionCipher");
            return this;
        }

        public Builder isUnprotectedTrafficAllowed(Boolean isUnprotectedTrafficAllowed) {
            this.isUnprotectedTrafficAllowed = isUnprotectedTrafficAllowed;
            this.__explicitlySet__.add("isUnprotectedTrafficAllowed");
            return this;
        }

        public CreateMacsecProperties build() {
            CreateMacsecProperties model = new CreateMacsecProperties(this.state, this.primaryKey, this.encryptionCipher, this.isUnprotectedTrafficAllowed);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateMacsecProperties model) {
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("primaryKey")) {
                this.primaryKey(model.getPrimaryKey());
            }
            if (model.wasPropertyExplicitlySet("encryptionCipher")) {
                this.encryptionCipher(model.getEncryptionCipher());
            }
            if (model.wasPropertyExplicitlySet("isUnprotectedTrafficAllowed")) {
                this.isUnprotectedTrafficAllowed(model.getIsUnprotectedTrafficAllowed());
            }
            return this;
        }
    }
}

