/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.output;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gradle.api.execute.GradleCommandLine;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.execute.RunUtils;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputListeners;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.IOColors;

public class GradleProcessorFactory
implements OutputProcessorFactory {
    private static final Pattern GRADLE_ERROR = Pattern.compile("(Build file|Script) '(.*)\\.gradle' line: ([0-9]+)");
    public static final OutputProcessor GRADLE_PROCESSOR = new OutputProcessor(){

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = GRADLE_ERROR.matcher(line);
            if (m.matches()) {
                String buildFile = m.group(2);
                String lineNum = m.group(3);
                File gradleFile = FileUtil.normalizeFile((File)new File(buildFile + ".gradle"));
                FileObject file = FileUtil.toFileObject((File)gradleFile);
                int l = 1;
                try {
                    l = Integer.parseInt(lineNum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                out.print("Script '" + buildFile + ".gradle' line: " + lineNum, OutputListeners.openFileAt(file, l, 1));
                return true;
            }
            return false;
        }
    };
    private static final Pattern JAVA_ERROR = Pattern.compile("(.*)\\.java\\:([0-9]+)\\: (error|warning)\\:(.*)");
    public static final OutputProcessor JAVAC_PROCESSOR = new OutputProcessor(){

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = JAVA_ERROR.matcher(line);
            if (m.matches()) {
                String classBase = m.group(1);
                String lineNum = m.group(2);
                String type = m.group(3);
                String text = m.group(4);
                File javaFile = FileUtil.normalizeFile((File)new File(classBase + ".java"));
                FileObject file = FileUtil.toFileObject((File)javaFile);
                int l = 1;
                try {
                    l = Integer.parseInt(lineNum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                out.print(classBase + ".java:" + lineNum, OutputListeners.openFileAt(file, l, 1));
                out.print(": " + type + ":" + text);
                return true;
            }
            return false;
        }
    };
    private static final Pattern GROOVY_ERROR = Pattern.compile("(.*)\\.groovy\\: ([0-9]+)\\: (.+)");
    private static final Pattern COLUMN_INFO = Pattern.compile(" @ line ([0-9]+), column ([0-9]+)\\.$");
    public static final OutputProcessor GROOVYC_PROCESSOR = new OutputProcessor(){

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = GROOVY_ERROR.matcher(line);
            if (m.matches()) {
                String classBase = m.group(1);
                String text = m.group(3);
                String lineNum = m.group(2);
                String colNum = "1";
                Matcher colm = COLUMN_INFO.matcher(text);
                if (colm.find()) {
                    lineNum = colm.group(1);
                    colNum = colm.group(2);
                }
                File groovyFile = FileUtil.normalizeFile((File)new File(classBase + ".groovy"));
                FileObject file = FileUtil.toFileObject((File)groovyFile);
                int l = 1;
                int c = 1;
                try {
                    l = Integer.parseInt(lineNum);
                    c = Integer.parseInt(colNum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                out.print(classBase + ".groovy: " + lineNum, OutputListeners.openFileAt(file, l, c));
                out.print(": " + text);
                return true;
            }
            return false;
        }
    };
    private static final Pattern URL_PATTERN = Pattern.compile("(((https?|ftp|file)://|file:/)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");
    public static final OutputProcessor URL_PROCESSOR = new OutputProcessor(){

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = URL_PATTERN.matcher(line);
            int last = 0;
            while (m.find()) {
                String txt = line.substring(last, m.start());
                String lnk = line.substring(m.start(), m.end());
                last = m.end();
                out.print(txt);
                try {
                    out.print(lnk, OutputListeners.openURL(new URL(lnk)));
                }
                catch (MalformedURLException ex) {
                    out.print(lnk);
                }
            }
            if (last > 0) {
                out.print(line.substring(last));
            }
            return last > 0;
        }
    };
    public static final OutputProcessor TASK_LINE_PROCESSOR = new OutputProcessor(){
        final Pattern TASK_LINE = Pattern.compile("> Task (:[\\w:\\-]+)( [\\w\\-]+)?");

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = this.TASK_LINE.matcher(line);
            boolean ret = m.matches();
            if (ret) {
                String task = m.group(1);
                String state = m.group(2);
                out.print("> Task ");
                out.print(task);
                if (state != null) {
                    IOColors.OutputType type = IOColors.OutputType.LOG_WARNING;
                    if (state.endsWith("EXECUTED") || state.endsWith("UP-TO-DATE") || state.endsWith("FROM-CACHE")) {
                        type = IOColors.OutputType.LOG_SUCCESS;
                    } else if (state.endsWith("FAILED")) {
                        type = IOColors.OutputType.LOG_FAILURE;
                    }
                    out.print(state, null, type);
                }
            }
            return ret;
        }
    };
    public static final OutputProcessor STATIC_STRING_PROCESSOR = new OutputProcessor(){
        private static final String BUILD_FAILED_MSG = "BUILD FAILED";
        private static final String BUILD_SUCCESS_MSG = "BUILD SUCCESSFUL";
        private static final String COD_INCUBATION_MSG = "Configuration on demand is an incubating feature.";
        private static final String CONFIG_CACHE_MGS = "Configuration cache ";

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            IOColors.OutputType type = null;
            if (line.startsWith(COD_INCUBATION_MSG) || line.startsWith(CONFIG_CACHE_MGS)) {
                type = IOColors.OutputType.LOG_DEBUG;
            } else if (line.startsWith(BUILD_SUCCESS_MSG)) {
                type = IOColors.OutputType.LOG_SUCCESS;
            } else if (line.startsWith(BUILD_FAILED_MSG)) {
                type = IOColors.OutputType.LOG_FAILURE;
            }
            if (type != null) {
                out.print(line, null, type);
            }
            return type != null;
        }
    };

    @Override
    public Set<? extends OutputProcessor> createOutputProcessors(RunConfig cfg) {
        return Set.of(GRADLE_PROCESSOR, JAVAC_PROCESSOR, GROOVYC_PROCESSOR, new WarningModeAllProcessor(cfg));
    }

    static class WarningModeAllProcessor
    implements OutputProcessor {
        private static Pattern WARNING_MODE_ALL = Pattern.compile("(.+ ')(\\-\\-warning\\-mode all)('.+)");
        final RunConfig cfg;

        public WarningModeAllProcessor(RunConfig cfg) {
            this.cfg = cfg;
        }

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = WARNING_MODE_ALL.matcher(line);
            if (m.matches()) {
                out.print(m.group(1));
                out.print(m.group(2), () -> {
                    GradleCommandLine cmd = new GradleCommandLine(this.cfg.getCommandLine());
                    cmd.addParameter(GradleCommandLine.Parameter.WARNING_MODE, "all");
                    RunConfig warnAll = this.cfg.withCommandLine(cmd);
                    RunUtils.executeGradle(warnAll, null);
                });
                out.print(m.group(3));
                return true;
            }
            return false;
        }
    }
}

