/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.options;

import java.util.prefs.Preferences;
import org.netbeans.modules.gradle.options.NetworkProxySettings;
import org.netbeans.modules.gradle.spi.execute.JavaRuntimeManager;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class GradleExperimentalSettings {
    public static final String PROP_DISABLE_CACHE = "disableCache";
    public static final String PROP_LAZY_OPEN_GROUPS = "lazyOpen";
    public static final String PROP_BUNDLED_LOADING = "bundledLoading";
    public static final String PROP_NETWORK_PROXY = "networkProxy";
    public static final String PROP_JAVA_RUNTIME_ID = "javaRuntimeId";
    private static final GradleExperimentalSettings INSTANCE;
    private final Preferences preferences;
    private static final String SYSPROP_DEFAULT_PROXY_BEHAVIOUR = "netbeans.networkProxy";
    private static final NetworkProxySettings DEFAULT_PROXY_BEHAVIOUR;

    public static GradleExperimentalSettings getDefault() {
        return INSTANCE;
    }

    GradleExperimentalSettings(Preferences preferences) {
        this.preferences = preferences;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setOpenLazy(boolean b) {
        this.getPreferences().putBoolean(PROP_LAZY_OPEN_GROUPS, b);
    }

    public boolean isOpenLazy() {
        return this.getPreferences().getBoolean(PROP_LAZY_OPEN_GROUPS, false);
    }

    public void setCacheDisabled(boolean b) {
        this.getPreferences().putBoolean(PROP_DISABLE_CACHE, b);
    }

    public boolean isCacheDisabled() {
        return this.getPreferences().getBoolean(PROP_DISABLE_CACHE, false);
    }

    public void setBundledLoading(boolean b) {
        this.getPreferences().putBoolean(PROP_BUNDLED_LOADING, b);
    }

    public boolean isBundledLoading() {
        return this.getPreferences().getBoolean(PROP_BUNDLED_LOADING, false);
    }

    public NetworkProxySettings getNetworkProxy() {
        String s = this.getPreferences().get(PROP_NETWORK_PROXY, DEFAULT_PROXY_BEHAVIOUR.name());
        try {
            return NetworkProxySettings.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            return DEFAULT_PROXY_BEHAVIOUR;
        }
    }

    public void setNetworkProxy(NetworkProxySettings s) {
        this.getPreferences().put(PROP_NETWORK_PROXY, s.name());
    }

    public JavaRuntimeManager.JavaRuntime getDefaultJavaRuntime() {
        String id = this.getPreferences().get(PROP_JAVA_RUNTIME_ID, null);
        JavaRuntimeManager mgr = (JavaRuntimeManager)Lookup.getDefault().lookup(JavaRuntimeManager.class);
        JavaRuntimeManager.JavaRuntime ret = mgr.getAvailableRuntimes().get(id);
        ret = ret != null ? ret : mgr.getAvailableRuntimes().get("default_platform");
        return ret;
    }

    public void setDefaultJavaRuntime(JavaRuntimeManager.JavaRuntime rt) {
        if (rt != null) {
            this.getPreferences().put(PROP_JAVA_RUNTIME_ID, rt.getId());
        } else {
            this.getPreferences().remove(PROP_JAVA_RUNTIME_ID);
        }
    }

    static {
        NetworkProxySettings def;
        INSTANCE = new GradleExperimentalSettings(NbPreferences.forModule(GradleExperimentalSettings.class));
        try {
            def = NetworkProxySettings.valueOf(System.getProperty(SYSPROP_DEFAULT_PROXY_BEHAVIOUR, NetworkProxySettings.ASK.name()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            def = NetworkProxySettings.ASK;
        }
        DEFAULT_PROXY_BEHAVIOUR = def;
    }
}

