/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.browsetask;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.browser.spi.URLDisplayerImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class NbBrowse
extends Task {
    private String url;
    private File file;
    private File context;
    private String urlPath;

    public void setUrl(String s) {
        this.url = s;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setContext(File f) {
        this.context = f;
    }

    public void setUrlPath(String s) {
        this.urlPath = s;
    }

    public void execute() throws BuildException {
        if (this.url != null ^ this.file == null) {
            throw new BuildException("You must define the url or file attributes", this.getLocation());
        }
        if (this.url == null) {
            this.url = this.file.toURI().toString();
        }
        this.log("Browsing: " + this.url);
        try {
            URL u = new URL(this.url);
            URL appRoot = null;
            if (this.context != null) {
                URLDisplayerImplementation urlDisplayer;
                FileObject fo = FileUtil.toFileObject((File)this.context);
                Project p = null;
                if (fo != null) {
                    p = FileOwnerQuery.getOwner((FileObject)fo);
                }
                if (this.urlPath != null && this.urlPath.length() > 0) {
                    if (!this.url.endsWith(this.urlPath)) {
                        throw new BuildException("The urlPath(" + this.urlPath + ") is not part of the url(" + this.url + ")", this.getLocation());
                    }
                    appRoot = new URL(this.url.substring(0, this.url.length() - this.urlPath.length()));
                }
                if (p != null && (urlDisplayer = (URLDisplayerImplementation)p.getLookup().lookup(URLDisplayerImplementation.class)) != null) {
                    urlDisplayer.showURL(appRoot != null ? appRoot : u, u, fo);
                    return;
                }
            }
            HtmlBrowser.URLDisplayer.getDefault().showURL(u);
        }
        catch (MalformedURLException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }
}

