/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image.navigation;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.awt.GraphicsUtils;
import org.openide.util.NbBundle;

public class ImagePreviewPanel
extends JPanel {
    private BufferedImage image;
    private final int stringGapSize = 10;
    private final Color background = UIManager.getColor("Table.background");
    private final Color foreground = UIManager.getColor("Table.foreground");

    public void setImage(BufferedImage image) {
        this.image = image;
        this.setBackground(this.background);
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)g);
        super.paintComponent(g);
        if (this.image != null) {
            g.setColor(this.foreground);
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            String sizes = "Dimensions: " + width + " x " + height;
            g.drawString(sizes, (int)((double)this.getWidth() * 0.05), this.getHeight() - 10);
            double widthRatio = (double)this.image.getWidth() / ((double)this.getWidth() * 0.9);
            double heightRatio = (double)this.image.getHeight() / ((double)this.getHeight() * 0.9 - 10.0 - 20.0);
            if (widthRatio > 1.0 || heightRatio > 1.0) {
                double ratio = widthRatio > heightRatio ? widthRatio : heightRatio;
                width = (int)((double)this.image.getWidth() / ratio);
                height = (int)((double)this.image.getHeight() / ratio);
            }
            g.drawImage(this.image, (this.getWidth() - width) / 2, (this.getHeight() - height) / 2, width, height, this);
        } else {
            g.setColor(Color.RED);
            FontMetrics fm = this.getFontMetrics(g.getFont());
            String errMessage = NbBundle.getMessage(ImagePreviewPanel.class, (String)"ERR_Thumbnail");
            int stringWidth = fm.stringWidth(errMessage);
            g.drawString(errMessage, (this.getWidth() - stringWidth) / 2, this.getHeight() / 2);
        }
    }
}

