/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.websvc.manager.api.WebServiceDescriptor;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlServiceProxyDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class WebServiceLibReferenceHelper {
    private static final String WEBSERVICE_CLIENTS_SUB_DIR = "webservice_clients";
    private static final AddLibrary DESIGN_RUNTIME_LIBRARY_ADD = new AddLibraryToProject();

    public static void addArchiveRefsToProject(Project project, List<String> jars) {
        try {
            FileObject projectLibDir = ManagerUtil.getProjectLibraryDirectory(project);
            FileObject wsClientsSubDir = projectLibDir.getFileObject(WEBSERVICE_CLIENTS_SUB_DIR);
            if (wsClientsSubDir == null) {
                wsClientsSubDir = projectLibDir.createFolder(WEBSERVICE_CLIENTS_SUB_DIR);
            }
            ArrayList<URL> copiedArchiveJars = new ArrayList<URL>();
            for (String jarFilePath : jars) {
                try {
                    String jarFileName = new File(jarFilePath).getName();
                    FileObject destJar = wsClientsSubDir.getFileObject(jarFileName);
                    if (destJar == null) {
                        destJar = wsClientsSubDir.createData(jarFileName);
                        WebServiceLibReferenceHelper.copyJarFile(jarFilePath, destJar);
                    }
                    copiedArchiveJars.add(new URL(destJar.getURL().toExternalForm() + "/"));
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            WebServiceLibReferenceHelper.addRefsToProject(project, copiedArchiveJars, new AddArchiveReferences(), new URL[0]);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            ioe.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyJarFile(String srcPath, FileObject destJar) throws IOException {
        FileLock fileLock = destJar.lock();
        try {
            OutputStream outStream = destJar.getOutputStream(fileLock);
            DataInputStream in = new DataInputStream(new FileInputStream(new File(srcPath)));
            DataOutputStream out = new DataOutputStream(outStream);
            byte[] bytes = new byte[1024];
            int byteCount = in.read(bytes);
            while (byteCount > -1) {
                out.write(bytes, 0, byteCount);
                byteCount = in.read(bytes);
            }
            out.flush();
            out.close();
            outStream.close();
            in.close();
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static void addLibRefsToProject(Project project, List<Library> libraries, String role) {
        WebServiceLibReferenceHelper.addRefsToProject(project, libraries, new AddLibraryFromRole(role), new Library[0]);
    }

    public static void addLibRefsToProject(Project project, List<Library> libraries) {
        WebServiceLibReferenceHelper.addRefsToProject(project, libraries, DESIGN_RUNTIME_LIBRARY_ADD, new Library[0]);
    }

    private static <T> void addRefsToProject(Project project, List<T> libDefs, AddLibrary<T> libraryAdder, T[] arr) {
        ArrayList<T> libsToAdd = new ArrayList<T>();
        for (T lib : libDefs) {
            if (libraryAdder.hasLibraryReference(project, lib)) continue;
            libsToAdd.add(lib);
        }
        try {
            libraryAdder.addLibraryReferences(project, libsToAdd.toArray(arr));
        }
        catch (IOException ie) {
            ErrorManager.getDefault().getInstance("org.netbeans.modules.websvc.manager.node.WebServiceLibReferenceHelper").log(65536, "Failed to add library references to project. IOException");
            ie.printStackTrace();
        }
    }

    public static void addDefaultJaxWsClientJar(Project project, WebServiceData data) {
        List<String> jars = WebServiceLibReferenceHelper.getDefaultJaxWsClientJars(data);
        WebServiceLibReferenceHelper.addArchiveRefsToProject(project, jars);
    }

    public static List<String> getDefaultJaxWsClientJars(WebServiceData data) {
        ArrayList<String> jarPaths = new ArrayList<String>();
        File basePath = new File(WebServiceDescriptor.WEBSVC_HOME, data.getJaxWsDescriptorPath()).getParentFile();
        for (WsdlServiceProxyDescriptor.JarEntry jar : data.getJaxWsDescriptor().getJars()) {
            if (!jar.getType().equals("proxy")) continue;
            File jarPath = new File(basePath, jar.getName());
            jarPaths.add(jarPath.getAbsolutePath());
        }
        return jarPaths;
    }

    private static class AddArchiveReferences
    implements AddLibrary<URL> {
        @Override
        public boolean hasLibraryReference(Project project, URL library) {
            return ManagerUtil.hasRootReference(project, library);
        }

        public void addLibraryReferences(Project project, URL[] libraries) throws IOException {
            ManagerUtil.addRootReferences(project, libraries);
        }
    }

    private static interface AddLibrary<T> {
        public boolean hasLibraryReference(Project var1, T var2);

        public void addLibraryReferences(Project var1, T[] var2) throws IOException;
    }

    private static class AddLibraryFromRole
    implements AddLibrary<Library> {
        private String role;

        public AddLibraryFromRole(String role) {
            this.role = role;
        }

        @Override
        public boolean hasLibraryReference(Project project, Library library) {
            return ManagerUtil.hasLibraryReference(project, library, this.role);
        }

        public void addLibraryReferences(Project project, Library[] libraries) throws IOException {
            ManagerUtil.addLibraryReferences(project, libraries, this.role);
        }
    }

    private static class AddLibraryToProject
    implements AddLibrary<Library> {
        @Override
        public boolean hasLibraryReference(Project project, Library library) {
            return ManagerUtil.hasLibraryReference(project, library, null);
        }

        public void addLibraryReferences(Project project, Library[] libraries) throws IOException {
            ManagerUtil.addLibraryReferences(project, libraries);
        }
    }
}

