/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.api.model;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.web.beans.api.model.AbstractModelImplementation;
import org.netbeans.modules.web.beans.api.model.CdiException;
import org.netbeans.modules.web.beans.api.model.DependencyInjectionResult;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.InterceptorsResult;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;

public final class WebBeansModel {
    private AbstractModelImplementation myImpl;

    WebBeansModel(AbstractModelImplementation impl) {
        this.myImpl = impl;
    }

    public DependencyInjectionResult lookupInjectables(VariableElement element, DeclaredType parentType, AtomicBoolean cancel) {
        return this.getProvider().lookupInjectables(element, parentType, cancel);
    }

    public boolean isInjectionPoint(VariableElement element) throws InjectionPointDefinitionError {
        return this.getProvider().isInjectionPoint(element);
    }

    public boolean isEventInjectionPoint(VariableElement element) {
        String typeElementFqn;
        TypeMirror elementType = element.asType();
        Element typeElement = this.getCompilationController().getTypes().asElement(elementType);
        if (typeElement instanceof TypeElement && ("javax.enterprise.event.Event".equals(typeElementFqn = ((TypeElement)typeElement).getQualifiedName().toString()) || "jakarta.enterprise.event.Event".equals(typeElementFqn))) {
            try {
                return this.isInjectionPoint(element);
            }
            catch (InjectionPointDefinitionError e) {
                return false;
            }
        }
        return false;
    }

    public boolean isDynamicInjectionPoint(VariableElement element) {
        return this.getProvider().isDynamicInjectionPoint(element);
    }

    public List<Element> getNamedElements() {
        return this.getProvider().getNamedElements(new AtomicBoolean(false));
    }

    public boolean isCdi11OrLater() {
        return this.getProvider().isCdi11OrLater();
    }

    public String getName(Element element) {
        return this.getProvider().getName(element);
    }

    public TypeMirror resolveType(String fqn) {
        return this.getProvider().resolveType(fqn);
    }

    public CompilationController getCompilationController() {
        return this.getProvider().getCompilationController();
    }

    public List<AnnotationMirror> getQualifiers(Element element, boolean all) {
        return this.getProvider().getQualifiers(element, all);
    }

    public boolean hasImplicitDefaultQualifier(Element element) {
        return this.getProvider().hasImplicitDefaultQualifier(element);
    }

    public List<ExecutableElement> getObservers(VariableElement element, DeclaredType parentType) {
        return this.getProvider().getObservers(element, parentType);
    }

    public List<VariableElement> getEventInjectionPoints(ExecutableElement element, DeclaredType parentType) {
        return this.getProvider().getEventInjectionPoints(element, parentType);
    }

    public VariableElement getObserverParameter(ExecutableElement element) {
        return this.getProvider().getObserverParameter(element);
    }

    public String getScope(Element element) throws CdiException {
        return this.getProvider().getScope(element);
    }

    public Collection<TypeElement> getDecorators(TypeElement element) {
        return this.getProvider().getDecorators(element);
    }

    public InterceptorsResult getInterceptors(Element element) {
        return this.getProvider().getInterceptors(element);
    }

    public Collection<AnnotationMirror> getInterceptorBindings(Element element) {
        return this.getProvider().getInterceptorBindings(element);
    }

    public AbstractModelImplementation getModelImplementation() {
        return this.myImpl;
    }

    private WebBeansModelProvider getProvider() {
        return this.getModelImplementation().getProvider();
    }
}

