/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.sites.SiteZipPanel;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.util.FileUtilities;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.EditableProperties;
import org.openide.util.NbPreferences;

public class SiteZip
implements SiteTemplateImplementation {
    static final Logger LOGGER = Logger.getLogger(SiteZip.class.getName());
    private static final String USED_TEMPLATES = "last.templates";
    private static final String SEPARATOR = "=s e p=";
    private static final FileUtilities.ZipEntryFilter NB_TEMPLATE_FILTER = new FileUtilities.ZipEntryFilter(){

        @Override
        public boolean accept(ZipEntry zipEntry) {
            return !zipEntry.isDirectory() && zipEntry.getName().equals("netbeans-project.properties");
        }
    };
    private Customizer cust;

    public String getId() {
        return "ARCHIVE";
    }

    public String getName() {
        return Bundle.SiteZip_name();
    }

    public String getDescription() {
        return this.getName();
    }

    public Customizer getCustomizer() {
        this.cust = new Customizer();
        return this.cust;
    }

    public boolean isPrepared() {
        return this.getArchiveFile().isFile();
    }

    public void prepare() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        String template = this.cust.panel.getTemplate();
        assert (this.isRemoteUrl(template)) : "Remote URL expected: " + template;
        SiteHelper.download((String)template, (File)this.getArchiveFile(), null);
    }

    public void configure(final SiteTemplateImplementation.ProjectProperties projectProperties) {
        assert (!EventQueue.isDispatchThread());
        assert (this.isPrepared());
        try {
            FileUtilities.runOnZipEntries(this.getArchiveFile(), new FileUtilities.ZipEntryTask(){

                @Override
                public void run(ZipEntry zipEntry) {
                }

                @Override
                public void run(InputStream zipEntryInputStream) {
                    EditableProperties templateProperties = new EditableProperties(false);
                    try {
                        templateProperties.load(zipEntryInputStream);
                        projectProperties.setSiteRootFolder(templateProperties.getProperty("site.root.folder")).setSourceFolder(templateProperties.getProperty("source.folder")).setTestFolder(templateProperties.getProperty("test.folder"));
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Error while reading file", ex);
                    }
                }
            }, NB_TEMPLATE_FILTER);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error while reading zip file", ex);
        }
    }

    public void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        SiteHelper.unzipProjectTemplate((FileObject)this.getTargetDir(projectDir, projectProperties), (File)this.getArchiveFile(), (ProgressHandle)handle, (String[])new String[]{"netbeans-project.properties"});
        SiteZip.registerTemplate(this.cust.panel.getTemplate());
    }

    private FileObject getTargetDir(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties) throws IOException {
        if (FileUtilities.listZipFiles(this.getArchiveFile(), NB_TEMPLATE_FILTER).isEmpty()) {
            String siteRootFolder = projectProperties.getSiteRootFolder();
            assert (siteRootFolder != null);
            return projectDir.getFileObject(siteRootFolder);
        }
        return projectDir;
    }

    public void cleanup() {
        String template = this.cust.panel.getTemplate();
        if (this.isRemoteUrl(template)) {
            return;
        }
        File archiveFile = this.getArchiveFile();
        if (archiveFile.isFile() && !archiveFile.delete()) {
            archiveFile.deleteOnExit();
        }
    }

    private File getArchiveFile() {
        String template = this.cust.panel.getTemplate();
        if (!this.isRemoteUrl(template)) {
            return new File(template);
        }
        CRC32 crc = new CRC32();
        crc.update(template.getBytes(StandardCharsets.UTF_8));
        String filename = String.valueOf(crc.getValue()) + ".zip";
        LOGGER.log(Level.INFO, "Remote URL \"{0}\" set, downloaded to {1}", new Object[]{template, filename});
        return new File(SiteHelper.getJsLibsDirectory(), filename);
    }

    private boolean isRemoteUrl(String input) {
        return input.toLowerCase().startsWith("http");
    }

    public static void registerTemplate(File f) {
        String name = f.getAbsolutePath();
        SiteZip.registerTemplate(name);
    }

    public static void registerTemplate(String name) {
        String templates = NbPreferences.forModule(SiteZip.class).get(USED_TEMPLATES, "");
        templates = name + SEPARATOR + templates.replace(name + SEPARATOR, "");
        NbPreferences.forModule(SiteZip.class).put(USED_TEMPLATES, templates);
    }

    public static List<String> getUsedTemplates() {
        String templates = NbPreferences.forModule(SiteZip.class).get(USED_TEMPLATES, "");
        return Arrays.asList(templates.split(SEPARATOR));
    }

    public static class Customizer {
        private SiteZipPanel panel = new SiteZipPanel(this);
        private ChangeSupport sup = new ChangeSupport((Object)this);
        private String error = "";

        public void addChangeListener(ChangeListener listener) {
            this.sup.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.sup.removeChangeListener(listener);
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public boolean isValid() {
            String tpl = this.panel.getTemplate();
            if (tpl.isEmpty()) {
                this.error = Bundle.SiteZip_error_template_missing();
                return false;
            }
            File localTpl = new File(tpl);
            if (!tpl.startsWith("http") && !localTpl.isFile()) {
                this.error = Bundle.SiteZip_error_template_invalid();
                return false;
            }
            if (localTpl.isFile() && !localTpl.getName().endsWith(".zip")) {
                this.error = Bundle.SiteZip_error_template_notZip();
                return false;
            }
            this.error = null;
            return true;
        }

        public String getErrorMessage() {
            return this.error;
        }

        public String getWarningMessage() {
            return null;
        }

        void fireChange() {
            this.sup.fireChange();
        }
    }
}

