/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.helper.ListGetNode;
import com.oracle.truffle.js.builtins.helper.ListGetNodeGen;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.access.CachedGetPropertyNode;
import com.oracle.truffle.js.nodes.access.IsArrayNode;
import com.oracle.truffle.js.nodes.access.IsJSDynamicObjectNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyCacheNode;
import com.oracle.truffle.js.nodes.access.ReadElementNodeFactory;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.ToArrayIndexNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTaggedExecutionNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyArray;
import com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultArray;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSSlowArgumentsArray;
import com.oracle.truffle.js.runtime.builtins.JSSlowArray;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.JSClassProfile;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.Objects;
import java.util.Set;

public class ReadElementNode
extends JSTargetableNode
implements ReadNode {
    @Node.Child
    private JavaScriptNode targetNode;
    @Node.Child
    private JavaScriptNode indexNode;
    @Node.Child
    private ReadElementTypeCacheDispatchNode typeCacheNode;
    protected final JSContext context;
    @CompilerDirectives.CompilationFinal
    private byte indexState;
    private static final byte INDEX_INT = 1;
    private static final byte INDEX_OBJECT = 2;
    static final int BOUNDED_BY_TYPES = Integer.MAX_VALUE;
    static final int EXPECT_RETURN_OBJECT = 0;
    static final int EXPECT_RETURN_INT = 1;
    static final int EXPECT_RETURN_DOUBLE = 2;
    static final boolean ALLOW_RETURN_TYPE_SPECULATION = true;

    static boolean isExpectedReturnInt(int expectedReturn) {
        return expectedReturn == 1;
    }

    static boolean isExpectedReturnDouble(int expectedReturn) {
        return expectedReturn == 2;
    }

    @NeverDefault
    public static ReadElementNode create(JSContext context) {
        return new ReadElementNode(null, null, context);
    }

    public static ReadElementNode create(JavaScriptNode targetNode, JavaScriptNode indexNode, JSContext context) {
        return new ReadElementNode(targetNode, indexNode, context);
    }

    protected ReadElementNode(JavaScriptNode targetNode, JavaScriptNode indexNode, JSContext context) {
        this.targetNode = targetNode;
        this.indexNode = indexNode;
        this.context = context;
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(JSTags.ReadElementTag.class) && this.materializationNeeded()) {
            JavaScriptNode clonedIndex;
            JavaScriptNode clonedTarget = this.targetNode == null || this.targetNode.hasSourceSection() ? this.targetNode : JSTaggedExecutionNode.createForInput(this.targetNode, this, materializedTags);
            JavaScriptNode javaScriptNode = clonedIndex = this.indexNode == null || this.indexNode.hasSourceSection() ? this.indexNode : JSTaggedExecutionNode.createForInput(this.indexNode, this, materializedTags);
            if (clonedTarget == this.targetNode && clonedIndex == this.indexNode) {
                return this;
            }
            if (clonedTarget == this.targetNode) {
                clonedTarget = ReadElementNode.cloneUninitialized(this.targetNode, materializedTags);
            }
            if (clonedIndex == this.indexNode) {
                clonedIndex = ReadElementNode.cloneUninitialized(this.indexNode, materializedTags);
            }
            ReadElementNode cloned = ReadElementNode.create(clonedTarget, clonedIndex, this.getContext());
            ReadElementNode.transferSourceSectionAndTags(this, cloned);
            return cloned;
        }
        return this;
    }

    private boolean materializationNeeded() {
        return this.targetNode != null && !this.targetNode.hasSourceSection() || this.indexNode != null && !this.indexNode.hasSourceSection();
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.ReadElementTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    @Override
    public Object evaluateTarget(VirtualFrame frame) {
        return this.targetNode.execute(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTarget(frame, target, ReadElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetInt(frame, target, ReadElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object target = this.evaluateTarget(frame);
        return this.executeWithTargetDouble(frame, target, ReadElementNode.evaluateReceiver(this.targetNode, frame, target));
    }

    @Override
    public Object executeWithTarget(VirtualFrame frame, Object target) {
        return this.executeWithTarget(frame, target, target);
    }

    public Object executeWithTarget(VirtualFrame frame, Object target, Object receiver) {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.getIndexNode().execute(frame);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndex(target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndex(target, index, receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.getIndexNode().executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                return this.executeWithTargetAndIndex(target, e.getResult(), receiver);
            }
            return this.executeWithTargetAndIndex(target, index);
        }
        assert (is == 2);
        Object index = this.getIndexNode().execute(frame);
        return this.executeWithTargetAndIndex(target, index, receiver);
    }

    public int executeWithTargetInt(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.getIndexNode().execute(frame);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexInt(target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexInt(target, index, receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.getIndexNode().executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                return this.executeWithTargetAndIndexInt(target, e.getResult(), receiver);
            }
            return this.executeWithTargetAndIndexInt(target, index, receiver);
        }
        assert (is == 2);
        Object index = this.getIndexNode().execute(frame);
        return this.executeWithTargetAndIndexInt(target, index, receiver);
    }

    public double executeWithTargetDouble(VirtualFrame frame, Object target, Object receiver) throws UnexpectedResultException {
        byte is = this.indexState;
        if (is == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object index = this.getIndexNode().execute(frame);
            if (index instanceof Integer) {
                this.indexState = 1;
                return this.executeWithTargetAndIndexDouble(target, (Integer)index, receiver);
            }
            this.indexState = (byte)2;
            return this.executeWithTargetAndIndexDouble(target, index, receiver);
        }
        if (is == 1) {
            int index;
            try {
                index = this.getIndexNode().executeInt(frame);
            }
            catch (UnexpectedResultException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.indexState = (byte)2;
                return this.executeWithTargetAndIndexDouble(target, e.getResult(), receiver);
            }
            return this.executeWithTargetAndIndexDouble(target, index, receiver);
        }
        assert (is == 2);
        Object index = this.getIndexNode().execute(frame);
        return this.executeWithTargetAndIndexDouble(target, index, receiver);
    }

    public final Object executeWithTargetAndIndex(Object target, Object index) {
        return this.executeTypeDispatch(target, index, target, (Object)Undefined.instance);
    }

    public final Object executeWithTargetAndIndex(Object target, int index) {
        return this.executeTypeDispatch(target, index, target, (Object)Undefined.instance);
    }

    public final Object executeWithTargetAndIndex(Object target, long index) {
        return this.executeTypeDispatch(target, index, target, (Object)Undefined.instance);
    }

    public final Object executeWithTargetAndIndex(Object target, Object index, Object receiver) {
        return this.executeTypeDispatch(target, index, receiver, (Object)Undefined.instance);
    }

    public final Object executeWithTargetAndIndex(Object target, int index, Object receiver) {
        return this.executeTypeDispatch(target, index, receiver, (Object)Undefined.instance);
    }

    public final int executeWithTargetAndIndexInt(Object target, Object index, Object receiver) throws UnexpectedResultException {
        return this.executeTypeDispatchInt(target, index, receiver, (Object)Undefined.instance);
    }

    public final int executeWithTargetAndIndexInt(Object target, int index, Object receiver) throws UnexpectedResultException {
        return this.executeTypeDispatchInt(target, index, receiver, (Object)Undefined.instance);
    }

    public final double executeWithTargetAndIndexDouble(Object target, Object index, Object receiver) throws UnexpectedResultException {
        return this.executeTypeDispatchDouble(target, index, receiver, (Object)Undefined.instance);
    }

    public final double executeWithTargetAndIndexDouble(Object target, int index, Object receiver) throws UnexpectedResultException {
        return this.executeTypeDispatchDouble(target, index, receiver, (Object)Undefined.instance);
    }

    public final Object executeWithTargetAndIndexOrDefault(Object target, Object index, Object defaultValue) {
        return this.executeTypeDispatch(target, index, target, defaultValue);
    }

    private ReadElementTypeCacheDispatchNode initTypeCacheDispatchNode() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.typeCacheNode = (ReadElementTypeCacheDispatchNode)this.insert(ReadElementNodeFactory.ReadElementTypeCacheDispatchNodeGen.create());
        return this.typeCacheNode;
    }

    protected final Object executeTypeDispatch(Object target, Object index, Object receiver, Object defaultValue) {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, this);
    }

    protected final Object executeTypeDispatch(Object target, int index, Object receiver, Object defaultValue) {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, this);
    }

    protected final Object executeTypeDispatch(Object target, long index, Object receiver, Object defaultValue) {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, this);
    }

    protected final int executeTypeDispatchInt(Object target, Object index, Object receiver, Object defaultValue) throws UnexpectedResultException {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUncheckedInt(target, index, receiver, defaultValue, this);
    }

    protected final int executeTypeDispatchInt(Object target, int index, Object receiver, Object defaultValue) throws UnexpectedResultException {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUncheckedInt(target, index, receiver, defaultValue, this);
    }

    protected final double executeTypeDispatchDouble(Object target, Object index, Object receiver, Object defaultValue) throws UnexpectedResultException {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUncheckedDouble(target, index, receiver, defaultValue, this);
    }

    protected final double executeTypeDispatchDouble(Object target, int index, Object receiver, Object defaultValue) throws UnexpectedResultException {
        ReadElementTypeCacheDispatchNode dispatch = this.typeCacheNode;
        if (dispatch == null) {
            dispatch = this.initTypeCacheDispatchNode();
        }
        return dispatch.executeWithTargetAndIndexUncheckedDouble(target, index, receiver, defaultValue, this);
    }

    protected static ArrayReadElementCacheNode makeArrayCacheNode(JSDynamicObject target, ScriptArray array) {
        if (array instanceof ConstantEmptyArray) {
            return ReadElementNodeFactory.EmptyArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof ConstantObjectArray && array.isHolesType()) {
            return ReadElementNodeFactory.ConstantObjectArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof LazyRegexResultArray) {
            return ReadElementNodeFactory.LazyRegexResultArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof LazyRegexResultIndicesArray) {
            return ReadElementNodeFactory.LazyRegexResultIndicesArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof LazyArray) {
            return ReadElementNodeFactory.LazyArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof AbstractConstantArray) {
            return ReadElementNodeFactory.ConstantArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof HolesIntArray) {
            return ReadElementNodeFactory.HolesIntArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof HolesDoubleArray) {
            return ReadElementNodeFactory.HolesDoubleArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof HolesJSObjectArray) {
            return ReadElementNodeFactory.HolesJSObjectArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof HolesObjectArray) {
            return ReadElementNodeFactory.HolesObjectArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof AbstractWritableArray) {
            return ReadElementNodeFactory.WritableArrayReadElementCacheNodeGen.create();
        }
        if (array instanceof TypedArray) {
            if (array instanceof TypedArray.AbstractUint32Array) {
                return ReadElementNodeFactory.Uint32ArrayReadElementCacheNodeGen.create((TypedArray)array);
            }
            if (array instanceof TypedArray.TypedIntArray) {
                return ReadElementNodeFactory.TypedIntArrayReadElementCacheNodeGen.create((TypedArray)array);
            }
            if (array instanceof TypedArray.TypedFloatArray) {
                return ReadElementNodeFactory.TypedFloatArrayReadElementCacheNodeGen.create((TypedArray)array);
            }
            if (array instanceof TypedArray.TypedBigIntArray) {
                return ReadElementNodeFactory.TypedBigIntArrayReadElementCacheNodeGen.create((TypedArray)array);
            }
            throw Errors.shouldNotReachHere();
        }
        return new ExactArrayReadElementCacheNode();
    }

    @Override
    public final JavaScriptNode getTarget() {
        return this.targetNode;
    }

    public final JavaScriptNode getElement() {
        return this.getIndexNode();
    }

    public final JSContext getContext() {
        return this.context;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return ReadElementNode.create(ReadElementNode.cloneUninitialized(this.targetNode, materializedTags), ReadElementNode.cloneUninitialized(this.getIndexNode(), materializedTags), this.getContext());
    }

    @Override
    public String expressionToString() {
        if (this.targetNode != null && this.indexNode != null) {
            return Objects.toString(this.targetNode.expressionToString(), "(intermediate value)") + "[" + Objects.toString(this.indexNode.expressionToString(), "(intermediate value)") + "]";
        }
        return null;
    }

    public JavaScriptNode getIndexNode() {
        return this.indexNode;
    }

    @ImportStatic(value={ReadElementNode.class})
    static abstract class ReadElementTypeCacheDispatchNode
    extends JavaScriptBaseNode {
        ReadElementTypeCacheDispatchNode() {
        }

        protected abstract Object executeExpectReturn(Object var1, Object var2, Object var3, Object var4, ReadElementNode var5, int var6);

        protected abstract Object executeExpectReturn(Object var1, long var2, Object var4, Object var5, ReadElementNode var6, int var7);

        @HostCompilerDirectives.InliningCutoff
        protected final Object executeWithTargetAndIndexUnchecked(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.executeExpectReturn(target, index, receiver, defaultValue, root, 0);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final Object executeWithTargetAndIndexUnchecked(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.executeExpectReturn(target, index, receiver, defaultValue, root, 0);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final int executeWithTargetAndIndexUncheckedInt(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeExpectReturn(target, index, receiver, defaultValue, root, 1));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final int executeWithTargetAndIndexUncheckedInt(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeExpectReturn(target, index, receiver, defaultValue, root, 1));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final double executeWithTargetAndIndexUncheckedDouble(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeExpectReturn(target, index, receiver, defaultValue, root, 2));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final double executeWithTargetAndIndexUncheckedDouble(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeExpectReturn(target, index, receiver, defaultValue, root, 2));
        }

        @Specialization(guards={"isObjectNode.executeBoolean(target)"}, limit="1")
        protected static Object doJSObjectLongIndex(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared IsJSDynamicObjectNode isObjectNode, @Cached @Cached.Shared JSObjectReadElementTypeCacheNode objectHandler) {
            if (ReadElementNode.isExpectedReturnInt(expectedReturn)) {
                try {
                    return objectHandler.executeWithTargetAndIndexUncheckedInt(target, index, receiver, defaultValue, root);
                }
                catch (UnexpectedResultException e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            if (ReadElementNode.isExpectedReturnDouble(expectedReturn)) {
                try {
                    return objectHandler.executeWithTargetAndIndexUncheckedDouble(target, index, receiver, defaultValue, root);
                }
                catch (UnexpectedResultException e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            assert (expectedReturn == 0);
            return objectHandler.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, root);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(target)"}, limit="1", replaces={"doJSObjectLongIndex"})
        protected static Object doJSObject(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared IsJSDynamicObjectNode isObjectNode, @Cached @Cached.Shared JSObjectReadElementTypeCacheNode objectHandler) {
            if (ReadElementNode.isExpectedReturnInt(expectedReturn)) {
                try {
                    return objectHandler.executeWithTargetAndIndexUncheckedInt(target, index, receiver, defaultValue, root);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            if (ReadElementNode.isExpectedReturnDouble(expectedReturn)) {
                try {
                    return objectHandler.executeWithTargetAndIndexUncheckedDouble(target, index, receiver, defaultValue, root);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            assert (expectedReturn == 0);
            return objectHandler.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, root);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        protected static Object doStringLongIndex(TruffleString target, long index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared StringReadElementTypeCacheNode stringHandler) {
            return stringHandler.executeWithTargetAndIndexUnchecked((Object)target, index, receiver, defaultValue, root);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(replaces={"doStringLongIndex"})
        protected static Object doString(TruffleString target, Object index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared StringReadElementTypeCacheNode stringHandler) {
            return stringHandler.executeWithTargetAndIndexUnchecked((Object)target, index, receiver, defaultValue, root);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"otherHandler.guard(target)"}, limit="BOUNDED_BY_TYPES")
        protected static Object doOther(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached(value="makeTypeCacheNode(target)") GuardedReadElementTypeCacheNode otherHandler) {
            return otherHandler.executeWithTargetAndIndexUnchecked(target, index, receiver, defaultValue, root);
        }

        protected static GuardedReadElementTypeCacheNode makeTypeCacheNode(Object target) {
            if (JSDynamicObject.isJSDynamicObject(target)) {
                throw CompilerDirectives.shouldNotReachHere((String)"JSDynamicObject");
            }
            if (Strings.isTString(target)) {
                throw CompilerDirectives.shouldNotReachHere((String)"TruffleString");
            }
            if (target instanceof Boolean) {
                return ReadElementNodeFactory.BooleanReadElementTypeCacheNodeGen.create();
            }
            if (target instanceof Number) {
                return ReadElementNodeFactory.NumberReadElementTypeCacheNodeGen.create(target.getClass());
            }
            if (target instanceof Symbol) {
                return ReadElementNodeFactory.SymbolReadElementTypeCacheNodeGen.create();
            }
            if (target instanceof BigInt) {
                return ReadElementNodeFactory.BigIntReadElementTypeCacheNodeGen.create();
            }
            assert (JSRuntime.isForeignObject(target)) : target.getClass();
            return ReadElementNodeFactory.ForeignObjectReadElementTypeCacheNodeGen.create();
        }
    }

    static abstract class EmptyArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        EmptyArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doEmptyArray(JSDynamicObject target, ConstantEmptyArray emptyArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile needGetProperty) {
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class ConstantObjectArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        ConstantObjectArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doConstantObjectArray(JSDynamicObject target, ConstantObjectArray constantObjectArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile notHoleArray, @Cached InlinedConditionProfile notHoleValue, @Cached InlinedConditionProfile needGetProperty) {
            if (inBounds.profile((Node)this, constantObjectArray.isInBoundsFast(target, index))) {
                Object value = ConstantObjectArray.getElementInBoundsDirect(target, (int)index);
                if (notHoleArray.profile((Node)this, !constantObjectArray.hasHoles(target))) {
                    return value;
                }
                if (notHoleValue.profile((Node)this, !HolesObjectArray.isHoleValue(value))) {
                    return value;
                }
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class LazyRegexResultArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        @Node.Child
        private DynamicObjectLibrary lazyRegexResultNode = JSObjectUtil.createDispatched(JSAbstractArray.LAZY_REGEX_RESULT_ID);
        @Node.Child
        private DynamicObjectLibrary lazyRegexResultOriginalInputNode = JSObjectUtil.createDispatched(JSAbstractArray.LAZY_REGEX_ORIGINAL_INPUT_ID);
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringNode = TruffleString.SubstringByteIndexNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        LazyRegexResultArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doLazyRegexResultArray(JSDynamicObject target, LazyRegexResultArray lazyRegexResultArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile needGetProperty) {
            int intIndex = (int)index;
            if (inBounds.profile((Node)this, lazyRegexResultArray.hasElement(target, intIndex))) {
                return LazyRegexResultArray.materializeGroup(context, target, intIndex, this.lazyRegexResultNode, this.lazyRegexResultOriginalInputNode, null, this.substringNode, this.getStartNode, this.getEndNode);
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class LazyRegexResultIndicesArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getStartNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();
        @Node.Child
        private TRegexUtil.InvokeGetGroupBoundariesMethodNode getEndNode = TRegexUtil.InvokeGetGroupBoundariesMethodNode.create();

        LazyRegexResultIndicesArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doLazyRegexResultIndicesArray(JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile needGetProperty) {
            LazyRegexResultIndicesArray lazyRegexResultIndicesArray = (LazyRegexResultIndicesArray)array;
            int intIndex = (int)index;
            if (inBounds.profile((Node)this, lazyRegexResultIndicesArray.hasElement(target, intIndex))) {
                return LazyRegexResultIndicesArray.materializeGroup(context, target, intIndex, null, this.getStartNode, this.getEndNode);
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class LazyArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        @Node.Child
        private ListGetNode listGetNode = ListGetNodeGen.create();

        LazyArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doLazyArray(JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile needGetProperty) {
            LazyArray lazyRegexResultArray = (LazyArray)array;
            int intIndex = (int)index;
            if (inBounds.profile((Node)this, lazyRegexResultArray.hasElement(target, intIndex))) {
                return lazyRegexResultArray.getElementInBounds(target, intIndex, this.listGetNode);
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class ConstantArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        ConstantArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doConstantArray(JSDynamicObject target, AbstractConstantArray constantArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile needGetProperty) {
            if (inBounds.profile((Node)this, constantArray.hasElement(target, index))) {
                return constantArray.getElementInBounds(target, (int)index);
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class HolesIntArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        HolesIntArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doHolesIntArray(JSDynamicObject target, HolesIntArray holesIntArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile notHoleValue, @Cached InlinedConditionProfile needGetProperty) {
            int value;
            if (inBounds.profile((Node)this, holesIntArray.isInBoundsFast(target, index)) && notHoleValue.profile((Node)this, !HolesIntArray.isHoleValue(value = holesIntArray.getInBoundsFastInt(target, (int)index)))) {
                return value;
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class HolesDoubleArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        HolesDoubleArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doHolesDoubleArray(JSDynamicObject target, HolesDoubleArray holesDoubleArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile notHoleValue, @Cached InlinedConditionProfile needGetProperty) {
            double value;
            if (inBounds.profile((Node)this, holesDoubleArray.isInBoundsFast(target, index)) && notHoleValue.profile((Node)this, !HolesDoubleArray.isHoleValue(value = holesDoubleArray.getInBoundsFastDouble(target, (int)index)))) {
                return value;
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class HolesJSObjectArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        HolesJSObjectArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doHolesJSObjectArray(JSDynamicObject target, HolesJSObjectArray holesArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile notHoleValue, @Cached InlinedConditionProfile needGetProperty) {
            JSDynamicObject value;
            if (inBounds.profile((Node)this, holesArray.isInBoundsFast(target, index)) && notHoleValue.profile((Node)this, !HolesJSObjectArray.isHoleValue(value = holesArray.getInBoundsFastJSObject(target, (int)index)))) {
                return value;
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class HolesObjectArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        HolesObjectArrayReadElementCacheNode() {
        }

        @Specialization
        protected Object doHolesObjectArray(JSDynamicObject target, HolesObjectArray holesArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds, @Cached InlinedConditionProfile notHoleValue, @Cached InlinedConditionProfile needGetProperty) {
            Object value;
            if (inBounds.profile((Node)this, holesArray.isInBoundsFast(target, index)) && notHoleValue.profile((Node)this, !HolesObjectArray.isHoleValue(value = holesArray.getInBoundsFastObject(target, (int)index)))) {
                return value;
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class WritableArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        WritableArrayReadElementCacheNode() {
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected int doWritableArrayInt(JSDynamicObject target, AbstractWritableArray writableArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds, @Cached @Cached.Shared InlinedConditionProfile needGetProperty) throws UnexpectedResultException {
            if (inBounds.profile((Node)this, writableArray.isInBoundsFast(target, index))) {
                return writableArray.getInBoundsFastInt(target, (int)index);
            }
            return JSTypesGen.expectInteger(this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty));
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected double doWritableArrayDouble(JSDynamicObject target, AbstractWritableArray writableArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds, @Cached @Cached.Shared InlinedConditionProfile needGetProperty) throws UnexpectedResultException {
            if (inBounds.profile((Node)this, writableArray.isInBoundsFast(target, index))) {
                return writableArray.getInBoundsFastDouble(target, (int)index);
            }
            return JSTypesGen.expectDouble(this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty));
        }

        @Specialization
        protected Object doWritableArray(JSDynamicObject target, AbstractWritableArray writableArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds, @Cached @Cached.Shared InlinedConditionProfile needGetProperty) {
            if (inBounds.profile((Node)this, writableArray.isInBoundsFast(target, index))) {
                return writableArray.getInBoundsFast(target, (int)index);
            }
            return this.readOutOfBounds(target, index, receiver, defaultValue, context, needGetProperty);
        }
    }

    static abstract class Uint32ArrayReadElementCacheNode
    extends AbstractTypedArrayReadElementCacheNode {
        Uint32ArrayReadElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected int doTypedUint32Array(JSDynamicObject target, TypedArray.AbstractUint32Array typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds, @Cached @Cached.Shared InlinedConditionProfile notNegative) throws UnexpectedResultException {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                int intValue = typedArray.getInt(target, (int)index, this.interop);
                if (notNegative.profile((Node)this, intValue >= 0)) {
                    return intValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnexpectedResultException((Object)((long)intValue & 0xFFFFFFFFL));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(defaultValue);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected double doTypedUint32ArrayDouble(JSDynamicObject target, TypedArray.AbstractUint32Array typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) throws UnexpectedResultException {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return (long)typedArray.getInt(target, (int)index, this.interop) & 0xFFFFFFFFL;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(defaultValue);
        }

        @Specialization
        protected Object doTypedUint32ArrayGet(JSDynamicObject target, TypedArray.AbstractUint32Array typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds, @Cached @Cached.Shared InlinedConditionProfile notNegative) {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                int intValue = typedArray.getInt(target, (int)index, this.interop);
                if (notNegative.profile((Node)this, intValue >= 0)) {
                    return intValue;
                }
                return (double)((long)intValue & 0xFFFFFFFFL);
            }
            return defaultValue;
        }
    }

    static abstract class TypedIntArrayReadElementCacheNode
    extends AbstractTypedArrayReadElementCacheNode {
        TypedIntArrayReadElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected int doTypedIntArrayInt(JSDynamicObject target, TypedArray.TypedIntArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) throws UnexpectedResultException {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getInt(target, (int)index, this.interop);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(defaultValue);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected double doTypedIntArrayDouble(JSDynamicObject target, TypedArray.TypedIntArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) throws UnexpectedResultException {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getInt(target, (int)index, this.interop);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(defaultValue);
        }

        @Specialization
        protected Object doTypedIntArray(JSDynamicObject target, TypedArray.TypedIntArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getInt(target, (int)index, this.interop);
            }
            return defaultValue;
        }
    }

    static abstract class TypedFloatArrayReadElementCacheNode
    extends AbstractTypedArrayReadElementCacheNode {
        TypedFloatArrayReadElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        protected double doTypedFloatArrayDouble(JSDynamicObject target, TypedArray.TypedFloatArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) throws UnexpectedResultException {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getDouble(target, (int)index, this.interop);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnexpectedResultException(defaultValue);
        }

        @Specialization
        protected Object doTypedFloatArray(JSDynamicObject target, TypedArray.TypedFloatArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached @Cached.Shared InlinedConditionProfile inBounds) {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getDouble(target, (int)index, this.interop);
            }
            return defaultValue;
        }
    }

    static abstract class TypedBigIntArrayReadElementCacheNode
    extends AbstractTypedArrayReadElementCacheNode {
        TypedBigIntArrayReadElementCacheNode(TypedArray arrayType) {
            super(arrayType);
        }

        @Specialization
        protected Object doTypedBigIntArray(JSDynamicObject target, TypedArray.TypedBigIntArray typedArray, long index, Object receiver, Object defaultValue, JSContext context, @Cached InlinedConditionProfile inBounds) {
            if (!JSArrayBufferView.hasDetachedBuffer(target, context) && inBounds.profile((Node)this, typedArray.hasElement(target, index))) {
                return typedArray.getBigInt(target, (int)index, this.interop);
            }
            return defaultValue;
        }
    }

    private static class ExactArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        private final JSClassProfile classProfile = JSClassProfile.create();

        private ExactArrayReadElementCacheNode() {
        }

        @Override
        protected Object executeArrayGet(JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) {
            return JSObject.getOrDefault(target, index, receiver, defaultValue, this.classProfile, (Node)this);
        }
    }

    static abstract class ForeignObjectReadElementTypeCacheNode
    extends GuardedReadElementTypeCacheNode {
        @Node.Child
        private InteropLibrary interop;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKeyNode;
        @Node.Child
        private ImportValueNode importValueNode = ImportValueNode.create();
        @Node.Child
        private InteropLibrary getterInterop;
        @Node.Child
        private ForeignObjectPrototypeNode foreignObjectPrototypeNode;
        @Node.Child
        private CachedGetPropertyNode readFromPrototypeNode;
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode;
        @CompilerDirectives.CompilationFinal
        private boolean optimistic = true;

        ForeignObjectReadElementTypeCacheNode() {
            this.interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);
        }

        @Specialization
        protected Object doForeignObject(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached InlinedExactClassProfile classProfile, @Cached InlinedBranchProfile errorBranch) {
            Object truffleObject = classProfile.profile((Node)this, target);
            if (this.interop.isNull(truffleObject)) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorCannotGetProperty(root.getContext(), JSRuntime.safeToString(index), target, false, this);
            }
            Object foreignResult = this.getImpl(truffleObject, index, defaultValue, root, errorBranch);
            if (foreignResult == defaultValue) {
                return foreignResult;
            }
            return this.importValueNode.executeWithTarget(foreignResult);
        }

        private Object getImpl(Object truffleObject, Object key, Object defaultValue, ReadElementNode root, @Cached InlinedBranchProfile errorBranch) {
            Object result;
            Object propertyKey;
            boolean hasArrayElements;
            block18: {
                hasArrayElements = this.interop.hasArrayElements(truffleObject);
                if (hasArrayElements) {
                    try {
                        Object indexOrPropertyKey = this.toArrayIndex(key);
                        if (indexOrPropertyKey instanceof Long) {
                            return this.interop.readArrayElement(truffleObject, ((Long)indexOrPropertyKey).longValue());
                        }
                        propertyKey = indexOrPropertyKey;
                        assert (JSRuntime.isPropertyKey(propertyKey));
                        break block18;
                    }
                    catch (InvalidArrayIndexException | UnsupportedMessageException e) {
                        return defaultValue;
                    }
                }
                propertyKey = this.toPropertyKey(key);
            }
            if (root.context.getLanguageOptions().hasForeignHashProperties() && this.interop.hasHashEntries(truffleObject)) {
                try {
                    return this.interop.readHashValue(truffleObject, propertyKey);
                }
                catch (UnknownKeyException e) {
                }
                catch (UnsupportedMessageException e) {
                    return defaultValue;
                }
            }
            if (propertyKey instanceof Symbol) {
                return this.maybeReadFromPrototype(truffleObject, propertyKey, root.context);
            }
            TruffleString exportedKeyStr = (TruffleString)propertyKey;
            if (hasArrayElements && Strings.equals(JSAbstractArray.LENGTH, exportedKeyStr)) {
                return this.getSize(truffleObject, errorBranch);
            }
            if (root.context.isOptionNashornCompatibilityMode() && (result = this.tryGetters(truffleObject, exportedKeyStr, root.context)) != null) {
                return result;
            }
            String stringKey = Strings.toJavaString(exportedKeyStr);
            if (this.optimistic) {
                try {
                    return this.interop.readMember(truffleObject, stringKey);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.optimistic = false;
                    return this.maybeReadFromPrototype(truffleObject, exportedKeyStr, root.context);
                }
            }
            if (this.interop.isMemberReadable(truffleObject, stringKey)) {
                try {
                    return this.interop.readMember(truffleObject, stringKey);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    return defaultValue;
                }
            }
            return this.maybeReadFromPrototype(truffleObject, exportedKeyStr, root.context);
        }

        private Object tryGetters(Object thisObj, TruffleString key, JSContext context) {
            assert (context.isOptionNashornCompatibilityMode());
            TruffleLanguage.Env env = this.getRealm().getEnv();
            if (env.isHostObject(thisObj)) {
                Object result = this.tryInvokeGetter(thisObj, Strings.GET, key);
                if (result != null) {
                    return result;
                }
                result = this.tryInvokeGetter(thisObj, Strings.IS, key);
                if (result != null) {
                    return result;
                }
            }
            return null;
        }

        private Object tryInvokeGetter(Object thisObj, TruffleString prefix, TruffleString key) {
            TruffleString getterKey = PropertyCacheNode.getAccessorKey(prefix, key);
            if (getterKey == null) {
                return null;
            }
            if (this.getterInterop == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getterInterop = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(5)));
            }
            if (!this.getterInterop.isMemberInvocable(thisObj, Strings.toJavaString(getterKey))) {
                return null;
            }
            try {
                return this.getterInterop.invokeMember(thisObj, Strings.toJavaString(getterKey), JSArguments.EMPTY_ARGUMENTS_ARRAY);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                return null;
            }
        }

        private Object getSize(Object truffleObject, InlinedBranchProfile errorBranch) {
            try {
                return JSRuntime.longToIntOrDouble(this.interop.getArraySize(truffleObject));
            }
            catch (UnsupportedMessageException e) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorInteropException(truffleObject, (InteropException)((Object)e), "getArraySize", this);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private Object maybeReadFromPrototype(Object truffleObject, Object key, JSContext context) {
            assert (JSRuntime.isPropertyKey(key));
            if (context.getLanguageOptions().hasForeignObjectPrototype() || key instanceof Symbol || JSInteropUtil.isBoxedPrimitive(truffleObject, this.interop)) {
                if (this.readFromPrototypeNode == null || this.foreignObjectPrototypeNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.readFromPrototypeNode = (CachedGetPropertyNode)this.insert(CachedGetPropertyNode.create(context));
                    this.foreignObjectPrototypeNode = (ForeignObjectPrototypeNode)this.insert(ForeignObjectPrototypeNode.create());
                }
                JSDynamicObject prototype = this.foreignObjectPrototypeNode.execute(truffleObject);
                return this.readFromPrototypeNode.execute(prototype, key, truffleObject, (Object)Undefined.instance);
            }
            return Undefined.instance;
        }

        @Override
        protected Object executeWithTargetAndIndexUnchecked(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.executeWithTargetAndIndexUnchecked(target, (Object)index, receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return JSRuntime.isForeignObject(target);
        }

        private Object toArrayIndex(Object maybeIndex) {
            if (this.toArrayIndexNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
            }
            return this.toArrayIndexNode.execute(maybeIndex);
        }

        private Object toPropertyKey(Object index) {
            if (this.toPropertyKeyNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toPropertyKeyNode = (JSToPropertyKeyNode)this.insert(JSToPropertyKeyNode.create());
            }
            return this.toPropertyKeyNode.execute(index);
        }
    }

    static abstract class BigIntReadElementTypeCacheNode
    extends ToPropertyKeyCachedReadElementTypeCacheNode {
        BigIntReadElementTypeCacheNode() {
        }

        @Specialization
        protected Object doBigInt(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            BigInt bigInt = (BigInt)target;
            return JSObject.getOrDefault((JSDynamicObject)JSBigInt.create(root.context, this.getRealm(), bigInt), index, receiver, defaultValue, this.jsclassProfile, (Node)root);
        }

        @Specialization
        protected Object doBigInt(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            BigInt bigInt = (BigInt)target;
            return this.readFromWrapper(JSBigInt.create(root.context, this.getRealm(), bigInt), indexToPropertyKeyNode.execute(index), receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof BigInt;
        }
    }

    static abstract class SymbolReadElementTypeCacheNode
    extends ToPropertyKeyCachedReadElementTypeCacheNode {
        SymbolReadElementTypeCacheNode() {
        }

        @Specialization
        protected Object doSymbol(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            Symbol symbol = (Symbol)target;
            return JSObject.getOrDefault((JSDynamicObject)JSSymbol.create(root.context, this.getRealm(), symbol), index, receiver, defaultValue, this.jsclassProfile, (Node)root);
        }

        @Specialization
        protected Object doSymbol(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            Symbol symbol = (Symbol)target;
            return this.readFromWrapper(JSSymbol.create(root.context, this.getRealm(), symbol), indexToPropertyKeyNode.execute(index), receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Symbol;
        }
    }

    static abstract class BooleanReadElementTypeCacheNode
    extends ToPropertyKeyCachedReadElementTypeCacheNode {
        BooleanReadElementTypeCacheNode() {
        }

        @Specialization
        protected Object doBoolean(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            Boolean bool = (Boolean)target;
            return JSObject.getOrDefault((JSDynamicObject)JSBoolean.create(root.context, this.getRealm(), bool), index, receiver, defaultValue, this.jsclassProfile, (Node)root);
        }

        @Specialization
        protected Object doBoolean(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            Boolean bool = (Boolean)target;
            return this.readFromWrapper(JSBoolean.create(root.context, this.getRealm(), bool), indexToPropertyKeyNode.execute(index), receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof Boolean;
        }
    }

    static abstract class NumberReadElementTypeCacheNode
    extends ToPropertyKeyCachedReadElementTypeCacheNode {
        private final Class<?> numberClass;

        NumberReadElementTypeCacheNode(Class<?> stringClass) {
            this.numberClass = stringClass;
        }

        @Specialization
        protected Object doNumber(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            Number number = (Number)CompilerDirectives.castExact((Object)target, this.numberClass);
            return JSObject.getOrDefault((JSDynamicObject)JSNumber.create(root.context, this.getRealm(), number), index, receiver, defaultValue, this.jsclassProfile, (Node)root);
        }

        @Specialization
        protected Object doNumber(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            Number number = (Number)CompilerDirectives.castExact((Object)target, this.numberClass);
            return this.readFromWrapper(JSNumber.create(root.context, this.getRealm(), number), indexToPropertyKeyNode.execute(index), receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return CompilerDirectives.isExact((Object)target, this.numberClass);
        }
    }

    static abstract class StringReadElementTypeCacheNode
    extends ToPropertyKeyCachedReadElementTypeCacheNode {
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode = ToArrayIndexNode.createNoToPropertyKey();
        @Node.Child
        private TruffleString.SubstringByteIndexNode substringByteIndexNode = TruffleString.SubstringByteIndexNode.create();

        StringReadElementTypeCacheNode() {
        }

        @Specialization
        protected Object doStringLongIndex(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root, @Cached @Cached.Shared InlinedConditionProfile stringIndexInBounds) {
            TruffleString string = (TruffleString)target;
            if (stringIndexInBounds.profile((Node)this, index >= 0L && index < (long)Strings.length(string))) {
                return Strings.substring(root.context, this.substringByteIndexNode, string, (int)index, 1);
            }
            return this.doStringLongIndexOOB(string, index, receiver, defaultValue, root);
        }

        @HostCompilerDirectives.InliningCutoff
        private Object doStringLongIndexOOB(TruffleString string, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            return JSObject.getOrDefault((JSDynamicObject)JSString.create(root.context, this.getRealm(), string), index, receiver, defaultValue, this.jsclassProfile, (Node)root);
        }

        @Specialization
        protected Object doString(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, @Cached @Cached.Exclusive InlinedConditionProfile arrayIndexIf, @Cached @Cached.Shared InlinedConditionProfile stringIndexInBounds, @Cached JSToPropertyKeyNode indexToPropertyKeyNode) {
            int intIndex;
            TruffleString string = (TruffleString)target;
            Object convertedIndex = this.toArrayIndexNode.execute(index);
            if (arrayIndexIf.profile((Node)this, convertedIndex instanceof Long) && stringIndexInBounds.profile((Node)this, (intIndex = ((Long)convertedIndex).intValue()) >= 0 && intIndex < Strings.length(string))) {
                return Strings.substring(root.context, this.substringByteIndexNode, string, intIndex, 1);
            }
            return this.doStringOOB(string, index, receiver, defaultValue, root, indexToPropertyKeyNode);
        }

        @HostCompilerDirectives.InliningCutoff
        private Object doStringOOB(TruffleString string, Object index, Object receiver, Object defaultValue, ReadElementNode root, JSToPropertyKeyNode indexToPropertyKeyNode) {
            return this.readFromWrapper(JSString.create(root.context, this.getRealm(), string), indexToPropertyKeyNode.execute(index), receiver, defaultValue, root);
        }

        @Override
        public boolean guard(Object target) {
            return target instanceof TruffleString;
        }
    }

    private static abstract class ToPropertyKeyCachedReadElementTypeCacheNode
    extends GuardedReadElementTypeCacheNode {
        @Node.Child
        private CachedGetPropertyNode getPropertyCachedNode;
        protected final JSClassProfile jsclassProfile = JSClassProfile.create();

        ToPropertyKeyCachedReadElementTypeCacheNode() {
        }

        @HostCompilerDirectives.InliningCutoff
        public Object readFromWrapper(JSDynamicObject wrapper, Object index, Object receiver, Object defaultValue, ReadElementNode root) {
            if (this.getPropertyCachedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getPropertyCachedNode = (CachedGetPropertyNode)this.insert(CachedGetPropertyNode.create(root.context));
            }
            return this.getPropertyCachedNode.execute(wrapper, index, receiver, defaultValue);
        }
    }

    private static abstract class AbstractTypedArrayReadElementCacheNode
    extends ArrayClassGuardCachedArrayReadElementCacheNode {
        @Node.Child
        protected InteropLibrary interop;

        AbstractTypedArrayReadElementCacheNode(TypedArray arrayType) {
            this.interop = arrayType.isInterop() ? (InteropLibrary)InteropLibrary.getFactory().createDispatched(5) : InteropLibrary.getUncached();
        }
    }

    static abstract class ArrayClassGuardCachedArrayReadElementCacheNode
    extends ArrayReadElementCacheNode {
        private final JSClassProfile outOfBoundsClassProfile = JSClassProfile.create();

        ArrayClassGuardCachedArrayReadElementCacheNode() {
        }

        protected Object readOutOfBounds(JSDynamicObject target, long index, Object receiver, Object defaultValue, JSContext context, InlinedConditionProfile needGetProperty) {
            if (needGetProperty.profile((Node)this, ArrayClassGuardCachedArrayReadElementCacheNode.needsSlowGet(target, context))) {
                return JSObject.getOrDefault(target, index, receiver, defaultValue, this.outOfBoundsClassProfile, (Node)this);
            }
            return defaultValue;
        }

        private static boolean needsSlowGet(JSDynamicObject target, JSContext context) {
            return !context.getArrayPrototypeNoElementsAssumption().isValid() || !context.getFastArrayAssumption().isValid() && JSSlowArray.isJSSlowArray(target) || !context.getFastArgumentsObjectAssumption().isValid() && JSSlowArgumentsArray.isJSSlowArgumentsObject(target);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={ReadElementNode.class})
    public static abstract class ArrayReadElementCacheDispatchNode
    extends JavaScriptBaseNode {
        protected ArrayReadElementCacheDispatchNode() {
        }

        protected abstract Object executeExpectReturn(Node var1, JSDynamicObject var2, ScriptArray var3, long var4, Object var6, Object var7, JSContext var8, int var9);

        protected final Object executeDelegateReturn(Node node, JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context, int expectedReturn) {
            if (ReadElementNode.isExpectedReturnInt(expectedReturn)) {
                try {
                    return this.executeArrayGetInt(node, target, array, index, receiver, defaultValue, context);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            if (ReadElementNode.isExpectedReturnDouble(expectedReturn)) {
                try {
                    return this.executeArrayGetDouble(node, target, array, index, receiver, defaultValue, context);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            assert (expectedReturn == 0);
            return this.executeArrayGet(node, target, array, index, receiver, defaultValue, context);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final Object executeArrayGet(Node node, JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) {
            return this.executeExpectReturn(node, target, array, index, receiver, defaultValue, context, 0);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final int executeArrayGetInt(Node node, JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeExpectReturn(node, target, array, index, receiver, defaultValue, context, 1));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final double executeArrayGetDouble(Node node, JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeExpectReturn(node, target, array, index, receiver, defaultValue, context, 2));
        }

        @Specialization(guards={"arrayType == cachedArrayType"}, limit="BOUNDED_BY_TYPES")
        protected static Object doDispatch(JSDynamicObject target, ScriptArray arrayType, long index, Object receiver, Object defaultValue, JSContext context, int expectedReturn, @Cached(value="arrayType") ScriptArray cachedArrayType, @Cached(value="makeHandler(target, cachedArrayType)") ArrayReadElementCacheNode handler) {
            if (ReadElementNode.isExpectedReturnInt(expectedReturn)) {
                try {
                    return handler.executeArrayGetInt(target, cachedArrayType, index, receiver, defaultValue, context);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            if (ReadElementNode.isExpectedReturnDouble(expectedReturn)) {
                try {
                    return handler.executeArrayGetDouble(target, cachedArrayType, index, receiver, defaultValue, context);
                }
                catch (Throwable e) {
                    throw JSRuntime.rethrow(e);
                }
            }
            assert (expectedReturn == 0);
            return handler.executeArrayGet(target, cachedArrayType, index, receiver, defaultValue, context);
        }

        protected static ArrayReadElementCacheNode makeHandler(JSDynamicObject target, ScriptArray arrayType) {
            return ReadElementNode.makeArrayCacheNode(target, arrayType);
        }
    }

    public static abstract class ReadElementArrayDispatchNode
    extends JavaScriptBaseNode {
        protected ReadElementArrayDispatchNode() {
        }

        public static ReadElementArrayDispatchNode create() {
            return ReadElementNodeFactory.ReadElementArrayDispatchNodeGen.create();
        }

        protected abstract Object executeArrayGet(JSDynamicObject var1, ScriptArray var2, long var3, Object var5, Object var6, JSContext var7);

        @Specialization
        protected final Object doDispatch(JSDynamicObject target, ScriptArray arrayType, long index, Object receiver, Object defaultValue, JSContext context, @Cached ArrayReadElementCacheDispatchNode dispatcher) {
            return dispatcher.executeArrayGet(this, target, arrayType, index, receiver, defaultValue, context);
        }
    }

    static abstract class ArrayReadElementCacheNode
    extends JavaScriptBaseNode {
        protected ArrayReadElementCacheNode() {
        }

        protected abstract Object executeArrayGet(JSDynamicObject var1, ScriptArray var2, long var3, Object var5, Object var6, JSContext var7);

        protected int executeArrayGetInt(JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeArrayGet(target, array, index, receiver, defaultValue, context));
        }

        protected double executeArrayGetDouble(JSDynamicObject target, ScriptArray array, long index, Object receiver, Object defaultValue, JSContext context) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeArrayGet(target, array, index, receiver, defaultValue, context));
        }
    }

    private static class JSObjectReadElementNonArrayTypeCacheNode
    extends JavaScriptBaseNode {
        @Node.Child
        private CachedGetPropertyNode getPropertyCachedNode;

        JSObjectReadElementNonArrayTypeCacheNode() {
        }

        public Object execute(JSDynamicObject targetObject, Object index, Object receiver, Object defaultValue, ReadElementNode root) {
            if (this.getPropertyCachedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getPropertyCachedNode = (CachedGetPropertyNode)this.insert(CachedGetPropertyNode.create(root.context));
            }
            return this.getPropertyCachedNode.execute(targetObject, index, receiver, defaultValue);
        }
    }

    static abstract class JSObjectReadElementTypeCacheNode
    extends JavaScriptBaseNode {
        @Node.Child
        private IsArrayNode isArrayNode;
        @Node.Child
        private ToArrayIndexNode toArrayIndexNode;
        @Node.Child
        private JSObjectReadElementNonArrayTypeCacheNode nonArrayCaseNode;
        private final JSClassProfile jsclassProfile = JSClassProfile.create();

        JSObjectReadElementTypeCacheNode() {
            this.isArrayNode = IsArrayNode.createIsAnyArray();
        }

        protected abstract Object executeExpectReturn(Object var1, Object var2, Object var3, Object var4, ReadElementNode var5, int var6);

        protected abstract Object executeExpectReturn(Object var1, long var2, Object var4, Object var5, ReadElementNode var6, int var7);

        @HostCompilerDirectives.InliningCutoff
        protected final Object executeWithTargetAndIndexUnchecked(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.executeExpectReturn(target, index, receiver, defaultValue, root, 0);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final Object executeWithTargetAndIndexUnchecked(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.executeExpectReturn(target, index, receiver, defaultValue, root, 0);
        }

        @HostCompilerDirectives.InliningCutoff
        protected final int executeWithTargetAndIndexUncheckedInt(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeExpectReturn(target, index, receiver, defaultValue, root, 1));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final int executeWithTargetAndIndexUncheckedInt(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectInteger(this.executeExpectReturn(target, index, receiver, defaultValue, root, 1));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final double executeWithTargetAndIndexUncheckedDouble(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeExpectReturn(target, index, receiver, defaultValue, root, 2));
        }

        @HostCompilerDirectives.InliningCutoff
        protected final double executeWithTargetAndIndexUncheckedDouble(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root) throws UnexpectedResultException {
            return JSTypesGen.expectDouble(this.executeExpectReturn(target, index, receiver, defaultValue, root, 2));
        }

        @HostCompilerDirectives.InliningCutoff
        private boolean isArray(Object target) {
            return this.isArrayNode.execute(target);
        }

        @HostCompilerDirectives.InliningCutoff
        private Object toArrayIndex(Object index) {
            ToArrayIndexNode toArrayIndex = this.toArrayIndexNode;
            if (toArrayIndex == null) {
                toArrayIndex = this.initToArrayIndexNode();
            }
            return toArrayIndex.execute(index);
        }

        private ToArrayIndexNode initToArrayIndexNode() {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toArrayIndexNode = (ToArrayIndexNode)this.insert(ToArrayIndexNode.create());
            return this.toArrayIndexNode;
        }

        @HostCompilerDirectives.InliningCutoff
        private Object readNonArrayObjectIndex(JSDynamicObject targetObject, Object index, Object receiver, Object defaultValue, ReadElementNode root) {
            return this.getNonArrayNode().execute(targetObject, index, receiver, defaultValue, root);
        }

        @Specialization
        protected Object doLongIndex(Object target, long index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared ArrayReadElementCacheDispatchNode arrayDispatch, @Cached @Cached.Shared InlinedConditionProfile arrayIf, @Cached @Cached.Shared InlinedConditionProfile arrayIndexIf, @Cached TruffleString.FromLongNode fromLong) {
            JSDynamicObject targetObject = (JSDynamicObject)((Object)target);
            if (arrayIf.profile((Node)this, this.isArray((Object)targetObject))) {
                ScriptArray array = JSObject.getArray(targetObject);
                if (arrayIndexIf.profile((Node)this, JSRuntime.isArrayIndex(index))) {
                    return arrayDispatch.executeDelegateReturn(this, targetObject, array, index, receiver, defaultValue, root.context, expectedReturn);
                }
                return this.getProperty(targetObject, Strings.fromLong(fromLong, index), receiver, defaultValue);
            }
            return this.readNonArrayObjectIndex(targetObject, index, receiver, defaultValue, root);
        }

        @Specialization(replaces={"doLongIndex"})
        protected Object doObjectIndex(Object target, Object index, Object receiver, Object defaultValue, ReadElementNode root, int expectedReturn, @Cached @Cached.Shared ArrayReadElementCacheDispatchNode arrayDispatch, @Cached @Cached.Shared InlinedConditionProfile arrayIf, @Cached @Cached.Shared InlinedConditionProfile arrayIndexIf) {
            JSDynamicObject targetObject = (JSDynamicObject)((Object)target);
            if (arrayIf.profile((Node)this, this.isArray((Object)targetObject))) {
                ScriptArray array = JSObject.getArray(targetObject);
                Object objIndex = this.toArrayIndex(index);
                if (arrayIndexIf.profile((Node)this, objIndex instanceof Long)) {
                    long longIndex = (Long)objIndex;
                    return arrayDispatch.executeDelegateReturn(this, targetObject, array, longIndex, receiver, defaultValue, root.context, expectedReturn);
                }
                return this.getProperty(targetObject, objIndex, receiver, defaultValue);
            }
            return this.readNonArrayObjectIndex(targetObject, index, receiver, defaultValue, root);
        }

        private Object getProperty(JSDynamicObject targetObject, Object objIndex, Object receiver, Object defaultValue) {
            return JSObject.getOrDefault(targetObject, objIndex, receiver, defaultValue, this.jsclassProfile, (Node)this);
        }

        private JSObjectReadElementNonArrayTypeCacheNode getNonArrayNode() {
            if (this.nonArrayCaseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonArrayCaseNode = (JSObjectReadElementNonArrayTypeCacheNode)this.insert(new JSObjectReadElementNonArrayTypeCacheNode());
            }
            return this.nonArrayCaseNode;
        }
    }

    static abstract class GuardedReadElementTypeCacheNode
    extends JavaScriptBaseNode {
        GuardedReadElementTypeCacheNode() {
        }

        public abstract boolean guard(Object var1);

        protected abstract Object executeWithTargetAndIndexUnchecked(Object var1, Object var2, Object var3, Object var4, ReadElementNode var5);

        protected abstract Object executeWithTargetAndIndexUnchecked(Object var1, long var2, Object var4, Object var5, ReadElementNode var6);
    }
}

